/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.util;

import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.eas.ep.client.editor.addfiled.AddFiledProcessing;
import com.kingdee.eas.ep.client.editor.editui.designer.IContext;
import com.kingdee.eas.ep.client.editor.query.model.DynQueryUtil;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.PropertyInfoProxy;
import com.kingdee.eas.ep.client.util.ListVisibleTool;
import com.kingdee.util.StringUtils;

public class CommonQueryFilter {
    private BizUnitInfo bizunit;
    private BizConfigureItemInfo item;
    private IContext context;
    private ListVisibleTool tool;

    public CommonQueryFilter(IContext context, BizUnitInfo bizunit, BizConfigureItemInfo item) {
        this.bizunit = bizunit;
        this.item = item;
        this.context = context;
        this.tool = new ListVisibleTool(context, bizunit, item);
    }

    public void setCommonQueryFilter(boolean isCommonQueryFilter) {
        if (!this.supportQueryFilter()) {
            return;
        }
        this.doUpdate(isCommonQueryFilter);
    }

    public boolean supportQueryFilter() {
        JoinQueryInfo query = this.bizunit.getQuery();
        EntityObjectInfo entity = this.bizunit.getEntity();
        return entity != null && query != null && this.item != null && this.item.getProperty() != null;
    }

    private static String getLastName(String fullName) {
        if (StringUtils.isEmpty((String)fullName)) {
            return "";
        }
        int pos = fullName.lastIndexOf(".");
        if (pos > 0) {
            return fullName.substring(pos + 1);
        }
        return fullName;
    }

    private void doUpdate(boolean isCommonQueryFilter) {
        JoinQueryInfo query = this.bizunit.getQuery();
        EntityObjectInfo entity = this.bizunit.getEntity();
        if (isCommonQueryFilter) {
            this.doAdd(query, entity, this.item);
        } else {
            this.doDelete(query, entity, this.item);
        }
    }

    private void doDelete(JoinQueryInfo query, EntityObjectInfo entity, BizConfigureItemInfo item) {
        AddFiledProcessing processing = this.getProcessing(item);
        if (!processing.hasQuery()) {
            return;
        }
        QueryFieldInfo queryField = null;
        QueryFieldCollection collection = this.tool.findQueryField(query, item);
        if (!collection.isEmpty()) {
            queryField = collection.get(0);
        }
        if (queryField != null) {
            if (queryField.isConfigured() && !item.isListVisible()) {
                SelectorInfo selector = query.getSelector();
                QueryFieldInfo prop = null;
                EntityObjectInfo entityRef = null;
                int m = selector.size();
                for (int j = 0; j < m; ++j) {
                    prop = selector.get(j);
                    PropertyRefCollection propertyRefs = prop.getPropertyRefs();
                    if (propertyRefs == null || propertyRefs.isEmpty()) continue;
                    String refPropertyName = propertyRefs.get(0).getRefProperty().getName();
                    if (!(refPropertyName = CommonQueryFilter.getLastName(refPropertyName)).equalsIgnoreCase(item.getProperty().getName())) continue;
                    entityRef = propertyRefs.get(0).getSubEntity().getEntityRef();
                    break;
                }
                DynQueryUtil.deleteFromQuery((QueryInfo)query, queryField);
                this.tool.deleteSubObject(query, queryField);
            } else {
                queryField.setExtendedProperty("isCommonQueryFilter", "false");
            }
        }
    }

    private void doAdd(JoinQueryInfo query, EntityObjectInfo entity, BizConfigureItemInfo item) {
        AddFiledProcessing processing = this.getProcessing(item);
        if (processing.hasQuery()) {
            QueryFieldInfo queryField = this.tool.addQueryField(query, item, processing);
            queryField.setExtendedProperty("isCommonQueryFilter", "true");
        }
    }

    public boolean isCommonQueryFilter() {
        String isCommonQueryFilter;
        if (!this.supportQueryFilter()) {
            return false;
        }
        JoinQueryInfo query = this.bizunit.getQuery();
        QueryFieldInfo queryField = null;
        QueryFieldCollection collection = this.tool.findQueryField(query, this.item);
        if (!collection.isEmpty()) {
            queryField = collection.get(0);
        }
        return queryField != null && (isCommonQueryFilter = queryField.getExtendedProperty("isCommonQueryFilter")) != null && isCommonQueryFilter.equals("true");
    }

    private AddFiledProcessing getProcessing(BizConfigureItemInfo item) {
        AddFiledProcessing.ProcessingInit init = (AddFiledProcessing.ProcessingInit)this.context.get("AddFiledPorcessingInit");
        AddFiledProcessing processing = init.initialize();
        processing.setUseAddFiled(true);
        processing.getProcessor("entity");
        processing.getProcessor("query");
        processing.getProcessor("listui");
        PropertyInfoProxy proxy = new PropertyInfoProxy(processing.getCurrentEntity());
        proxy.setDepend(processing.getDepend());
        processing.setProxy(proxy);
        processing.setFiledFromEntitySelf(false);
        processing.getProxy().setPropertyInfo(item.getProperty());
        if (item.getComponent() != null) {
            processing.setClassType(item.getComponent().getClassType());
        }
        processing.setIschkIsUseable(true);
        processing.setIschkIsVisible(true);
        processing.setTextName(item.getProperty().getName());
        processing.setListDisplay(true);
        return processing;
    }
}

