/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.util;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.ep.EPException;
import com.kingdee.eas.ep.client.util.CustomUI;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class CoreUICustom {
    protected static final Logger logger = CoreUIObject.getLogger((String)"Custom UI");
    private CustomEntity entity = null;
    private String uiPK = null;
    private String uiTitle = null;
    private Map uiContext = null;

    public CoreUICustom(Map uiContext) {
        this.uiContext = uiContext;
    }

    public void init() throws Exception {
        UIObjectInfo uiModel;
        String uiParam = (String)this.uiContext.get("UIClassParam");
        Map params = CustomUI.getUIParam(uiParam);
        if (params != null) {
            this.uiPK = (String)params.get("uipk");
        }
        if (StringUtils.isEmpty((String)this.uiPK)) {
            logger.error((Object)"UI that is customized can't find UIClassParam~");
            SysUtil.abort();
        }
        if (UictUtils.isEmptyMD((AbstractMDValue)(uiModel = UictUtils.loadUI((IMetaDataPK)MetaDataPK.create((String)this.uiPK))))) {
            throw new EPException(EPException.ENABLE_SCHEME_FIRST);
        }
        this.initCustom(uiModel);
        this.entity = this.getCustomEntity(uiModel);
    }

    protected abstract CustomEntity getCustomEntity(UIObjectInfo var1) throws Exception;

    protected void initCustom(UIObjectInfo uiModel) throws Exception {
    }

    public ICoreBase getBizInterface() throws Exception {
        if (this.entity == null || this.entity.getPk() == null) {
            throw new EPException(EPException.ENABLE_SCHEME_FIRST);
        }
        return (ICoreBase)BOSObjectFactory.createRemoteCommonBOSObject((IMetaDataPK)new MetaDataPK(this.entity.getPk()));
    }

    public CustomEntity getEntity() {
        return this.entity;
    }

    public void setEntity(CustomEntity entity) {
        this.entity = entity;
    }

    public IMetaDataPK getMetaDataPK() {
        if (this.uiPK == null) {
            return null;
        }
        return new MetaDataPK(this.uiPK);
    }

    public String getUiTitle() {
        return this.uiTitle;
    }

    public void setUiTitle(String uiTitle) {
        this.uiTitle = uiTitle;
    }

    public static class CustomEntity {
        private BOSObjectType bosType = null;
        private String pk = null;
        private EntityObjectInfo entity = null;
        private BizUnitInfo bizUnit = null;

        CustomEntity(UIObjectInfo uiModel) throws Exception {
            DataObjectCollection dataObjectCollection = uiModel.getDataObjects();
            if (dataObjectCollection == null) {
                logger.error((Object)"UI that is customized can't find Entity~");
                throw new EPException(EPException.ENABLE_SCHEME_FIRST);
            }
            for (int i = 0; i < dataObjectCollection.size(); ++i) {
                DataObjectInfo doInfo = dataObjectCollection.get(i);
                String type = doInfo.getObjectType();
                if (!MetaDataTypeList.ENTITY.toString().equals(type)) continue;
                this.pk = doInfo.getType();
                break;
            }
            if (this.pk == null) {
                throw new EPException(EPException.ENABLE_SCHEME_FIRST);
            }
        }

        public EntityObjectInfo getEntity() {
            if (this.entity == null && this.pk != null) {
                IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                this.entity = loader.getEntity((IMetaDataPK)new MetaDataPK(this.pk));
            }
            return this.entity;
        }

        public PropertyInfo getPropertyByName(String name) {
            return this.getEntity().getPropertyByName(name);
        }

        public BOSObjectType getBosType() {
            if (this.bosType == null) {
                this.bosType = this.getEntity().getType();
            }
            return this.bosType;
        }

        public String getPk() {
            return this.pk;
        }

        public BizUnitInfo getBizUnit() {
            if (this.bizUnit == null) {
                IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                MetaDataPK bizUnitPK = new MetaDataPK(this.getEntity().getBizUnitPK());
                this.bizUnit = (BizUnitInfo)loader.get(BOSObjectType.create((String)"bzut"), (IMetaDataPK)bizUnitPK);
            }
            return this.bizUnit;
        }

        public String getRelatedEntityPK() {
            return this.getBizUnit().getRelatedEntityPK();
        }

        public String getRelatedEditUIPK() {
            return this.getBizUnit().getRelatedEditUIPK();
        }
    }
}

