/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.util;

import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class DEPTableUtils {
    public static List getBindColumnNames(QueryFieldInfo field, ComponentInfo table) {
        ArrayList<String> names = new ArrayList<String>();
        if (table != null && field != null) {
            PropertyBindingCollection bindings = table.getPropertyBindings();
            for (int i = 0; i < bindings.size(); ++i) {
                String name;
                PropertyBindingInfo bind = bindings.get(i);
                String fieldName = bind.getBingdingField();
                if (fieldName == null || !fieldName.equals(field.getName()) || StringUtils.isEmpty((String)(name = bind.getPropertyName())) || name.indexOf(".") <= 0) continue;
                name = name.substring(0, name.indexOf("."));
                names.add(name);
            }
        }
        return names;
    }

    public static ColumnInfo getColumn(TableInfo tableInfo, String name) {
        if (tableInfo != null) {
            List columns = tableInfo.getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                ColumnInfo column = (ColumnInfo)columns.get(i);
                if (!name.equals(column.getName())) continue;
                return column;
            }
        }
        return null;
    }

    public static void removeCell(TableInfo kdTable, ColumnInfo column) {
        int index = DEPTableUtils.getColumnIndex(kdTable, column);
        if (index != -1) {
            List headers = kdTable.getHeaders();
            int n = headers.size();
            for (int i = 0; i < n; ++i) {
                HeaderInfo head = (HeaderInfo)headers.get(i);
                if (index > head.getCellCount() - 1) continue;
                CellInfo cell = (CellInfo)head.getCells().get(index);
                head.removeCell(cell);
            }
        }
    }

    public static int getColumnIndex(TableInfo kdTable, ColumnInfo column) {
        List columns = kdTable.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            ColumnInfo _column = (ColumnInfo)columns.get(i);
            if (!_column.equals((Object)column)) continue;
            return i;
        }
        return -1;
    }

    public static String createColumnName(TableInfo table, String suggestName) {
        String name = suggestName;
        if (DEPTableUtils.nameUsed(table, name)) {
            for (int i = 1; i < Integer.MAX_VALUE && DEPTableUtils.nameUsed(table, name = suggestName + i); ++i) {
            }
        }
        return name;
    }

    private static boolean nameUsed(TableInfo table, String columnName) {
        ColumnInfo column = DEPTableUtils.getColumn(table, columnName);
        return column != null;
    }

    public static void addColumn(TableInfo tableMainInfo, String name, String alias) {
        ColumnInfo column = DEPTableUtils.getColumn(tableMainInfo, name);
        if (column != null) {
            return;
        }
        column = new ColumnInfo();
        column.setName(name);
        column.setWidth(80);
        column.setConfigured(true);
        tableMainInfo.addColumn(column);
        List heads = tableMainInfo.getHeaders();
        for (int i = 0; i < heads.size(); ++i) {
            HeaderInfo header = (HeaderInfo)heads.get(i);
            CellInfo cell = new CellInfo(header);
            cell.setName(alias);
            cell.setConfigured(true);
            header.addCell(cell);
        }
    }

    public static TableInfo getTableInfo(ComponentInfo table) {
        PropertyInfo property;
        if (table != null && "com.kingdee.bos.ctrl.kdf.table.KDTable".equals(table.getClassType()) && (property = table.getProperties().get("formatXml")) != null) {
            String format = property.getValue();
            TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)format);
            return tableInfo;
        }
        return null;
    }
}

