/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.util;

import com.kingdee.bos.metadata.bizunit.BizDataType;
import com.kingdee.bos.metadata.bizunit.DataSourceType;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.eas.ep.BizDataTypeEnum;
import com.kingdee.eas.ep.DataSourceEnum;

public class EntityEditorHelper {
    public static BizDataTypeEnum getDataTypeAlias(PropertyInfo prop) {
        if (prop == null) {
            return null;
        }
        if (prop instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
            DataType dataType = ownProp.getDataType();
            if (DataType.ENUM.equals((Object)dataType)) {
                return BizDataTypeEnum.ENUM;
            }
            if (DataType.BOOLEAN.equals((Object)dataType)) {
                return BizDataTypeEnum.BOOLEAN;
            }
            if (DataType.STRING.equals((Object)dataType)) {
                String bdt = prop.getExtendedProperty("bizDataType");
                if ("NOTE".equalsIgnoreCase(bdt)) {
                    return BizDataTypeEnum.NOTE;
                }
                return BizDataTypeEnum.STRING;
            }
            if (DataType.INTEGER.equals((Object)dataType)) {
                return BizDataTypeEnum.INTEGER;
            }
            if (DataType.FLOAT.equals((Object)dataType)) {
                return BizDataTypeEnum.FLOAT;
            }
            if (DataType.DOUBLE.equals((Object)dataType)) {
                return BizDataTypeEnum.DOUBLE;
            }
            if (DataType.BOSUUID.equals((Object)dataType)) {
                return BizDataTypeEnum.BOSUUID;
            }
            if (DataType.CHAR.equals((Object)dataType)) {
                return BizDataTypeEnum.CHAR;
            }
            if (DataType.DATE.equals((Object)dataType) || DataType.TIMESTAMP.equals((Object)dataType)) {
                return BizDataTypeEnum.DATE;
            }
            if (DataType.DECIMAL.equals((Object)dataType)) {
                String bdt = prop.getExtendedProperty("bizDataType");
                if (BizDataType.AMOUNT.getName().equals(bdt)) {
                    return BizDataTypeEnum.AMOUNT;
                }
                if (BizDataType.PRICE.getName().equals(bdt)) {
                    return BizDataTypeEnum.PRICE;
                }
                if (BizDataType.QUANTITY.getName().equals(bdt)) {
                    return BizDataTypeEnum.QUANTITY;
                }
                return BizDataTypeEnum.DECIMAL;
            }
            if (DataType.LONG.equals((Object)dataType)) {
                return BizDataTypeEnum.LONG;
            }
            if (DataType.TIME.equals((Object)dataType)) {
                return BizDataTypeEnum.TIME;
            }
            return BizDataTypeEnum.OTHER;
        }
        LinkPropertyInfo lnkProp = (LinkPropertyInfo)prop;
        RelationshipInfo relation = lnkProp.getRelationship();
        if (CardinalityType.ONE.equals((Object)relation.getSupplierCardinality()) || CardinalityType.ZERO_TO_ONE.equals((Object)relation.getSupplierCardinality())) {
            return BizDataTypeEnum.OBJECT;
        }
        return BizDataTypeEnum.COLLECTION;
    }

    public static DataType getPropertyType(BizDataTypeEnum bizType) {
        DataType dataType = null;
        if (bizType.equals((Object)BizDataTypeEnum.STRING)) {
            dataType = DataType.STRING;
        } else if (bizType.equals((Object)BizDataTypeEnum.DATE)) {
            dataType = DataType.DATE;
        } else if (bizType.equals((Object)BizDataTypeEnum.INTEGER)) {
            dataType = DataType.INTEGER;
        } else if (bizType.equals((Object)BizDataTypeEnum.QUANTITY)) {
            dataType = DataType.DECIMAL;
        } else if (bizType.equals((Object)BizDataTypeEnum.AMOUNT)) {
            dataType = DataType.DECIMAL;
        } else if (bizType.equals((Object)BizDataTypeEnum.PRICE)) {
            dataType = DataType.DECIMAL;
        } else if (bizType.equals((Object)BizDataTypeEnum.NOTE)) {
            dataType = DataType.STRING;
        } else if (bizType.equals((Object)BizDataTypeEnum.BOOLEAN)) {
            dataType = DataType.BOOLEAN;
        } else if (bizType.equals((Object)BizDataTypeEnum.DECIMAL)) {
            dataType = DataType.DECIMAL;
        } else if (bizType.equals((Object)BizDataTypeEnum.IMAGE)) {
            dataType = DataType.BYTEARRAY;
        } else if (bizType.equals((Object)BizDataTypeEnum.ENUM)) {
            dataType = DataType.ENUM;
        } else if (bizType.equals((Object)BizDataTypeEnum.TIME)) {
            dataType = DataType.TIME;
        }
        return dataType;
    }

    public static DataSourceEnum getDataSourceType(DataSourceType type) {
        if (type == null) {
            return DataSourceEnum.SELF;
        }
        if (type.equals((Object)DataSourceType.MANAUL)) {
            return DataSourceEnum.SELF;
        }
        if (type.equals((Object)DataSourceType.BASEDATA)) {
            return DataSourceEnum.BASEDATA;
        }
        if (type.equals((Object)DataSourceType.BASEDATAEXT)) {
            return DataSourceEnum.BASEDATAEXT;
        }
        if (type.equals((Object)DataSourceType.ENUMLIST)) {
            return DataSourceEnum.LIST;
        }
        return DataSourceEnum.SELF;
    }

    public static DataSourceType getDataSourceType(DataSourceEnum type) {
        if (type == null) {
            return DataSourceType.MANAUL;
        }
        if (type.equals((Object)DataSourceEnum.SELF)) {
            return DataSourceType.MANAUL;
        }
        if (type.equals((Object)DataSourceEnum.BASEDATA)) {
            return DataSourceType.BASEDATA;
        }
        if (type.equals((Object)DataSourceEnum.BASEDATAEXT)) {
            return DataSourceType.BASEDATAEXT;
        }
        if (type.equals((Object)DataSourceEnum.LIST)) {
            return DataSourceType.ENUMLIST;
        }
        return DataSourceType.MANAUL;
    }
}

