/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.util;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.bizunitproxy.EditUIProxyHelper;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.eas.ep.client.editor.addfiled.AddFiledProcessing;
import com.kingdee.eas.ep.client.editor.bind.DataBindUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class EntriesManagerUtils {
    private static final String DYNPROPERTYBINDS = "dynpropertybinds";
    private AddFiledProcessing processing;
    private List propList = new ArrayList();
    private UIObjectInfo uiModel;
    private TableInfo kdTable;

    public EntriesManagerUtils(UIObjectInfo uiModel, AddFiledProcessing processing, TableInfo tableInfo) {
        this.processing = processing;
        this.uiModel = uiModel;
        this.kdTable = tableInfo;
    }

    public void extractTableSumInfo(UIObjectInfo uiObject, ComponentInfo tableControl) {
        List columns = this.kdTable.getColumns();
        int m = columns.size();
        for (int j = 0; j < m; ++j) {
            ColumnInfo column = (ColumnInfo)columns.get(j);
            PropertyInfo property = EditUIProxyHelper.getColumnBindProperty((UIObjectInfo)uiObject, (ComponentInfo)tableControl, (String)column.getName(), (boolean)true);
            if (!ConvertUtils.getExtendedPropertyBooelanValue((IObjectValue)property, (String)"needSum")) continue;
            column.setExtendedProperty("needSum", Boolean.TRUE.toString());
        }
    }

    public void addHeader() {
        HeaderInfo header = new HeaderInfo(this.kdTable);
        header.setName("header" + (this.kdTable.getHeaderCount() + 1));
        header.setConfigured(true);
        this.kdTable.addHeader(header);
    }

    public void addEntriesColumn(PropertyInfo info) {
        ColumnInfo column = new ColumnInfo(this.kdTable);
        String name = info.getName();
        if (!EntriesManagerUtils.isValidateName(this.kdTable, name, this.kdTable.getColumnCount())) {
            name = EntriesManagerUtils.getNameByName(this.kdTable, name, 1);
        }
        column.setName(name);
        column.setConfigured(true);
        this.kdTable.addColumn(column);
        List headers = this.kdTable.getHeaders();
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            HeaderInfo headerInfo = (HeaderInfo)headers.get(i);
            this.addCell(headerInfo, info);
        }
    }

    public void addCell(HeaderInfo header, PropertyInfo info) {
        CellInfo cell = new CellInfo(header);
        cell.setName(info.getAlias());
        cell.setConfigured(true);
        header.addCell(cell);
    }

    public void editColumn(ColumnInfo colInfo, PropertyInfo newInfo) {
        String name;
        int index = this.kdTable.getColumns().indexOf(colInfo);
        if (index >= 0) {
            this.editCell(newInfo.getAlias(), index);
        }
        if (!EntriesManagerUtils.isValidateName(this.kdTable, name = newInfo.getName(), index)) {
            name = EntriesManagerUtils.getNameByName(this.kdTable, name, 1);
        }
        colInfo.setName(name);
    }

    public void editCell(String alias, int index) {
        List headers = this.kdTable.getHeaders();
        if (headers.size() > 0) {
            int n = headers.size();
            for (int i = 0; i < n; ++i) {
                HeaderInfo head = (HeaderInfo)headers.get(i);
                if (index > head.getCellCount() - 1) continue;
                CellInfo cell = (CellInfo)head.getCells().get(index);
                cell.setName(alias);
            }
        }
    }

    public void doAdd(ComponentInfo component, PropertyInfo info, EntityObjectInfo entity) {
        this.addEntriesColumn(info);
        this.bindData(component, info, entity, (ColumnInfo)this.kdTable.getColumns().get(this.kdTable.getColumnCount() - 1));
    }

    public void doEdit(ComponentInfo component, PropertyInfo newInfo, EntityObjectInfo entity, PropertyInfo oldInfo, boolean isNameChange) {
        ColumnInfo[] bindColumns = this.getBindColumns(component, oldInfo, entity);
        if (bindColumns != null && bindColumns.length > 0 && bindColumns[0] != null) {
            for (ColumnInfo colInfo : bindColumns) {
                int index;
                String oldPropName = colInfo.getName();
                if (isNameChange) {
                    if (colInfo.getName().equals(oldInfo.getName())) {
                        this.editColumn(colInfo, newInfo);
                    }
                    this.editBindData(component, entity, oldPropName, colInfo, newInfo.getName());
                    continue;
                }
                if (!colInfo.getName().equals(oldInfo.getName()) || (index = this.kdTable.getColumns().indexOf(colInfo)) < 0) continue;
                this.editCell(newInfo.getAlias(), index);
            }
        }
    }

    public void doDelete(ComponentInfo component, List deletePropList, EntityObjectInfo entity) {
        int j = deletePropList.size();
        for (int i = 0; i < j; ++i) {
            PropertyInfo info = (PropertyInfo)deletePropList.get(i);
            ColumnInfo[] bindColumns = this.getBindColumns(component, info, entity);
            if (bindColumns == null || bindColumns.length <= 0 || bindColumns[0] == null) continue;
            for (ColumnInfo colInfo : bindColumns) {
                this.deleteColumn(colInfo);
                EntriesManagerUtils.deleteBindData(component, colInfo.getName());
            }
        }
    }

    private void deleteColumn(ColumnInfo element) {
        int index = this.kdTable.getColumns().indexOf(element);
        if (index >= 0) {
            List headers = this.kdTable.getHeaders();
            int n = headers.size();
            for (int i = 0; i < n; ++i) {
                HeaderInfo head = (HeaderInfo)headers.get(i);
                if (index > head.getCellCount() - 1) continue;
                CellInfo cell = (CellInfo)head.getCells().get(index);
                head.removeCell(cell);
            }
        }
        this.kdTable.removeColumn(element);
    }

    public void bindData(ComponentInfo cominfo, PropertyInfo info, EntityObjectInfo entity, ColumnInfo columnInfo) {
        PropertyBindingCollection pbc;
        String proName = columnInfo.getName() + ".text";
        String bindField = info.getName();
        DataObjectCollection dataObjectCollection = this.uiModel.getDataObjects();
        DataObjectInfo doInfo = null;
        int n = dataObjectCollection.size();
        for (int i = 0; i < n; ++i) {
            DataObjectInfo data = dataObjectCollection.get(i);
            if (!data.getName().equals("editData")) continue;
            doInfo = data;
            break;
        }
        if ((pbc = cominfo.getPropertyBindings()).get(proName) == null) {
            PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
            propertyBindingInfo.setPropertyName(proName);
            propertyBindingInfo.setBindingObject(doInfo.getName());
            PropertyCollection propertyCol = this.processing.getEntityPro().getEntityInfo().getInheritedProperties();
            int size = propertyCol.size();
            for (int i = size - 1; i >= 0; --i) {
                PropertyInfo info2 = propertyCol.get(i);
                if (!(info2 instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo lpi = (LinkPropertyInfo)info2;
                PropertyBindingInfo pbinfo = pbc.get("userObject");
                if (pbinfo != null && lpi.getName().equals(pbinfo.getBingdingField())) {
                    bindField = info2.getName() + "." + bindField;
                    break;
                }
                if (!info2.getAlias().equals(entity.getAlias())) continue;
                bindField = info2.getName() + "." + bindField;
                break;
            }
            String type = null;
            if (info instanceof OwnPropertyInfo) {
                OwnPropertyInfo propInfo = (OwnPropertyInfo)info;
                type = DataType.ENUM.equals((Object)propInfo.getDataType()) ? propInfo.getMetaDataRef() : propInfo.getJavaType();
            } else if (info instanceof LinkPropertyInfo) {
                LinkPropertyInfo linkPropInfo = (LinkPropertyInfo)info;
                type = linkPropInfo.getRelationship().getSupplierObject().getObjectValueClass();
                RelationshipInfo ship = linkPropInfo.getRelationship();
                type = CardinalityType.isOneORZero((CardinalityType)ship.getSupplierCardinality()) ? ship.getSupplierObject().getObjectValueClass() : ship.getSupplierObject().getObjectCollectionClass();
            } else {
                type = "java.lang.String";
            }
            propertyBindingInfo.setBingdingField(bindField);
            propertyBindingInfo.setPropertyType(Object.class.getName());
            propertyBindingInfo.setFieldType(type);
            propertyBindingInfo.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
            pbc.add(propertyBindingInfo);
        }
        if (pbc.get(proName) != null) {
            PropertyBindingInfo propertyBindingInfo = pbc.get(proName);
            DataBindUtils.extractPropertyToTable(cominfo, this.kdTable, this.processing.getBaseEntity(), propertyBindingInfo, 1);
        }
        if (cominfo.getExtendedProperty(DYNPROPERTYBINDS) != null) {
            String bindsText = "" + cominfo.getExtendedProperty(DYNPROPERTYBINDS) + "|" + proName;
            cominfo.setExtendedProperty(DYNPROPERTYBINDS, bindsText);
        } else {
            cominfo.setExtendedProperty(DYNPROPERTYBINDS, proName);
        }
    }

    public static void deleteBindData(ComponentInfo cominfo, String proName) {
        proName = proName + ".text";
        PropertyBindingCollection pbc = cominfo.getPropertyBindings();
        if (pbc.get(proName) != null) {
            PropertyBindingInfo propertyBindingInfo = pbc.get(proName);
            pbc.remove(propertyBindingInfo);
        }
        if (cominfo.getExtendedProperty(DYNPROPERTYBINDS) != null) {
            String bindsText = cominfo.getExtendedProperty(DYNPROPERTYBINDS);
            if (bindsText != null && bindsText.indexOf(proName) > -1 && bindsText.length() == proName.length()) {
                cominfo.setExtendedProperty(DYNPROPERTYBINDS, null);
            } else if (bindsText != null && bindsText.indexOf(proName) > -1 && bindsText.length() > proName.length() && bindsText.substring(0, proName.length()).equals(proName)) {
                bindsText = StringUtils.replace((String)bindsText, (String)(proName + "|"), (String)"");
                cominfo.setExtendedProperty(DYNPROPERTYBINDS, bindsText);
            } else if (bindsText != null && bindsText.indexOf(proName) > -1 && bindsText.length() > proName.length() && !bindsText.substring(0, proName.length()).equals(proName)) {
                bindsText = StringUtils.replace((String)bindsText, (String)("|" + proName), (String)"");
                cominfo.setExtendedProperty(DYNPROPERTYBINDS, bindsText);
            }
        }
    }

    public void editBindData(ComponentInfo cominfo, EntityObjectInfo entity, String oldProName, ColumnInfo columnInfo, String fieldName) {
        oldProName = oldProName + ".text";
        String newProName = columnInfo.getName() + ".text";
        fieldName = this.fieldName(fieldName, cominfo, entity);
        PropertyBindingCollection pbc = cominfo.getPropertyBindings();
        if (pbc.get(oldProName) != null) {
            PropertyBindingInfo propertyBindingInfo = pbc.get(oldProName);
            propertyBindingInfo.setPropertyName(newProName);
            propertyBindingInfo.setBingdingField(fieldName);
        }
        String bindsText = cominfo.getExtendedProperty(DYNPROPERTYBINDS);
        if (columnInfo.isConfigured()) {
            bindsText = StringUtils.replace((String)bindsText, (String)oldProName, (String)newProName);
            cominfo.setExtendedProperty(DYNPROPERTYBINDS, bindsText);
        }
    }

    public void bindEntry(ComponentInfo cominfo, EntityObjectInfo entity) {
        PropertyBindingCollection pbc;
        String proName = "userObject";
        String bindField = "";
        DataObjectCollection dataObjectCollection = this.uiModel.getDataObjects();
        DataObjectInfo doInfo = null;
        int n = dataObjectCollection.size();
        for (int i = 0; i < n; ++i) {
            DataObjectInfo data = dataObjectCollection.get(i);
            if (!data.getName().equals("editData")) continue;
            doInfo = data;
            break;
        }
        if ((pbc = cominfo.getPropertyBindings()).get(proName) == null) {
            PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
            propertyBindingInfo.setPropertyName(proName);
            propertyBindingInfo.setBindingObject(doInfo.getName());
            PropertyCollection propertyCol = this.processing.getEntityPro().getEntityInfo().getInheritedProperties();
            int size = propertyCol.size();
            for (int i = size - 1; i >= 0; --i) {
                PropertyInfo info2 = propertyCol.get(i);
                if (!info2.getAlias().equals(entity.getAlias())) continue;
                bindField = info2.getName();
                break;
            }
            String type = "com.kingdee.eas.ep.BillEntryCustomInfo";
            propertyBindingInfo.setBingdingField(bindField);
            propertyBindingInfo.setPropertyType(Object.class.getName());
            propertyBindingInfo.setFieldType(type);
            propertyBindingInfo.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
            pbc.add(propertyBindingInfo);
        }
        if (pbc.get(proName) != null) {
            PropertyBindingInfo propertyBindingInfo = pbc.get(proName);
            DataBindUtils.extractPropertyToTable(cominfo, this.kdTable, this.processing.getBaseEntity(), propertyBindingInfo, 1);
        }
        if (cominfo.getExtendedProperty(DYNPROPERTYBINDS) != null) {
            String bindsText = "" + cominfo.getExtendedProperty(DYNPROPERTYBINDS) + "|" + proName;
            cominfo.setExtendedProperty(DYNPROPERTYBINDS, bindsText);
        } else {
            cominfo.setExtendedProperty(DYNPROPERTYBINDS, proName);
        }
    }

    public static boolean isValidateName(TableInfo tableinfo, String name, int index) {
        List columns = tableinfo.getColumns();
        int j = columns.size();
        for (int i = 0; i < j; ++i) {
            ColumnInfo columnInfo = (ColumnInfo)columns.get(i);
            if (i == index || !name.equals(columnInfo.getName())) continue;
            return false;
        }
        return true;
    }

    public static String getNameByName(TableInfo tableinfo, String name, int suffix) {
        List columns = tableinfo.getColumns();
        HashSet<String> nameSet = new HashSet<String>();
        int j = columns.size();
        for (int i = 0; i < j; ++i) {
            ColumnInfo columnInfo = (ColumnInfo)columns.get(i);
            nameSet.add(columnInfo.getName());
        }
        while (nameSet.contains(name + suffix)) {
            ++suffix;
        }
        name = name + suffix;
        return name;
    }

    public ColumnInfo[] getBindColumns(ComponentInfo table, PropertyInfo pInfo, EntityObjectInfo entity) {
        List names = this.getBindColumnName(table, pInfo, entity);
        ColumnInfo[] columns = new ColumnInfo[names.size()];
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            columns[i] = this.getColumn(this.kdTable, name);
        }
        return columns;
    }

    private List getBindColumnName(ComponentInfo table, PropertyInfo pInfo, EntityObjectInfo entity) {
        ArrayList<String> names = new ArrayList<String>();
        if (table != null && pInfo != null) {
            PropertyBindingCollection bindings = table.getPropertyBindings();
            String fieldName = pInfo.getName();
            fieldName = this.fieldName(fieldName, table, entity);
            for (int i = 0; i < bindings.size(); ++i) {
                String name;
                PropertyBindingInfo bind = bindings.get(i);
                String bindField = bind.getBingdingField();
                if (bindField == null || !bindField.equals(fieldName) || StringUtils.isEmpty((String)(name = bind.getPropertyName())) || name.indexOf(".") <= 0) continue;
                name = name.substring(0, name.indexOf("."));
                names.add(name);
            }
        }
        return names;
    }

    private String fieldName(String fieldName, ComponentInfo table, EntityObjectInfo entity) {
        PropertyBindingCollection bindings = table.getPropertyBindings();
        PropertyCollection propertyCol = this.processing.getEntityPro().getEntityInfo().getInheritedProperties();
        int size = propertyCol.size();
        for (int i = size - 1; i >= 0; --i) {
            PropertyInfo info2 = propertyCol.get(i);
            if (!(info2 instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo lpi = (LinkPropertyInfo)info2;
            PropertyBindingInfo pbinfo = bindings.get("userObject");
            if (pbinfo != null && lpi.getName().equals(pbinfo.getBingdingField())) {
                fieldName = info2.getName() + "." + fieldName;
                break;
            }
            if (!info2.getAlias().equals(entity.getAlias())) continue;
            fieldName = info2.getName() + "." + fieldName;
            break;
        }
        return fieldName;
    }

    private ColumnInfo getColumn(TableInfo tableInfo, String name) {
        if (tableInfo != null) {
            List columns = tableInfo.getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                ColumnInfo column = (ColumnInfo)columns.get(i);
                if (!name.equals(column.getName())) continue;
                return column;
            }
        }
        return null;
    }

    public void setKdTable(TableInfo kdTable) {
        this.kdTable = kdTable;
    }

    public TableInfo getKdTable() {
        return this.kdTable;
    }
}

