/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.util;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.view.BriefViewTreeNode;
import com.kingdee.bos.metadata.view.BusinessObjectBriefView;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.SubSystemUtils;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FacadeTreeUtil {
    static Collator collator = Collator.getInstance(Locale.CHINA);

    public void initialJobTaskTreeView(KDTree destKDTree, boolean isResetBySelf) {
        if (destKDTree == null) {
            throw new IllegalArgumentException();
        }
        this.initialJobTaskTree(destKDTree, isResetBySelf);
    }

    private void initialJobTaskTree(KDTree destKDTree, boolean isResetBySelf) {
        if (destKDTree == null) {
            throw new IllegalArgumentException();
        }
        IBriefViewTreeNode businessTreeViewRoot = this.getJobTaskTreeView(isResetBySelf);
        if (businessTreeViewRoot == null) {
            throw new UnsupportedOperationException();
        }
        TreeNode rootTreeNode = businessTreeViewRoot.getRoot();
        DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode((Object)rootTreeNode);
        rootNode.setAllowsChildren(true);
        rootNode.setText(businessTreeViewRoot.getAlias());
        this.addJobTaskChildNode(rootNode, rootTreeNode);
        KingdeeTreeModel kingdeeTreeModel = (KingdeeTreeModel)destKDTree.getModel();
        kingdeeTreeModel.setRoot((TreeNode)rootNode);
        kingdeeTreeModel.setAsksAllowsChildren(true);
        destKDTree.setSelectionPath(new TreePath(rootNode));
    }

    private IBriefViewTreeNode getJobTaskTreeView(boolean isResetBySelf) {
        IBriefViewTreeNode root = null;
        BOSObjectType[] type = new BOSObjectType[]{MetaDataTypeList.FACADE};
        if (isResetBySelf) {
            try {
                root = SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_base_function_facade", (BOSObjectType[])type);
            }
            catch (Exception e) {
                root = SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_base_function", (BOSObjectType[])type);
            }
        } else {
            BusinessObjectBriefView businessObjectBriefView;
            IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            try {
                businessObjectBriefView = metaDataLoader.getBusinessObjectBriefView((IMetaDataPK)new MetaDataPK("com_kingdee_eas_base_function_facade"));
            }
            catch (Exception e) {
                businessObjectBriefView = metaDataLoader.getBusinessObjectBriefView((IMetaDataPK)new MetaDataPK("com_kingdee_eas_base_function"));
            }
            root = businessObjectBriefView.getViewRootByType(type);
        }
        return SubSystemUtils.getRemoveEmptyPackageNode((IBriefViewTreeNode)root);
    }

    private void addJobTaskChildNode(DefaultKingdeeTreeNode rootNode, TreeNode dstParentBusinessNode) {
        if (rootNode == null || dstParentBusinessNode == null || !(dstParentBusinessNode instanceof BriefViewTreeNode)) {
            throw new IllegalArgumentException();
        }
        BriefViewTreeNode parentBusinessNode = (BriefViewTreeNode)dstParentBusinessNode;
        int childCount = parentBusinessNode.getChildCount();
        ArrayList<BriefViewTreeNode> packageList = new ArrayList<BriefViewTreeNode>();
        ArrayList otherList = new ArrayList();
        for (int i = 0; i < childCount; ++i) {
            BriefViewTreeNode businessChildNode = (BriefViewTreeNode)parentBusinessNode.getChildAt(i);
            String[] nodeInfo = null;
            if (businessChildNode.getMetaDataType().equals((Object)BOSObjectType.create((String)"pack"))) {
                packageList.add(businessChildNode);
                continue;
            }
            if (!businessChildNode.getMetaDataType().equals((Object)BOSObjectType.create((String)"fade"))) continue;
            String alias = businessChildNode.getAlias();
            String fullName = businessChildNode.getFullName();
            if (alias == null) {
                alias = fullName.substring(fullName.lastIndexOf(".") + 1);
            }
            nodeInfo = new String[]{alias, businessChildNode.getMetaDataType().toString(), fullName};
            otherList.add(nodeInfo);
        }
        otherList = this.sortNodeInfoList(otherList);
        ArrayList<BriefViewTreeNode> childNodeList = new ArrayList<BriefViewTreeNode>();
        childNodeList.addAll(packageList);
        childNodeList.addAll(otherList);
        if (childNodeList.size() > 0) {
            for (int i = 0; i < childNodeList.size(); ++i) {
                DefaultKingdeeTreeNode ChildNode = null;
                Object nodeObject = childNodeList.get(i);
                if (nodeObject instanceof BriefViewTreeNode) {
                    BriefViewTreeNode businessChildNode = (BriefViewTreeNode)nodeObject;
                    ChildNode = new DefaultKingdeeTreeNode((Object)businessChildNode);
                    ChildNode.setText(businessChildNode.getAlias());
                    this.addJobTaskChildNode(ChildNode, (TreeNode)businessChildNode);
                    rootNode.add((MutableTreeNode)ChildNode);
                    continue;
                }
                if (!(nodeObject instanceof String[])) continue;
                String[] nodeInfo = (String[])nodeObject;
                String type = nodeInfo[1];
                ChildNode = new DefaultKingdeeTreeNode((Object)nodeInfo);
                ChildNode.setText(nodeInfo[0]);
                if (type.equals("fade")) {
                    ChildNode.setAllowsChildren(false);
                }
                rootNode.add((MutableTreeNode)ChildNode);
            }
        }
    }

    private ArrayList sortNodeInfoList(ArrayList nodes) {
        int i;
        ArrayList<String[]> list = new ArrayList<String[]>();
        HashMap[] map = new HashMap[nodes.size()];
        for (i = 0; i < nodes.size(); ++i) {
            map[i] = new HashMap();
            map[i].put("alias", ((String[])nodes.get(i))[0]);
            map[i].put("nodeInfo", nodes.get(i));
        }
        Arrays.sort(map, new Comparator(){

            public int compare(Object o1, Object o2) {
                String n1 = (String)((HashMap)o1).get("alias");
                String n2 = (String)((HashMap)o2).get("alias");
                return collator.compare(n1, n2);
            }
        });
        for (i = 0; i < map.length; ++i) {
            list.add(i, (String[])map[i].get("nodeInfo"));
        }
        return list;
    }
}

