/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinItemCollection;
import com.kingdee.bos.metadata.query.JoinItemInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.bizunitproxy.EditUIProxyHelper;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.editor.addfiled.AddFiledProcessing;
import com.kingdee.eas.ep.client.editor.bind.DataBindUtils;
import com.kingdee.eas.ep.client.editor.editui.designer.IContext;
import com.kingdee.eas.ep.client.editor.editui.designer.NewCtrlWizardDialog;
import com.kingdee.eas.ep.client.editor.query.model.DynQueryUtil;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.PropertyInfoProxy;
import com.kingdee.eas.ep.client.util.DEPTableUtils;
import com.kingdee.util.StringUtils;
import java.util.List;
import org.apache.log4j.Logger;

public class ListVisibleTool {
    private BizUnitInfo bizunit;
    private BizConfigureItemInfo item;
    private IContext context;
    private static final Logger logger = CoreUIObject.getLogger(ListVisibleTool.class);

    public ListVisibleTool(IContext context, BizUnitInfo bizunit, BizConfigureItemInfo item) {
        this.bizunit = bizunit;
        this.item = item;
        this.context = context;
    }

    public void setListVisible(boolean visible) {
        if (!this.supportListVisible()) {
            return;
        }
        this.doUpdate(visible);
    }

    public boolean supportListVisible() {
        JoinQueryInfo query = this.bizunit.getQuery();
        EntityObjectInfo entity = this.bizunit.getEntity();
        UIObjectInfo listUI = this.bizunit.getListUI();
        return entity != null && query != null && listUI != null && this.isItemConform(this.item) && ListVisibleTool.isMainObjectConform(query, entity);
    }

    public boolean isListVisible() {
        if (!this.supportListVisible()) {
            return false;
        }
        JoinQueryInfo query = this.bizunit.getQuery();
        UIObjectInfo listUI = this.bizunit.getListUI();
        QueryFieldCollection collection = this.findQueryField(query, this.item);
        for (int j = 0; j < collection.size(); ++j) {
            QueryFieldInfo queryField = collection.get(j);
            ColumnInfo[] columns = this.getBindColumns(queryField, listUI);
            for (int i = 0; i < columns.length; ++i) {
                ColumnInfo column = columns[i];
                if (column == null || column.isHide()) continue;
                return true;
            }
        }
        return false;
    }

    private void doUpdate(boolean visible) {
        JoinQueryInfo query = this.bizunit.getQuery();
        EntityObjectInfo entity = this.bizunit.getEntity();
        if (visible) {
            this.doAdd(query, entity, this.item);
        } else {
            this.doDelete(query, this.item);
        }
    }

    private void doAdd(JoinQueryInfo query, EntityObjectInfo entity, BizConfigureItemInfo item) {
        AddFiledProcessing processing = this.getProcessing(item);
        if (processing.hasListUI()) {
            QueryFieldInfo queryField = this.addQueryField(query, item, processing);
            this.addColumn(queryField, processing);
        }
    }

    private void doDelete(JoinQueryInfo query, BizConfigureItemInfo item) {
        AddFiledProcessing processing = this.getProcessing(item);
        if (processing.hasListUI()) {
            QueryFieldCollection collection = this.findQueryField(query, item);
            for (int i = 0; i < collection.size(); ++i) {
                QueryFieldInfo queryField = collection.get(i);
                this.deleteQueryField(query, queryField);
                UIObjectInfo listUI = this.bizunit.getListUI();
                ComponentInfo table = this.getTableMain(listUI);
                if (table == null) continue;
                this.deleteBindColumn(queryField, table);
            }
        }
    }

    private EntityObjectInfo getBindEntry(BizConfigureItemInfo item) {
        ComponentInfo entry = item.getEntry();
        PropertyBindingCollection pbc = entry.getPropertyBindings();
        PropertyBindingInfo pb = pbc.get("userObject");
        if (pb != null) {
            EntityObjectInfo entryEntity;
            String field = pb.getBingdingField();
            EntityObjectInfo entity = this.bizunit.getEntity();
            com.kingdee.bos.metadata.entity.PropertyInfo propertyInfo = EditUIProxyHelper.getPropertyByName((EntityObjectInfo)entity, (String)field);
            if (propertyInfo instanceof LinkPropertyInfo && (entryEntity = this.getRelationEntity((LinkPropertyInfo)propertyInfo)) != null) {
                return entryEntity;
            }
        }
        return null;
    }

    private EntityObjectInfo getRelationEntity(LinkPropertyInfo property) {
        RelationshipInfo relationship = property.getRelationship();
        if (relationship != null) {
            return relationship.getSupplierObject();
        }
        return null;
    }

    private ColumnInfo[] getBindColumns(QueryFieldInfo field, UIObjectInfo listui) {
        List names = this.getBindColumnNames(field, listui);
        ColumnInfo[] columns = new ColumnInfo[names.size()];
        TableInfo tableInfo = this.getTableMainInfo(listui);
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            columns[i] = DEPTableUtils.getColumn(tableInfo, name);
        }
        return columns;
    }

    private List getBindColumnNames(QueryFieldInfo field, UIObjectInfo listui) {
        ComponentInfo table = this.getTableMain(listui);
        return DEPTableUtils.getBindColumnNames(field, table);
    }

    private TableInfo getTableMainInfo(UIObjectInfo listui) {
        ComponentInfo table = this.getTableMain(listui);
        return DEPTableUtils.getTableInfo(table);
    }

    private ComponentInfo getTableMain(UIObjectInfo uiobj) {
        ComponentCollection col = uiobj.getComponents();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            ComponentInfo component = col.get(i);
            if (!"tblMain".equalsIgnoreCase(component.getName()) || !"com.kingdee.bos.ctrl.kdf.table.KDTable".equals(component.getClassType())) continue;
            return component;
        }
        return null;
    }

    private PropertyBindingCollection getPropertyBinds(QueryFieldInfo field, ComponentInfo table) {
        PropertyBindingCollection results = new PropertyBindingCollection();
        if (table != null && field != null) {
            PropertyBindingCollection bindings = table.getPropertyBindings();
            for (int i = 0; i < bindings.size(); ++i) {
                PropertyBindingInfo bind = bindings.get(i);
                String fieldName = bind.getBingdingField();
                if (fieldName == null || !fieldName.equals(field.getName())) continue;
                results.add(bind);
            }
        }
        return results;
    }

    private void deleteBindColumn(QueryFieldInfo queryField, ComponentInfo table) {
        PropertyBindingCollection bindings = this.getPropertyBinds(queryField, table);
        if (bindings != null && bindings.size() > 0) {
            TableInfo mainTable = DEPTableUtils.getTableInfo(table);
            for (int i = 0; i < bindings.size(); ++i) {
                ColumnInfo column;
                PropertyBindingInfo bind = bindings.get(i);
                String columnName = bind.getPropertyName();
                if (StringUtils.isEmpty((String)columnName) || columnName.indexOf(".") <= 0 || (column = DEPTableUtils.getColumn(mainTable, columnName = columnName.substring(0, columnName.indexOf(".")))) == null) continue;
                if (column.isConfigured()) {
                    DEPTableUtils.removeCell(mainTable, column);
                    mainTable.getColumns().remove(column);
                    table.getPropertyBindings().remove(bind);
                    DataBindUtils.delProBindDesc(table, bind);
                    continue;
                }
                column.setHide(true);
            }
            PropertyInfo property = table.getProperties().get("formatXml");
            property.setValue(KDTableDesignerHelper.getXmlFrom((TableInfo)mainTable));
            table.setConfigured(true);
        }
    }

    private void deleteQueryField(JoinQueryInfo query, QueryFieldInfo queryField) {
        String isCommonQueryFilter;
        if (queryField.isConfigured() && !"true".equalsIgnoreCase(isCommonQueryFilter = queryField.getExtendedProperty("isCommonQueryFilter"))) {
            DynQueryUtil.deleteFromQuery((QueryInfo)query, queryField);
            this.deleteSubObject(query, queryField);
        }
    }

    public void deleteSubObject(JoinQueryInfo query, QueryFieldInfo queryField) {
        PropertyRefCollection col = queryField.getPropertyRefs();
        for (int i = 0; i < col.size(); ++i) {
            PropertyRefInfo refInfo = col.get(i);
            SubEntityInfo subEntity = refInfo.getSubEntity();
            if (!this.canDelete(query, subEntity)) continue;
            try {
                query.removeSubObject((SubObjectInfo)subEntity);
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private boolean canDelete(JoinQueryInfo queryInfo, SubEntityInfo subEntity) {
        if (subEntity == null) {
            return false;
        }
        PropertyUnitCollection fields = queryInfo.getUnits();
        if (fields != null) {
            for (int i = 0; i < fields.size(); ++i) {
                PropertyUnitInfo unitInfo = fields.get(i);
                if (!(unitInfo instanceof QueryFieldInfo) || !this.isFieldFormSubEntity((QueryFieldInfo)unitInfo, subEntity)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isFieldFormSubEntity(QueryFieldInfo queryField, SubEntityInfo subEntity) {
        if (queryField != null && subEntity != null) {
            PropertyRefCollection col = queryField.getPropertyRefs();
            for (int i = 0; i < col.size(); ++i) {
                PropertyRefInfo refInfo = col.get(i);
                if (!subEntity.equals((Object)refInfo.getSubEntity())) continue;
                return true;
            }
        }
        return false;
    }

    public QueryFieldInfo addQueryField(JoinQueryInfo query, BizConfigureItemInfo item, AddFiledProcessing processing) {
        QueryFieldCollection collection = this.findQueryField(query, item);
        if (collection.isEmpty()) {
            return NewCtrlWizardDialog.addDynQueryFileds(processing);
        }
        return collection.get(0);
    }

    private void addColumn(QueryFieldInfo queryField, AddFiledProcessing processing) {
        UIObjectInfo listUI = this.bizunit.getListUI();
        List columnNames = this.getBindColumnNames(queryField, listUI);
        ComponentInfo tableMain = this.getTableMain(listUI);
        TableInfo mainTableInfo = DEPTableUtils.getTableInfo(tableMain);
        if (!columnNames.isEmpty()) {
            for (int i = 0; i < columnNames.size(); ++i) {
                String columnName = (String)columnNames.get(i);
                ColumnInfo column = DEPTableUtils.getColumn(mainTableInfo, columnName);
                if (column == null) {
                    BizConfigureItemInfo item1 = this.createItem(columnName, this.item);
                    this.addColumn(mainTableInfo, item1);
                    this.addDataBinding(processing, queryField.getName(), mainTableInfo);
                    continue;
                }
                if (!column.isHide()) continue;
                column.setHide(false);
            }
        } else {
            String suggestName = this.item.getProperty().getName();
            String columnName = DEPTableUtils.createColumnName(mainTableInfo, suggestName);
            String alias = this.item.getLabel();
            DEPTableUtils.addColumn(mainTableInfo, columnName, alias);
            processing.setTextName(columnName);
            this.addDataBinding(processing, queryField.getName(), mainTableInfo);
        }
        PropertyInfo property = tableMain.getProperties().get("formatXml");
        NewCtrlWizardDialog.storeFormatXml(property, mainTableInfo);
        tableMain.setConfigured(true);
    }

    private void addColumn(TableInfo tableMainInfo, BizConfigureItemInfo item) {
        String name = item.getProperty().getName();
        String alias = item.getLabel();
        DEPTableUtils.addColumn(tableMainInfo, name, alias);
    }

    private BizConfigureItemInfo createItem(String controlName, BizConfigureItemInfo source) {
        BizConfigureItemInfo newItem = new BizConfigureItemInfo();
        newItem.setControlName(controlName);
        newItem.setLabel(source.getLabel());
        newItem.setProperty(source.getProperty());
        return newItem;
    }

    private void addDataBinding(AddFiledProcessing processing, String bindField, TableInfo table) {
        processing.setQueryFiledName(bindField);
        processing.setFormatXml(KDTableDesignerHelper.getXmlFrom((TableInfo)table));
        NewCtrlWizardDialog.addListUIFiled(processing);
    }

    private AddFiledProcessing getProcessing(BizConfigureItemInfo item) {
        AddFiledProcessing.ProcessingInit init = (AddFiledProcessing.ProcessingInit)this.context.get("AddFiledPorcessingInit");
        AddFiledProcessing processing = init.initialize();
        processing.setUseAddFiled(true);
        processing.getProcessor("entity");
        processing.getProcessor("query");
        processing.getProcessor("listui");
        processing.setProxy(new PropertyInfoProxy(processing.getCurrentEntity()));
        processing.setFiledFromEntitySelf(false);
        processing.getProxy().setPropertyInfo(item.getProperty());
        if (item.getComponent() != null) {
            processing.setClassType(item.getComponent().getClassType());
        }
        processing.setIschkIsUseable(true);
        processing.setIschkIsVisible(true);
        processing.setTextName(item.getProperty().getName());
        processing.setListDisplay(true);
        if (item.getEntry() != null) {
            this.initProcessingForEntry(processing, item);
        } else {
            processing.setEntryEntitySelectIndex(-1);
        }
        return processing;
    }

    private void initProcessingForEntry(AddFiledProcessing processing, BizConfigureItemInfo item) {
        List entris = processing.getEntryEntityObject();
        EntityObjectInfo bindEntry = this.getBindEntry(item);
        if (bindEntry != null) {
            for (int i = 0; i < entris.size(); ++i) {
                List selectEntry = (List)entris.get(i);
                EntityObjectInfo entryEntityObject = (EntityObjectInfo)selectEntry.get(1);
                if (!bindEntry.getFullName().equals(entryEntityObject.getFullName())) continue;
                processing.setEntryEntitySelectIndex(i);
                break;
            }
        }
    }

    public QueryFieldCollection findQueryField(JoinQueryInfo query, BizConfigureItemInfo item) {
        if (item.getDataSource() != null) {
            return this.getLinkField(query, item);
        }
        QueryFieldCollection col = new QueryFieldCollection();
        QueryFieldInfo field = this.getOwenField(query, item);
        if (field != null) {
            col.add(field);
        }
        return col;
    }

    private QueryFieldInfo getOwenField(JoinQueryInfo query, BizConfigureItemInfo item) {
        SelectorInfo selector = query.getSelector();
        QueryFieldInfo field = null;
        SubObjectInfo subObject = this.getSubObject(query, item);
        if (subObject != null) {
            int n = selector.size();
            for (int i = 0; i < n; ++i) {
                PropertyRefInfo propertyRefInfo;
                SubEntityInfo subEntity;
                field = selector.get(i);
                PropertyRefCollection propertyRefs = field.getPropertyRefs();
                if (propertyRefs == null || propertyRefs.size() != 1 || (subEntity = (propertyRefInfo = propertyRefs.get(0)).getSubEntity()) == null || !subEntity.equals((Object)subObject)) continue;
                String refPropertyName = propertyRefInfo.getRefProperty().getName();
                if (!(refPropertyName = this.getLastName(refPropertyName)).equals(item.getProperty().getName())) continue;
                return field;
            }
        }
        return null;
    }

    private String getLastName(String fullName) {
        if (StringUtils.isEmpty((String)fullName)) {
            return "";
        }
        int pos = fullName.lastIndexOf(".");
        if (pos > 0) {
            return fullName.substring(pos + 1);
        }
        return fullName;
    }

    private SubObjectInfo getSubObject(JoinQueryInfo query, BizConfigureItemInfo item) {
        SubObjectInfo subObject = null;
        if (item.getEntry() != null) {
            EntityObjectInfo bindEntry = this.getBindEntry(item);
            subObject = DynQueryUtil.getSubEntity((QueryInfo)query, bindEntry);
        } else {
            try {
                subObject = query.getMainObject();
            }
            catch (BOSException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return subObject;
    }

    private QueryFieldCollection getLinkField(JoinQueryInfo query, BizConfigureItemInfo item) {
        QueryFieldCollection col = new QueryFieldCollection();
        SubObjectInfo leftSubObject = this.getSubObject(query, item);
        if (leftSubObject != null) {
            QueryFieldInfo field = null;
            SelectorInfo selector = query.getSelector();
            int n = selector.size();
            for (int i = 0; i < n; ++i) {
                JoinInfo joinInfo;
                JoinCollection join;
                field = selector.get(i);
                SubEntityInfo subEntity = this.getSubEntity(field);
                if (!this.isSubEntityConform(subEntity, item) || (join = subEntity.getJoinsFromSupplier()).size() != 1 || !(joinInfo = join.get(0)).getLeftObject().equals((Object)leftSubObject) || !this.isJoinItemConform(joinInfo, item)) continue;
                col.add(field);
            }
        }
        return col;
    }

    private SubEntityInfo getSubEntity(QueryFieldInfo field) {
        PropertyRefCollection propertyRefs = field.getPropertyRefs();
        if (propertyRefs != null && propertyRefs.size() == 1) {
            PropertyRefInfo propertyRefInfo = propertyRefs.get(0);
            return propertyRefInfo.getSubEntity();
        }
        return null;
    }

    public static boolean isMainObjectConform(JoinQueryInfo query, EntityObjectInfo entity) {
        try {
            SubObjectInfo mainObject = query.getMainObject();
            if (mainObject instanceof SubEntityInfo) {
                String fullName = ((SubEntityInfo)mainObject).getEntityRef().getFullName();
                if (entity.getFullName().equals(fullName)) {
                    return true;
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return false;
    }

    private boolean isItemConform(BizConfigureItemInfo item) {
        EntityObjectInfo entry;
        if (item == null || item.getProperty() == null) {
            return false;
        }
        return item.getEntry() == null || (entry = this.getBindEntry(item)) != null;
    }

    private boolean isSubEntityConform(SubEntityInfo subEntity, BizConfigureItemInfo item) {
        EntityObjectInfo dataSource = item.getDataSource();
        return this.isSameEntity(subEntity, dataSource);
    }

    private boolean isSameEntity(SubEntityInfo subEntity, EntityObjectInfo entity) {
        String entitypk;
        EntityObjectInfo entityRef;
        return subEntity != null && entity != null ? (entityRef = subEntity.getEntityRef()) != null && (entitypk = entityRef.getFullName()).equals(entity.getFullName()) : subEntity == null && entity == null;
    }

    private boolean isJoinItemConform(JoinInfo joinInfo, BizConfigureItemInfo item) {
        JoinItemCollection items = joinInfo.getJoinItems();
        for (int i = 0; i < items.size(); ++i) {
            JoinItemInfo joinItemInfo = items.get(i);
            PropertyUnitInfo leftField = this.getLeftField(joinInfo, joinItemInfo);
            if (!leftField.getRefPropertyName().equals(item.getProperty().getName())) continue;
            return true;
        }
        return false;
    }

    private PropertyUnitInfo getLeftField(JoinInfo joinInfo, JoinItemInfo joinItemInfo) {
        PropertyUnitInfo leftField = joinItemInfo.getLeftField();
        PropertyRefCollection refs = leftField.getPropertyRefs();
        for (int j = 0; j < refs.size(); ++j) {
            PropertyRefInfo refInfo = refs.get(j);
            SubEntityInfo subEntity = refInfo.getSubEntity();
            if (!subEntity.equals((Object)joinInfo.getLeftObject())) continue;
            return leftField;
        }
        return joinItemInfo.getRightField();
    }
}

