/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.dtp.ControlDefaultSizeManager;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.ui.dtp.kdtable.TableInfoHelper;
import com.kingdee.bos.ui.dtp.model.ComponentNameManager;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.layout.KDRectangle;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.BizDataTypeEnum;
import com.kingdee.eas.ep.DataSourceEnum;
import com.kingdee.eas.ep.client.depend.mutiLan.MutiLanUtil;
import com.kingdee.eas.ep.client.editor.addfiled.AddFiledProcessing;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.IContext;
import com.kingdee.eas.ep.client.editor.editui.designer.NewCtrlWizardDialog;
import com.kingdee.eas.ep.client.editor.editui.designer.TabbedPaneEditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.UictEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.editor.editui.designer.util.ComponentHelper;
import com.kingdee.eas.ep.client.editor.editui.designer.util.TableInfoUtils;
import com.kingdee.eas.ep.client.editor.kdtable.EditKDTableUI;
import com.kingdee.eas.ep.client.editor.kdtable.KDTableDesignerConfigUI;
import com.kingdee.eas.ep.client.editor.kdtable.TableDesignerUI;
import com.kingdee.eas.ep.client.model.BizConfigureItemCollection;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureTreeNode;
import com.kingdee.eas.ep.client.model.PropertyInfoProxy;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import com.kingdee.eas.ep.client.util.EntityEditorHelper;
import com.kingdee.eas.ep.client.util.EntriesManagerUtils;
import com.kingdee.eas.ep.client.util.UictUtils;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;

public class PaletteUtils {
    private static Logger logger = Logger.getLogger((String)PaletteUtils.class.getName());
    private AddFiledProcessing processing;
    private EditPartViewer viewer;
    private UIObjectInfo uiModel;
    private IContext context;
    private BizConfigureTreeNode node;
    private Object classType;
    private String itemName;
    private String name;
    private String alias;
    private int x;
    private int y;
    private TabbedPaneEditPart tabEditPart;
    private ComponentNameManager nameManager = null;
    private boolean isMult;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public PaletteUtils(EditPartViewer viewer, Object classType, String itemName) {
        this.viewer = viewer;
        this.uiModel = (UIObjectInfo)viewer.getContext().getUiModel();
        this.context = viewer.getContext();
        this.node = (BizConfigureTreeNode)((UictEditPartViewer)viewer).getNode();
        this.classType = classType;
        this.itemName = itemName;
        this.isMult = this.context.getOperate().getTarget().isMult();
    }

    public void addEntityFiled() {
        NewCtrlWizardDialog.addEntityFiled(this.processing);
    }

    public void addDynQueryFileds() {
        if (this.processing.hasListUI()) {
            NewCtrlWizardDialog.addDynQueryFileds(this.processing);
        }
    }

    public void addListUIFiled() {
        if (this.processing.hasListUI()) {
            NewCtrlWizardDialog.addListUIFiled(this.processing);
        }
    }

    public void addEditUICommpent() {
        NewCtrlWizardDialog.addEditUICommpent(this.processing, this.node, this.uiModel, this.processing.getClassType());
        BizConfigureItemCollection items = (BizConfigureItemCollection)this.node.getConfigureItems();
        if (items.size() > 0 && items.get(items.size() - 1).getComponent() != null) {
            items.get(items.size() - 1).getComponent().setExtendedProperty("dataType", ((BizDataTypeEnum)((Object)this.classType)).getValue());
        }
    }

    public void aaddEditUIEntryTableFiled() {
        NewCtrlWizardDialog.addEditUIEntryTableFiled(this.processing, this.context);
    }

    public AddFiledProcessing getProcessing() {
        return this.processing;
    }

    public void initProcessing(String MDPK) {
        AddFiledProcessing.ProcessingInit init = (AddFiledProcessing.ProcessingInit)this.viewer.getContext().get("AddFiledPorcessingInit");
        this.processing = init.initialize();
        this.processing.setUseAddFiled(true);
        this.processing.getProcessor("entity");
        PropertyInfoProxy proxy = new PropertyInfoProxy(this.processing.getBaseEntity());
        proxy.setDepend(this.processing.getDepend());
        this.processing.setProxy(proxy);
        this.setProxy(MDPK);
        if (this.classType.equals((Object)BizDataTypeEnum.OBJECT)) {
            if (MDPK == null) {
                throw new IllegalArgumentException("MDPK=null");
            }
            this.addObjectInfo(MDPK);
        } else {
            this.addPropertyInfo(MDPK);
        }
    }

    private void setProxy(String MDPK) {
        this.processing.setFiledFromEntitySelf(false);
        this.processing.getProxy().setDataType((BizDataTypeEnum)((Object)this.classType));
        if (this.classType.equals((Object)BizDataTypeEnum.OBJECT)) {
            this.processing.getProxy().setDataSourceType(DataSourceEnum.BASEDATA);
        } else {
            this.processing.getProxy().setDataSourceType(DataSourceEnum.SELF);
        }
        this.processing.getProxy().setConfigured(true);
        this.processing.setClassType(this.getClassType(this.classType));
        this.setClassType(this.processing, (BizDataTypeEnum)((Object)this.classType));
        if (this.classType.equals((Object)BizDataTypeEnum.ENUM)) {
            this.processing.getProxy().setEnumPK(MDPK);
        }
    }

    private void addPropertyInfo(String MDPK) {
        OwnPropertyInfo propertyInfo = null;
        propertyInfo = new OwnPropertyInfo();
        propertyInfo.setName(this.name);
        MutiLanUtil.setAlias(propertyInfo, this.alias);
        propertyInfo.setDataType(EntityEditorHelper.getPropertyType((BizDataTypeEnum)((Object)this.classType)));
        PropertyInfoProxy infoProxy = this.processing.getProxy();
        this.updateSelfInput(infoProxy, (BizDataTypeEnum)((Object)this.classType));
        propertyInfo.setLength(infoProxy.getLength());
        propertyInfo.setPrecision(infoProxy.getPrecision());
        propertyInfo.setDecimalDigits(infoProxy.getScale());
        infoProxy.setName(this.name);
        this.processing.setMult(this.isMult);
        propertyInfo.setMultilingual(this.isMult);
        this.processing.setTextName(this.name);
        this.processing.setTextLableName(this.alias);
        propertyInfo.setConfigured(true);
        propertyInfo.setExtendedProperty("isInCode", "true");
        propertyInfo.setExtendedProperty("isForMapping", "true");
        propertyInfo.setExtendedProperty("isForGrouping", "true");
        propertyInfo.setExtendedProperty("isForMatching", "true");
        propertyInfo.setExtendedProperty("enableFieldPermission", String.valueOf(true));
        propertyInfo.setExtendedProperty("dynExtendPropertyList", "isInCode|isForMapping|isForGrouping|isForMatching|enableFieldPermission");
        if (this.classType.equals((Object)BizDataTypeEnum.ENUM)) {
            propertyInfo.setMetadataRef(MDPK);
        }
        infoProxy.setPropertyInfo((PropertyInfo)propertyInfo);
        this.processing.setIschkIsUseable(true);
        this.processing.setIschkIsVisible(true);
    }

    private void addObjectInfo(String MDPK) {
        LinkPropertyInfo propertyInfo = null;
        propertyInfo = new LinkPropertyInfo();
        EntityObjectInfo objectInfo = UictUtils.loadEntity((IMetaDataPK)MetaDataPK.create((String)MDPK), this.processing.getDepend());
        EntityObjectInfo entity = this.processing.getBaseEntity();
        propertyInfo.setName(this.name);
        this.alias = this.getPropertyInfoAlias(entity, objectInfo.getAlias());
        MutiLanUtil.setAlias(propertyInfo, this.alias);
        RelationshipInfo relation = new RelationshipInfo();
        relation.setPackage(entity.getPackage());
        String relationName = "R_" + entity.getName() + "_" + objectInfo.getName() + "_" + this.name;
        relation.setName(relationName);
        relation.setType(RelationshipType.ASSOCIATION);
        relation.setClientCardinality(CardinalityType.ONE);
        relation.setSupplierCardinality(CardinalityType.ZERO_TO_ONE);
        relation.setClientObject(entity);
        relation.setSupplierObject(objectInfo);
        relation.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        propertyInfo.setRelationship(relation);
        this.processing.getProxy().setName(this.name);
        this.processing.getProxy().setDataSource(objectInfo);
        this.processing.setMult(this.isMult);
        this.processing.setTextName(this.name);
        this.processing.setTextLableName(this.alias);
        EntityViewInfo defaultView = entity.getDefaultView();
        if (defaultView == null) {
            defaultView = new EntityViewInfo();
            entity.setDefaultView(defaultView);
        }
        propertyInfo.setConfigured(true);
        propertyInfo.setExtendedProperty("isInCode", "true");
        propertyInfo.setExtendedProperty("isForMapping", "true");
        propertyInfo.setExtendedProperty("isForGrouping", "true");
        propertyInfo.setExtendedProperty("isForMatching", "true");
        propertyInfo.setExtendedProperty("enableFieldPermission", String.valueOf(true));
        propertyInfo.setExtendedProperty("dynExtendPropertyList", "isInCode|isForMapping|isForGrouping|isForMatching|enableFieldPermission");
        this.processing.getProxy().setPropertyInfo((PropertyInfo)propertyInfo);
        this.processing.setIschkIsUseable(true);
        this.processing.setIschkIsVisible(true);
    }

    public void addListUIColumn() {
        if (this.processing.hasListUI()) {
            this.processing.setListDisplay(true);
            this.processing.setCanFilter(true);
            this.processing.getProcessor("query");
            this.processing.getProcessor("listui");
            String xml = this.processing.getListUIInfo().getComponents().getComponentInfo("tblMain").getProperties().get("formatXml").getValue();
            TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)xml);
            this.addColumn(tableInfo);
            this.processing.setFormatXml(KDTableDesignerHelper.getXmlFrom((TableInfo)tableInfo));
            this.processing.setIschkIsUseable(true);
            this.processing.setIschkIsVisible(true);
        }
    }

    public void addColumn(TableInfo tableInfo) {
        ColumnInfo column = new ColumnInfo(tableInfo);
        column.setName(this.processing.getTextName());
        column.setWidth(80);
        column.setConfigured(true);
        tableInfo.addColumn(column);
        List heads = tableInfo.getHeaders();
        for (int i = 0; i < heads.size(); ++i) {
            HeaderInfo header = (HeaderInfo)heads.get(i);
            CellInfo cell = new CellInfo(header);
            cell.setName(this.processing.getTextLableName());
            cell.setConfigured(true);
            header.addCell(cell);
        }
    }

    public void addEditUIEntryColumn() {
        ComponentInfo cInfo = null;
        List selectEntry = (List)this.processing.getEntryEntityObject().get(this.processing.getEntryEntitySelectIndex());
        cInfo = (ComponentInfo)selectEntry.get(0);
        String xml = cInfo.getProperties().get("formatXml").getValue();
        TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)xml);
        this.addColumn(tableInfo);
        this.processing.setEntryFormatXml(KDTableDesignerHelper.getXmlFrom((TableInfo)tableInfo));
    }

    public String getComponentType(Object classType) {
        String componentName = null;
        if (BizDataTypeEnum.STRING.equals(classType)) {
            componentName = "com.kingdee.bos.ctrl.swing.KDTextField";
        } else if (BizDataTypeEnum.NOTE.equals(classType)) {
            componentName = "com.kingdee.bos.ctrl.swing.KDTextArea";
        } else if (BizDataTypeEnum.INTEGER.equals(classType)) {
            componentName = "com.kingdee.bos.ctrl.swing.KDNumberTextField";
        } else if (BizDataTypeEnum.DECIMAL.equals(classType)) {
            componentName = "com.kingdee.bos.ctrl.swing.KDNumberTextField";
        } else if (BizDataTypeEnum.DATE.equals(classType)) {
            componentName = "com.kingdee.bos.ctrl.swing.KDDatePicker";
        } else if (BizDataTypeEnum.BOOLEAN.equals(classType)) {
            componentName = "com.kingdee.bos.ctrl.swing.KDCheckBox";
        } else if (BizDataTypeEnum.AMOUNT.equals(classType)) {
            componentName = "com.kingdee.bos.ctrl.swing.KDNumberTextField";
        } else if (BizDataTypeEnum.PRICE.equals(classType)) {
            componentName = "com.kingdee.bos.ctrl.swing.KDNumberTextField";
        } else if (BizDataTypeEnum.QUANTITY.equals(classType)) {
            componentName = "com.kingdee.bos.ctrl.swing.KDNumberTextField";
        } else if (BizDataTypeEnum.IMAGE.equals(classType)) {
            componentName = "com.kingdee.eas.ep.client.KDPictureBox";
        }
        return componentName;
    }

    protected void updateSelfInput(PropertyInfoProxy infoProxy, BizDataTypeEnum bdEnum) {
        infoProxy.setScale(0);
        infoProxy.setPrecision(0);
        if (bdEnum.equals((Object)BizDataTypeEnum.STRING)) {
            infoProxy.setLength(50);
            infoProxy.setMultiLanguage(this.isMult);
        } else if (bdEnum.equals((Object)BizDataTypeEnum.DATE)) {
            infoProxy.setLength(8);
        } else if (bdEnum.equals((Object)BizDataTypeEnum.DECIMAL)) {
            infoProxy.setLength(28);
            infoProxy.setPrecision(28);
            infoProxy.setScale(10);
        } else if (bdEnum.equals((Object)BizDataTypeEnum.INTEGER)) {
            infoProxy.setLength(4);
            infoProxy.setPrecision(10);
            infoProxy.setScale(0);
        } else if (bdEnum.equals((Object)BizDataTypeEnum.QUANTITY)) {
            infoProxy.setLength(28);
            infoProxy.setPrecision(28);
            infoProxy.setScale(10);
        } else if (bdEnum.equals((Object)BizDataTypeEnum.AMOUNT)) {
            infoProxy.setLength(28);
            infoProxy.setPrecision(28);
            infoProxy.setScale(10);
        } else if (bdEnum.equals((Object)BizDataTypeEnum.PRICE)) {
            infoProxy.setLength(28);
            infoProxy.setPrecision(28);
            infoProxy.setScale(10);
        } else if (bdEnum.equals((Object)BizDataTypeEnum.NOTE)) {
            infoProxy.setLength(255);
            infoProxy.setMultiLanguage(this.isMult);
        } else if (bdEnum.equals((Object)BizDataTypeEnum.BOOLEAN)) {
            infoProxy.setLength(1);
            infoProxy.setDefaultValue("false");
        }
    }

    protected String getClassType(Object classType) {
        String type = null;
        if (classType.equals((Object)BizDataTypeEnum.STRING)) {
            type = "TextField";
        } else if (classType.equals((Object)BizDataTypeEnum.NOTE)) {
            type = "TextArea";
        } else if (classType.equals((Object)BizDataTypeEnum.BOOLEAN)) {
            type = "Bool";
        } else if (classType.equals((Object)BizDataTypeEnum.TIME)) {
            type = "TIME";
        } else if (classType.equals((Object)BizDataTypeEnum.DATE)) {
            type = "DATE";
        } else if (classType.equals((Object)BizDataTypeEnum.INTEGER) || classType.equals((Object)BizDataTypeEnum.DECIMAL) || classType.equals((Object)BizDataTypeEnum.AMOUNT) || classType.equals((Object)BizDataTypeEnum.PRICE) || classType.equals((Object)BizDataTypeEnum.QUANTITY)) {
            type = "Number";
        } else if (classType.equals((Object)BizDataTypeEnum.OBJECT)) {
            type = "F7";
        } else if (classType.equals((Object)BizDataTypeEnum.IMAGE)) {
            type = "Image";
        }
        return type;
    }

    public void setClassType(Object classType) {
        this.classType = classType;
    }

    public void setClassType(AddFiledProcessing processing, BizDataTypeEnum enType) {
        String classType = null;
        if (enType.equals((Object)BizDataTypeEnum.STRING)) {
            classType = "TextField";
        } else if (enType.equals((Object)BizDataTypeEnum.INTEGER) || enType.equals((Object)BizDataTypeEnum.DECIMAL) || enType.equals((Object)BizDataTypeEnum.AMOUNT) || enType.equals((Object)BizDataTypeEnum.PRICE) || enType.equals((Object)BizDataTypeEnum.QUANTITY)) {
            classType = "Number";
        } else if (enType.equals((Object)BizDataTypeEnum.DATE)) {
            classType = "Date";
        } else if (enType.equals((Object)BizDataTypeEnum.TIME)) {
            classType = "Time";
        } else if (enType.equals((Object)BizDataTypeEnum.BOOLEAN)) {
            classType = "Bool";
        } else if (enType.equals((Object)BizDataTypeEnum.NOTE)) {
            classType = "TextArea";
        } else if (enType.equals((Object)BizDataTypeEnum.OBJECT)) {
            classType = "F7";
        } else if (enType.equals((Object)BizDataTypeEnum.ENUM)) {
            classType = "Enum";
        } else if (BizDataTypeEnum.IMAGE.equals((Object)enType)) {
            classType = "Image";
        }
        processing.setClassType(classType);
    }

    public void setCurrentEntity(EntityObjectInfo entityObj) {
        this.processing.setCurrentEntity(entityObj);
        for (int i = 0; i < this.processing.getEntryEntityObject().size(); ++i) {
            EntityObjectInfo entityObjInfo = (EntityObjectInfo)((ArrayList)this.processing.getEntryEntityObject().get(i)).get(1);
            if (!(entityObj.getAlias() + "-" + entityObj.getName()).equals(entityObjInfo.getAlias() + "-" + entityObjInfo.getName())) continue;
            this.processing.getProcessor("entryentity" + entityObj.getAlias() + "-" + entityObj.getName() + this.processing.getCurrentEntity().getFullName());
            this.processing.setEntryEntitySelectIndex(i);
        }
    }

    public void initEntityProcessing() {
        AddFiledProcessing.ProcessingInit init = (AddFiledProcessing.ProcessingInit)this.viewer.getContext().get("AddFiledPorcessingInit");
        this.processing = init.initialize();
        this.processing.setUseAddFiled(true);
        this.processing.getProcessor("entity");
        PropertyInfoProxy proxy = new PropertyInfoProxy(this.processing.getCurrentEntity());
        proxy.setDepend(this.processing.getDepend());
        this.processing.setProxy(proxy);
        this.setLocation();
        this.addEntityInfo();
    }

    private void addEntityInfo() {
        if (this.nameManager == null) {
            this.nameManager = this.uiModel.getNameManager();
        }
        EntityObjectInfo bindEntity = this.processing.getEntityPro().getEntityInfo();
        EntityObjectInfo entity = null;
        if (bindEntity != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put("Owner", this);
            try {
                uiContext = new UIContext((Object)this);
                uiContext.put("Owner", this);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EditKDTableUI.class.getName(), (Map)uiContext);
                EditKDTableUI ui = (EditKDTableUI)uiWindow.getUIObject();
                ui.setNameManager(this.nameManager);
                uiWindow.show();
                entity = ui.getEntity();
                if (entity != null) {
                    String entityName = this.name = entity.getName();
                    this.processing.getProxy().setEntity(entity);
                    this.processing.getProxy().setName(entityName);
                    this.processing.setMult(this.isMult);
                    this.processing.setTextName(entityName);
                    this.processing.setTextLableName(entityName);
                    this.editEntityTable(ui);
                    this.viewer.getContext().setDirty(true);
                }
            }
            catch (UIException e) {
                logger.error((Object)"PaletteUtils.addEntityInfo", (Throwable)e);
            }
        }
    }

    private EntityObjectInfo getBindEntity(UIObjectInfo ui) {
        DataObjectCollection col = ui.getDataObjects();
        EntityObjectInfo entity = null;
        if (col != null) {
            DataObjectInfo doInfo = null;
            for (int i = 0; i < col.size(); ++i) {
                doInfo = col.get(i);
                if (!doInfo.getObjectType().equals(MetaDataTypeList.ENTITY.toString())) continue;
                entity = UictUtils.loadEntity((IMetaDataPK)MetaDataPK.create((String)doInfo.getType()), this.processing.getDepend());
            }
        }
        return entity;
    }

    public IMetaDataPK createMetaDataPK(String _package, String name) throws BOSException {
        MetaDataPK pk = MetaDataPK.create((String)_package, (String)name);
        boolean flag = true;
        for (long i = 1L; i < Long.MAX_VALUE; ++i) {
            flag = true;
            EntityObjectInfo tempEntity = UictUtils.loadEntity((IMetaDataPK)pk, this.processing.getDepend());
            if (UictUtils.isEmptyMD((AbstractMDValue)tempEntity)) {
                int n = this.processing.getEntryMeta().size();
                for (int m = 0; m < n; ++m) {
                    if (!(this.processing.getEntryMeta().get(m) instanceof EntityObjectInfo) || this.processing.getEntryMeta().get(m).toString().indexOf(pk.getFullName()) <= -1) continue;
                    flag = false;
                }
                if (flag) break;
            }
            pk = MetaDataPK.create((String)_package, (String)(name + i));
        }
        if (!UictUtils.isEmptyMD((AbstractMDValue)UictUtils.loadEntity((IMetaDataPK)pk, this.processing.getDepend()))) {
            throw new BOSException("failed create RelationShip because all the suitable name has been used!");
        }
        return pk;
    }

    public void addNewTabPanel(ComponentInfo parent, BizConfigureTreeNode node) {
        ComponentInfo cInfo = null;
        cInfo = ComponentHelper.createComponent(this.uiModel, "com.kingdee.bos.ctrl.swing.KDPanel", "tabpanel1", "\u65b0\u589e\u9875\u7b7e1", null);
        Dimension dim = ControlDefaultSizeManager.getDefaultSize((String)cInfo.getClassType());
        Object constraint = ComponentHelper.createContraint(parent, new Rectangle(10, 10, dim.width, dim.height));
        constraint = "\u65b0\u589e\u9875\u7b7e1";
        cInfo.setConstraint(constraint);
        parent.addChild((AbstractUIObjectInfo)this.uiModel, cInfo);
        this.addBizConfigureItem(cInfo, node, "\u65b0\u589e\u9875\u7b7e1", null);
    }

    public void addOnlyComponent() {
        ComponentInfo cInfo = ComponentHelper.createComponent(this.uiModel, (String)this.classType, this.name, this.alias, null);
        if (this.itemName != null && !"".equals(this.itemName)) {
            cInfo.setExtendedProperty("buildDetail", "true");
        }
        ComponentInfo parent = (ComponentInfo)this.node.getUserObject();
        Dimension dim = ControlDefaultSizeManager.getDefaultSize((String)cInfo.getClassType());
        Object constraint = ComponentHelper.createContraint(parent, new Rectangle(10, 10, dim.width, dim.height));
        cInfo.setConstraint(constraint);
        parent.addChild((AbstractUIObjectInfo)this.uiModel, cInfo);
        KDRectangle rect = new KDRectangle(new Rectangle(this.x, this.y, dim.width, dim.height));
        this.addBizConfigureItem(cInfo, this.node, this.name, rect);
        if ("com.kingdee.bos.ctrl.swing.KDTabbedPane".equals(cInfo.getClassType())) {
            for (int i = 0; i < this.node.getChildCount(); ++i) {
                BizConfigureTreeNode childNode = (BizConfigureTreeNode)((Object)this.node.getChildAt(i));
                if (!cInfo.equals(childNode.getUserObject())) continue;
                this.addNewTabPanel(cInfo, childNode);
                break;
            }
        }
    }

    private void addBizConfigureItem(ComponentInfo cInfo, BizConfigureTreeNode node, String componentName, KDRectangle rect) {
        BizConfigureItemInfo item = new BizConfigureItemInfo();
        ComponentInfo childField = EditUIEditorHelper.getNeedComponent(cInfo);
        childField.setConfigured(true);
        item.setName(childField.getName());
        item.setLabel(componentName);
        item.setLabelLength(100);
        item.setLabelUnderLine(true);
        item.setEnabled(true);
        item.setVisible(true);
        item.setRequired(false);
        item.setBounds(rect);
        item.setComponent(childField);
        BizConfigureItemCollection items = (BizConfigureItemCollection)node.getConfigureItems();
        items.add(item);
        if (EditUIEditorHelper.isXYOrKDLayout(cInfo) || "com.kingdee.bos.ctrl.kdf.table.KDTable".equals(cInfo.getClassType())) {
            BizConfigureTreeNode child = EditUIEditorHelper.createConfigureTreeNode(cInfo, this.uiModel, null);
            child.setItem(item);
            node.add((MutableTreeNode)((Object)child));
        }
    }

    public void editEntityTable(EditKDTableUI ui) {
        UictEditPartViewer uictviewer = (UictEditPartViewer)this.viewer;
        EditPart part = uictviewer.getPartManager().getPart2(this.x, this.y);
        BizConfigureItemInfoAdapter adapter = (BizConfigureItemInfoAdapter)part.getModel();
        ComponentInfo component = adapter.getItem().getComponent();
        TableInfo tableInfo = null;
        if (ui.getTabbedPaneIndex() == 0) {
            tableInfo = ui.getEmUI().getTableInfo();
        } else if (ui.getTabbedPaneIndex() == 1) {
            if (ui.getTableUI() instanceof TableDesignerUI) {
                tableInfo = ((TableDesignerUI)((Object)ui.getTableUI())).getTableInfo();
            } else if (ui.getTableUI() instanceof KDTableDesignerConfigUI) {
                tableInfo = ((KDTableDesignerConfigUI)((Object)ui.getTableUI())).getTableInfo();
            }
        } else if (ui.getTabbedPaneIndex() == 2) {
            tableInfo = ui.getHeadUI().getTableInfo();
        }
        EntriesManagerUtils util = new EntriesManagerUtils(this.uiModel, this.processing, tableInfo);
        if (uictviewer.getContext().isBase()) {
            AbstractUIObjectInfo uiModel;
            IContext context = uictviewer.getContext();
            if (context != null && (uiModel = context.getUiModel()) != null && uiModel instanceof UIObjectInfo) {
                util.extractTableSumInfo((UIObjectInfo)uiModel, component);
            }
            String formatXMLExt = TableInfoHelper.toFormatXmlExt((TableInfo)tableInfo);
            adapter.getItem().getComponent().setExtendedProperty("extend_formatxml", formatXMLExt);
            String order = EditUIEditorHelper.getTableColumnOrder(tableInfo);
            adapter.getItem().getComponent().setExtendedProperty("column_order", order);
            if (tableInfo.getMergeBlockCount() == 0) {
                PaletteUtils.storeFormatXml(adapter, tableInfo);
            } else {
                adapter.setFormatXml(KDTableDesignerHelper.getXmlFrom((TableInfo)tableInfo));
            }
            adapter.getItem().getComponent().setConfigured(true);
            uictviewer.getContext().setDirty(true);
        } else {
            String order = EditUIEditorHelper.getTableColumnOrder(tableInfo);
            adapter.getItem().getComponent().setExtendedProperty("column_order", order);
            String formatXml = KDTableDesignerHelper.getXmlFrom((TableInfo)tableInfo);
            adapter.setFormatXml(formatXml);
            uictviewer.getContext().setDirty(true);
        }
    }

    public static void storeFormatXml(BizConfigureItemInfoAdapter adapter, TableInfo tableInfo) {
        for (int i = 0; i < MutiLanUtil.EAS_LOCALES.length; ++i) {
            Locale locale = MutiLanUtil.EAS_LOCALES[i];
            String formatXml = "";
            String shortcode = BOSLocaleUtil.getShortCode((Locale)locale);
            if (shortcode != null && shortcode != BOSLocaleUtil.getShortCode((Locale)UIObjectInfo.currentLocale)) {
                formatXml = adapter.getFormatXml(locale);
                TableInfo otableInfo = KDTableDesignerHelper.getTableInfoFrom((String)formatXml);
                TableInfoUtils util = new TableInfoUtils();
                util.setCurrentLocale(AbstractUIObjectInfo.currentLocale);
                util.setTargetLocal(locale);
                util.synTableInfo(otableInfo, tableInfo);
                formatXml = KDTableDesignerHelper.getXmlFrom((TableInfo)otableInfo);
                adapter.setFormatXml(formatXml, locale, false);
                continue;
            }
            adapter.setFormatXml(KDTableDesignerHelper.getXmlFrom((TableInfo)tableInfo));
        }
    }

    public void setLocation(int x, int y) {
        this.processing.setX(x);
        this.processing.setY(y);
    }

    public void setLocation() {
        this.processing.setX(this.x);
        this.processing.setY(this.y);
    }

    public void setXY(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public EditPartViewer getViewer() {
        return this.viewer;
    }

    public ComponentNameManager getNameManager() {
        return this.nameManager;
    }

    public String getPropertyInfoAlias(EntityObjectInfo entity, String alias) {
        String aliasTemp = alias;
        int index = 0;
        PropertyCollection propertyCol = entity.getProperties();
        for (int i = 0; i < propertyCol.size(); ++i) {
            PropertyInfo info = propertyCol.get(i);
            if (!(info instanceof LinkPropertyInfo) || !info.getAlias().equalsIgnoreCase(aliasTemp)) continue;
            aliasTemp = alias + ++index;
        }
        return aliasTemp;
    }

    public void setNameManager(ComponentNameManager nameManager) {
        this.nameManager = nameManager;
    }
}

