/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.util;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.service.permission.metadata.BizPropertyInfo;
import com.kingdee.bos.service.permission.metadata.BizRefInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.MutableTreeNode;

public class PermissionDefineHelper {
    public static void generateItemTree(DefaultKingdeeTreeNode root, PermissionItemCollection collection) {
        if (root == null || collection == null) {
            throw new IllegalArgumentException("root and collection can not be null");
        }
        root.setText("root");
        root.setUserObject((Object)"root");
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            PermissionItemInfo item = collection.get(i);
            String group = item.getGroupName();
            DefaultKingdeeTreeNode node = PermissionDefineHelper.getTreeNodeByGroup(root, group);
            DefaultKingdeeTreeNode itemNode = new DefaultKingdeeTreeNode();
            itemNode.setUserObject((Object)item);
            String text = item.getAlias();
            text = StringUtils.isEmpty((String)text) ? item.getName() : text;
            itemNode.setText(text);
            node.add((MutableTreeNode)itemNode);
        }
    }

    private static DefaultKingdeeTreeNode getTreeNodeByGroup(DefaultKingdeeTreeNode root, String group) {
        if (StringUtils.isEmpty((String)group)) {
            return root;
        }
        String[] items = StringUtils.split((String)group, (String)".");
        return PermissionDefineHelper.getTreeNodeBySplitArray(root, items);
    }

    private static DefaultKingdeeTreeNode getTreeNodeBySplitArray(DefaultKingdeeTreeNode root, String[] items) {
        DefaultKingdeeTreeNode selectedNode = null;
        if (items.length >= 1) {
            String item = items[0];
            Enumeration children = root.children();
            while (children.hasMoreElements()) {
                String label;
                DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)children.nextElement();
                Object obj = child.getUserObject();
                if (!(obj instanceof String) || !(label = (String)obj).equals(item)) continue;
                selectedNode = child;
                break;
            }
            if (selectedNode == null) {
                selectedNode = new DefaultKingdeeTreeNode();
                selectedNode.setUserObject((Object)item);
                selectedNode.setText(item);
                root.add((MutableTreeNode)selectedNode);
            }
        }
        if (items.length == 1) {
            return selectedNode;
        }
        String[] otherItems = new String[items.length - 1];
        System.arraycopy(items, 1, otherItems, 0, items.length - 1);
        return PermissionDefineHelper.getTreeNodeBySplitArray(selectedNode, otherItems);
    }

    public static boolean setSelectedByUserObject(KDTree tree, DefaultKingdeeTreeNode root, Object userObj) {
        if (tree != null && root != null && userObj != null) {
            if (root.getUserObject() == userObj) {
                tree.setSelectionNode(root);
                return true;
            }
            Enumeration children = root.children();
            while (children.hasMoreElements()) {
                DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)children.nextElement();
                boolean ret = PermissionDefineHelper.setSelectedByUserObject(tree, child, userObj);
                if (!ret) continue;
                return true;
            }
        }
        return false;
    }

    public static void getCheckedNode(DefaultKingdeeTreeNode node, List list) {
        if (node != null && list != null) {
            if (node.getChildCount() == 0 && node.isChecked()) {
                list.add(node);
            } else {
                int size = node.getChildCount();
                for (int i = 0; i < size; ++i) {
                    PermissionDefineHelper.getCheckedNode((DefaultKingdeeTreeNode)node.getChildAt(i), list);
                }
            }
        }
    }

    public static String getPropertyText(BizPropertyInfo bpi, BizRefInfo bri, Project depend) {
        if (bpi != null && bri != null) {
            MethodInfo method;
            String s = bpi.getProperty();
            if (s == null) {
                s = "";
            }
            if ((method = PermissionDefineHelper.getMethodByInnerID(PermissionDefineHelper.getMetaData(bri), s, depend)) == null) {
                return s;
            }
            s = PermissionDefineHelper.getMethodDeclares(method);
            return s;
        }
        return "";
    }

    private static MetaDataInfo getMetaData(BizRefInfo bri) {
        if (bri != null) {
            return bri.getBizMetadataInfo();
        }
        return null;
    }

    private static String getMethodDeclares(MethodInfo info) {
        StringBuffer sb = new StringBuffer(info.getName());
        sb.append("(");
        ParameterCollection parmas = info.getParameters();
        for (int i = 0; i < parmas.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(parmas.get(i).getDataType());
            sb.append(" ");
            sb.append(parmas.get(i).getName());
        }
        sb.append(")");
        return sb.toString();
    }

    public static MethodInfo getMethodByInnerID(MetaDataInfo meta, String id, Project depend) {
        if (meta == null) {
            return null;
        }
        MetaDataPK pk = new MetaDataPK(meta.getPackage(), meta.getName());
        IObjectValue newModel = UictUtils.loadMD(PermissionDefineHelper.getBOSObjectType(meta.getMetaDataType()), (IMetaDataPK)pk, depend);
        if (newModel == null) {
            return null;
        }
        MethodCollection methods = null;
        if (MetaDataTypeList.ENTITY.toString().equals(meta.getMetaDataType())) {
            methods = PermissionDefineHelper.getEntityMethodCollection((EntityObjectInfo)newModel);
        } else if (MetaDataTypeList.FACADE.toString().equals(meta.getMetaDataType())) {
            methods = PermissionDefineHelper.getFacadeMethodCollection((FacadeInfo)newModel);
        }
        if (methods == null) {
            return null;
        }
        for (MethodInfo m : methods) {
            if (id == null || !id.equals(m.getString("innerID"))) continue;
            return m;
        }
        return null;
    }

    public static BOSObjectType getBOSObjectType(String type) {
        if (MetaDataTypeList.ENTITY.toString().equals(type)) {
            return MetaDataTypeList.ENTITY;
        }
        if (MetaDataTypeList.FACADE.toString().equals(type)) {
            return MetaDataTypeList.FACADE;
        }
        if (MetaDataTypeList.UIOBJECT.toString().equals(type)) {
            return MetaDataTypeList.UIOBJECT;
        }
        if (MetaDataTypeList.WEBUIOBJECT.toString().equals(type)) {
            return MetaDataTypeList.WEBUIOBJECT;
        }
        return null;
    }

    private static MethodCollection getEntityMethodCollection(EntityObjectInfo entity) {
        ArrayList allentity = new ArrayList();
        PermissionDefineHelper.listEntityParents(allentity, entity);
        MethodCollection methods = new MethodCollection();
        int n = allentity.size();
        for (int i = 0; i < n; ++i) {
            EntityObjectInfo entityInfo = (EntityObjectInfo)allentity.get(i);
            MethodCollection methods2 = entityInfo.getMethods();
            for (int j = 0; j < methods2.size(); ++j) {
                MethodInfo m = methods2.get(j);
                methods.add(m);
            }
        }
        return methods;
    }

    private static MethodCollection getFacadeMethodCollection(FacadeInfo facade) {
        ArrayList allfacade = new ArrayList();
        PermissionDefineHelper.listFacadeParents(allfacade, facade);
        MethodCollection methods = new MethodCollection();
        int n = allfacade.size();
        for (int i = 0; i < n; ++i) {
            FacadeInfo facadeInfo = (FacadeInfo)allfacade.get(i);
            MethodCollection methods2 = facadeInfo.getMethods();
            for (int j = 0; j < methods2.size(); ++j) {
                MethodInfo m = methods2.get(j);
                methods.add(m);
            }
        }
        return methods;
    }

    private static void listEntityParents(List list, EntityObjectInfo entity) {
        EntityObjectInfo parent = entity.getBaseEntity();
        if (parent != null) {
            PermissionDefineHelper.listEntityParents(list, parent);
        }
        list.add(entity);
    }

    private static void listFacadeParents(List list, FacadeInfo facade) {
        FacadeInfo parent = facade.getBaseFacade();
        if (parent != null) {
            PermissionDefineHelper.listFacadeParents(list, parent);
        }
        list.add(facade);
    }

    public static void refreshTreeText(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return;
        }
        Object uo = root.getUserObject();
        if (uo instanceof PermissionItemInfo) {
            PermissionItemInfo item = (PermissionItemInfo)uo;
            String text = item.getAlias();
            text = StringUtils.isEmpty((String)text) ? item.getName() : text;
            root.setText(text);
        }
        int n = root.getChildCount();
        for (int i = 0; i < n; ++i) {
            PermissionDefineHelper.refreshTreeText((DefaultKingdeeTreeNode)root.getChildAt(i));
        }
    }

    public static class ExtendPropertyInfo {
        Object key;
        Object value;
        String desc;

        public ExtendPropertyInfo(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public void setKey(Object key) {
            this.key = key;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
}

