/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.configure.IMetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.ExtendedTableCollection;
import com.kingdee.bos.metadata.data.ExtendedTableInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.ep.BizDataTypeEnum;
import com.kingdee.eas.ep.EPException;
import com.kingdee.eas.ep.client.util.UictColumnInfo;
import com.kingdee.eas.ep.depend.MetadataUtils;
import com.kingdee.eas.ep.util.EPUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;

public class UictUtils {
    private static Logger logger = Logger.getLogger((String)UictUtils.class.getName());
    public static final String strNull = "null";
    public static final String empty = "";

    public static IBriefViewTreeNode getBaseDataNode(IBriefViewTreeNode root) {
        UictUtils.removeNotBaseDataNode(root);
        return root;
    }

    private static void removeNotBaseDataNode(IBriefViewTreeNode node) {
        IBriefViewTreeNode child = null;
        if (node.getChildCount() > 0) {
            for (int i = node.getChildCount() - 1; i >= 0; --i) {
                child = (IBriefViewTreeNode)node.getChildAt(i);
                UictUtils.removeNotBaseDataNode(child);
                if (child.getChildCount() != 0) continue;
                if (child.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE)) {
                    node.remove((MutableTreeNode)child);
                    continue;
                }
                MetaDataBriefInfo mdInfo = child.getMetaDataObjectBriefInfo();
                BizUnitInfo info = UictUtils.loadBizUnit(mdInfo.getMetaDataPK());
                if (info == null || "BaseData".equalsIgnoreCase(info.getBizType().getName())) continue;
                node.remove((MutableTreeNode)child);
            }
        }
    }

    public static BizUnitInfo loadBizUnit(IMetaDataPK pk) {
        BizUnitInfo bizUnit = null;
        if (pk != null) {
            try {
                BizUnitInfo biz = (BizUnitInfo)UictUtils.loadMD(MetaDataTypeList.BIZUNIT, pk);
                return biz;
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return bizUnit;
    }

    public static BizUnitInfo loadBizUnit(IMetaDataPK pk, Project depend) {
        BizUnitInfo bizUnit = null;
        if (pk != null) {
            try {
                BizUnitInfo biz = (BizUnitInfo)UictUtils.loadMD(MetaDataTypeList.BIZUNIT, pk, depend);
                return biz;
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return bizUnit;
    }

    public static EntityObjectInfo loadEntity(IMetaDataPK pk, Project depend) {
        return (EntityObjectInfo)UictUtils.loadMD(MetaDataTypeList.ENTITY, pk, depend);
    }

    public static BizEnumInfo loadBizEnum(IMetaDataPK pk, Project depend) {
        return (BizEnumInfo)UictUtils.loadMD(MetaDataTypeList.BIZENUM, pk, depend);
    }

    public static FunctionObjectInfo loadFunction(IMetaDataPK pk, Project depend) {
        return (FunctionObjectInfo)UictUtils.loadMD(MetaDataTypeList.FUNCTION, pk, depend);
    }

    public static QueryInfo loadQuery(IMetaDataPK pk, Project depend) {
        QueryInfo query = (QueryInfo)UictUtils.loadMD(MetaDataTypeList.BASEQUERY, pk, depend);
        UictUtils.checkQuery(query);
        return query;
    }

    private static void checkQuery(QueryInfo query) {
        if (query instanceof JoinQueryInfo) {
            int i;
            JoinQueryInfo queryInfo = (JoinQueryInfo)query;
            JoinCollection joins = queryInfo.getJoins();
            SubObjectCollection subObjs = queryInfo.getSubObjects();
            HashMap rightMap = new HashMap();
            HashMap leftMap = new HashMap();
            if (joins.size() <= 1) {
                return;
            }
            for (i = 0; i < joins.size(); ++i) {
                JoinInfo join = joins.get(i);
                if (join != null && join.getLeftObject() != null) {
                    rightMap.put(join.getLeftObject().getName().toLowerCase(), null);
                }
                if (join == null || join.getRightObject() == null) continue;
                rightMap.put(join.getRightObject().getName().toLowerCase(), null);
            }
            for (i = 0; i < subObjs.size(); ++i) {
                SubObjectInfo sub = subObjs.get(i);
                if (leftMap.containsKey(sub.getName().toLowerCase()) || rightMap.containsKey(sub.getName().toLowerCase())) continue;
                subObjs.remove(sub);
            }
        }
    }

    public static UIObjectInfo loadUI(IMetaDataPK pk, Project depend) {
        return (UIObjectInfo)UictUtils.loadMD(MetaDataTypeList.UIOBJECT, pk, depend);
    }

    public static WebUIObjectInfo loadWebUI(IMetaDataPK pk, Project depend) {
        return (WebUIObjectInfo)UictUtils.loadMD(MetaDataTypeList.WEBUIOBJECT, pk, depend);
    }

    public static FacadeInfo loadFacade(IMetaDataPK pk, Project depend) {
        return (FacadeInfo)UictUtils.loadMD(MetaDataTypeList.FACADE, pk, depend);
    }

    public static PermissionInfo loadPermission(IMetaDataPK pk, Project depend) {
        return (PermissionInfo)UictUtils.loadMD(MetaDataTypeList.PERMISSION, pk, depend);
    }

    public static IObjectValue loadMD(BOSObjectType type, IMetaDataPK pk, Project depend) {
        MetadataUtils.clearCache(type);
        return MetadataUtils.loadMD(type, pk, depend);
    }

    public static EntityObjectInfo loadEntity(IMetaDataPK pk) {
        return (EntityObjectInfo)UictUtils.loadMD(MetaDataTypeList.ENTITY, pk);
    }

    public static BizEnumInfo loadBizEnum(IMetaDataPK pk) {
        return (BizEnumInfo)UictUtils.loadMD(MetaDataTypeList.BIZENUM, pk);
    }

    public static FunctionObjectInfo loadFunction(IMetaDataPK pk) {
        return (FunctionObjectInfo)UictUtils.loadMD(MetaDataTypeList.FUNCTION, pk);
    }

    public static QueryInfo loadQuery(IMetaDataPK pk) {
        return (QueryInfo)UictUtils.loadMD(MetaDataTypeList.BASEQUERY, pk);
    }

    public static UIObjectInfo loadUI(IMetaDataPK pk) {
        return (UIObjectInfo)UictUtils.loadMD(MetaDataTypeList.UIOBJECT, pk);
    }

    public static WebUIObjectInfo loadWebUI(IMetaDataPK pk) {
        return (WebUIObjectInfo)UictUtils.loadMD(MetaDataTypeList.WEBUIOBJECT, pk);
    }

    public static FacadeInfo loadFacade(IMetaDataPK pk) {
        return (FacadeInfo)UictUtils.loadMD(MetaDataTypeList.FACADE, pk);
    }

    public static PermissionInfo loadPermission(IMetaDataPK pk) {
        return (PermissionInfo)UictUtils.loadMD(MetaDataTypeList.PERMISSION, pk);
    }

    public static IObjectValue loadMD(BOSObjectType type, IMetaDataPK pk) {
        MetadataUtils.clearCache(type);
        return MetadataUtils.loadMD(type, pk);
    }

    public static EntityObjectInfo loadMD(BOSObjectType type) {
        if (type != null) {
            try {
                IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                return loader.loadMetameta(type);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    private static void befroeSave(AbstractMetaDataValue metadata) {
        if (metadata instanceof UIObjectInfo) {
            ComponentCollection toolBars = ((UIObjectInfo)metadata).getToolbarsPanel().getComponents();
            for (int i = 0; i < toolBars.size(); ++i) {
                ComponentInfo toolBar = toolBars.get(i);
                toolBar.setParent(null);
            }
        }
    }

    private static void befroeSave(AbstractMetaDataValue[] metadata) {
        for (int i = 0; i < metadata.length; ++i) {
            UictUtils.befroeSave(metadata[i]);
        }
    }

    public static void saveMetadata(AbstractMetaDataValue metadata, String customizedSchemeID, Project depend) throws Exception {
        UictUtils.befroeSave(metadata);
        IMetadataStore mdstore = MetadataStoreFactory.getMetadataStore(null);
        Project[] projects = new Project[]{};
        if (depend != null && depend.getDepend() != null && depend.getDepend().size() != 0) {
            projects = new Project[depend.getDepend().size()];
            projects = depend.getDepend().toArray(projects);
        }
        mdstore.saveMetadata(metadata, customizedSchemeID, projects);
    }

    public static void deleteMetadata(Project depend, IMetaDataPK pk, BOSObjectType type) {
        IMetadataStore mdstore = MetadataStoreFactory.getMetadataStore(null);
        try {
            mdstore.deleteMetadata(depend, pk, type);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public static String getXml(Project depend, IMetaDataPK pk, BOSObjectType type) {
        IMetadataStore mdstore = MetadataStoreFactory.getMetadataStore(null);
        String xml = empty;
        try {
            xml = mdstore.getXml(depend, pk, type);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return xml;
    }

    public static void saveMetadata(AbstractMetaDataValue[] mds, String customizedSchemeID, Project depend) throws Exception {
        UictUtils.befroeSave(mds);
        IMetadataStore mdstore = MetadataStoreFactory.getMetadataStore(null);
        Project[] projects = new Project[]{};
        if (depend != null && depend.getDepend() != null && depend.getDepend().size() != 0) {
            projects = new Project[depend.getDepend().size()];
            projects = depend.getDepend().toArray(projects);
        }
        try {
            mdstore.saveMetadata(mds, customizedSchemeID, projects);
        }
        catch (BOSException e) {
            if (e.getMessage().indexOf("METADATA_INCOMPLETE") == 0) {
                String name = e.getMessage().replace("METADATA_INCOMPLETE", empty);
                for (int i = 0; i < mds.length; ++i) {
                    if (!mds[i].getFullName().equals(name)) continue;
                    String entity = ((RelationshipInfo)mds[i]).getSupplierObject().getFullName();
                    throw new EPException(EPException.METADATA_INCOMPLETE, new Object[]{entity});
                }
            }
            throw e;
        }
    }

    public static List getConfigureColumnCollection(DataTableInfo table) {
        ColumnInfo column;
        if (table == null) {
            logger.warn((Object)"DataTableInfo is null,can not get the ColumnCollection");
            return null;
        }
        ArrayList<UictColumnInfo> configure = new ArrayList<UictColumnInfo>();
        ColumnCollection col = table.getColumns();
        int num = 0;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            column = col.get(i);
            if (!column.isConfigured()) continue;
            configure.add(new UictColumnInfo(column, false));
            ++num;
        }
        logger.info((Object)("\u672c\u8868\u6709" + num + "\u4e2a\u9884\u7559\u5b57\u6bb5"));
        ExtendedTableInfo extTable = UictUtils.getConfigureExtendedTable(table);
        if (extTable != null) {
            col = extTable.getColumns();
            num = 0;
            int size2 = col.size();
            for (int j = 0; j < size2; ++j) {
                column = col.get(j);
                if (!column.isConfigured()) continue;
                configure.add(new UictColumnInfo(column, true));
                ++num;
            }
            logger.info((Object)("\u6269\u5c55\u8868\u6709" + num + "\u4e2a\u9884\u7559\u5b57\u6bb5"));
        }
        return configure;
    }

    public static ExtendedTableInfo getConfigureExtendedTable(DataTableInfo table) {
        if (table == null) {
            logger.warn((Object)"DataTableInfo is null");
            return null;
        }
        ExtendedTableCollection tableCol = table.getExtendedTables();
        ExtendedTableInfo extTable = null;
        int size = tableCol.size();
        for (int i = 0; i < size; ++i) {
            extTable = tableCol.get(i);
            String isConfigure = extTable.getExtendedProperty("isConfigureExtendedTable");
            if (!"true".equals(isConfigure)) continue;
            return extTable;
        }
        logger.info((Object)"\u6ca1\u627e\u5230\u9884\u7559\u5b57\u6bb5\u7684\u6269\u5c55\u8868");
        return null;
    }

    public static List getCanUseColumnCollection(EntityObjectInfo entity, BizDataTypeEnum type) {
        if (entity == null) {
            logger.warn((Object)"EntityObjectInfo is null,can not get the ColumnCollection");
            return null;
        }
        List col = UictUtils.getConfigureColumnCollection(entity.getTable());
        if (col == null) {
            return null;
        }
        return UictUtils.getCanUseColumnCollection(entity, col, type);
    }

    public static List getCanUseColumnCollection(EntityObjectInfo entity, List col, BizDataTypeEnum type) {
        if (entity == null || col == null) {
            logger.warn((Object)"EntityObjectInfo or ColumnCollection is null,can not get the ColumnCollection");
            return null;
        }
        ArrayList<UictColumnInfo> canUse = new ArrayList<UictColumnInfo>();
        PropertyCollection pCol = entity.getProperties();
        boolean isUse = false;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            UictColumnInfo uci = (UictColumnInfo)col.get(i);
            isUse = false;
            int size2 = pCol.size();
            for (int j = 0; j < size2; ++j) {
                com.kingdee.bos.metadata.entity.PropertyInfo pInfo = pCol.get(j);
                if (("F" + StringUtils.headCharUpperCase((String)pInfo.getName())).equalsIgnoreCase(uci.getColumn().getName())) {
                    isUse = true;
                    break;
                }
                if (!("CF" + StringUtils.headCharUpperCase((String)pInfo.getName())).equalsIgnoreCase(uci.getColumn().getName())) continue;
                isUse = true;
                break;
            }
            if (isUse || !UictUtils.isCorrectType(uci.getColumn(), type)) continue;
            canUse.add(uci);
        }
        return canUse;
    }

    private static boolean isCorrectType(ColumnInfo column, BizDataTypeEnum type) {
        if (column == null) {
            return false;
        }
        if (type == null) {
            return true;
        }
        if (BizDataTypeEnum.STRING.equals((Object)type) || BizDataTypeEnum.NOTE.equals((Object)type)) {
            return column.getTypeName().equals((Object)SQLType.NVARCHAR);
        }
        if (BizDataTypeEnum.INTEGER.equals((Object)type) || BizDataTypeEnum.BOOLEAN.equals((Object)type)) {
            return column.getTypeName().equals((Object)SQLType.INT);
        }
        if (BizDataTypeEnum.DECIMAL.equals((Object)type) || BizDataTypeEnum.AMOUNT.equals((Object)type) || BizDataTypeEnum.PRICE.equals((Object)type) || BizDataTypeEnum.QUANTITY.equals((Object)type)) {
            return column.getTypeName().equals((Object)SQLType.NUMERIC);
        }
        if (BizDataTypeEnum.DATE.equals((Object)type)) {
            return column.getTypeName().equals((Object)SQLType.DATETIME);
        }
        if (BizDataTypeEnum.OBJECT.equals((Object)type) || BizDataTypeEnum.ENUM.equals((Object)type)) {
            return column.getTypeName().equals((Object)SQLType.VARCHAR);
        }
        return false;
    }

    public static String delFirstF(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        if (str.indexOf("F") == 0 && str.length() > 1) {
            return str.substring(1, str.length());
        }
        if (str.indexOf("CF") == 0 && str.length() > 2) {
            return str.substring(2, str.length());
        }
        return null;
    }

    public static final String getObjectString(Object obj) {
        if (obj == null) {
            return empty;
        }
        String str = String.valueOf(obj).trim();
        if (str.equals(strNull) || str.length() == 0) {
            str = empty;
        }
        return str;
    }

    public static final HashMap getEaslocaleFromKDMultiLangBox(KDMultiLangBox mlb) {
        HashMap<String, String> ps = new HashMap<String, String>();
        int z = mlb.getItemCount();
        for (int i = 0; i < z; ++i) {
            MultiLangItem mli = (MultiLangItem)mlb.getItemAt(i);
            String key = LangUtil.makeLang((Locale)mli.getLang().getLocale());
            String val = (String)mli.getData();
            ps.put(key, val);
        }
        return ps;
    }

    public static boolean isEmptyMD(AbstractMDValue amd) {
        return MetadataUtils.isEmptyMD(amd);
    }

    public static void updateProject() throws BOSException {
        try {
            EPUtils.clearCache();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String getAlias(ComponentInfo roundInfo) {
        if (UictUtils.isIgnore(roundInfo)) {
            return roundInfo.getName();
        }
        PropertyInfo property = null;
        String alias = null;
        if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(roundInfo.getClassType())) {
            alias = StringUtils.isEmpty((String)roundInfo.getAlias()) ? roundInfo.getName() : roundInfo.getAlias();
        } else if ("com.kingdee.bos.ctrl.swing.KDLabel".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDButton".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDWorkButton".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDRadioButton".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDCheckBox".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDMenu".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDMenuItem".equals(roundInfo.getClassType())) {
            property = roundInfo.getPropertyByName("text");
        } else if ("com.kingdee.bos.ctrl.swing.KDContainer".equals(roundInfo.getClassType())) {
            property = roundInfo.getPropertyByName("title");
        } else if ("com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(roundInfo.getClassType())) {
            property = roundInfo.getPropertyByName("boundLabelText");
        } else {
            if ("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDTextField".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDFormattedTextField".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDComboBox".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDDatePicker".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea".equals(roundInfo.getClassType())) {
                ComponentInfo parent = roundInfo.getParent();
                return UictUtils.getAlias(parent);
            }
            property = "com.kingdee.bos.ctrl.web.LabelContainer".equals(roundInfo.getClassType()) ? roundInfo.getPropertyByName("caption") : roundInfo.getPropertyByName("text");
        }
        if (property != null) {
            alias = property.getValue();
        }
        if (alias == null) {
            alias = roundInfo.getName();
        }
        return alias;
    }

    private static boolean isIgnore(ComponentInfo component) {
        if (component != null) {
            if (("com.kingdee.bos.ctrl.swing.KDTextArea".equalsIgnoreCase(component.getClassType()) || "com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea".equalsIgnoreCase(component.getClassType())) && component.getParent() != null && !"com.kingdee.bos.ctrl.swing.KDLabelContainer".equalsIgnoreCase(component.getParent().getClassType())) {
                return true;
            }
            if (component.getParent() != null && "com.kingdee.bos.ctrl.swing.KDLabelContainer".equalsIgnoreCase(component.getParent().getClassType())) {
                return false;
            }
        }
        return false;
    }
}

