/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.util;

import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class UploadToSharePlatform {
    private static final Logger logger = Logger.getLogger(UploadToSharePlatform.class);

    public static void doExport(byte[] bin, String postUrl, String fileName, String fileDes) {
        if (postUrl.indexOf("dep.script") > -1) {
            fileName = fileName + ".js";
        } else if (postUrl.indexOf("dep.scheme") > -1) {
            fileName = fileName + ".jar";
        }
        if (UploadToSharePlatform.isProcFileExist(postUrl, fileName)) {
            boolean confirm;
            boolean bl = confirm = MsgBox.showConfirm2((String)"\u5b58\u5728\u540c\u540d\u6587\u4ef6,\u662f\u5426\u8981\u8986\u76d6?") == 0;
            if (!confirm) {
                SysUtil.abort();
            }
        }
        UploadToSharePlatform.uploadToSP(fileName, fileDes, bin, postUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean uploadToSP(String uploadFile, String desc, byte[] io, String actionUrl) {
        String s = "";
        String end = "\r\n";
        String twoHyphens = "--";
        String boundary = "*****";
        boolean flag = false;
        FilterOutputStream ds = null;
        InputStream is = null;
        try {
            URL url = new URL(actionUrl);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setRequestMethod("POST");
            con.setRequestProperty("Connection", "Keep-Alive");
            con.setRequestProperty("Charset", "UTF-8");
            con.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
            ds = new DataOutputStream(con.getOutputStream());
            String filename = URLEncoder.encode(uploadFile, "UTF-8");
            ((DataOutputStream)ds).writeBytes(twoHyphens + boundary + end);
            ((DataOutputStream)ds).writeBytes("Content-Disposition: form-data; name=\"file\";filename=\"" + filename + "\"" + end);
            ((DataOutputStream)ds).writeBytes("Content-Type:application/octet-stream" + end);
            ((DataOutputStream)ds).writeBytes(end);
            int bufferSize = io.length;
            byte[] buffer = new byte[bufferSize];
            buffer = io;
            ((DataOutputStream)ds).write(buffer, 0, buffer.length);
            ((DataOutputStream)ds).writeBytes(end);
            ((DataOutputStream)ds).writeBytes(twoHyphens + boundary + end);
            ((DataOutputStream)ds).writeBytes("Content-Disposition: form-data; name=\"filedesc\"" + end);
            ((DataOutputStream)ds).writeBytes(end);
            String filedesc = URLEncoder.encode(desc, "UTF-8");
            byte[] descbuffer = filedesc.getBytes("UTF-8");
            ds.write(descbuffer);
            ((DataOutputStream)ds).writeBytes(end);
            ((DataOutputStream)ds).writeBytes(twoHyphens + boundary + twoHyphens + end);
            ((DataOutputStream)ds).flush();
            is = con.getInputStream();
            int bufferStringSize = 50;
            byte[] bufferString = new byte[bufferStringSize];
            while (is.read(bufferString) != -1) {
                s = new String(bufferString, "UTF-8");
            }
            logger.info((Object)("UploadToSharePlatform.uploadToSP inputStream " + s));
            if (s.indexOf("Access denied") != -1) {
                MsgBox.showInfo((String)"\u7f51\u7edc\u8d85\u65f6\uff01");
            } else if (s.indexOf("\u4e0a\u4f20\u6587\u4ef6\u6210\u529f") != -1) {
                MsgBox.showInfo((String)"\u4e0a\u4f20\u6210\u529f\uff01");
            }
            ds.close();
        }
        catch (Exception e) {
            logger.error((Object)"UploadToSharePlatform.uploadToSP", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (ds != null) {
                try {
                    ds.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    public static boolean isProcFileExist(String postUrl, String comparedname) {
        try {
            String resourceID = "dep.script";
            if (postUrl.indexOf("dep.script") > -1) {
                resourceID = "dep.script";
            } else if (postUrl.indexOf("dep.scheme") > -1) {
                resourceID = "dep.scheme";
            }
            URL wfurl = new URL("http://web20.kingdee.com/app/rest/resource/" + resourceID + "/0");
            SAXBuilder wfbuilder = new SAXBuilder();
            Document wfdoc = wfbuilder.build(wfurl);
            Element wfroot = wfdoc.getRootElement();
            List files = wfroot.getChildren();
            for (int k = 0; k < files.size(); ++k) {
                Element file = (Element)files.get(k);
                String fileName = file.getAttributeValue("filename");
                if (null == fileName || "".equals(fileName) || !fileName.equals(comparedname)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger.error((Object)"UploadToSP.isProcFileExist", (Throwable)e);
            return true;
        }
    }
}

