/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.util;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.eas.ep.ExtendPointInfo;
import com.kingdee.eas.ep.ExtendPointParamCollection;
import com.kingdee.eas.ep.PlugInInfo;
import com.kingdee.eas.ep.client.editor.editui.designer.Target;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;

public class UserBehaviorCollector {
    private static final int MESSAGELEVEL = 3;
    private static final String IMPORTBIZUNIT = "DEP-ImportBizUnit-";
    private static final String IMPORTENTITY = "DEP-ImportEntity-";
    private static final String IMPORTQUERY = "DEP-ImportQuery-";
    private static final String IMPORTUI = "DEP-ImportUI-";
    private static final String CREATECOMPONENT = "DEP-CreateComponent-";
    private static final String USERCONFIGURE = "DEP-UserConfigure-";
    private static final String CREATEBIZRULE = "DEP-CreateBizRule-";
    private static final String SAVEPLUGINSCRIPT = "DEP-SavePluginScript-";

    public static void fireImportBizUnit(BizUnitInfo bizunit) {
        if (bizunit != null) {
            UserBehaviorCollector.sendMessage(IMPORTBIZUNIT + bizunit.getFullName());
        }
    }

    public static void fireImportEntity(EntityObjectInfo entity) {
        if (entity != null) {
            UserBehaviorCollector.sendMessage(IMPORTENTITY + entity.getFullName());
        }
    }

    public static void fireImportQuery(QueryInfo query) {
        if (query != null) {
            UserBehaviorCollector.sendMessage(IMPORTQUERY + query.getFullName());
        }
    }

    public static void fireImportUI(UIObjectInfo ui) {
        if (ui != null) {
            UserBehaviorCollector.sendMessage(IMPORTUI + ui.getFullName());
        }
    }

    public static void fireCreateComponent(Target target) {
        StringBuffer message = new StringBuffer(CREATECOMPONENT);
        message.append(target.getClassType());
        String name = target.getName();
        if (!StringUtils.isEmpty((String)name)) {
            message.append("-");
            message.append(name);
        }
        UserBehaviorCollector.sendMessage(message.toString());
    }

    public static void fireUserConfigure(IMetaDataPK pk) {
        if (pk != null) {
            UserBehaviorCollector.sendMessage(USERCONFIGURE + pk.getFullName());
        }
    }

    public static void fireSavePluginScript(PlugInInfo plugin) {
        ExtendPointInfo point = plugin.getPoint();
        if (point != null) {
            StringBuffer buffer = new StringBuffer(SAVEPLUGINSCRIPT);
            buffer.append(point.getName());
            ExtendPointParamCollection params = point.getParam();
            if (params != null && !params.isEmpty()) {
                buffer.append("(");
                for (int i = 0; i < params.size(); ++i) {
                    if (i != 0) {
                        buffer.append(",");
                    }
                    buffer.append(params.get(i).getType());
                }
                buffer.append(")");
            }
            UserBehaviorCollector.sendMessage(buffer.toString());
        }
    }

    public static void fireCreateBizRule(String ruleName) {
        if (!StringUtils.isEmpty((String)ruleName)) {
            UserBehaviorCollector.sendMessage(CREATEBIZRULE + ruleName);
        }
    }

    private static void sendMessage(String message) {
        try {
            Class<?> staticUtil = Class.forName("com.kingdee.eas.base.uiframe.client.ui.web20.statistics.StatisticsUtil");
            Class[] methodParams = new Class[]{Integer.TYPE, String.class};
            Method method = staticUtil.getMethod("send", methodParams);
            Object[] invokeParams = new Object[]{new Integer(3), message};
            method.invoke(null, invokeParams);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

