/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizrule.RuleSetInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.layout.UILayoutConfigInfo;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ep.EditUIConfigureFactory;
import com.kingdee.eas.ep.EditUIConfigureInfo;
import com.kingdee.eas.ep.EditUIUserOrgUictFactory;
import com.kingdee.eas.ep.EditUIUserOrgUictInfo;
import com.kingdee.eas.ep.IEditUIConfigure;
import com.kingdee.eas.ep.IEditUIUserOrgUict;
import com.kingdee.eas.ep.client.model.BizConfigureTreeNode;
import com.kingdee.eas.ep.client.runtime.ActionUserScheme;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class UserConfigureUtils {
    private static final Logger logger = Logger.getLogger(UserConfigureUtils.class);
    public static final Project userConfigureProject = new Project("GAua9S29TkGmh7sO70jeUSyY1lE=");
    public static final String target = "target";

    public static void storeConfigureModel(BizUnitInfo bizUnit, EditUIConfigureInfo configure, BizConfigureTreeNode root) throws Exception {
        RuleSetInfo ruleSet;
        UIObjectInfo editUI = bizUnit.getEditUI();
        UILayoutConfigInfo uiObj = new UILayoutConfigInfo(editUI.getPackage(), editUI.getName(), editUI.getAlias());
        EditUIEditorHelper.adjustMainPanel(uiObj, root);
        EditUIEditorHelper.adjustComponents(uiObj, root);
        String title = root.getItem().getLabel();
        if (!uiObj.isEmpty() || !StringUtils.equals((String)title, (String)editUI.getTitle())) {
            uiObj.setTitle(editUI.getTitle());
            configure.setUIObject(uiObj.toJSONObject().toString());
        }
        if ((ruleSet = EditUIEditorHelper.createRuleSetForUserConfigure(root, bizUnit)).getRules() != null && !ruleSet.getRules().isEmpty()) {
            String xml = EditUIEditorHelper.getRuleSetXml(ruleSet);
            configure.setBizRuleSet(xml);
        } else {
            configure.setBizRuleSet(null);
        }
    }

    public static void assign(EditUIConfigureInfo configure) {
        try {
            EditUIUserOrgUictInfo assignInfo = new EditUIUserOrgUictInfo();
            assignInfo.setConfigure(configure);
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            assignInfo.setUser(userInfo);
            IEditUIUserOrgUict instance = EditUIUserOrgUictFactory.getRemoteInstance();
            instance.addnew(assignInfo);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public static void clearAssign(EditUIConfigureInfo configure) {
        try {
            IEditUIUserOrgUict instance = EditUIUserOrgUictFactory.getRemoteInstance();
            instance.delete("WHERE configure = '" + configure.getId().toString() + "'");
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public static boolean isCustomized(String uipk) throws BOSException, EASBizException {
        IEditUIConfigure instance = EditUIConfigureFactory.getRemoteInstance();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        FilterItemInfo schemeItem = new FilterItemInfo("customizedSchemeID", (Object)userConfigureProject.getId());
        FilterItemInfo pkItem = new FilterItemInfo("UIObjectPK", (Object)uipk);
        filterItems.add(schemeItem);
        filterItems.add(pkItem);
        filter.setMaskString("#0 and #1");
        return instance.exists(filter);
    }

    public static void installUserSchemeSevice(CoreUIObject ui) {
        if (ui instanceof EditUI) {
            try {
                String paramValue = ParamManager.getParamValue(null, (String)"IS_User_Scheme_Show");
                if (paramValue != null && paramValue.equalsIgnoreCase("true")) {
                    IMetaDataPK pk = ((EditUI)ui).getMetaDataPK();
                    KDToolBar toolBar = ui.getUIToolBar();
                    if (toolBar == null || UserConfigureUtils.exist(toolBar) || !UserConfigureUtils.canUserConfigure(pk)) {
                        return;
                    }
                    KDWorkButton btn = UserConfigureUtils.createUserSchemeBtn(ui);
                    Icon icon = EASResource.getIcon((String)"imgTbtn_quit");
                    String text = UIFrameResource.getString((String)"close");
                    int count = toolBar.getComponentCount();
                    if (icon != null && !StringUtils.isEmpty((String)text)) {
                        for (int i = count - 1; i >= 0; --i) {
                            Component component = toolBar.getComponent(i);
                            if (!(component instanceof KDWorkButton) || !icon.equals(((KDWorkButton)component).getIcon())) continue;
                            toolBar.add((Component)btn, i);
                            return;
                        }
                    }
                    toolBar.add((Component)btn);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e, (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private static boolean exist(KDToolBar toolBar) {
        int count = toolBar.getComponentCount();
        for (int i = count - 1; i >= 0; --i) {
            Component component = toolBar.getComponent(i);
            if (!"btnUserScheme".equals(component.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean canUserConfigure(IMetaDataPK pk) {
        String fullName;
        IMetaDataLoader loader;
        UIObjectInfo ui;
        return pk != null && (ui = (UIObjectInfo)(loader = MetaDataLoaderFactory.getRemoteMetaDataLoader()).get(MetaDataTypeList.UIOBJECT, pk)) != null && ((fullName = pk.getFullName()).startsWith("com.kingdee.eas.") && !fullName.startsWith("com.kingdee.eas.bos.") && !fullName.startsWith("com.kingdee.eas.base.") || ui.isDynamic());
    }

    private static KDWorkButton createUserSchemeBtn(CoreUIObject ui) {
        KDWorkButton btn = new KDWorkButton();
        btn.setName("btnUserScheme");
        ActionUserScheme userScheme = new ActionUserScheme((IUIObject)ui);
        btn.setAction((Action)((Object)userScheme));
        btn.setIcon(EASResource.getIcon((String)"imgTbtn_signup"));
        ResourceBundleHelper helper = new ResourceBundleHelper(ActionUserScheme.class.getName());
        btn.setToolTipText(helper.getString("alias"));
        btn.setText(helper.getString("alias"));
        return btn;
    }
}

