/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.util.move;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.ep.client.util.move.MosueLocationChangeEvent;
import com.kingdee.eas.ep.client.util.move.MosueLocationChangeListener;
import com.kingdee.eas.ep.client.util.move.MoveMouseAdapter;
import com.kingdee.eas.ep.client.util.move.MoveSplitPaneDivider;
import com.kingdee.eas.ep.client.util.move.MoveSplitPaneUI;
import com.kingdee.eas.ep.util.ConfigServiceUtils;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.apache.log4j.Logger;

public class SplitPaneMoveHelper {
    private static final Logger logger = Logger.getLogger(SplitPaneMoveHelper.class);
    private static final List registerServiceList = new ArrayList();
    private static final int DEFAULT_HIDE_DIVIDERLOCATION = Integer.MIN_VALUE;
    private static final int DEFAULT_SHOW_DIVIDERLOCATION = Integer.MIN_VALUE;
    private int dividerLocationAtHide = Integer.MIN_VALUE;
    private int dividerLocationAtShow = Integer.MIN_VALUE;
    private int showSize = Integer.MIN_VALUE;
    public static final int DIVIDER_STATUS_OPEN = 0;
    public static final int DIVIDER_STATUS_CLOSE = 1;
    private int currentDividerStatus = 0;
    private int intHideLocation = -1;
    private static final int TOPLOCATION_INT = 1;
    private static final int LEFTLOCATION_INT = 2;
    private static final int RIGHTLOCATION_INT = 3;
    private static final int BOTTOMLOCATION_INT = 4;
    private Map mapHideLocation = null;
    private List listenersLoc = new ArrayList();
    private JSplitPane splitPane = null;
    private List topComponents = new ArrayList();
    private int currentMouseLocation = -1;
    private Timer moveTimer = null;
    private boolean isRunning = true;
    private MoveSplitPaneDivider divider = null;

    public static final void registerService(JSplitPane splitPane, String constraints) {
        SplitPaneMoveHelper.registerService(splitPane, constraints, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public static final void registerService(JSplitPane splitPane, String constraints, int hideLoaction, int showLocation) {
        registerServiceList.add(new SplitPaneMoveHelper(splitPane, constraints, hideLoaction, showLocation));
    }

    private SplitPaneMoveHelper(JSplitPane splitPane, String constraints, int dividerLocationAtHide, int dividerLocationAtShow) {
        this.splitPane = splitPane;
        MoveSplitPaneUI ui = new MoveSplitPaneUI(splitPane, this);
        this.splitPane.setUI(ui);
        this.divider = (MoveSplitPaneDivider)ui.getDivider();
        this.splitPane.setDividerSize(20);
        splitPane.setOneTouchExpandable(true);
        this.mapHideLocation = this.getHideCompoentByConstraints(splitPane, constraints);
        this.dividerLocationAtHide = dividerLocationAtHide;
        this.dividerLocationAtShow = dividerLocationAtShow;
        this.initAllTopComponent(this.topComponents, (Container)this.mapHideLocation.get(new Integer(this.intHideLocation)), (Component)this.mapHideLocation.get(new Integer(this.intHideLocation)));
        this.initMouseListener();
        String userConfig = ConfigServiceUtils.getUserConfigData(splitPane.getName(), (IMetaDataPK)new MetaDataPK(this.getClass().getName()));
        ui.setStickLabStatus(Boolean.valueOf(userConfig));
    }

    private Map getHideCompoentByConstraints(JSplitPane splitPane, String constraints) {
        HashMap<Integer, Component> retVal = new HashMap<Integer, Component>();
        if ("left".equals(constraints)) {
            this.intHideLocation = 2;
            retVal.put(new Integer(2), splitPane.getLeftComponent());
        } else if ("right".equals(constraints)) {
            this.intHideLocation = 3;
            retVal.put(new Integer(3), splitPane.getRightComponent());
        } else if ("top".equals(constraints)) {
            this.intHideLocation = 1;
            retVal.put(new Integer(1), splitPane.getTopComponent());
        } else if ("bottom".equals(constraints)) {
            this.intHideLocation = 4;
            retVal.put(new Integer(4), splitPane.getBottomComponent());
        } else {
            throw new IllegalArgumentException("constraints \u53c2\u6570\u9519\u8bef!");
        }
        return retVal;
    }

    private void initAllTopComponent(List retVal, Container container, Component hideComponent) {
        Component[] components = container.getComponents();
        if (components.length == 0) {
            retVal.add(container);
        }
        for (int i = 0; i < components.length; ++i) {
            Component c = components[i];
            if (!(c instanceof Container)) continue;
            Container c1 = (Container)c;
            if (hideComponent != container) {
                retVal.add(container);
            }
            this.initAllTopComponent(retVal, c1, hideComponent);
        }
    }

    public void onMouseExited(MouseEvent e) {
        Component comp = (Component)this.mapHideLocation.get(new Integer(this.intHideLocation));
        switch (this.intHideLocation) {
            case 1: {
                break;
            }
            case 2: {
                if (e.getX() > this.splitPane.getX() && e.getX() >= comp.getX()) break;
                return;
            }
            case 3: {
                if (e.getX() < comp.getWidth()) break;
                return;
            }
            case 4: {
                break;
            }
        }
        this.setCurrentMouseLocation(-1);
    }

    public void onMouseEntered(MouseEvent e) {
        this.setCurrentMouseLocation(1);
    }

    public void onMouseMoved(MouseEvent e) {
        try {
            this.reSetMouseLocationAtHideComp(e);
        }
        catch (AWTException e1) {
            logger.error((Object)"\u8c03\u6574\u9f20\u6807\u4f4d\u7f6e\u51fa\u9519", (Throwable)e1);
        }
    }

    private void initMouseListener() {
        MoveMouseAdapter adapter1 = new MoveMouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                SplitPaneMoveHelper.this.onMouseMoved(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                SplitPaneMoveHelper.this.onMouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SplitPaneMoveHelper.this.onMouseExited(e);
            }
        };
        Component comp = (Component)this.mapHideLocation.get(new Integer(this.intHideLocation));
        comp.addMouseMotionListener(adapter1);
        comp.addMouseListener(adapter1);
        MoveMouseAdapter adapter2 = new MoveMouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                Component comp = (Component)SplitPaneMoveHelper.this.mapHideLocation.get(new Integer(SplitPaneMoveHelper.this.intHideLocation));
                MouseEvent newE = SwingUtilities.convertMouseEvent(e.getComponent(), e, comp);
                comp.dispatchEvent(newE);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Component comp = (Component)SplitPaneMoveHelper.this.mapHideLocation.get(new Integer(SplitPaneMoveHelper.this.intHideLocation));
                MouseEvent newE = SwingUtilities.convertMouseEvent(e.getComponent(), e, comp);
                comp.dispatchEvent(newE);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                Component comp = (Component)SplitPaneMoveHelper.this.mapHideLocation.get(new Integer(SplitPaneMoveHelper.this.intHideLocation));
                MouseEvent newE = SwingUtilities.convertMouseEvent(e.getComponent(), e, comp);
                comp.dispatchEvent(newE);
            }
        };
        for (int i = 0; i < this.topComponents.size(); ++i) {
            Component c;
            Component temp = c = (Component)this.topComponents.get(i);
            temp.addMouseMotionListener(adapter2);
            temp.addMouseListener(adapter2);
        }
        final BasicSplitPaneDivider container = ((BasicSplitPaneUI)this.splitPane.getUI()).getDivider();
        MoveMouseAdapter adapter3 = new MoveMouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                try {
                    SplitPaneMoveHelper.this.reSetMouseLocationAtDivider(e);
                }
                catch (AWTException e1) {
                    logger.error((Object)"\u8c03\u6574\u9f20\u6807\u4f4d\u7f6e\u51fa\u9519", (Throwable)e1);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                SplitPaneMoveHelper.this.setCurrentMouseLocation(0);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                logger.debug((Object)("e.getX()" + e.getX()));
                switch (SplitPaneMoveHelper.this.intHideLocation) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (e.getX() >= 0) break;
                        return;
                    }
                    case 3: {
                        logger.debug((Object)("container.getWidth()" + container.getWidth()));
                        if (e.getX() <= container.getWidth()) break;
                        return;
                    }
                    case 4: {
                        break;
                    }
                }
                SplitPaneMoveHelper.this.setCurrentMouseLocation(-1);
            }
        };
        container.addMouseListener(adapter3);
        container.addMouseMotionListener(adapter3);
        MoveMouseAdapter adapter4 = new MoveMouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                MouseEvent newE = SwingUtilities.convertMouseEvent(e.getComponent(), e, container);
                container.dispatchEvent(newE);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MouseEvent newE = SwingUtilities.convertMouseEvent(e.getComponent(), e, container);
                container.dispatchEvent(newE);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                MouseEvent newE = SwingUtilities.convertMouseEvent(e.getComponent(), e, container);
                container.dispatchEvent(newE);
            }
        };
        ArrayList list = new ArrayList();
        this.initAllTopComponent(list, container, container);
        for (int i = 0; i < list.size(); ++i) {
            Component c = (Component)list.get(i);
            c.addMouseListener(adapter4);
            c.addMouseMotionListener(adapter4);
        }
        this.listenersLoc.add(new MosueLocationChangeListener(this));
    }

    private void reSetMouseLocationAtHideComp(MouseEvent e) throws AWTException {
        if (!this.isRunning) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        Component comp = (Component)this.mapHideLocation.get(new Integer(this.intHideLocation));
        switch (this.intHideLocation) {
            case 1: {
                break;
            }
            case 2: {
                if (x > comp.getX()) break;
                Point oldP = new Point(comp.getX() + 5, y);
                SwingUtilities.convertPointToScreen(oldP, comp);
                Robot Robot2 = new Robot();
                Robot2.mouseMove((int)oldP.getX(), (int)oldP.getY());
                break;
            }
            case 3: {
                Point newPoint = SwingUtilities.convertPoint(comp, e.getPoint(), this.splitPane);
                if (!(newPoint.getX() > (double)(this.splitPane.getWidth() - 5))) break;
                Point oldP = new Point(this.splitPane.getWidth() - 5, y);
                SwingUtilities.convertPointToScreen(oldP, this.splitPane);
                Robot Robot3 = new Robot();
                Robot3.mouseMove((int)oldP.getX(), (int)oldP.getY());
                break;
            }
            case 4: {
                break;
            }
        }
    }

    private void reSetMouseLocationAtDivider(MouseEvent e) throws AWTException {
        if (!this.isRunning) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        int w = ((BasicSplitPaneUI)this.splitPane.getUI()).getDivider().getWidth();
        if (this.currentDividerStatus == 0) {
            return;
        }
        switch (this.intHideLocation) {
            case 1: {
                break;
            }
            case 2: {
                if (x > 0) break;
                Point oldP = new Point(0, y);
                SwingUtilities.convertPointToScreen(oldP, ((BasicSplitPaneUI)this.splitPane.getUI()).getDivider());
                Robot Robot2 = new Robot();
                Robot2.mouseMove((int)oldP.getX(), (int)oldP.getY());
                break;
            }
            case 3: {
                if (x < w) break;
                Point oldP = new Point(w, y);
                SwingUtilities.convertPointToScreen(oldP, ((BasicSplitPaneUI)this.splitPane.getUI()).getDivider());
                Robot Robot3 = new Robot();
                Robot3.mouseMove((int)oldP.getX(), (int)oldP.getY());
                break;
            }
            case 4: {
                break;
            }
        }
    }

    public void stopMoveService() {
        this.isRunning = false;
    }

    public void startMoveService() {
        this.isRunning = true;
    }

    public void onMouseLocationChenged(MosueLocationChangeEvent event) {
        if (!this.isRunning) {
            return;
        }
        int oldLocation = event.getOldLocation();
        int newLocation = event.getNewLocation();
        if (oldLocation == 1 && newLocation == -1 || oldLocation == 0 && newLocation == -1) {
            logger.debug((Object)("oldLocation:" + MosueLocationChangeEvent.debugMap.get(new Integer(oldLocation)) + ",newLocation:" + MosueLocationChangeEvent.debugMap.get(new Integer(newLocation))));
            this.hideComponent();
        } else if (newLocation == 1 || newLocation == 0 && oldLocation != 1) {
            logger.debug((Object)("oldLocation:" + MosueLocationChangeEvent.debugMap.get(new Integer(oldLocation)) + ",newLocation:" + MosueLocationChangeEvent.debugMap.get(new Integer(newLocation))));
            this.showComponent();
        }
    }

    private void hideComponent() {
        if (this.dividerLocationAtHide == Integer.MIN_VALUE && this.dividerLocationAtShow == Integer.MIN_VALUE) {
            switch (this.intHideLocation) {
                case 1: {
                    break;
                }
                case 2: {
                    this.showSize = this.splitPane.getDividerLocation();
                    this.dividerLocationAtHide = 0;
                    break;
                }
                case 3: {
                    this.showSize = this.splitPane.getWidth() - this.splitPane.getDividerLocation();
                    this.dividerLocationAtHide = this.splitPane.getWidth();
                    break;
                }
                case 4: {
                    break;
                }
            }
        }
        this.currentDividerStatus = 1;
        this.moveMainPanelDividerLocation(this.dividerLocationAtHide);
    }

    private void showComponent() {
        if (this.showSize == Integer.MIN_VALUE) {
            return;
        }
        switch (this.intHideLocation) {
            case 1: {
                break;
            }
            case 2: {
                this.dividerLocationAtShow = this.showSize;
                break;
            }
            case 3: {
                this.dividerLocationAtShow = this.splitPane.getWidth() - this.showSize;
                break;
            }
            case 4: {
                break;
            }
        }
        this.currentDividerStatus = 0;
        this.moveMainPanelDividerLocation(this.dividerLocationAtShow);
    }

    private void moveFinishCallBack() {
        block0 : switch (this.currentDividerStatus) {
            case 0: {
                break;
            }
            case 1: {
                switch (this.intHideLocation) {
                    case 1: {
                        break block0;
                    }
                    case 2: {
                        this.divider.clickLeftButton();
                        break block0;
                    }
                    case 3: {
                        this.divider.clickRightButton();
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                break;
            }
        }
    }

    private void moveMainPanelDividerLocation(int location) {
        int currentLocation = this.splitPane.getDividerLocation();
        int stopLoaction = location;
        if (this.moveTimer != null && this.moveTimer.isRunning()) {
            this.moveTimer.stop();
        }
        MoveActionListener listener = new MoveActionListener(this.splitPane, currentLocation, stopLoaction);
        this.moveTimer = new Timer(-100, listener);
        listener.setParentTimer(this.moveTimer);
        this.moveTimer.start();
    }

    public void setCurrentMouseLocation(int currentMouseLocation) {
        if (!this.isRunning) {
            return;
        }
        int tempMouseStatus = this.currentMouseLocation;
        this.currentMouseLocation = currentMouseLocation;
        for (int i = 0; i < this.listenersLoc.size(); ++i) {
            MosueLocationChangeListener listener = (MosueLocationChangeListener)this.listenersLoc.get(i);
            listener.fireMosueStatusChanged(tempMouseStatus, currentMouseLocation);
        }
    }

    class MoveActionListener
    implements ActionListener {
        private Timer parentTimer = null;
        private final int beginLocation;
        private final int endLocation;
        private int currentLocation = 0;
        private JSplitPane splitPane = null;
        private static final int moveSpeed = 60;

        public MoveActionListener(JSplitPane splitPane, int beginLocation, int endLocation) {
            this.splitPane = splitPane;
            this.beginLocation = beginLocation;
            this.currentLocation = beginLocation;
            this.endLocation = endLocation;
        }

        public Timer getParentTimer() {
            return this.parentTimer;
        }

        public void setParentTimer(Timer parentTimer) {
            this.parentTimer = parentTimer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            logger.debug((Object)(new Date() + "actionPerformed" + this.currentLocation));
            this.currentLocation = this.beginLocation > this.endLocation ? (this.currentLocation -= 60) : (this.currentLocation += 60);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (MoveActionListener.this.beginLocation > MoveActionListener.this.endLocation) {
                        if (MoveActionListener.this.currentLocation > MoveActionListener.this.endLocation) {
                            if (MoveActionListener.this.currentLocation < MoveActionListener.this.splitPane.getDividerLocation()) {
                                MoveActionListener.this.splitPane.setDividerLocation(MoveActionListener.this.currentLocation);
                                logger.debug((Object)(new Date() + "DividerLocation11=" + MoveActionListener.this.splitPane.getDividerLocation()));
                            } else if (MoveActionListener.this.currentLocation - 60 > MoveActionListener.this.endLocation) {
                                MoveActionListener.this.splitPane.setDividerLocation(MoveActionListener.this.currentLocation - 60);
                                MoveActionListener.this.currentLocation = MoveActionListener.this.currentLocation - 60;
                                logger.debug((Object)(new Date() + "DividerLocation12=" + MoveActionListener.this.splitPane.getDividerLocation()));
                            } else {
                                MoveActionListener.this.splitPane.setDividerLocation(MoveActionListener.this.endLocation);
                                logger.debug((Object)(new Date() + "DividerLocation13=" + MoveActionListener.this.splitPane.getDividerLocation()));
                            }
                        } else {
                            if (MoveActionListener.this.splitPane.getDividerLocation() > MoveActionListener.this.endLocation) {
                                MoveActionListener.this.splitPane.setDividerLocation(MoveActionListener.this.endLocation);
                                logger.debug((Object)(new Date() + "DividerLocation14=" + MoveActionListener.this.splitPane.getDividerLocation()));
                            }
                            SplitPaneMoveHelper.this.moveFinishCallBack();
                            MoveActionListener.this.getParentTimer().stop();
                            logger.debug((Object)(new Date() + "TimerStop=" + MoveActionListener.this.splitPane.getDividerLocation()));
                        }
                    } else {
                        logger.debug((Object)(new Date() + "\u5411\u53f3(\u4e0b)\u79fb\u52a8"));
                        if (MoveActionListener.this.currentLocation < MoveActionListener.this.endLocation) {
                            if (MoveActionListener.this.currentLocation > MoveActionListener.this.splitPane.getDividerLocation()) {
                                MoveActionListener.this.splitPane.setDividerLocation(MoveActionListener.this.currentLocation);
                                logger.debug((Object)(new Date() + "DividerLocation23=" + MoveActionListener.this.splitPane.getDividerLocation()));
                            } else if (MoveActionListener.this.currentLocation + 60 < MoveActionListener.this.endLocation) {
                                MoveActionListener.this.splitPane.setDividerLocation(MoveActionListener.this.currentLocation + 60);
                                logger.debug((Object)(new Date() + "currentLocation:" + (MoveActionListener.this.currentLocation + 60)));
                                logger.debug((Object)(new Date() + "DividerLocation21=" + MoveActionListener.this.splitPane.getDividerLocation()));
                            } else {
                                MoveActionListener.this.splitPane.setDividerLocation(MoveActionListener.this.endLocation);
                                logger.debug((Object)(new Date() + "DividerLocation22=" + MoveActionListener.this.splitPane.getDividerLocation()));
                            }
                        } else {
                            if (MoveActionListener.this.splitPane.getDividerLocation() < MoveActionListener.this.endLocation) {
                                MoveActionListener.this.splitPane.setDividerLocation(MoveActionListener.this.endLocation);
                                logger.debug((Object)(new Date() + "DividerLocation24=" + MoveActionListener.this.splitPane.getDividerLocation()));
                            }
                            SplitPaneMoveHelper.this.moveFinishCallBack();
                            MoveActionListener.this.getParentTimer().stop();
                            logger.debug((Object)(new Date() + "TimerStop=" + MoveActionListener.this.splitPane.getDividerLocation()));
                        }
                    }
                }
            });
        }
    }
}

