/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.validate;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.ep.client.validate.CheckItem;
import com.kingdee.eas.ep.client.validate.CheckItems;
import com.kingdee.eas.ep.client.validate.IVerify;
import com.kingdee.eas.ep.client.validate.VerifyReport;
import com.kingdee.eas.ep.client.validate.VerifyScene;
import com.kingdee.eas.ep.client.validate.VerifySuite;
import com.kingdee.eas.ep.client.validate.VerifyTargetType;
import com.kingdee.eas.ep.client.validate.VerifyUnit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class VerifyOperator
implements Serializable {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.validate.VerifyOperator");
    private VerifyReport report = new VerifyReport();

    public VerifyOperator() {
    }

    public VerifyOperator(VerifyReport report) {
        if (report != null) {
            this.report = report;
        }
    }

    public VerifyReport getVerifyReport() {
        return this.report;
    }

    public boolean check(IObjectValue target, VerifyScene scene) {
        assert (target != null);
        assert (scene != null);
        VerifyTargetType type = VerifyTargetType.getTargetType(target);
        if (type == null) {
            logger.debug((Object)("No support type:" + target.getClass().getName()));
            return true;
        }
        List list = this.getCheckItemList(type, scene);
        VerifySuite otherSuite = new VerifySuite(type.getName());
        for (int i = 0; i < list.size(); ++i) {
            CheckItem item = (CheckItem)list.get(i);
            IVerify v = this.newInstance(item.getClassName());
            if (v == null) continue;
            if (v instanceof VerifyUnit) {
                ((VerifyUnit)v).setName(item.getName());
                ((VerifyUnit)v).setTarget(target);
            }
            if (item.getType().equals("BOS")) continue;
            otherSuite.addVerify(v);
        }
        return otherSuite.check(this.report);
    }

    private IVerify newInstance(String className) {
        assert (className != null);
        IVerify v = null;
        try {
            v = (IVerify)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            logger.debug((Object)"instance IVerify failed", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.debug((Object)"instance IVerify failed", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.debug((Object)"instance IVerify failed", (Throwable)e);
        }
        return v;
    }

    private List getCheckItemList(VerifyTargetType obj, VerifyScene scene) {
        ArrayList<CheckItem> list = new ArrayList<CheckItem>();
        CheckItems items = CheckItems.getInstance();
        for (int i = 0; i < items.getItems().length; ++i) {
            CheckItem item = items.getItems()[i];
            if (!item.getObjects().contains((Object)obj) || !item.getScenes().contains((Object)scene) || !item.isEnabled()) continue;
            list.add(items.getItems()[i]);
        }
        return list;
    }
}

