/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.validate.imp;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.IndexCollection;
import com.kingdee.eas.ep.client.validate.VerifyReport;
import com.kingdee.eas.ep.client.validate.VerifyUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckTableIndexName
extends VerifyUnit {
    private static final String UNIQUE_INDEX_REGEX = "UX_\\p{Upper}{2}_\\p{Upper}{1}\\p{ASCII}*";
    private static final String COMMON_INDEX_REGEX = "IX_\\p{Upper}{2}_\\p{Upper}{1}\\p{ASCII}*";
    private static final String C_UNIQUE_INDEX_REGEX = "UX_C_\\p{Upper}{2}_\\p{Upper}{1}\\p{ASCII}*";
    private static final String C_COMMON_INDEX_REGEX = "IX_C_\\p{Upper}{2}_\\p{Upper}{1}\\p{ASCII}*";

    @Override
    public boolean check(VerifyReport report) {
        assert (this.getTarget() instanceof AbstractTableInfo);
        AbstractTableInfo table = (AbstractTableInfo)this.getTarget();
        IndexCollection indexs = table.getIndexes();
        String uReg = isDevelopVersion ? UNIQUE_INDEX_REGEX : C_UNIQUE_INDEX_REGEX;
        String cReg = isDevelopVersion ? COMMON_INDEX_REGEX : C_COMMON_INDEX_REGEX;
        Pattern uPattern = Pattern.compile(uReg);
        Pattern cPattern = Pattern.compile(cReg);
        int size = indexs.size();
        for (int i = 0; i < size; ++i) {
            Matcher matcher;
            String n = indexs.get(i).getName();
            if (indexs.get(i).isUnique()) {
                matcher = uPattern.matcher(n);
                if (matcher.matches()) continue;
                report.addWarning("\u552f\u4e00\u7d22\u5f15\u7684\u540d\u79f0\u4e0d\u7b26\u5408\u89c4\u8303 :" + n);
                return false;
            }
            matcher = cPattern.matcher(n);
            if (matcher.matches()) continue;
            report.addWarning("\u7d22\u5f15\u7684\u540d\u79f0\u4e0d\u7b26\u5408\u89c4\u8303 :" + n);
            return false;
        }
        return true;
    }
}

