/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.validate.imp;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ForeignKeyCollection;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.eas.ep.client.validate.VerifyReport;
import com.kingdee.eas.ep.client.validate.VerifyUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckTableKeyName
extends VerifyUnit {
    private static final String FK_REGEX = "FK_\\p{Upper}{2}_\\p{Upper}{1}\\p{ASCII}*";
    private static final String PK_REGEX = "PK_\\p{Upper}{2}_\\p{Upper}{1}\\p{ASCII}*";
    private static final String C_FK_REGEX = "FK_C_\\p{Upper}{2}_\\p{Upper}{1}\\p{ASCII}*";
    private static final String C_PK_REGEX = "PK_C_\\p{Upper}{2}_\\p{Upper}{1}\\p{ASCII}*";

    @Override
    public boolean check(VerifyReport report) {
        Matcher matcher;
        assert (this.getTarget() instanceof AbstractTableInfo);
        AbstractTableInfo table = (AbstractTableInfo)this.getTarget();
        Pattern pkPattern = Pattern.compile(isDevelopVersion ? PK_REGEX : C_PK_REGEX);
        PrimaryKeyInfo pk = table.getPrimaryKey();
        if (pk != null && !(matcher = pkPattern.matcher(pk.getName())).matches()) {
            report.addWarning(this.resHelper.getString("invalidTablePrimaryKeyName") + pk.getName());
            return false;
        }
        Pattern fkPattern = Pattern.compile(isDevelopVersion ? FK_REGEX : C_FK_REGEX);
        ForeignKeyCollection keys = table.getForeignKeys();
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            Matcher matcher2 = fkPattern.matcher(keys.get(i).getName());
            if (matcher2.matches()) continue;
            report.addWarning(this.resHelper.getString("invalidTableForeignKeyName") + keys.get(i).getName());
            return false;
        }
        return true;
    }
}

