/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.validate.imp;

import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.ui.bizunitproxy.EditUIProxyHelper;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.util.StringUtils;

public class DataBindValidater {
    private String message;
    private Context context;

    public DataBindValidater(Context context) {
        this.context = context;
    }

    public boolean validate(ComponentInfo cInfo, PropertyBindingInfo bindInfo) {
        AbstractUIObjectInfo parent = this.context.getUiModel();
        DataObjectCollection col = parent.getDataObjects();
        if (col != null) {
            for (int i = 0; i < col.size(); ++i) {
                DataObjectInfo doInfo = col.get(i);
                if (!MetaDataTypeList.JOINQUERY.toString().equals(doInfo.getObjectType()) && !MetaDataTypeList.UNIONQUERY.toString().equals(doInfo.getObjectType()) && !MetaDataTypeList.BASEQUERY.toString().equals(doInfo.getObjectType())) continue;
                return true;
            }
        }
        if (cInfo == null || bindInfo == null) {
            this.message = "\u83b7\u53d6\u63a7\u4ef6\u4fe1\u606f\u6216\u8005\u6570\u636e\u7ed1\u5b9a\u4fe1\u606f\u51fa\u9519";
            return false;
        }
        String bindingObject = bindInfo.getBindingObject();
        String bindField = bindInfo.getBingdingField();
        String propertyName = bindInfo.getPropertyName();
        if (StringUtils.isEmpty((String)bindingObject) || StringUtils.isEmpty((String)bindField) || StringUtils.isEmpty((String)propertyName)) {
            this.message = "\u7ed1\u5b9a\u5bf9\u8c61\uff0c\u7ed1\u5b9a\u5b57\u6bb5\uff0c\u7ed1\u5b9a\u63a7\u4ef6\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a";
            return false;
        }
        if ("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equals(cInfo.getClassType())) {
            EntityObjectInfo bindEntity = this.context.getEditorUI().getModel().getEntity();
            PropertyInfo prop = EditUIProxyHelper.getPropertyByName((EntityObjectInfo)bindEntity, (String)bindField);
            if (prop == null) {
                this.message = "\u52a0\u8f7d\u5c5e\u6027 : " + bindField + "\u51fa\u9519";
                return false;
            }
            if (prop instanceof LinkPropertyInfo) {
                RelationshipInfo relationShip = ((LinkPropertyInfo)prop).getRelationship();
                if (relationShip == null || relationShip.getSupplierObject() == null) {
                    this.message = "\u83b7\u53d6relationShip\u51fa\u9519";
                    return false;
                }
                EntityObjectInfo supplyEntityInfo = relationShip.getSupplierObject();
                if (supplyEntityInfo == null) {
                    this.message = "supplyEntity is null : " + relationShip.getAlias();
                    return false;
                }
                String sQueryPK = supplyEntityInfo.getExtendedProperty("defaultF7Query");
                if (StringUtils.isEmpty((String)sQueryPK)) {
                    this.message = "\u5173\u8054\u5b9e\u4f53 " + supplyEntityInfo.getFullName() + "\u7f3a\u5c11\u5c55\u5c5e\u6027defaultF7Query\uff0c\u4e0d\u5141\u8bb8\u7ed1\u5b9a\uff0c\u8bf7\u901a\u77e5\u8be5\u5355\u636e\u5f00\u53d1\u4eba\u5458\u5c06\u6269\u5c55\u5c5e\u6027\u8865\u5145\u5b8c\u6574\u3002";
                    return false;
                }
            } else {
                this.message = "F7\u7c7b\u578b\u63a7\u4ef6\u5e94\u5f53\u7ed1\u5b9a\u8fde\u63a5\u5c5e\u6027";
                return false;
            }
        }
        return true;
    }

    public String getMessage() {
        return this.message;
    }
}

