/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.wizard;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.eas.ep.CustomizedUnitFactory;
import com.kingdee.eas.ep.CustomizedUnitInfo;
import com.kingdee.eas.ep.ICustomizedUnit;
import com.kingdee.eas.ep.NodeTypeEnum;
import com.kingdee.eas.ep.client.CustomizedUnitUI;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.CustomizedUnitTreeNode;
import com.kingdee.eas.ep.client.wizard.AbstractUictWizardUI;
import com.kingdee.eas.ep.updater.CustomizedUnitNodeInfo;
import com.kingdee.eas.ep.updater.CustomizedUnitNodeInfoConverter;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.awt.Component;

public abstract class AbstractMetadataWizardUI
extends AbstractUictWizardUI {
    protected String customizedSchemedID;
    protected Project depend;
    protected CustomizedUnitTreeNode selectedNode = null;
    protected CustomizedUnitUI ui;

    public void setCustomizedSchemedID(String customizedSchemedID) {
        this.customizedSchemedID = customizedSchemedID;
    }

    public String getCustomizedSchemedID() {
        return this.customizedSchemedID;
    }

    public Project getDepend() {
        return this.depend;
    }

    public void setDepend(Project depend) {
        this.depend = depend;
    }

    public void setCustomizedUnitNodeInfo(CustomizedUnitTreeNode selectedNode) {
        this.selectedNode = selectedNode;
    }

    public void setCustomizedUnitUI(CustomizedUnitUI ui) {
        this.ui = ui;
    }

    public CustomizedUnitInfo getCustomizedUnitInfo() {
        if (this.selectedNode != null) {
            CustomizedUnitTreeNode node = this.selectedNode;
            while (true) {
                if (node == null) {
                    return null;
                }
                if (NodeTypeEnum.CUSTOMIZED_UNIT.equals((Object)node.getNodeType())) {
                    CustomizedUnitInfo info = (CustomizedUnitInfo)node.getUserObject();
                    return info;
                }
                node = (CustomizedUnitTreeNode)((Object)node.getParent());
            }
        }
        return null;
    }

    protected void updateCustomizedUnit(AbstractMetaDataValue mdv, NodeTypeEnum type) {
        CustomizedUnitInfo info = this.getCustomizedUnitInfo();
        if (info != null) {
            CustomizedUnitNodeInfo cunInfo = CustomizedUnitNodeInfoConverter.converter2Object(info.getCustomizedUnitObject());
            CustomizedUnitNodeInfo.MetaDataInfo md = new CustomizedUnitNodeInfo.MetaDataInfo(mdv.getPackage(), mdv.getName(), mdv.getAlias());
            if (NodeTypeEnum.ENTITY.equals((Object)type)) {
                cunInfo.getEntity().add(md);
            } else if (NodeTypeEnum.QUERY.equals((Object)type)) {
                cunInfo.getQuery().add(md);
            } else if (NodeTypeEnum.ENUM.equals((Object)type)) {
                cunInfo.getEnums().add(md);
            } else if (NodeTypeEnum.FACADE.equals((Object)type)) {
                cunInfo.getFacade().add(md);
            } else if (NodeTypeEnum.FUNCTION.equals((Object)type)) {
                cunInfo.getFunction().add(md);
            } else if (NodeTypeEnum.EXCEPTION.equals((Object)type)) {
                cunInfo.getException().add(md);
            } else if (NodeTypeEnum.LISTUI.equals((Object)type)) {
                cunInfo.getUi().getListui().add(md);
            } else if (NodeTypeEnum.EDITUI.equals((Object)type)) {
                cunInfo.getUi().getEditui().add(md);
            } else if (NodeTypeEnum.OTHERUI.equals((Object)type)) {
                cunInfo.getUi().getOtherui().add(md);
            }
            String xml = CustomizedUnitNodeInfoConverter.coverter2xml(cunInfo);
            try {
                ICustomizedUnit bizInterface = CustomizedUnitFactory.getRemoteInstance();
                info.setCustomizedUnitObject(xml);
                ObjectUuidPK pk = new ObjectUuidPK(info.getId());
                bizInterface.update((IObjectPK)pk, (CoreBaseInfo)info);
                this.ui.getExplorerPanel().getCustomizedUnitTreePanel().refresh(3);
            }
            catch (Exception e) {
                ExceptionHandler.handleError((Component)((Object)this), e, "\u66f4\u65b0\u6269\u5c55\u5355\u5143\u4fe1\u606f\u5931\u8d25\uff01\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            }
        }
    }
}

