/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.wizard;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.ResTypeConvert;
import com.kingdee.eas.ep.client.CommonDialog;
import com.kingdee.eas.ep.client.wizard.IUictWizardPage;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;

public abstract class AbstractUictWizardUI
extends CommonDialog {
    private static final Logger logger = CoreUIObject.getLogger(AbstractUictWizardUI.class);
    protected String EXIT_STATUS = null;
    public static final String CONFIRM_EXIT = "confirm";
    public static final String CANCEL_EXIT = "cancel";
    private JLabel pageTitle;
    private JLabel pic;
    private JLabel description;
    private JPanel wizardPanel;
    private KDButton preview;
    private KDButton finish;
    private KDButton next;
    private KDButton cancel;
    private Object model;
    private IUictWizardPage presentPage;
    private Map pagesMap = new HashMap();
    private List pagesList = new ArrayList();

    public AbstractUictWizardUI() throws Exception {
        this.initUIP();
        this.jbInit();
    }

    private void jbInit() throws Exception {
        this.setUITitle("Wizard");
        this.setName("UictWizardUI");
    }

    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 600, 400));
        this.setPreferredSize(new Dimension(600, 400));
        this.setLayout(new BorderLayout(0, 0));
        this.add(this.createDescriptionPanel(), "North");
        this.add(this.createWizardPanel(), "Center");
        this.add(this.createBrowseButtons(), "South");
    }

    private JPanel createDescriptionPanel() {
        this.pageTitle = new JLabel();
        this.pageTitle.setFont(ResTypeConvert.convertFont((String)"family=Dialog,name=Dialog,style=1,size=15"));
        this.pageTitle.setBounds(new Rectangle(5, 10, 590, 20));
        this.pageTitle.setOpaque(false);
        this.pic = new JLabel();
        this.pic.setBounds(new Rectangle(0, 35, 16, 16));
        this.pic.setOpaque(false);
        this.description = new JLabel();
        this.description.setBounds(new Rectangle(18, 35, 580, 20));
        this.description.setOpaque(false);
        JSeparator separator = new JSeparator();
        BorderLayout descriptionLayout = new BorderLayout(0, 0);
        JPanel descriptionPanel = new JPanel(descriptionLayout);
        JPanel tipsPanel = new JPanel();
        tipsPanel.setLayout(null);
        tipsPanel.setOpaque(false);
        tipsPanel.setPreferredSize(new Dimension(600, 60));
        tipsPanel.add(this.pageTitle);
        tipsPanel.add(this.pic);
        tipsPanel.add(this.description);
        descriptionPanel.add((Component)tipsPanel, "Center");
        descriptionPanel.add((Component)separator, "South");
        descriptionPanel.setBackground(Color.WHITE);
        descriptionPanel.setSize(new Dimension(600, 60));
        return descriptionPanel;
    }

    private JPanel createWizardPanel() {
        this.wizardPanel = new JPanel();
        this.wizardPanel.setLayout(new CardLayout());
        this.wizardPanel.setSize(new Dimension(600, 290));
        return this.wizardPanel;
    }

    private JPanel createBrowseButtons() {
        this.preview = new KDButton("\u4e0a\u4e00\u6b65");
        this.preview.setEnabled(false);
        this.next = new KDButton("\u4e0b\u4e00\u6b65");
        this.next.setEnabled(false);
        this.finish = new KDButton("\u5b8c\u6210");
        this.finish.setEnabled(false);
        this.cancel = new KDButton("\u53d6\u6d88");
        this.cancel.setEnabled(false);
        FlowLayout buttonLayout = new FlowLayout();
        buttonLayout.setAlignment(2);
        JPanel buttonPanel = new JPanel(buttonLayout);
        buttonPanel.setSize(new Dimension(600, 50));
        buttonPanel.add((Component)this.preview);
        buttonPanel.add((Component)this.next);
        buttonPanel.add((Component)this.finish);
        buttonPanel.add((Component)this.cancel);
        this.preview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AbstractUictWizardUI.this.callPreviousPage();
            }
        });
        this.finish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AbstractUictWizardUI.this.callFinish();
            }
        });
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AbstractUictWizardUI.this.callNextPage();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AbstractUictWizardUI.this.callCancel();
            }
        });
        JSeparator separator = new JSeparator();
        BorderLayout bl = new BorderLayout(0, 0);
        JPanel southPanel = new JPanel(bl);
        southPanel.add((Component)separator, "North");
        southPanel.add((Component)buttonPanel, "Center");
        return southPanel;
    }

    public void addPages() {
    }

    public void setVisible() {
        this.preview.setVisible(false);
        this.next.setVisible(false);
    }

    public boolean addPage(IUictWizardPage page) {
        if (page != null) {
            page.setWizard(this);
            page.init();
            int size = this.pagesList.size();
            if (size > 0) {
                IUictWizardPage last = (IUictWizardPage)this.pagesList.get(size - 1);
                last.setNextPageName(page.getPageName());
                page.setPreviewPageName(last.getPageName());
            }
            this.pagesList.add(page);
            this.pagesMap.put(page.getPageName(), page);
            this.wizardPanel.add((Component)((JPanel)((Object)page)), page.getPageName());
            if (this.pagesMap.size() == 1) {
                this.presentPage = page;
                CardLayout card = (CardLayout)this.wizardPanel.getLayout();
                card.show(this.wizardPanel, this.presentPage.getPreviewPageName());
                this.resetWizard(this.presentPage);
            }
            return true;
        }
        return false;
    }

    public IUictWizardPage getPageByName(String pageName) {
        IUictWizardPage page = (IUictWizardPage)this.pagesMap.get(pageName);
        return page;
    }

    private void callPreviousPage() {
        if (this.presentPage == null) {
            return;
        }
        IUictWizardPage previewPage = (IUictWizardPage)this.pagesMap.get(this.presentPage.getPreviewPageName());
        if (previewPage == null) {
            return;
        }
        this.presentPage.afterPageChange();
        if (previewPage.isJumpedCurrentPage()) {
            do {
                this.presentPage = previewPage;
            } while ((previewPage = (IUictWizardPage)this.pagesMap.get(previewPage.getPreviewPageName())).isJumpedCurrentPage());
        }
        CardLayout card = (CardLayout)this.wizardPanel.getLayout();
        card.show(this.wizardPanel, this.presentPage.getPreviewPageName());
        previewPage.beforePageChange();
        this.presentPage = previewPage;
        this.resetWizard(this.presentPage);
    }

    private void callNextPage() {
        if (this.presentPage == null) {
            return;
        }
        if (!this.presentPage.isPageStoreValidate()) {
            return;
        }
        this.presentPage.afterPageChange();
        IUictWizardPage nextPage = (IUictWizardPage)this.pagesMap.get(this.presentPage.getNextPageName());
        if (nextPage == null) {
            return;
        }
        if (this.presentPage.isJumpNextPage()) {
            do {
                this.presentPage = nextPage;
                nextPage.setJumpedCurrentPage(true);
                nextPage = (IUictWizardPage)this.pagesMap.get(nextPage.getNextPageName());
                if (nextPage != null) continue;
                return;
            } while (this.presentPage.isJumpNextPage());
        } else {
            nextPage.setJumpedCurrentPage(false);
        }
        CardLayout card = (CardLayout)this.wizardPanel.getLayout();
        card.show(this.wizardPanel, this.presentPage.getNextPageName());
        nextPage.beforePageChange();
        this.presentPage = nextPage;
        this.resetWizard(this.presentPage);
        nextPage = (IUictWizardPage)this.pagesMap.get(this.presentPage.getNextPageName());
        if (this.presentPage.isJumpNextPage() && nextPage != null && nextPage.getNextPageName() == null) {
            this.next.setEnabled(false);
        }
    }

    private void callFinish() {
        this.EXIT_STATUS = CONFIRM_EXIT;
        if (!this.presentPage.isPageStoreValidate()) {
            return;
        }
        this.performFinish();
        this.destroyWindow();
    }

    private void callCancel() {
        this.EXIT_STATUS = CANCEL_EXIT;
        this.destroyWindow();
    }

    protected void performFinish() {
    }

    public void resetWizard(IUictWizardPage page) {
        if (page != null) {
            this.pageTitle.setText(page.getTitle());
            this.pic.setIcon(page.getPic());
            this.description.setText(page.getDescription());
            if (this.pagesList.size() > 1) {
                this.preview.setEnabled(page.canPreview());
            } else {
                this.preview.setEnabled(false);
            }
            this.next.setEnabled(page.canNext());
            this.finish.setEnabled(page.canFinish());
            this.cancel.setEnabled(page.canCancel());
        }
    }

    public void setModel(Object model) {
        this.model = model;
    }

    public Object getModel() {
        return this.model;
    }

    @Override
    public String getExitStatus() {
        return this.EXIT_STATUS;
    }
}

