/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.wizard.bind;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.eas.ep.client.editor.bind.DataBindUtils;
import com.kingdee.eas.ep.client.editor.editui.designer.IUIEditor;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.AbstractBizConfigureItemCollection;
import com.kingdee.eas.ep.client.model.AbstractBizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.AllComponentInfoArr;
import com.kingdee.eas.ep.client.model.BizConfigureTreeNode;
import com.kingdee.eas.ep.client.model.dtc.DTCConfigInfo;
import com.kingdee.eas.ep.client.model.dtc.DTCConfigManager;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;

public class DataBindTreeBuilder {
    public static void generateControlTree(KDTree tree, DefaultKingdeeTreeNode root, AllComponentInfoArr allComponentInfoArr) {
        if (tree == null || root == null || allComponentInfoArr == null) {
            throw new IllegalArgumentException("tree, root and AllComponentInfoArr can not be null");
        }
        root.removeAllChildren();
        root.setText("root");
        root.setUserObject((Object)"root");
        Object[] comps = allComponentInfoArr.getComponentInfoArr().toArray();
        int n = comps.length;
        for (int i = 0; i < n; ++i) {
            ComponentInfo item = (ComponentInfo)comps[i];
            DefaultKingdeeTreeNode itemNode = new DefaultKingdeeTreeNode();
            itemNode.setUserObject((Object)item);
            itemNode.setText(item.getName());
            DTCConfigInfo info = DTCConfigManager.getInstance().getDTCConfig(item.getClassType());
            if (info != null) {
                itemNode.setCustomIcon((Icon)info.getSmallIcon());
            }
            root.add((MutableTreeNode)itemNode);
        }
        ((KingdeeTreeModel)tree.getModel()).reload();
        if (root.getChildCount() > 0 && root.getFirstChild() != null && root.getFirstChild() instanceof DefaultKingdeeTreeNode) {
            tree.setSelectionNode((DefaultKingdeeTreeNode)root.getFirstChild());
        }
    }

    public static void initComponentTree(KDTree tree, AllComponentInfoArr allComponentInfoArr) {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
        Object[] comps = allComponentInfoArr.getComponentInfoArr().toArray();
        int size = comps.length;
        for (int index = 0; index < size; ++index) {
            ComponentInfo item = (ComponentInfo)comps[index];
            DefaultKingdeeTreeNode compNode = new DefaultKingdeeTreeNode();
            compNode.setUserObject((Object)item);
            String[] proNames = DataBindUtils.getAllPropertyNames(item);
            if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(item.getClassType())) {
                compNode.setText(item.getAlias() != null ? item.getAlias() : item.getName());
                for (String name : proNames) {
                    DefaultKingdeeTreeNode proNode = new DefaultKingdeeTreeNode();
                    proNode.setUserObject((Object)name);
                    proNode.setText(name);
                    compNode.add((MutableTreeNode)proNode);
                }
            } else {
                String lias = UictUtils.getAlias(item);
                compNode.setUserObject((Object)item);
                compNode.setText(lias != null ? lias + "(" + item.getName() + "." + proNames[0] + ")" : item.getName());
            }
            root.add((MutableTreeNode)compNode);
        }
    }

    public static void initComponentTree(DefaultKingdeeTreeNode treeRootNode, BizConfigureTreeNode bizRoot) {
        int n = bizRoot.getChildCount();
        for (int i = 0; i < n; ++i) {
            BizConfigureTreeNode child = (BizConfigureTreeNode)((Object)bizRoot.getChildAt(i));
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
            node.setText(child.getName());
            node.setUserObject((Object)child.getItem().getComponent());
            treeRootNode.add((MutableTreeNode)node);
            DataBindTreeBuilder.initComponentTree(node, child);
        }
        AbstractBizConfigureItemCollection items = bizRoot.getConfigureItems();
        for (int j = 0; j < items.size(); ++j) {
            AbstractBizConfigureItemInfo item = items.get(j);
            ComponentInfo component = item.getComponent();
            if (component == null || !EditUIEditorHelper.canBind(component) || EditUIEditorHelper.isBinded(component)) continue;
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
            node.setUserObject((Object)component);
            if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(component.getClassType())) {
                node.setText(UictUtils.getAlias(component));
            } else {
                String lias = UictUtils.getAlias(component);
                node.setText(lias);
            }
            treeRootNode.add((MutableTreeNode)node);
        }
    }

    public static void initValueObjTree(KDTree tree, IUIEditor editor, DataObjectCollection dataObjectCollection, Project depend) {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
        if (dataObjectCollection.size() > 0) {
            DataObjectInfo data = dataObjectCollection.get(0);
            DefaultKingdeeTreeNode itemNode = new DefaultKingdeeTreeNode();
            itemNode.setUserObject((Object)data);
            root.add((MutableTreeNode)itemNode);
            if (data.getObjectType().trim().equals(MetaDataTypeList.ENTITY.toString())) {
                EntityObjectInfo bindEntity = editor.getModel().getEntity();
                if (bindEntity != null) {
                    itemNode.setText(bindEntity.getAlias() + "(" + bindEntity.getName() + ")");
                    DataBindTreeBuilder.generateDataObjectPropertyTree(tree, itemNode, bindEntity, depend);
                }
            } else if (data.getObjectType().trim().equals(MetaDataTypeList.JOINQUERY.toString()) || data.getObjectType().trim().equals(MetaDataTypeList.BASEQUERY.toString()) || data.getObjectType().trim().equals(MetaDataTypeList.UNIONQUERY.toString())) {
                JoinQueryInfo queryInfo = editor.getModel().getQuery();
                if (queryInfo != null) {
                    itemNode.setText(queryInfo.getAlias() + "(" + queryInfo.getName() + ")");
                    DataBindTreeBuilder.generateDataObjectPropertyTree(tree, itemNode, (QueryInfo)queryInfo, depend);
                }
            } else {
                ExceptionHandler.handleError(null, null, "\u65e0\u6548\u5bf9\u8c61\u7c7b\u578b");
            }
        }
    }

    public static void generateControlPropertyTree(KDTree tree, DefaultKingdeeTreeNode root, ComponentInfo component) {
        if (tree == null || root == null || component == null) {
            throw new IllegalArgumentException("tree, root and component can not be null");
        }
        root.removeAllChildren();
        root.setText("root");
        root.setUserObject((Object)"root");
        String[] proNames = DataBindUtils.getAllPropertyNames(component);
        if (component.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDCheckBox")) {
            String name = proNames[1];
            DefaultKingdeeTreeNode itemNode = new DefaultKingdeeTreeNode();
            itemNode.setUserObject((Object)name);
            itemNode.setText(name);
            root.add((MutableTreeNode)itemNode);
        } else {
            for (String name : proNames) {
                DefaultKingdeeTreeNode itemNode = new DefaultKingdeeTreeNode();
                itemNode.setUserObject((Object)name);
                itemNode.setText(name);
                root.add((MutableTreeNode)itemNode);
            }
        }
        ((KingdeeTreeModel)tree.getModel()).reload();
        if (root.getChildCount() >= 1 && root.getFirstChild() != null && root.getFirstChild() instanceof DefaultKingdeeTreeNode) {
            tree.setSelectionNode((DefaultKingdeeTreeNode)root.getFirstChild());
        }
    }

    public static void generateDataObjectTree(KDTree tree, DefaultKingdeeTreeNode root, DataObjectCollection dataObjectCollection) {
        if (tree == null || root == null || dataObjectCollection == null) {
            throw new IllegalArgumentException("tree, root and dataObjectCollection can not be null");
        }
        root.removeAllChildren();
        root.setText("root");
        root.setUserObject((Object)"root");
        int n = dataObjectCollection.size();
        for (int i = 0; i < n; ++i) {
            DataObjectInfo data = dataObjectCollection.get(i);
            DefaultKingdeeTreeNode itemNode = new DefaultKingdeeTreeNode();
            itemNode.setUserObject((Object)data);
            itemNode.setText(data.getName());
            root.add((MutableTreeNode)itemNode);
        }
        ((KingdeeTreeModel)tree.getModel()).reload();
        if (root.getChildCount() > 0 && root.getFirstChild() != null && root.getFirstChild() instanceof DefaultKingdeeTreeNode) {
            tree.setSelectionNode((DefaultKingdeeTreeNode)root.getFirstChild());
        }
    }

    public static void generateDataObjectPropertyTree(KDTree tree, DefaultKingdeeTreeNode root, DataObjectInfo dataObjectInfo, Project depend) {
        if (tree == null || root == null || dataObjectInfo == null) {
            throw new IllegalArgumentException("tree, root and dataObjectInfo can not be null");
        }
        root.removeAllChildren();
        root.setText(dataObjectInfo.getName());
        root.setUserObject((Object)"root");
        EntityObjectInfo object = null;
        if (dataObjectInfo.getType() == null) {
            return;
        }
        if (dataObjectInfo.getObjectType().trim().equals(MetaDataTypeList.ENTITY.toString())) {
            IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)dataObjectInfo.getType());
            object = UictUtils.loadEntity(pk, depend);
        } else if (dataObjectInfo.getObjectType().trim().equals(MetaDataTypeList.JOINQUERY.toString()) || dataObjectInfo.getObjectType().trim().equals(MetaDataTypeList.BASEQUERY.toString()) || dataObjectInfo.getObjectType().trim().equals(MetaDataTypeList.UNIONQUERY.toString())) {
            IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)dataObjectInfo.getType());
            object = UictUtils.loadQuery(pk, depend);
        } else {
            ExceptionHandler.handleError(null, null, "\u65e0\u6548\u5bf9\u8c61\u7c7b\u578b");
        }
        if (object != null) {
            DataBindTreeBuilder.buildDataObjectPropertyTreeNode((IObjectValue)object, root, 0);
        }
        ((KingdeeTreeModel)tree.getModel()).reload();
        if (root.getChildCount() > 0 && root.getFirstChild() != null && root.getFirstChild() instanceof DefaultKingdeeTreeNode) {
            tree.setSelectionNode((DefaultKingdeeTreeNode)root.getFirstChild());
        }
    }

    public static void generateDataObjectPropertyTree(KDTree tree, DefaultKingdeeTreeNode root, EntityObjectInfo object, Project depend) {
        if (tree == null || root == null || object == null) {
            throw new IllegalArgumentException("tree, root and dataObjectInfo can not be null");
        }
        if (object != null) {
            DataBindTreeBuilder.buildDataObjectPropertyTreeNode((IObjectValue)object, root, 0);
        }
        ((KingdeeTreeModel)tree.getModel()).reload();
        if (root.getChildCount() > 0 && root.getFirstChild() != null && root.getFirstChild() instanceof DefaultKingdeeTreeNode) {
            tree.setSelectionNode((DefaultKingdeeTreeNode)root.getFirstChild());
        }
    }

    public static void generateDataObjectPropertyTree(KDTree tree, DefaultKingdeeTreeNode root, QueryInfo object, Project depend) {
        if (tree == null || root == null || object == null) {
            throw new IllegalArgumentException("tree, root and dataObjectInfo can not be null");
        }
        if (object != null) {
            DataBindTreeBuilder.buildDataObjectPropertyTreeNode((IObjectValue)object, root, 0);
        }
        ((KingdeeTreeModel)tree.getModel()).reload();
        if (root.getChildCount() > 0 && root.getFirstChild() != null && root.getFirstChild() instanceof DefaultKingdeeTreeNode) {
            tree.setSelectionNode((DefaultKingdeeTreeNode)root.getFirstChild());
        }
    }

    private static void buildDataObjectPropertyTreeNode(IObjectValue object, DefaultKingdeeTreeNode node, int level) {
        PropertyCollection propertyCollection;
        if (object instanceof QueryInfo) {
            int i;
            SelectorInfo selectorInfo = ((QueryInfo)object).getSelector();
            int size = selectorInfo.size();
            ArrayList<String> fieldNameList = new ArrayList<String>(size);
            HashMap<String, QueryFieldInfo> fieldMap = new HashMap<String, QueryFieldInfo>(size);
            String fieldName = null;
            QueryFieldInfo qfInfo = null;
            for (i = 0; i < size; ++i) {
                qfInfo = selectorInfo.get(i);
                fieldName = qfInfo.getName();
                fieldNameList.add(fieldName);
                fieldMap.put(fieldName, qfInfo);
            }
            Collections.sort(fieldNameList);
            for (i = 0; i < size; ++i) {
                fieldName = fieldNameList.get(i).toString();
                qfInfo = (QueryFieldInfo)fieldMap.get(fieldName);
                DefaultKingdeeTreeNode itemNode = new DefaultKingdeeTreeNode();
                itemNode.setUserObject((Object)qfInfo);
                itemNode.setText(qfInfo.getDisplayName() + "(" + qfInfo.getName() + ")");
                node.add((MutableTreeNode)itemNode);
                if (qfInfo.getExtendedProperty("configured") == null) continue;
                DataBindTreeBuilder.setDynFiledColor(itemNode);
            }
        } else if (object instanceof LinkPropertyInfo) {
            RelationshipInfo r = ((LinkPropertyInfo)object).getRelationship();
            PropertyCollection propertyCollection2 = null;
            if (r == null || r.getSupplierProperty() == null) {
                return;
            }
            propertyCollection2 = r.getSupplierProperty() == object ? r.getClientObject().getInheritedProperties() : r.getSupplierObject().getInheritedProperties();
            if (propertyCollection2 != null && level <= 3) {
                DataBindTreeBuilder.buildLinkPropAndSelfPropNode(propertyCollection2, node, level);
            }
        } else if (object instanceof EntityObjectInfo && (propertyCollection = ((EntityObjectInfo)object).getInheritedProperties()) != null) {
            DataBindTreeBuilder.buildLinkPropAndSelfPropNode(propertyCollection, node, level);
        }
    }

    private static void buildLinkPropAndSelfPropNode(PropertyCollection propertyCollection, DefaultKingdeeTreeNode node, int level) {
        DefaultKingdeeTreeNode itemNode;
        PropertyInfo pInfo;
        int i;
        ArrayList<String> linkPropNameList = new ArrayList<String>();
        ArrayList<String> selfPropNameList = new ArrayList<String>();
        HashMap<String, PropertyInfo> linkPropMap = new HashMap<String, PropertyInfo>();
        HashMap<String, PropertyInfo> selfPropMap = new HashMap<String, PropertyInfo>();
        String propName = null;
        int size = propertyCollection.size();
        for (i = 0; i < size; ++i) {
            pInfo = propertyCollection.get(i);
            propName = pInfo.getName();
            if (pInfo instanceof LinkPropertyInfo) {
                linkPropNameList.add(propName);
                linkPropMap.put(propName, pInfo);
                continue;
            }
            selfPropNameList.add(propName);
            selfPropMap.put(propName, pInfo);
        }
        Collections.sort(linkPropNameList);
        Collections.sort(selfPropNameList);
        size = linkPropNameList.size();
        for (i = 0; i < size; ++i) {
            propName = linkPropNameList.get(i).toString();
            pInfo = (PropertyInfo)linkPropMap.get(propName);
            itemNode = new DefaultKingdeeTreeNode();
            itemNode.setUserObject((Object)pInfo);
            itemNode.setText(pInfo.getAlias() + "(" + pInfo.getName() + ")");
            node.add((MutableTreeNode)itemNode);
            DataBindTreeBuilder.buildDataObjectPropertyTreeNode((IObjectValue)pInfo, itemNode, level + 1);
            if (!pInfo.isConfigured()) continue;
            DataBindTreeBuilder.setDynFiledColor(itemNode);
        }
        size = selfPropNameList.size();
        for (i = 0; i < size; ++i) {
            propName = selfPropNameList.get(i).toString();
            pInfo = (PropertyInfo)selfPropMap.get(propName);
            itemNode = new DefaultKingdeeTreeNode();
            itemNode.setUserObject((Object)pInfo);
            itemNode.setText(pInfo.getAlias() + "(" + pInfo.getName() + ")");
            node.add((MutableTreeNode)itemNode);
            if (!pInfo.isConfigured()) continue;
            DataBindTreeBuilder.setDynFiledColor(itemNode);
        }
    }

    private static void setDynFiledColor(DefaultKingdeeTreeNode node) {
        node.setTextColor(Color.BLUE);
    }

    public static DefaultKingdeeTreeNode findTreeNodeByName(DefaultKingdeeTreeNode node, String name) {
        if (StringUtils.isEmpty((String)name) || node == null) {
            return null;
        }
        Object userObject = node.getUserObject();
        String txt = null;
        txt = userObject != null && userObject instanceof AbstractMDValue ? ((AbstractMDValue)userObject).getString("name") : node.getText();
        if (name.equals(txt)) {
            return node;
        }
        DefaultKingdeeTreeNode treeNode = null;
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            treeNode = DataBindTreeBuilder.findTreeNodeByName((DefaultKingdeeTreeNode)node.getChildAt(i), name);
            if (treeNode == null) continue;
            return treeNode;
        }
        return null;
    }
}

