/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.wizard.layout;

import com.kingdee.bos.ui.dtp.kdlayout.KDLayoutUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.layout.KDRectangle;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.wizard.AbstractKDLayoutAnchorWizardUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import org.apache.log4j.Logger;

public class KDLayoutAnchorWizardUI
extends AbstractKDLayoutAnchorWizardUI {
    private static final Logger logger = CoreUIObject.getLogger(KDLayoutAnchorWizardUI.class);
    protected static String EXIT_STATUS = null;
    public static final String CONFIRM_EXIT = "confirm";
    public static final String CANCEL_EXIT = "cancel";
    private BizConfigureItemInfoAdapter item;
    private int anchorValue;
    private int anchor;
    private int top;
    private int bottom;
    private int left;
    private int right;
    private boolean center;

    public KDLayoutAnchorWizardUI() throws Exception {
        this.setLayout(null);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void chkCenter_itemStateChanged(ItemEvent e) throws Exception {
        this.center = this.chkCenter.isSelected();
    }

    @Override
    protected void cmbTop_itemStateChanged(ItemEvent e) throws Exception {
        this.top = this.getTopAnchorValue(this.cmbTop.getSelectedIndex());
    }

    @Override
    protected void cmbBottom_itemStateChanged(ItemEvent e) throws Exception {
        this.bottom = this.getBottomAnchorValue(this.cmbBottom.getSelectedIndex());
    }

    @Override
    protected void cmbLeft_itemStateChanged(ItemEvent e) throws Exception {
        this.left = this.getLeftAnchorValue(this.cmbLeft.getSelectedIndex());
    }

    @Override
    protected void cmbRight_itemStateChanged(ItemEvent e) throws Exception {
        this.right = this.getRightAnchorValue(this.cmbRight.getSelectedIndex());
    }

    public int getAnchorValue() {
        int ret = this.top + this.bottom + this.left + this.right;
        if (this.center) {
            ret += 16;
        }
        return ret;
    }

    public void setAnchorValue(int anchor) {
        this.anchor = anchor;
    }

    private int getBottomIndex(int value) {
        int index = 0;
        switch (value) {
            case 0: {
                index = 0;
                break;
            }
            case 2: {
                index = 1;
                break;
            }
            case 64: {
                index = 2;
                break;
            }
            default: {
                index = 0;
            }
        }
        return index;
    }

    private int getTopIndex(int value) {
        int index = 0;
        switch (value) {
            case 0: {
                index = 0;
                break;
            }
            case 1: {
                index = 1;
                break;
            }
            case 32: {
                index = 2;
                break;
            }
            default: {
                index = 0;
            }
        }
        return index;
    }

    private int getTopAnchorValue(int index) {
        int value = 0;
        switch (index) {
            case 0: {
                value = 0;
                break;
            }
            case 1: {
                value = 1;
                break;
            }
            case 2: {
                value = 32;
                break;
            }
            default: {
                value = 0;
            }
        }
        return value;
    }

    private int getBottomAnchorValue(int index) {
        int value = 0;
        switch (index) {
            case 0: {
                value = 0;
                break;
            }
            case 1: {
                value = 2;
                break;
            }
            case 2: {
                value = 64;
                break;
            }
            default: {
                value = 0;
            }
        }
        return value;
    }

    private int getLeftIndex(int value) {
        int index = 0;
        switch (value) {
            case 0: {
                index = 0;
                break;
            }
            case 4: {
                index = 1;
                break;
            }
            case 128: {
                index = 2;
                break;
            }
            default: {
                index = 0;
            }
        }
        return index;
    }

    private int getLeftAnchorValue(int index) {
        int value = 0;
        switch (index) {
            case 0: {
                value = 0;
                break;
            }
            case 1: {
                value = 4;
                break;
            }
            case 2: {
                value = 128;
                break;
            }
            default: {
                value = 0;
            }
        }
        return value;
    }

    private int getRightAnchorValue(int index) {
        int value = 0;
        switch (index) {
            case 0: {
                value = 0;
                break;
            }
            case 1: {
                value = 8;
                break;
            }
            case 2: {
                value = 256;
                break;
            }
            default: {
                value = 0;
            }
        }
        return value;
    }

    private int getRightIndex(int value) {
        int index = 0;
        switch (value) {
            case 0: {
                index = 0;
                break;
            }
            case 8: {
                index = 1;
                break;
            }
            case 256: {
                index = 2;
                break;
            }
            default: {
                index = 0;
            }
        }
        return index;
    }

    public void setItem(BizConfigureItemInfoAdapter item) {
        this.item = item;
    }

    public void initAnchor(int anchor) {
        int[] sideAnchor = KDLayoutUtil.getSideAnchor((int)anchor);
        this.top = sideAnchor[0];
        this.bottom = sideAnchor[1];
        this.left = sideAnchor[2];
        this.right = sideAnchor[3];
        this.center = sideAnchor[4] == 1;
        this.cmbTop.setSelectedIndex(this.getTopIndex(this.top));
        this.cmbBottom.setSelectedIndex(this.getBottomIndex(this.bottom));
        this.cmbLeft.setSelectedIndex(this.getLeftIndex(this.left));
        this.cmbRight.setSelectedIndex(this.getRightIndex(this.right));
        this.chkCenter.setSelected(this.center);
    }

    public void init() {
        this.initAnchor(this.anchor);
    }

    @Override
    protected void cancelkDButton_actionPerformed(ActionEvent e) throws Exception {
        super.cancelkDButton_actionPerformed(e);
        EXIT_STATUS = CANCEL_EXIT;
        this.destroyWindow();
    }

    @Override
    protected void okkDButton_actionPerformed(ActionEvent e) throws Exception {
        super.okkDButton_actionPerformed(e);
        EXIT_STATUS = CONFIRM_EXIT;
        this.performFinish();
        this.destroyWindow();
    }

    protected void performFinish() {
        try {
            this.getAnchorValue();
            KDRectangle bounds = new KDRectangle(this.item.getBounds());
            bounds.setAnchor(this.anchorValue);
            this.item.setBounds(bounds);
        }
        catch (Exception exc) {
            ExceptionHandler.handleError((Component)((Object)this), exc, "\u951a\u5b9a\u7ea6\u675f\u8bbe\u7f6e\u5931\u8d25\uff01\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            return;
        }
    }

    public String getExitStatus() {
        return EXIT_STATUS;
    }
}

