/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.wizard.template;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.config.DynamicMetadataFactory;
import com.kingdee.bos.config.IDynamicMetadata;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.db.DBUpdateInfo;
import com.kingdee.bos.db.DBUpdateInfoSet;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BIMNameFactory;
import com.kingdee.bos.metadata.bizunit.BizUnitCtrl;
import com.kingdee.bos.metadata.bizunit.BizUnitHelper;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.management.SuffixCollection;
import com.kingdee.bos.metadata.management.SuffixInfo;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ep.CustomizedItemFactory;
import com.kingdee.eas.ep.CustomizedItems;
import com.kingdee.eas.ep.IUpdateSql;
import com.kingdee.eas.ep.ReCreateException;
import com.kingdee.eas.ep.UpdateSqlFactory;
import com.kingdee.eas.ep.UpdateSqlInfo;
import com.kingdee.eas.ep.client.util.SqlBuilder;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.ep.client.wizard.template.MetaDataGetter;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.util.List;
import org.apache.log4j.Logger;

public class CopyCreator {
    private static final Logger logger = Logger.getLogger(CopyCreator.class);
    private static SuffixCollection suffixs;
    private TemplateInfo templateInfo = null;
    private String customizedSchemedID;
    private Project depend;
    private BizUnitInfo bizUnit = null;
    private AbstractMetaDataValue[] mds = null;

    public CopyCreator(TemplateInfo templateInfo, String customizedSchemedID, Project depend) {
        this.templateInfo = templateInfo;
        this.customizedSchemedID = customizedSchemedID;
        this.depend = depend;
    }

    private void addMetaDataPK(CustomizedItems items, AbstractMetaDataValue meta) {
        if (meta != null) {
            items.addMetadataPK(meta.getRealFullName());
        }
    }

    private boolean isCustomized(AbstractMetaDataValue[] mds) throws Exception {
        if (mds == null) {
            return false;
        }
        CustomizedItems items = new CustomizedItems();
        items.setSchemeID(this.customizedSchemedID);
        for (int i = 0; i < mds.length; ++i) {
            this.addMetaDataPK(items, mds[i]);
        }
        return CustomizedItemFactory.getRemoteInstance().isCustomized(items);
    }

    public BizUnitInfo create() throws Exception {
        AbstractMetaDataValue md;
        String editUI;
        BizUnitInfo temp;
        JoinQueryInfo query;
        if (this.templateInfo == null) {
            return null;
        }
        MetaDataLoaderFactory.getRemoteMetaDataLoader().clear(MetaDataTypeList.UIOBJECT);
        XMLAccessEngine.getXMLLoader((Context)ConfigMDUtil.getContext()).clearCacheByType(MetaDataTypeList.UIOBJECT);
        MetaDataLoaderFactory.getRemoteMetaDataLoader().clear(MetaDataTypeList.WEBUIOBJECT);
        XMLAccessEngine.getXMLLoader((Context)ConfigMDUtil.getContext()).clearCacheByType(MetaDataTypeList.WEBUIOBJECT);
        BizUnitInfo template = this.templateInfo.getTemplate();
        BizUnitCtrl bizUnitCtrl = new BizUnitCtrl(ContextManager.getContext());
        bizUnitCtrl.loadAll(template, true, false);
        EntityObjectInfo entity = template.getEntity();
        if (entity != null) {
            entity.setTrueClone(true);
        }
        if ((entity = template.getRelatedEntity()) != null) {
            entity.setTrueClone(true);
        }
        if ((query = template.getQuery()) != null) {
            query.setTrueClone(true);
        }
        this.bizUnit = temp = bizUnitCtrl.clone(template, suffixs, this.templateInfo.getPackagePath(), this.templateInfo.getName(), this.templateInfo.getUiType());
        temp.setAlias(this.templateInfo.getAlias());
        temp.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        temp.setPackage(this.templateInfo.getPackagePath());
        if (temp.getEditUI() != null && !StringUtils.isEmpty((String)template.getEditUIPK())) {
            temp.getEditUI().setTemplateUIClass(template.getEditUIPK());
        }
        if (temp.getListUI() != null && !StringUtils.isEmpty((String)template.getListUIPK())) {
            temp.getListUI().setTemplateUIClass(template.getListUIPK());
            if (temp.getEditUI() != null && !StringUtils.isEmpty((String)template.getEditUIPK())) {
                temp.getListUI().setTemplateEditUIClass(template.getEditUIPK());
                temp.getListUI().setDynEditUIClass(temp.getEditUI().getRealFullName());
            }
        }
        if (temp.getRelatedTreeUI() != null && !StringUtils.isEmpty((String)template.getRelatedEditUIPK())) {
            temp.getRelatedTreeUI().setTemplateUIClass(template.getRelatedEditUIPK());
        }
        if ((query = temp.getQuery()) != null) {
            query.setExtendedProperty("f7WindowTitle", this.templateInfo.getAlias());
        }
        if ((entity = temp.getEntity()) != null) {
            editUI = entity.getExtendedProperty("editUI");
            if (!StringUtils.isEmpty((String)editUI)) {
                entity.setExtendedProperty("editUI", editUI + "$$" + template.getEditUIPK());
            }
            String listUI = entity.getExtendedProperty("listUI");
            if (!StringUtils.isEmpty((String)editUI)) {
                entity.setExtendedProperty("listUI", listUI + "$$" + template.getListUIPK());
            }
        }
        if ("com.kingdee.eas.ep.TreeBaseCustomNew".equals(template.getFullName())) {
            JoinQueryInfo relatedQuery = temp.getRelatedQuery();
            String QueryName = temp.getName() + "F7Query";
            String packageName = query.getPackage();
            relatedQuery.setPackage(packageName);
            relatedQuery.setName(QueryName);
            relatedQuery.setExtendedProperty("F7WindowTitle", this.templateInfo.getAlias() + "F7Query");
            relatedQuery.setAlias(this.templateInfo.getAlias() + "F7Query");
            CopyCreator.updateQuery(relatedQuery, template.getEntity(), entity);
            entity.setExtendedProperty("defaultF7Query", packageName + "." + QueryName);
        }
        if ((entity = temp.getRelatedEntity()) != null && !StringUtils.isEmpty((String)(editUI = entity.getExtendedProperty("editUI")))) {
            entity.setExtendedProperty("editUI", editUI + "$$" + template.getRelatedTreeUI());
        }
        this.mds = new MetaDataGetter(temp).getMetaData();
        for (int i = 0; i < this.mds.length; ++i) {
            md = this.mds[i];
            md.setDynamic(true);
        }
        if (this.existsInDynamicmetas(this.mds, this.depend)) {
            throw new ReCreateException();
        }
        this.isCustomized(this.mds);
        if (template.getName().equals("TreeBaseCustomNew")) {
            // empty if block
        }
        UictUtils.saveMetadata(this.mds, this.customizedSchemedID, this.depend);
        CoreBaseCollection sqlCol = new CoreBaseCollection();
        md = null;
        for (int i = 0; i < this.mds.length; ++i) {
            String pkName;
            md = this.mds[i];
            if (!(md instanceof EntityObjectInfo) || ((EntityObjectInfo)md).getTable() == null) continue;
            entity = (EntityObjectInfo)md;
            DataTableInfo table = entity.getTable();
            pkName = pkName.substring(0, (pkName = BIMNameFactory.createTablePKName((String)table.getRealPackage(), (String)table.getRealName(), (String)"FID", (boolean)true)).length() > 18 ? 18 : pkName.length());
            pkName = pkName.replace('.', '_');
            table.getPrimaryKey().setName(pkName);
            String tableSql = SqlBuilder.buildTableSql(table);
            DBUpdateInfo sqlObj = new DBUpdateInfo(10, table.getRealName(), table.getRealName(), tableSql, 0);
            DBUpdateInfoSet sqlSet = new DBUpdateInfoSet();
            sqlSet.addDBUpdateInfo(sqlObj);
            UpdateSqlInfo sqlInfo = new UpdateSqlInfo();
            sqlInfo.setId(BOSUuid.create((BOSObjectType)sqlInfo.getBOSType()));
            sqlInfo.setCustomizedSchemeID(this.customizedSchemedID);
            sqlInfo.setEntityPK(entity.getRealPackage() + "." + entity.getRealName());
            sqlInfo.setTablePK(table.getRealPackage() + "." + table.getRealName());
            sqlInfo.setSql(sqlSet.toJSONObject().toString());
            sqlCol.add((CoreBaseInfo)sqlInfo);
        }
        if (sqlCol.size() > 0) {
            IUpdateSql instance = UpdateSqlFactory.getRemoteInstance();
            instance.addnew(sqlCol);
        }
        this.clearCache(template);
        return this.bizUnit;
    }

    private static String getPackageWithSuffix(String pk, SuffixCollection c, BOSObjectType type) {
        assert (pk != null);
        SuffixInfo info = c.get(type);
        if (info != null && !StringUtils.isEmpty((String)info.getSuffix())) {
            if (pk.length() == 0) {
                return info.getSuffix();
            }
            return pk + "." + info.getSuffix();
        }
        if (MetaDataTypeList.WEBUIOBJECT.equals((Object)type)) {
            if (pk.length() == 0) {
                return "web";
            }
            return pk + ".web";
        }
        return pk;
    }

    private static void updateQuery(JoinQueryInfo query, EntityObjectInfo oldEntity, EntityObjectInfo newEntity) {
        SubObjectCollection subEntitys = query.getSubObjects();
        int n = subEntitys.size();
        for (int i = 0; i < n; ++i) {
            SubEntityInfo subEntity = (SubEntityInfo)subEntitys.get(i);
            if (subEntity.getEntityRef().equals((Object)newEntity)) {
                subEntity.setEntityRef(newEntity);
                String oldSubEntityName = subEntity.getRealName();
                subEntity.setName(newEntity.getRealName());
                PropertyUnitCollection props = query.getUnits();
                int m = props.size();
                for (int j = 0; j < m; ++j) {
                    PropertyUnitInfo prop = props.get(j);
                    if (prop == null || prop.getPropertyRefs().size() != 1 || !StringUtils.equalsIgnoreCase((String)(subEntity = prop.getPropertyRefs().get(0).getSubEntity()).getRealName(), (String)oldSubEntityName)) continue;
                    subEntity.setName(newEntity.getRealName());
                }
                JoinCollection joins = query.getJoins();
                int m2 = joins.size();
                for (int j = 0; j < m2; ++j) {
                    SubObjectInfo subObj;
                    JoinInfo join = joins.get(j);
                    if (join == null || join.getLeftObject() == null || !StringUtils.equalsIgnoreCase((String)(subObj = join.getLeftObject()).getRealName(), (String)oldSubEntityName)) continue;
                    subObj.setName(newEntity.getRealName());
                }
                continue;
            }
            if (!subEntity.getEntityRef().getFullName().equalsIgnoreCase(oldEntity.getFullName())) continue;
            subEntity.setEntityRef(newEntity);
        }
    }

    private boolean existsInDynamicmetas(AbstractMetaDataValue[] md, Project project) {
        if (md == null || md.length < 1) {
            return false;
        }
        String sql = "where metadatapk in (";
        int n = md.length;
        for (int i = 0; i < n; ++i) {
            sql = i == 0 ? sql + "'" + md[i].getRealFullName() + "'" : sql + ",'" + md[i].getRealFullName() + "'";
        }
        sql = sql + ")";
        try {
            IDynamicMetadata idynamic = DynamicMetadataFactory.getRemoteInstance();
            if (idynamic.exists(sql)) {
                return true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return false;
    }

    private void clearCache(BizUnitInfo template) {
        AbstractMetaDataValue md2 = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        for (int i = 0; i < this.mds.length; ++i) {
            md2 = this.mds[i];
            if (md2 instanceof UIObjectInfo) continue;
            logger.info((Object)(" clear md cache --- > [" + md2.getBOSType() + "]" + md2.getFullName()));
            if (md2 == null || StringUtils.isEmpty((String)md2.getFullName())) continue;
            loader.clear(md2.getBOSType(), (IMetaDataPK)new MetaDataPK(md2.getFullName()));
        }
        List tmds = BizUnitHelper.getRelatedMetadatas((BizUnitInfo)template);
        for (AbstractMetaDataValue md2 : tmds) {
            if (md2 == null || StringUtils.isEmpty((String)md2.getFullName())) continue;
            loader.clear(md2.getBOSType(), (IMetaDataPK)new MetaDataPK(md2.getFullName()));
        }
    }

    public TemplateInfo getTemplateInfo() {
        return this.templateInfo;
    }

    public String getCustomizedSchemedID() {
        return this.customizedSchemedID;
    }

    public Project getDepend() {
        return this.depend;
    }

    public BizUnitInfo getCreatedBizUnit() {
        return this.bizUnit;
    }

    public AbstractMetaDataValue[] getCreatedMetaDatas() {
        return this.mds;
    }

    static {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        SolutionInfo solution = loader.getSolution();
        suffixs = solution.getSuffixes();
    }

    public static class TemplateInfo {
        private String packagePath = null;
        private String name = null;
        private String alias = null;
        private int uiType = 0;
        private BizUnitInfo template = null;

        public TemplateInfo() {
        }

        public TemplateInfo(String packagePath, String name, String alias, BizUnitInfo template, int uiType) {
            this.packagePath = packagePath;
            this.name = name;
            this.alias = alias;
            this.template = template;
            this.uiType = uiType;
        }

        public String getPackagePath() {
            return this.packagePath;
        }

        public void setPackagePath(String packagePath) {
            this.packagePath = packagePath;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public BizUnitInfo getTemplate() {
            return this.template;
        }

        public void setTemplate(BizUnitInfo template) {
            this.template = template;
        }

        public int getUiType() {
            return this.uiType;
        }

        public void setUiType(int uiType) {
            this.uiType = uiType;
        }
    }
}

