/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.wizard.template;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.bizunit.BizDataType;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.eas.ep.client.depend.mutiLan.MutiLanUtil;
import java.util.ArrayList;
import java.util.List;

public class MetaDataGetter {
    private BizUnitInfo bizUnit = null;
    private List relate = null;
    private String alias = null;
    private String bizUnitPK = null;

    public MetaDataGetter(BizUnitInfo bizUnit) {
        this.bizUnit = bizUnit;
        if (bizUnit != null) {
            this.relate = new ArrayList();
            this.alias = bizUnit.getAlias();
            this.bizUnitPK = bizUnit.getRealFullName();
        }
    }

    public AbstractMetaDataValue[] getMetaData() {
        if (this.bizUnit == null) {
            return new AbstractMetaDataValue[0];
        }
        this.handleRelated();
        this.handleEntity();
        this.handleQuery();
        this.handleUI();
        this.handleWebUI();
        this.handleFunction();
        this.relate.add(this.bizUnit);
        AbstractMetaDataValue[] mds = new AbstractMetaDataValue[this.relate.size()];
        mds = this.relate.toArray(mds);
        return mds;
    }

    private void handleRelated() {
        UIObjectInfo relatedTreeUI;
        EntityObjectInfo relatedEntity;
        DataTableInfo table = this.bizUnit.getRelatedTable();
        if (table != null) {
            table.setBizUnitPK(this.bizUnitPK);
            this.relate.add(table);
        }
        if ((relatedEntity = this.bizUnit.getRelatedEntity()) != null) {
            relatedEntity.setAlias(this.alias + "\u7c7b\u522b\u5b9e\u4f53");
            relatedEntity.setBizUnitPK(this.bizUnitPK);
            relatedEntity.setIsGenerateCode(false);
            this.relate.add(relatedEntity);
            PropertyCollection props = relatedEntity.getProperties();
            int n = props.size();
            for (int i = 0; i < n; ++i) {
                RelationshipInfo relation;
                LinkPropertyInfo lnkProp;
                PropertyInfo prop = props.get(i);
                if (!(prop instanceof LinkPropertyInfo) || (lnkProp = (LinkPropertyInfo)prop).getRelationship() == null || (relation = lnkProp.getRelationship()).getSupplierCardinality() != CardinalityType.ZERO_TO_ONE && relation.getSupplierCardinality() != CardinalityType.ONE) continue;
                this.relate.add(relation);
            }
        }
        if ((relatedTreeUI = this.bizUnit.getRelatedTreeUI()) != null) {
            relatedTreeUI.setBizUnitPK(this.bizUnitPK);
            relatedTreeUI.setAlias(this.alias + "\u7c7b\u522b\u7f16\u8f91\u754c\u9762");
            relatedTreeUI.setTitle(relatedTreeUI.getAlias());
            this.relate.add(relatedTreeUI);
        }
    }

    private void handleEntity() {
        EntityObjectInfo entity = this.bizUnit.getEntity();
        if (entity == null) {
            return;
        }
        DataTableInfo table = entity.getTable();
        if (table != null) {
            table.setBizUnitPK(this.bizUnitPK);
            this.relate.add(table);
        }
        entity.setIsGenerateCode(false);
        entity.setBizUnitPK(this.bizUnitPK);
        MutiLanUtil.setAllMutiLanAlias(entity, this.alias);
        this.relate.add(entity);
        BizFieldCollection fields = this.bizUnit.getFields();
        BizFieldInfo field = null;
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            field = fields.get(i);
            if (BizDataType.OBJECT.equals((Object)field.getBizDataType()) && field.getDataSource() != null) {
                EntityObjectCollection extEntityCol;
                String propName = field.getPropertyName();
                if (propName == null) continue;
                LinkPropertyInfo lnkProperty = (LinkPropertyInfo)entity.getPropertyByName(propName, false);
                if (lnkProperty != null && lnkProperty.getRelationship() != null) {
                    this.relate.add(lnkProperty.getRelationship());
                }
                if ((extEntityCol = this.bizUnit.getExtendEntities()) == null || extEntityCol.size() <= 0) continue;
                int m = extEntityCol.size();
                for (int j = 0; j < m; ++j) {
                    lnkProperty = (LinkPropertyInfo)extEntityCol.get(j).getPropertyByName(propName, false);
                    if (lnkProperty == null || lnkProperty.getRelationship() == null) continue;
                    this.relate.add(lnkProperty.getRelationship());
                }
                continue;
            }
            if (!(fields.get(i) instanceof BizGroupFieldInfo)) continue;
            BizGroupFieldInfo groupField = (BizGroupFieldInfo)fields.get(i);
            this.getRelateMetadata(entity, groupField);
        }
    }

    private void getRelateMetadata(EntityObjectInfo entity, BizGroupFieldInfo groupField) {
        JoinQueryInfo subQuery;
        EntityObjectInfo subEntity;
        LinkPropertyInfo lnkProperty;
        String propName;
        DataTableInfo table = groupField.getTableObject();
        if (table != null) {
            this.relate.add(table);
        }
        if ((propName = groupField.getPropertyName()) != null && (lnkProperty = (LinkPropertyInfo)entity.getPropertyByName(propName, false)) != null && lnkProperty.getRelationship() != null) {
            this.relate.add(lnkProperty.getRelationship());
        }
        if ((subEntity = groupField.getEntityObject()) != null) {
            subEntity.setAlias(this.alias + "\u5206\u5f55");
            subEntity.setIsGenerateCode(false);
            this.relate.add(subEntity);
            BizFieldCollection subFields = groupField.getFields();
            int m = subFields.size();
            for (int j = 0; j < m; ++j) {
                LinkPropertyInfo lnkProperty2;
                String subPropName;
                if (subFields.get(j) instanceof BizGroupFieldInfo) {
                    this.getRelateMetadata(subEntity, (BizGroupFieldInfo)subFields.get(j));
                    continue;
                }
                if (!BizDataType.OBJECT.equals((Object)subFields.get(j).getBizDataType()) || subFields.get(j).getDataSource() == null || (subPropName = subFields.get(j).getPropertyName()) == null || (lnkProperty2 = (LinkPropertyInfo)subEntity.getPropertyByName(subPropName, false)) == null || lnkProperty2.getRelationship() == null) continue;
                this.relate.add(lnkProperty2.getRelationship());
            }
        }
        if ((subQuery = groupField.getQuery()) != null) {
            subQuery.setAlias(this.alias + "\u5b50\u67e5\u8be2");
            this.relate.add(subQuery);
        }
    }

    private void handleQuery() {
        JoinQueryInfo relateQuery;
        JoinQueryInfo query = this.bizUnit.getQuery();
        if (query != null) {
            query.setBizUnitPK(this.bizUnitPK);
            MutiLanUtil.setAlias(query, this.alias + "\u67e5\u8be2");
            this.relate.add(query);
        }
        if ("com.kingdee.eas.ep.app.TreeBaseCustomNew".equals(this.bizUnit.getEntity().getFullName()) && (relateQuery = this.bizUnit.getRelatedQuery()) != null) {
            relateQuery.setBizUnitPK(this.bizUnitPK);
            MutiLanUtil.setAlias(relateQuery, this.alias + "\u67e5\u8be2");
            this.relate.add(relateQuery);
        }
    }

    private void handleUI() {
        UIObjectInfo ui = this.bizUnit.getEditUI();
        if (ui != null) {
            MutiLanUtil.setAllMutiLanAlias(ui, this.alias + "\u7f16\u8f91\u754c\u9762");
            ui.setBizUnitPK(this.bizUnitPK);
            MutiLanUtil.setAllMutiLanTitle(ui, ui.getAlias());
            this.relate.add(ui);
            if (ui.getRuleSet() != null) {
                this.relate.add(ui.getRuleSet());
            }
        }
        if ((ui = this.bizUnit.getListUI()) != null) {
            ui.setBizUnitPK(this.bizUnitPK);
            MutiLanUtil.setAllMutiLanAlias(ui, this.alias + "\u67e5\u8be2\u754c\u9762");
            MutiLanUtil.setAllMutiLanTitle(ui, ui.getAlias());
            this.relate.add(ui);
        }
    }

    private void handleWebUI() {
        WebUIObjectInfo ui = this.bizUnit.getWebEditUI();
        if (ui != null) {
            ui.setAlias(this.alias + "\u7f16\u8f91\u754c\u9762");
            ui.setBizUnitPK(this.bizUnitPK);
            this.relate.add(ui);
            if (ui.getRuleSet() != null) {
                this.relate.add(ui.getRuleSet());
            }
        }
        if ((ui = this.bizUnit.getWebListUI()) != null) {
            ui.setBizUnitPK(this.bizUnitPK);
            ui.setAlias(this.alias + "\u67e5\u8be2\u754c\u9762");
            this.relate.add(ui);
        }
    }

    private void handleFunction() {
        FunctionObjectInfo fun = this.bizUnit.getEntityFunction();
        if (fun != null) {
            this.relate.add(fun);
        }
        if ((fun = this.bizUnit.getEditUIFunction()) != null) {
            fun.setAlias(this.alias + "\u7f16\u8f91\u529f\u80fd");
            this.relate.add(fun);
        }
        if ((fun = this.bizUnit.getListUIFunction()) != null) {
            fun.setAlias(this.alias + "\u5217\u8868\u529f\u80fd");
            this.relate.add(fun);
        }
    }
}

