/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.wizard.template;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.ep.CustomTemplateCollection;
import com.kingdee.eas.ep.CustomTemplateFactory;
import com.kingdee.eas.ep.CustomTemplateInfo;
import com.kingdee.eas.ep.ICustomTemplate;
import com.kingdee.eas.ep.client.editor.editui.designer.listener.NameListener;
import com.kingdee.eas.ep.client.editor.packageset.PackagePromptBox;
import com.kingdee.eas.ep.client.figure.FigureHelper;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.wizard.AbstractMetadataWizardUI;
import com.kingdee.eas.ep.client.wizard.AbstractUictWizardPage;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;

public class TemplateUI
extends AbstractUictWizardPage {
    private static final Logger logger = CoreUIObject.getLogger(TemplateUI.class);
    public static final String PAGE_NAME = "TemplateUI";
    private static final String TITLE = "\u590d\u5236\u6a21\u677f";
    private static final String DESCRIPTION = "\u8bf7\u9009\u62e9\u6a21\u677f(\u590d\u5236\u65b0\u589e\u7684\u5185\u5bb9\u5728\u91cd\u65b0\u542f\u7528\u52a8\u6001\u6269\u5c55\u65b9\u6848\u540e\u624d\u80fd\u751f\u6548)";
    public static final String UITYPE_GUI = "GUI";
    public static final String UITYPE_GUI$WEB = "GUI and Web";
    protected ResourceBundleHelper resHelper = null;
    protected KDTable tableList;
    protected KDLabelContainer lblName;
    protected KDTextField txtName;
    protected KDLabelContainer lblPK;
    protected KDPromptBox txtPK;
    protected KDLabelContainer lblAlias;
    protected KDTextField txtAlias;
    protected KDLabelContainer lblUIType;
    private CustomTemplateInfo template = null;

    public TemplateUI(String name) {
        this.setLayout(null);
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.setPageName(name);
        this.txtPK.setEditable(false);
        this.txtName.addKeyListener((KeyListener)new NameListener());
    }

    @Override
    public void createControls() {
        this.resHelper = new ResourceBundleHelper(TemplateUI.class.getName());
        this.tableList = new KDTable();
        this.lblName = new KDLabelContainer();
        this.txtName = new KDTextField();
        this.lblPK = new KDLabelContainer();
        this.txtPK = new KDPromptBox();
        this.lblAlias = new KDLabelContainer();
        this.txtAlias = new KDTextField();
        this.lblUIType = new KDLabelContainer();
        this.tableList.setName("tableList");
        this.lblName.setName("lblName");
        this.txtName.setName("txtName");
        this.lblPK.setName("lblPK");
        this.txtPK.setName("txtPK");
        this.lblAlias.setName("lblAlias");
        this.txtAlias.setName("txtAlias");
        this.lblUIType.setName("lblUIType");
        this.setBounds(new Rectangle(10, 10, 600, 300));
        this.setLayout(null);
        this.tableList.setBounds(new Rectangle(10, 100, 581, 193));
        this.add((Component)this.tableList, null);
        this.lblName.setBounds(new Rectangle(10, 31, 581, 19));
        this.add((Component)this.lblName, null);
        this.lblPK.setBounds(new Rectangle(10, 8, 581, 19));
        this.add((Component)this.lblPK, null);
        this.lblAlias.setBounds(new Rectangle(10, 55, 581, 19));
        this.add((Component)this.lblAlias, null);
        this.lblUIType.setBounds(new Rectangle(10, 79, 581, 19));
        this.add((Component)this.lblUIType, null);
        this.lblName.setBoundEditor((JComponent)this.txtName);
        this.lblPK.setBoundEditor((JComponent)this.txtPK);
        this.lblAlias.setBoundEditor((JComponent)this.txtAlias);
        this.tableList.setFormatXml(this.resHelper.getString("tableList.formatXml"));
        this.tableList.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    TemplateUI.this.tableList_tableSelectChanged(e);
                }
                catch (Exception exception) {
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        });
        this.tableList.checkParsed(true);
        this.lblName.setBoundLabelText(this.resHelper.getString("lblName.boundLabelText"));
        this.lblName.setBoundLabelLength(70);
        this.lblPK.setBoundLabelText(this.resHelper.getString("lblPK.boundLabelText"));
        this.lblPK.setBoundLabelLength(70);
        this.lblAlias.setBoundLabelText(this.resHelper.getString("lblAlias.boundLabelText"));
        this.lblAlias.setBoundLabelLength(70);
        this.lblUIType.setBoundLabelText("UI\u7c7b\u578b");
        this.lblUIType.setBoundLabelLength(70);
        this.txtName.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                String name = TemplateUI.this.txtName.getText();
                String alias = TemplateUI.this.txtAlias.getText();
                if (StringUtils.isEmpty((String)alias)) {
                    TemplateUI.this.txtAlias.setText(name);
                } else if (name.startsWith(alias)) {
                    TemplateUI.this.txtAlias.setText(name);
                } else if (alias.startsWith(name) && alias.length() == name.length() + 1) {
                    TemplateUI.this.txtAlias.setText(name);
                }
                TemplateUI.this.validata();
            }
        });
        this.txtAlias.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                TemplateUI.this.validata();
            }
        });
    }

    private void validata() {
        String name = this.txtName.getText();
        String alias = this.txtAlias.getText();
        String pk = this.txtPK.getText();
        boolean correct = true;
        if (StringUtils.isEmpty((String)name) || !this.isValidName(name)) {
            this.setDescription("\u540d\u79f0\u975e\u6cd5\u6216\u4e3a\u7a7a\uff0c\u5408\u6cd5\u540d\u79f0\u7531\u5b57\u6bcd\u548c\u6570\u5b57\u7ec4\u6210\u5e76\u4e14\u9996\u5b57\u6bcd\u4e3a\u5927\u5199\u5b57\u6bcd");
            correct = false;
        }
        if (correct && StringUtils.isEmpty((String)pk)) {
            this.setDescription("\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
            correct = false;
        }
        if (correct && StringUtils.isEmpty((String)alias)) {
            this.setDescription("\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            correct = false;
        }
        if (correct && name.trim().length() > 50) {
            this.setDescription("\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26");
            correct = false;
        }
        if (correct && this.template == null) {
            this.setDescription("\u672a\u9009\u4e2d\u6a21\u677f");
            correct = false;
        }
        if (!correct) {
            this.canFinish = false;
            this.setPic(FigureHelper.errorIcon);
        } else {
            this.canFinish = true;
            this.setDescription(DESCRIPTION);
            this.setPic(null);
        }
        this.fireReset();
    }

    public String getPK() {
        return this.txtPK.getText();
    }

    @Override
    public String getName() {
        return this.txtName.getText();
    }

    public String getAlias() {
        return this.txtAlias.getText();
    }

    public String getUIType() {
        return UITYPE_GUI;
    }

    public CustomTemplateInfo getTemplateInfo() {
        return this.template;
    }

    protected void tableList_tableSelectChanged(KDTSelectEvent e) throws Exception {
        CustomTemplateInfo tInfo;
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.tableList);
        if (rowIndex.length > 0 && (tInfo = (CustomTemplateInfo)this.tableList.getRow(rowIndex[0]).getUserObject()) != null) {
            this.template = tInfo;
            this.validata();
            return;
        }
        this.template = null;
        this.validata();
    }

    private boolean isValidName(String name) {
        char[] chars = name.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[0] < 'A' || chars[0] > 'Z') {
                return false;
            }
            if (chars[i] < '0' || chars[i] > 'z') {
                return false;
            }
            if (i != 0 || chars[i] >= 'A') continue;
            return false;
        }
        return true;
    }

    @Override
    public void init() {
        this.canCancel = true;
        this.canPreview = false;
        this.canNext = false;
        this.canFinish = false;
        try {
            this.loadTemplate();
        }
        catch (Exception e) {
            ExceptionHandler.handleError(this, e, "\u52a0\u8f7d\u6a21\u677f\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
        }
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("CUSTOMIZEDSCHEMEID", ((AbstractMetadataWizardUI)this.getWizard()).getCustomizedSchemedID());
        ctx.put("DEPEND", (String)((AbstractMetadataWizardUI)this.getWizard()).getDepend());
        PackagePromptBox pack = new PackagePromptBox((IUIObject)this.getWizard(), ctx);
        this.txtPK.setSelector((KDPromptSelector)pack);
    }

    private void loadTemplate() throws Exception {
        ICustomTemplate instance = CustomTemplateFactory.getRemoteInstance();
        CustomTemplateCollection col = instance.getCustomTemplateCollection();
        this.tableList.removeRows();
        if (col == null) {
            return;
        }
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            CustomTemplateInfo info = col.get(i);
            IRow row = this.tableList.addRow();
            row.setUserObject((Object)info);
            row.getCell("nameColumn").setValue((Object)info.getName());
        }
    }
}

