/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.wizard.template;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.bizrule.RuleSetInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ep.CustomizedUnitFactory;
import com.kingdee.eas.ep.CustomizedUnitInfo;
import com.kingdee.eas.ep.ICustomizedUnit;
import com.kingdee.eas.ep.NodeTypeEnum;
import com.kingdee.eas.ep.client.model.CustomizedUnitTreeNode;
import com.kingdee.eas.ep.client.wizard.template.CopyCreator;
import com.kingdee.eas.ep.updater.CustomizedUnitNodeInfo;
import com.kingdee.eas.ep.updater.CustomizedUnitNodeInfoConverter;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.util.StringUtils;

public class UnitNodeCreator {
    private CopyCreator copyCreator = null;
    private CustomizedUnitNodeInfo unitNode = null;
    private CustomizedUnitTreeNode selectNode = null;
    private CustomizedUnitInfo unitInfo = null;
    private String TemplateNumber;

    public UnitNodeCreator(CopyCreator copyCreator, CustomizedUnitTreeNode selectNode, CustomizedUnitInfo unitInfo) {
        this.copyCreator = copyCreator;
        this.selectNode = selectNode;
        this.unitInfo = unitInfo;
        if (unitInfo != null) {
            this.unitNode = CustomizedUnitNodeInfoConverter.converter2Object(unitInfo.getCustomizedUnitObject());
        }
    }

    public CustomizedUnitNodeInfo create() throws Exception {
        if (this.copyCreator == null) {
            return this.unitNode;
        }
        BizUnitInfo bizUnit = this.copyCreator.getCreatedBizUnit();
        if (this.unitNode == null && bizUnit != null) {
            this.unitNode = new CustomizedUnitNodeInfo();
            this.unitNode.setPackagePK(bizUnit.getPackage());
            this.unitNode.setName(bizUnit.getName());
            this.unitNode.setAlias(bizUnit.getAlias());
            this.unitNode.setCustomizedType("bizunit");
            this.unitNode.setType("2");
            this.unitNode.setUiType(String.valueOf(this.copyCreator.getTemplateInfo().getUiType()));
            this.unitNode.setTemplateNumber(this.TemplateNumber);
        } else if (this.unitNode == null) {
            return this.unitNode;
        }
        this.buildNodeContent();
        String xml = CustomizedUnitNodeInfoConverter.coverter2xml(this.unitNode);
        ICustomizedUnit bizInterface = CustomizedUnitFactory.getRemoteInstance();
        if (this.unitInfo != null) {
            this.unitInfo.setCustomizedUnitObject(xml);
            ObjectUuidPK cpk = new ObjectUuidPK(this.unitInfo.getId());
            bizInterface.update((IObjectPK)cpk, (CoreBaseInfo)this.unitInfo);
        } else {
            CustomizedUnitInfo dataObj = new CustomizedUnitInfo();
            dataObj.setId(BOSUuid.create((BOSObjectType)dataObj.getBOSType()));
            dataObj.setNumber(dataObj.getId().toString());
            dataObj.setName(this.unitNode.getName());
            dataObj.setDisplayName(StringUtils.isEmpty((String)this.unitNode.getAlias()) ? this.unitNode.getName() : this.unitNode.getAlias());
            dataObj.setNodeType(NodeTypeEnum.CUSTOMIZED_UNIT);
            dataObj.setCustomizedUnitObject(xml);
            dataObj.setIsLeaf(false);
            dataObj.setLevel(this.selectNode.getLevel() + 1);
            dataObj.setParent((CustomizedUnitInfo)this.selectNode.getUserObject());
            dataObj.setCustomizedSchemeID(this.copyCreator.getCustomizedSchemedID());
            if (this.copyCreator.getCreatedBizUnit() != null) {
                dataObj.setMetaDataPK(this.copyCreator.getCreatedBizUnit().getFullName());
            }
            bizInterface.addnew((CoreBaseInfo)dataObj);
        }
        return this.unitNode;
    }

    private void buildNodeContent() {
        AbstractMetaDataValue[] mds = this.copyCreator.getCreatedMetaDatas();
        CustomizedUnitNodeInfo.MetaDataInfo md = null;
        for (int i = 0; i < mds.length; ++i) {
            md = new CustomizedUnitNodeInfo.MetaDataInfo(mds[i].getRealPackage(), mds[i].getRealName(), mds[i].getAlias());
            if (mds[i] instanceof EntityObjectInfo) {
                this.unitNode.getEntity().add(md);
                continue;
            }
            if (mds[i] instanceof JoinQueryInfo) {
                this.unitNode.getQuery().add(md);
                continue;
            }
            if (mds[i] instanceof UIObjectInfo) {
                if (this.isInheritedFromClass((UIObjectInfo)mds[i], ListUI.class)) {
                    this.unitNode.getUi().getListui().add(md);
                    continue;
                }
                if (this.isInheritedFromClass((UIObjectInfo)mds[i], EditUI.class)) {
                    this.unitNode.getUi().getEditui().add(md);
                    if (((UIObjectInfo)mds[i]).getRuleSet() == null) continue;
                    RuleSetInfo ruleSet = ((UIObjectInfo)mds[i]).getRuleSet();
                    md = new CustomizedUnitNodeInfo.MetaDataInfo(ruleSet.getRealPackage(), ruleSet.getRealName(), ruleSet.getAlias());
                    this.unitNode.getRuleSet().add(md);
                    continue;
                }
                if (!this.isInheritedFromClass((UIObjectInfo)mds[i], CoreUI.class)) continue;
                this.unitNode.getUi().getOtherui().add(md);
                continue;
            }
            if (mds[i] instanceof WebUIObjectInfo) {
                if (this.isInheritedFromFullName((WebUIObjectInfo)mds[i], "com.kingdee.eas.framework.web.ListUI")) {
                    this.unitNode.getWebUi().getListui().add(md);
                    continue;
                }
                if (!this.isInheritedFromFullName((WebUIObjectInfo)mds[i], "com.kingdee.eas.framework.web.EditUI")) continue;
                this.unitNode.getWebUi().getEditui().add(md);
                continue;
            }
            if (!(mds[i] instanceof FunctionObjectInfo)) continue;
            this.unitNode.getFunction().add(md);
        }
    }

    private boolean isInheritedFromClass(UIObjectInfo ui, Class c) {
        for (UIObjectInfo tmp = ui; tmp != null; tmp = tmp.getParent()) {
            if (!c.getName().equals(tmp.getFullName())) continue;
            return true;
        }
        return false;
    }

    private boolean isInheritedFromFullName(WebUIObjectInfo ui, String fullname) {
        for (WebUIObjectInfo tmp = ui; tmp != null; tmp = tmp.getParent()) {
            if (!fullname.equals(tmp.getRealFullName())) continue;
            return true;
        }
        return false;
    }

    public String getTemplateNumber() {
        return this.TemplateNumber;
    }

    public void setTemplateNumber(String templateNumber) {
        this.TemplateNumber = templateNumber;
    }
}

