/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.db.DBUpdateInfo;
import com.kingdee.bos.db.DBUpdateInfoSet;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.IMetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.eas.ep.CustomizedSchemeCollection;
import com.kingdee.eas.ep.CustomizedSchemeFactory;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.ICustomizedScheme;
import com.kingdee.eas.ep.IUpdateSql;
import com.kingdee.eas.ep.UpdateSqlFactory;
import com.kingdee.eas.ep.client.depend.ClientCacheManager;
import com.kingdee.eas.ep.depend.VersionManager;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class EPUtils {
    private static final Logger logger = Logger.getLogger((String)EPUtils.class.getName());
    private static final String CUSTOMIZEDSCHEME = "T_EP_CustomizedScheme";

    private static Manifest makeSchemeManifest(Context ctx, String schemeId, int type) throws Exception {
        ICustomizedScheme iCS = CustomizedSchemeFactory.getLocalInstance(ctx);
        CustomizedSchemeInfo csInfo = iCS.getCustomizedSchemeInfo((IObjectPK)new ObjectUuidPK(schemeId));
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(Attributes.Name.MANIFEST_VERSION).append(": 1.0\n");
        sbuf.append("ID: ").append(schemeId);
        sbuf.append("\n");
        sbuf.append("name: ").append(csInfo.getName());
        sbuf.append("\n");
        sbuf.append("alias: ").append(csInfo.getAlias());
        sbuf.append("\n");
        sbuf.append("depend: ").append(csInfo.getDepend());
        sbuf.append("\n");
        sbuf.append("export_type: ").append(new Integer(type));
        sbuf.append("\n");
        sbuf.append("release-date: ").append(new Date());
        sbuf.append("\n");
        sbuf.append("version");
        sbuf.append(": ");
        sbuf.append(VersionManager.getPlatformVersion());
        sbuf.append("\n");
        ByteArrayInputStream in = new ByteArrayInputStream(sbuf.toString().getBytes("UTF-8"));
        Manifest manifest = new Manifest(in);
        return manifest;
    }

    public static byte[] exportSchemeToSQL(Context ctx, String schemeId, String relativepath) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Manifest manifest = EPUtils.makeSchemeManifest(ctx, schemeId, 0);
        JarOutputStream outStream = new JarOutputStream((OutputStream)stream, manifest);
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(EPUtils.generateDeleteSql(outStream, schemeId, relativepath));
        MetaDataPK tablePk = MetaDataPK.create((String)"com.kingdee.bos.config.app.T_CON_DynamicMetadata");
        StringBuffer sql = null;
        sql = new StringBuffer("SELECT * FROM T_CON_DynamicMetadata ");
        sql.append(" WHERE FProjectID = '");
        sql.append(schemeId).append("'");
        EPUtils.exportSql2Jar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString(), relativepath, paths);
        tablePk = MetaDataPK.create((String)"com.kingdee.bos.config.app.T_CON_EntityPKMapping");
        sql = new StringBuffer("SELECT * FROM T_CON_EntityPKMapping ");
        EPUtils.exportSql2Jar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString(), relativepath, paths, true);
        tablePk = MetaDataPK.create((String)"com.kingdee.bos.config.app.T_CON_FacadePKMapping");
        sql = new StringBuffer("SELECT * FROM T_CON_FacadePKMapping ");
        EPUtils.exportSql2Jar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString(), relativepath, paths, true);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_ExtendPoint");
        sql = new StringBuffer("SELECT * FROM T_EP_ExtendPoint");
        sql.append(" WHERE FSchemeID = '");
        sql.append(schemeId).append("'");
        EPUtils.exportSql2Jar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString(), relativepath, paths);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_ExtendPointParam");
        sql = new StringBuffer("SELECT * FROM T_EP_ExtendPointParam");
        sql.append(" WHERE FSchemeID = '");
        sql.append(schemeId).append("'");
        EPUtils.exportSql2Jar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString(), relativepath, paths);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_PlugIn");
        sql = new StringBuffer("SELECT * FROM T_EP_PlugIn ");
        sql.append(" WHERE FSchemeID = '");
        sql.append(schemeId).append("'");
        EPUtils.exportSql2Jar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString(), relativepath, paths);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_PlugInScript");
        sql = new StringBuffer("SELECT * FROM T_EP_PlugInScript ");
        sql.append(" WHERE FSchemeID = '");
        sql.append(schemeId).append("'");
        EPUtils.exportSql2Jar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString(), relativepath, paths);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_LibScript");
        sql = new StringBuffer("SELECT * FROM T_EP_LibScript WHERE FSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportSql2Jar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString(), relativepath, paths);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_LibScriptTREE");
        sql = new StringBuffer("SELECT * FROM T_EP_LibScriptTREE WHERE FSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportSql2Jar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString(), relativepath, paths);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_CustomizedScheme");
        sql = new StringBuffer("SELECT * FROM T_EP_CustomizedScheme WHERE FID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportSql2Jar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString(), relativepath, paths);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_CustomizedUnit");
        sql = new StringBuffer("SELECT * FROM T_EP_CustomizedUnit WHERE FCustomizedSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportSql2Jar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString(), relativepath, paths);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_EditUIConfigure");
        sql = new StringBuffer("SELECT * FROM T_EP_EditUIConfigure WHERE FCustomizedSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportSql2Jar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString(), relativepath, paths);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_Exception");
        sql = new StringBuffer("SELECT * FROM T_EP_Exception WHERE FProject = '");
        sql.append(schemeId).append("'");
        EPUtils.exportSql2Jar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString(), relativepath, paths);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_Sql");
        sql = new StringBuffer("SELECT * FROM T_EP_Sql WHERE FCustomizedSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportSql2Jar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString(), relativepath, paths);
        paths.add(EPUtils.exportSQLTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString(), relativepath));
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_DynQueryScheme");
        sql = new StringBuffer("SELECT * FROM T_EP_DynQueryScheme WHERE FDynSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportSql2Jar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString(), relativepath, paths);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.base.commonquery.app.T_QUERY_DynQuerySolution");
        sql = new StringBuffer("SELECT T1.* FROM T_QUERY_DynQuerySolution T1 ");
        sql.append(" INNER JOIN T_EP_DynQueryScheme T2 ON T1.FID = T2.FDynQueryID ");
        sql.append(" WHERE T2.FDynSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportSql2Jar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString(), relativepath, paths);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.base.commonquery.app.T_QUERY_DynQueryEntity");
        sql = new StringBuffer("SELECT T1.* FROM T_QUERY_DynQueryEntity T1 ");
        sql.append(" INNER JOIN T_QUERY_DynQuerySolution T2 ON T1.FDynSolutionID = T2.FID ");
        sql.append(" INNER JOIN T_EP_DynQueryScheme T3 ON T2.FID = T3.FDynQueryID ");
        sql.append(" WHERE T3.FDynSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportSql2Jar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString(), relativepath, paths);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.base.commonquery.app.T_QUERY_DynQueryJoinField");
        sql = new StringBuffer("SELECT T1.* FROM T_QUERY_DynQueryJoinField T1 ");
        sql.append(" INNER JOIN T_QUERY_DynQueryEntity T2 ON T1.FEntityID = T2.FID ");
        sql.append(" INNER JOIN T_QUERY_DynQuerySolution T3 ON T2.FDynSolutionID = T3.FID ");
        sql.append(" INNER JOIN T_EP_DynQueryScheme T4 ON T3.FID = T4.FDynQueryID ");
        sql.append(" WHERE T4.FDynSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportSql2Jar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString(), relativepath, paths);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.base.commonquery.app.T_QUERY_DynQuerySelectField");
        sql = new StringBuffer("SELECT T1.* FROM T_QUERY_DynQuerySelectField T1 ");
        sql.append(" INNER JOIN T_QUERY_DynQueryEntity T2 ON T1.FEntityID = T2.FID ");
        sql.append(" INNER JOIN T_QUERY_DynQuerySolution T3 ON T2.FDynSolutionID = T3.FID ");
        sql.append(" INNER JOIN T_EP_DynQueryScheme T4 ON T3.FID = T4.FDynQueryID ");
        sql.append(" WHERE T4.FDynSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportSql2Jar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString(), relativepath, paths);
        Document doc = new Document();
        Element rootElement = new Element("System");
        rootElement.setName("template");
        doc.setRootElement(rootElement);
        int n = paths.size();
        for (int i = 0; i < n; ++i) {
            if (paths.get(i) == null) continue;
            String path = paths.get(i).toString();
            Element data = new Element("Data");
            if (!StringUtils.isEmpty((String)relativepath)) {
                data.setText(relativepath + "/" + path);
            } else {
                data.setText(path);
            }
            rootElement.addContent((Content)data);
        }
        Format format = Format.getRawFormat();
        format.setEncoding("UTF-8");
        XMLOutputter outp = new XMLOutputter(format);
        JarEntry jarAdd = new JarEntry("update.xml");
        jarAdd.setTime(new Date().getTime());
        outStream.putNextEntry(jarAdd);
        outStream.write(outp.outputString(doc).getBytes("UTF-8"), 0, outp.outputString(doc).getBytes("UTF-8").length);
        outStream.flush();
        outStream.close();
        byte[] bb = stream.toByteArray();
        stream.close();
        return bb;
    }

    private static String generateDeleteSql(JarOutputStream outStream, String schemeId, String relativepath) throws Exception {
        StringBuffer deleteSQL = new StringBuffer();
        String sql = "delete from T_EP_CustomizedUnit where FCustomizedSchemeID is null or FCustomizedSchemeID = '" + schemeId + "'";
        deleteSQL.append(sql);
        deleteSQL.append(";\n");
        sql = "delete from T_CON_DynamicMetadata where FProjectID = '" + schemeId + "'";
        deleteSQL.append(sql);
        deleteSQL.append(";\n");
        sql = "delete from T_EP_EditUIOrgUict where exists(select * from T_EP_EditUIConfigure where fid = T_EP_EditUIOrgUict.FConfigureID and FCustomizedSchemeID = '" + schemeId + "') ";
        deleteSQL.append(sql);
        deleteSQL.append(";\n");
        sql = "delete from T_EP_EditUIUserOrgUict where exists(select * from T_EP_EditUIConfigure where fid = T_EP_EditUIUserOrgUict.FConfigureID and FCustomizedSchemeID = '" + schemeId + "') ";
        deleteSQL.append(sql);
        deleteSQL.append(";\n");
        sql = "delete from T_EP_EditUIConfigure where FCustomizedSchemeID = '" + schemeId + "'";
        deleteSQL.append(sql);
        deleteSQL.append(";\n");
        sql = "delete from T_EP_Sql where FCustomizedSchemeID = '" + schemeId + "'";
        deleteSQL.append(sql);
        deleteSQL.append(";\n");
        sql = "delete from T_EP_CustomizedItem where FSchemeID = '" + schemeId + "'";
        deleteSQL.append(sql);
        deleteSQL.append(";\n");
        sql = "delete from T_EP_Exception where FProject = '" + schemeId + "'";
        deleteSQL.append(sql);
        deleteSQL.append(";\n");
        sql = "delete from T_EP_LibScriptTREE where FSchemeID = '" + schemeId + "'";
        deleteSQL.append(sql);
        deleteSQL.append(";\n");
        sql = "delete from T_EP_LibScript where FSchemeID = '" + schemeId + "'";
        deleteSQL.append(sql);
        deleteSQL.append(";\n");
        sql = "delete from T_EP_ExtendPoint where FSchemeID = '" + schemeId + "'";
        deleteSQL.append(sql);
        deleteSQL.append(";\n");
        sql = "delete from T_EP_ExtendPointParam where FSchemeID = '" + schemeId + "'";
        deleteSQL.append(sql);
        deleteSQL.append(";\n");
        sql = "delete from T_EP_PlugIn where FSchemeID = '" + schemeId + "'";
        deleteSQL.append(sql);
        deleteSQL.append(";\n");
        sql = "delete from T_EP_PlugInScript where FSchemeID = '" + schemeId + "'";
        deleteSQL.append(sql);
        deleteSQL.append(";\n");
        sql = "delete from T_EP_DynQueryScheme where FDynSchemeID = '" + schemeId + "'";
        deleteSQL.append(sql);
        deleteSQL.append(";\n");
        sql = "delete from t_ep_lock where FSchemeID = '" + schemeId + "'";
        deleteSQL.append(sql);
        deleteSQL.append(";\n");
        sql = "delete from T_EP_CustomizedScheme where FID = '" + schemeId + "'";
        deleteSQL.append(sql);
        deleteSQL.append(";\n");
        String path = "deletescheme.sql";
        JarEntry jarAdd = new JarEntry(path);
        jarAdd.setTime(new Date().getTime());
        outStream.putNextEntry(jarAdd);
        outStream.write(deleteSQL.toString().getBytes("UTF-8"), 0, deleteSQL.toString().getBytes("UTF-8").length);
        return path;
    }

    public static byte[] exportScheme(Context ctx, String schemeId, boolean exportLock) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Manifest manifest = EPUtils.makeSchemeManifest(ctx, schemeId, 1);
        JarOutputStream outStream = new JarOutputStream((OutputStream)stream, manifest);
        MetaDataPK tablePk = MetaDataPK.create((String)"com.kingdee.bos.config.app.T_CON_DynamicMetadata");
        StringBuffer sql = null;
        sql = new StringBuffer("SELECT * FROM T_CON_DynamicMetadata ");
        sql.append(" WHERE FProjectID = '");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.bos.config.app.T_CON_EntityPKMapping");
        sql = new StringBuffer("SELECT * FROM T_CON_EntityPKMapping ");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.bos.config.app.T_CON_FacadePKMapping");
        sql = new StringBuffer("SELECT * FROM T_CON_FacadePKMapping ");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_ExtendPoint");
        sql = new StringBuffer("SELECT * FROM T_EP_ExtendPoint");
        sql.append(" WHERE FSchemeID = '");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_ExtendPointParam");
        sql = new StringBuffer("SELECT * FROM T_EP_ExtendPointParam");
        sql.append(" WHERE FSchemeID = '");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_PlugIn");
        sql = new StringBuffer("SELECT * FROM T_EP_PlugIn ");
        sql.append(" WHERE FSchemeID = '");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_PlugInScript");
        sql = new StringBuffer("SELECT * FROM T_EP_PlugInScript ");
        sql.append(" WHERE FSchemeID = '");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_LibScript");
        sql = new StringBuffer("SELECT * FROM T_EP_LibScript WHERE FSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_LibScriptTREE");
        sql = new StringBuffer("SELECT * FROM T_EP_LibScriptTREE WHERE FSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_CustomizedScheme");
        sql = new StringBuffer("SELECT * FROM T_EP_CustomizedScheme WHERE FID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_CustomizedUnit");
        sql = new StringBuffer("SELECT * FROM T_EP_CustomizedUnit WHERE FCustomizedSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_EditUIConfigure");
        sql = new StringBuffer("SELECT * FROM T_EP_EditUIConfigure WHERE FCustomizedSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_Exception");
        sql = new StringBuffer("SELECT * FROM T_EP_Exception WHERE FProject = '");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_Sql");
        sql = new StringBuffer("SELECT * FROM T_EP_Sql WHERE FCustomizedSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_DynQueryScheme");
        sql = new StringBuffer("SELECT * FROM T_EP_DynQueryScheme WHERE FDynSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.base.commonquery.app.T_QUERY_DynQuerySolution");
        sql = new StringBuffer("SELECT T1.* FROM T_QUERY_DynQuerySolution T1 ");
        sql.append(" INNER JOIN T_EP_DynQueryScheme T2 ON T1.FID = T2.FDynQueryID ");
        sql.append(" WHERE T2.FDynSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.base.commonquery.app.T_QUERY_DynQueryEntity");
        sql = new StringBuffer("SELECT T1.* FROM T_QUERY_DynQueryEntity T1 ");
        sql.append(" INNER JOIN T_QUERY_DynQuerySolution T2 ON T1.FDynSolutionID = T2.FID ");
        sql.append(" INNER JOIN T_EP_DynQueryScheme T3 ON T2.FID = T3.FDynQueryID ");
        sql.append(" WHERE T3.FDynSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.base.commonquery.app.T_QUERY_DynQueryJoinField");
        sql = new StringBuffer("SELECT T1.* FROM T_QUERY_DynQueryJoinField T1 ");
        sql.append(" INNER JOIN T_QUERY_DynQueryEntity T2 ON T1.FEntityID = T2.FID ");
        sql.append(" INNER JOIN T_QUERY_DynQuerySolution T3 ON T2.FDynSolutionID = T3.FID ");
        sql.append(" INNER JOIN T_EP_DynQueryScheme T4 ON T3.FID = T4.FDynQueryID ");
        sql.append(" WHERE T4.FDynSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.base.commonquery.app.T_QUERY_DynQuerySelectField");
        sql = new StringBuffer("SELECT T1.* FROM T_QUERY_DynQuerySelectField T1 ");
        sql.append(" INNER JOIN T_QUERY_DynQueryEntity T2 ON T1.FEntityID = T2.FID ");
        sql.append(" INNER JOIN T_QUERY_DynQuerySolution T3 ON T2.FDynSolutionID = T3.FID ");
        sql.append(" INNER JOIN T_EP_DynQueryScheme T4 ON T3.FID = T4.FDynQueryID ");
        sql.append(" WHERE T4.FDynSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        if (exportLock) {
            tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_Lock");
            sql = null;
            sql = new StringBuffer("SELECT * FROM T_EP_Lock ");
            sql.append(" WHERE FSchemeID = '");
            sql.append(schemeId).append("'");
            sql.append(" and FUnitID is null");
            EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        }
        outStream.close();
        byte[] bb = stream.toByteArray();
        stream.close();
        return bb;
    }

    public static byte[] exportScheme(Context ctx, String schemeId) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Manifest manifest = EPUtils.makeSchemeManifest(ctx, schemeId, 1);
        JarOutputStream outStream = new JarOutputStream((OutputStream)stream, manifest);
        MetaDataPK tablePk = MetaDataPK.create((String)"com.kingdee.bos.config.app.T_CON_DynamicMetadata");
        StringBuffer sql = null;
        sql = new StringBuffer("SELECT * FROM T_CON_DynamicMetadata ");
        sql.append(" WHERE FProjectID = '");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.bos.config.app.T_CON_EntityPKMapping");
        sql = new StringBuffer("SELECT * FROM T_CON_EntityPKMapping ");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.bos.config.app.T_CON_FacadePKMapping");
        sql = new StringBuffer("SELECT * FROM T_CON_FacadePKMapping ");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_ExtendPoint");
        sql = new StringBuffer("SELECT * FROM T_EP_ExtendPoint");
        sql.append(" WHERE FSchemeID = '");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_ExtendPointParam");
        sql = new StringBuffer("SELECT * FROM T_EP_ExtendPointParam");
        sql.append(" WHERE FSchemeID = '");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_PlugIn");
        sql = new StringBuffer("SELECT * FROM T_EP_PlugIn ");
        sql.append(" WHERE FSchemeID = '");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_PlugInScript");
        sql = new StringBuffer("SELECT * FROM T_EP_PlugInScript ");
        sql.append(" WHERE FSchemeID = '");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_LibScript");
        sql = new StringBuffer("SELECT * FROM T_EP_LibScript WHERE FSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_LibScriptTREE");
        sql = new StringBuffer("SELECT * FROM T_EP_LibScriptTREE WHERE FSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_CustomizedScheme");
        sql = new StringBuffer("SELECT * FROM T_EP_CustomizedScheme WHERE FID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_CustomizedUnit");
        sql = new StringBuffer("SELECT * FROM T_EP_CustomizedUnit WHERE FCustomizedSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_EditUIConfigure");
        sql = new StringBuffer("SELECT * FROM T_EP_EditUIConfigure WHERE FCustomizedSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_Exception");
        sql = new StringBuffer("SELECT * FROM T_EP_Exception WHERE FProject = '");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_Sql");
        sql = new StringBuffer("SELECT * FROM T_EP_Sql WHERE FCustomizedSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_DynQueryScheme");
        sql = new StringBuffer("SELECT * FROM T_EP_DynQueryScheme WHERE FDynSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.base.commonquery.app.T_QUERY_DynQuerySolution");
        sql = new StringBuffer("SELECT T1.* FROM T_QUERY_DynQuerySolution T1 ");
        sql.append(" INNER JOIN T_EP_DynQueryScheme T2 ON T1.FID = T2.FDynQueryID ");
        sql.append(" WHERE T2.FDynSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.base.commonquery.app.T_QUERY_DynQueryEntity");
        sql = new StringBuffer("SELECT T1.* FROM T_QUERY_DynQueryEntity T1 ");
        sql.append(" INNER JOIN T_QUERY_DynQuerySolution T2 ON T1.FDynSolutionID = T2.FID ");
        sql.append(" INNER JOIN T_EP_DynQueryScheme T3 ON T2.FID = T3.FDynQueryID ");
        sql.append(" WHERE T3.FDynSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.base.commonquery.app.T_QUERY_DynQueryJoinField");
        sql = new StringBuffer("SELECT T1.* FROM T_QUERY_DynQueryJoinField T1 ");
        sql.append(" INNER JOIN T_QUERY_DynQueryEntity T2 ON T1.FEntityID = T2.FID ");
        sql.append(" INNER JOIN T_QUERY_DynQuerySolution T3 ON T2.FDynSolutionID = T3.FID ");
        sql.append(" INNER JOIN T_EP_DynQueryScheme T4 ON T3.FID = T4.FDynQueryID ");
        sql.append(" WHERE T4.FDynSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.base.commonquery.app.T_QUERY_DynQuerySelectField");
        sql = new StringBuffer("SELECT T1.* FROM T_QUERY_DynQuerySelectField T1 ");
        sql.append(" INNER JOIN T_QUERY_DynQueryEntity T2 ON T1.FEntityID = T2.FID ");
        sql.append(" INNER JOIN T_QUERY_DynQuerySolution T3 ON T2.FDynSolutionID = T3.FID ");
        sql.append(" INNER JOIN T_EP_DynQueryScheme T4 ON T3.FID = T4.FDynQueryID ");
        sql.append(" WHERE T4.FDynSchemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_RuleSet");
        sql = new StringBuffer("SELECT * FROM T_EP_RuleSet WHERE fschemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_Rule");
        sql = new StringBuffer("SELECT * FROM T_EP_Rule WHERE fschemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_TriggerTime");
        sql = new StringBuffer("SELECT * FROM T_EP_TriggerTime WHERE fschemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_Action");
        sql = new StringBuffer("SELECT * FROM T_EP_Action WHERE fschemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_RuleParameter");
        sql = new StringBuffer("SELECT * FROM T_EP_RuleParameter WHERE fschemeID ='");
        sql.append(schemeId).append("'");
        EPUtils.exportTableDataToJar(ctx, outStream, (IMetaDataPK)tablePk, sql.toString());
        outStream.close();
        byte[] bb = stream.toByteArray();
        stream.close();
        return bb;
    }

    private static void update2DefaultSetting(Context ctx, HashMap jarContents) throws Exception {
        String schemeId = (String)jarContents.get("SCHEME_ID");
        EPUtils.clearDebugInfo(ctx, schemeId);
        EPUtils.disableScheme(ctx, schemeId);
    }

    private static void disableScheme(Context ctx, String schemeId) throws Exception {
        if (!StringUtils.isEmpty((String)schemeId)) {
            String sql = "update T_EP_CustomizedScheme set FStart = 0 where FID = '" + schemeId + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    private static void clearDebugInfo(Context ctx, String schemeId) throws Exception {
        if (!StringUtils.isEmpty((String)schemeId)) {
            String sql = "update T_EP_PlugInScript set FDebug = 0 where FSchemeID = '" + schemeId + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    public static void importScheme(Context ctx, byte[] bb) throws Exception {
        HashMap jarContents = EPUtils.getJarContents(bb);
        MetaDataPK tablePk = MetaDataPK.create((String)"com.kingdee.bos.config.app.T_CON_DynamicMetadata");
        ArrayList<String> primaryKeyColumns = new ArrayList<String>();
        primaryKeyColumns.add("FProjectID");
        EPUtils.importTableDataToDB(ctx, (IMetaDataPK)tablePk, jarContents, primaryKeyColumns);
        tablePk = MetaDataPK.create((String)"com.kingdee.bos.config.app.T_CON_EntityPKMapping");
        primaryKeyColumns = new ArrayList();
        primaryKeyColumns.add("FMETADATAPK");
        primaryKeyColumns.add("FBOSTYPE");
        EPUtils.importTableDataToDB2(ctx, (IMetaDataPK)tablePk, jarContents, primaryKeyColumns);
        tablePk = MetaDataPK.create((String)"com.kingdee.bos.config.app.T_CON_FacadePKMapping");
        primaryKeyColumns = new ArrayList();
        primaryKeyColumns.add("FMETADATAPK");
        primaryKeyColumns.add("FBOSTYPE");
        EPUtils.importTableDataToDB2(ctx, (IMetaDataPK)tablePk, jarContents, primaryKeyColumns);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_ExtendPoint");
        primaryKeyColumns = new ArrayList();
        primaryKeyColumns.add("FSchemeID");
        EPUtils.importTableDataToDB(ctx, (IMetaDataPK)tablePk, jarContents, primaryKeyColumns);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_ExtendPointParam");
        primaryKeyColumns = new ArrayList();
        primaryKeyColumns.add("FSchemeID");
        EPUtils.importTableDataToDB(ctx, (IMetaDataPK)tablePk, jarContents, primaryKeyColumns);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_PlugIn");
        primaryKeyColumns = new ArrayList();
        primaryKeyColumns.add("FSchemeID");
        EPUtils.importTableDataToDB(ctx, (IMetaDataPK)tablePk, jarContents, primaryKeyColumns);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_PlugInScript");
        primaryKeyColumns = new ArrayList();
        primaryKeyColumns.add("FSchemeID");
        EPUtils.importTableDataToDB(ctx, (IMetaDataPK)tablePk, jarContents, primaryKeyColumns);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_LibScript");
        primaryKeyColumns = new ArrayList();
        primaryKeyColumns.add("FSchemeID");
        EPUtils.importTableDataToDB(ctx, (IMetaDataPK)tablePk, jarContents, primaryKeyColumns);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.T_EP_LibScriptTREE");
        primaryKeyColumns = new ArrayList();
        primaryKeyColumns.add("FSchemeID");
        EPUtils.importTableDataToDB(ctx, (IMetaDataPK)tablePk, jarContents, primaryKeyColumns);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_CustomizedScheme");
        primaryKeyColumns = new ArrayList();
        primaryKeyColumns.add("FID");
        EPUtils.importTableDataToDB(ctx, (IMetaDataPK)tablePk, jarContents, primaryKeyColumns);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_CustomizedUnit");
        primaryKeyColumns = new ArrayList();
        primaryKeyColumns.add("FCustomizedSchemeID");
        EPUtils.importTableDataToDB(ctx, (IMetaDataPK)tablePk, jarContents, primaryKeyColumns);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_EditUIConfigure");
        primaryKeyColumns = new ArrayList();
        primaryKeyColumns.add("FCustomizedSchemeID");
        EPUtils.importTableDataToDB(ctx, (IMetaDataPK)tablePk, jarContents, primaryKeyColumns);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_Exception");
        primaryKeyColumns = new ArrayList();
        primaryKeyColumns.add("FProject");
        EPUtils.importTableDataToDB(ctx, (IMetaDataPK)tablePk, jarContents, primaryKeyColumns);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_Sql");
        primaryKeyColumns = new ArrayList();
        primaryKeyColumns.add("FCustomizedSchemeID");
        EPUtils.importTableDataToDB(ctx, (IMetaDataPK)tablePk, jarContents, primaryKeyColumns);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_DynQueryScheme");
        primaryKeyColumns = new ArrayList();
        primaryKeyColumns.add("FDynSchemeID");
        EPUtils.importTableDataToDB(ctx, (IMetaDataPK)tablePk, jarContents, primaryKeyColumns);
        String schemeId = (String)jarContents.get("SCHEME_ID");
        StringBuffer sql = new StringBuffer("DELETE FROM T_QUERY_DynQuerySelectField ");
        sql.append(" WHERE FEntityID IN (SELECT T1.FID FROM T_QUERY_DynQueryEntity T1 ");
        sql.append(" INNER JOIN T_QUERY_DynQuerySolution T2 ON T1.FDynSolutionID = T2.FID ");
        sql.append(" INNER JOIN T_EP_DynQueryScheme T3 ON T2.FID = T3.FDynQueryID ");
        sql.append(" WHERE T3.FDynSchemeID='").append(schemeId).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer("DELETE FROM T_QUERY_DynQueryJoinField ");
        sql.append(" WHERE FEntityID IN (SELECT T1.FID FROM T_QUERY_DynQueryEntity T1 ");
        sql.append(" INNER JOIN T_QUERY_DynQuerySolution T2 ON T1.FDynSolutionID = T2.FID ");
        sql.append(" INNER JOIN T_EP_DynQueryScheme T3 ON T2.FID = T3.FDynQueryID ");
        sql.append(" WHERE T3.FDynSchemeID='").append(schemeId).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer("DELETE FROM T_QUERY_DynQueryEntity ");
        sql.append(" WHERE FDynSolutionID IN (SELECT T1.FID FROM T_QUERY_DynQuerySolution T1 ");
        sql.append(" INNER JOIN T_EP_DynQueryScheme T2 ON T1.FID = T2.FDynQueryID ");
        sql.append(" WHERE T2.FDynSchemeID='").append(schemeId).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer("DELETE FROM T_QUERY_DynQuerySolution ");
        sql.append(" WHERE FID IN (SELECT FDynQueryID FROM T_EP_DynQueryScheme ");
        sql.append(" WHERE FDynSchemeID='").append(schemeId).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.base.commonquery.app.T_QUERY_DynQuerySolution");
        EPUtils.importTableDataToDB(ctx, (IMetaDataPK)tablePk, jarContents, null);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.base.commonquery.app.T_QUERY_DynQueryEntity");
        EPUtils.importTableDataToDB(ctx, (IMetaDataPK)tablePk, jarContents, null);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.base.commonquery.app.T_QUERY_DynQueryJoinField");
        EPUtils.importTableDataToDB(ctx, (IMetaDataPK)tablePk, jarContents, null);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.base.commonquery.app.T_QUERY_DynQuerySelectField");
        EPUtils.importTableDataToDB(ctx, (IMetaDataPK)tablePk, jarContents, null);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_RuleParameter");
        primaryKeyColumns = new ArrayList();
        primaryKeyColumns.add("fschemeID");
        EPUtils.importTableDataToDB(ctx, (IMetaDataPK)tablePk, jarContents, primaryKeyColumns);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_Rule");
        primaryKeyColumns = new ArrayList();
        primaryKeyColumns.add("fschemeID");
        EPUtils.importTableDataToDB(ctx, (IMetaDataPK)tablePk, jarContents, primaryKeyColumns);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_RuleSet");
        primaryKeyColumns = new ArrayList();
        primaryKeyColumns.add("fschemeID");
        EPUtils.importTableDataToDB(ctx, (IMetaDataPK)tablePk, jarContents, primaryKeyColumns);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_TriggerTime");
        primaryKeyColumns = new ArrayList();
        primaryKeyColumns.add("fschemeID");
        EPUtils.importTableDataToDB(ctx, (IMetaDataPK)tablePk, jarContents, primaryKeyColumns);
        tablePk = MetaDataPK.create((String)"com.kingdee.eas.ep.app.T_EP_Action");
        primaryKeyColumns = new ArrayList();
        primaryKeyColumns.add("fschemeID");
        EPUtils.importTableDataToDB(ctx, (IMetaDataPK)tablePk, jarContents, primaryKeyColumns);
        EPUtils.update2DefaultSetting(ctx, jarContents);
    }

    private static void importTableDataToDB(Context ctx, IMetaDataPK tablePk, HashMap jarContents, ArrayList primaryKeyColumns) throws Exception {
        int i;
        String tableName = tablePk.getName();
        byte[] bb = (byte[])jarContents.get(tableName + "/" + tableName + ".xml");
        if (bb == null) {
            return;
        }
        SAXBuilder builder = new SAXBuilder();
        String tableDataXml = new String(bb, "UTF-8");
        Document doc = builder.build((Reader)new StringReader(tableDataXml));
        Element rootElement = doc.getRootElement();
        if (rootElement.getChildren().size() == 0) {
            return;
        }
        Connection conn = EJBFactory.getConnection((Context)ctx);
        String schemeId = (String)jarContents.get("SCHEME_ID");
        StringBuffer sql = null;
        if (primaryKeyColumns != null && primaryKeyColumns.size() > 0) {
            sql = new StringBuffer("DELETE FROM ");
            sql.append(tableName);
            sql.append(" WHERE ");
            sql.append(primaryKeyColumns.get(0));
            sql.append(" = ?");
            PreparedStatement deletePs = conn.prepareStatement(sql.toString());
            deletePs.setString(1, schemeId);
            deletePs.execute();
            SQLUtils.cleanup((Statement)deletePs);
        }
        HashMap columnTypeMap = EPUtils.getColumnTypes(ctx, tablePk);
        Element rowElement = (Element)rootElement.getChildren().get(0);
        Element columnElement = null;
        ArrayList<String> columnNameList = new ArrayList<String>(rowElement.getChildren().size());
        int length = rowElement.getChildren().size();
        for (int t = 0; t < length; ++t) {
            columnElement = (Element)rowElement.getChildren().get(t);
            if (!CUSTOMIZEDSCHEME.equalsIgnoreCase(tableName)) {
                columnNameList.add(columnElement.getName());
                continue;
            }
            if (!CUSTOMIZEDSCHEME.equalsIgnoreCase(tableName) || !columnTypeMap.containsKey(columnElement.getName().toUpperCase())) continue;
            columnNameList.add(columnElement.getName());
        }
        PreparedStatement insertPs = null;
        sql = new StringBuffer("INSERT INTO ");
        sql.append(tableName);
        sql.append(" (");
        int size = columnNameList.size();
        for (i = 0; i < size; ++i) {
            sql.append(columnNameList.get(i));
            if (i == size - 1) {
                sql.append(") ");
                continue;
            }
            sql.append(",");
        }
        sql.append(" VALUES (");
        size = columnNameList.size();
        for (i = 0; i < size; ++i) {
            sql.append("?");
            if (i == size - 1) {
                sql.append(") ");
                continue;
            }
            sql.append(",");
        }
        insertPs = conn.prepareStatement(sql.toString());
        HashMap<String, String> dataMap = null;
        boolean existInsert = false;
        int size2 = rootElement.getChildren().size();
        for (int i2 = 0; i2 < size2; ++i2) {
            int t;
            rowElement = (Element)rootElement.getChildren().get(i2);
            dataMap = new HashMap<String, String>();
            int length2 = rowElement.getChildren().size();
            for (t = 0; t < length2; ++t) {
                columnElement = (Element)rowElement.getChildren().get(t);
                if (StringUtils.isEmpty((String)columnElement.getText())) {
                    dataMap.put(columnElement.getName(), null);
                    continue;
                }
                dataMap.put(columnElement.getName(), columnElement.getText());
            }
            length2 = columnNameList.size();
            for (t = 0; t < length2; ++t) {
                SQLType sqlType = (SQLType)columnTypeMap.get(columnNameList.get(t));
                if (sqlType == SQLType.BLOB) {
                    bb = (byte[])jarContents.get(dataMap.get(columnNameList.get(t)));
                    if (bb != null) {
                        insertPs.setBinaryStream(t + 1, (InputStream)new BufferedInputStream(new ByteArrayInputStream(bb)), bb.length);
                        continue;
                    }
                    insertPs.setNull(t + 1, 2004);
                    continue;
                }
                if (sqlType == SQLType.CLOB || sqlType == SQLType.NCLOB) {
                    bb = (byte[])jarContents.get(dataMap.get(columnNameList.get(t)));
                    if (bb != null) {
                        insertPs.setString(t + 1, new String(bb, "UTF-8"));
                        continue;
                    }
                    insertPs.setNull(t + 1, 12);
                    continue;
                }
                if (sqlType == SQLType.DATETIME) {
                    insertPs.setNull(t + 1, 91);
                    continue;
                }
                if (sqlType == SQLType.INT) {
                    if (dataMap.get(columnNameList.get(t)) == null) {
                        insertPs.setNull(t + 1, 2);
                        continue;
                    }
                    insertPs.setObject(t + 1, dataMap.get(columnNameList.get(t)));
                    continue;
                }
                if (dataMap.get(columnNameList.get(t)) == null) {
                    insertPs.setNull(t + 1, 12);
                    continue;
                }
                insertPs.setObject(t + 1, dataMap.get(columnNameList.get(t)));
            }
            insertPs.addBatch();
            existInsert = true;
        }
        if (existInsert) {
            insertPs.executeBatch();
        }
        SQLUtils.cleanup((Statement)insertPs);
    }

    private static HashMap getColumnTypes(Context ctx, IMetaDataPK tablePk) throws Exception {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        DataTableInfo tableInfo = (DataTableInfo)loader.get(MetaDataTypeList.DATATABLE, tablePk);
        HashMap<String, SQLType> columnTypesMap = new HashMap<String, SQLType>();
        int length = tableInfo.getColumns().size();
        for (int i = 0; i < length; ++i) {
            columnTypesMap.put(tableInfo.getColumns().get(i).getName().toUpperCase(), tableInfo.getColumns().get(i).getTypeName());
        }
        return columnTypesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap getJarContents(byte[] bb) throws Exception {
        File jarFile = File.createTempFile(Uuid.create().toString(), ".jar");
        try (FilterOutputStream bos = null;){
            bos = new BufferedOutputStream(new FileOutputStream(jarFile));
            bos.write(bb);
            ((BufferedOutputStream)bos).flush();
        }
        HashMap<String, Object> jarContents = new HashMap<String, Object>();
        JarFile jf = new JarFile(jarFile);
        Manifest manifest = jf.getManifest();
        String schemeId = manifest.getMainAttributes().getValue("ID");
        jarContents.put("SCHEME_ID", schemeId);
        Enumeration<JarEntry> e = jf.entries();
        JarEntry je = null;
        InputStream is = null;
        long size = 0L;
        byte[] data = null;
        while (e.hasMoreElements()) {
            je = e.nextElement();
            logger.info((Object)je.getName());
            is = jf.getInputStream(je);
            size = je.getSize();
            data = new byte[(int)size];
            int rb = 0;
            int chunk = 0;
            while ((int)size - rb > 0 && (chunk = is.read(data, rb, (int)size - rb)) != -1) {
                rb += chunk;
            }
            jarContents.put(je.getName(), data);
            is.close();
        }
        try {
            if (jf != null) {
                jf.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (jf != null) {
                jf.close();
            }
        }
        jarFile.delete();
        return jarContents;
    }

    private static String exportSQLTableDataToJar(Context ctx, JarOutputStream outStream, IMetaDataPK tablePk, String sql, String relativepath) throws Exception {
        ISQLExecutor iSQL = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
        IRowSet rows = iSQL.executeSQL();
        StringBuffer content = new StringBuffer();
        ArrayList<DBUpdateInfoSet> sqls = new ArrayList<DBUpdateInfoSet>();
        while (rows.next()) {
            try {
                DBUpdateInfoSet sqlSet = DBUpdateInfoSet.toDBUpdateInfoSet((String)rows.getString("FSql"));
                sqls.add(sqlSet);
            }
            catch (Exception e) {
                throw new BOSException("\u89e3\u6790\u5347\u7ea7\u811a\u672c[" + rows.getString("FSql") + "]\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
        for (DBUpdateInfoSet sqlSet : sqls) {
            List sqlObjs = sqlSet.getDBUpdateInfoSet();
            for (DBUpdateInfo sqlObj : sqlObjs) {
                if (sqlObj.getSql().isNull()) continue;
                content.append(sqlObj.getSql().getValue() + ";\n");
            }
        }
        String path = tablePk.getName() + "/" + tablePk.getName() + "_data.sql";
        path = path.toLowerCase();
        JarEntry jarAdd = new JarEntry(path);
        jarAdd.setTime(new Date().getTime());
        outStream.putNextEntry(jarAdd);
        outStream.write(content.toString().getBytes("UTF-8"), 0, content.toString().getBytes("UTF-8").length);
        return path;
    }

    private static void exportSql2Jar(Context ctx, JarOutputStream outStream, IMetaDataPK tablePk, String sql, String relativepath, List paths) throws Exception {
        EPUtils.exportSql2Jar(ctx, outStream, tablePk, sql, relativepath, paths, false);
    }

    private static void exportSql2Jar(Context ctx, JarOutputStream outStream, IMetaDataPK tablePk, String sql, String relativepath, List paths, boolean exist) throws Exception {
        HashMap columnMap = EPUtils.getColumnTypes(ctx, tablePk);
        ISQLExecutor iSQL = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
        IRowSet rows = iSQL.executeSQL();
        ResultSetMetaData meta = rows.getMetaData();
        ArrayList<String> columnNames = new ArrayList<String>(meta.getColumnCount());
        StringBuffer headSql = new StringBuffer("INSERT INTO ").append(tablePk.getName());
        String columnName = null;
        int size = meta.getColumnCount();
        for (int i = 1; i <= size; ++i) {
            columnName = meta.getColumnName(i).toUpperCase();
            columnNames.add(columnName);
            if (i == 1) {
                headSql.append(" ( ").append(columnName);
                continue;
            }
            if (i == size) {
                headSql.append(",").append(columnName).append(" ) VALUES ( ");
                continue;
            }
            headSql.append(",").append(columnName);
        }
        Document doc = new Document();
        Element rootElement = new Element("doc");
        Element sqlElement = null;
        Element itemElement = null;
        doc.setRootElement(rootElement);
        StringBuffer datasql = new StringBuffer();
        int index = 0;
        ArrayList<String> binaryDataList = null;
        StringBuffer insertSql = null;
        while (rows.next()) {
            ++index;
            binaryDataList = null;
            insertSql = new StringBuffer();
            if (columnNames.contains("FID") && exist) {
                String id = rows.getString("FID");
                String existsql = "If not exists (select * from " + tablePk.getName() + " where fid ='" + id + "')";
                insertSql.append(existsql);
            }
            insertSql.append(headSql.toString());
            int size2 = columnNames.size();
            for (int i = 0; i < size2; ++i) {
                String nameInMetadata;
                if (i > 0 && i < size2) {
                    insertSql.append(",");
                }
                if ((nameInMetadata = (columnName = columnNames.get(i).toString())).endsWith("_L1") || nameInMetadata.endsWith("_L2") || nameInMetadata.endsWith("_L3")) {
                    nameInMetadata = nameInMetadata.substring(0, nameInMetadata.length() - 3);
                }
                SQLType sqlType = (SQLType)columnMap.get(nameInMetadata);
                Object obj = rows.getObject(columnName);
                if (obj != null) {
                    if (sqlType == SQLType.BLOB || sqlType == SQLType.CLOB || sqlType == SQLType.NCLOB) {
                        insertSql.append("?");
                    } else if (sqlType == SQLType.INT) {
                        if (tablePk.getName().equalsIgnoreCase(CUSTOMIZEDSCHEME) && columnName.equalsIgnoreCase("FStart")) {
                            insertSql.append("1");
                        } else {
                            insertSql.append(obj.toString());
                        }
                    } else if (sqlType == SQLType.NVARCHAR) {
                        insertSql.append("N'").append(obj.toString()).append("'");
                    } else if (sqlType == SQLType.DATETIME) {
                        insertSql.append("null");
                    } else {
                        insertSql.append("'").append(obj.toString()).append("'");
                    }
                } else {
                    insertSql.append("null");
                }
                if (obj == null || sqlType != SQLType.BLOB && sqlType != SQLType.CLOB && sqlType != SQLType.NCLOB) continue;
                String dataName = "";
                if ("com.kingdee.bos.config.app.T_CON_DynamicMetadata".equalsIgnoreCase(tablePk.getFullName()) && "fsegment".equalsIgnoreCase(columnName)) {
                    String pk;
                    dataName = pk = rows.getString("FMetaDataPK");
                } else if (columnNames.contains("FID")) {
                    String id = rows.getString("FID");
                    dataName = columnName + "_" + EPUtils.translateID(id);
                } else {
                    dataName = columnName + "_" + i;
                }
                String fileName = tablePk.getName() + "/data/" + dataName + ".dat";
                fileName = fileName.toLowerCase();
                JarEntry jarAdd = new JarEntry(fileName);
                jarAdd.setTime(new Date().getTime());
                outStream.putNextEntry(jarAdd);
                if (binaryDataList == null) {
                    binaryDataList = new ArrayList<String>();
                }
                if (sqlType == SQLType.BLOB) {
                    InputStream is = rows.getBlob(columnName).getBinaryStream();
                    byte[] buffer = new byte[2048];
                    int length = -1;
                    while ((length = is.read(buffer)) != -1) {
                        outStream.write(buffer, 0, length);
                    }
                    is.close();
                    binaryDataList.add("BLOB" + fileName);
                    continue;
                }
                String content = rows.getString(columnName);
                outStream.write(content.getBytes("UTF-8"));
                binaryDataList.add("CLOB" + fileName);
            }
            if (binaryDataList != null && binaryDataList.size() > 0) {
                insertSql.append(")");
                itemElement = new Element("item");
                sqlElement = new Element("sql").setText(insertSql.toString());
                itemElement.addContent((Content)sqlElement);
                String binaryDataName = null;
                Element paraElement = new Element("para");
                int size3 = binaryDataList.size();
                for (int i = 0; i < size3; ++i) {
                    Element processElement = new Element("FPROCESSXML");
                    processElement.setAttribute("dataInFile", "true");
                    binaryDataName = binaryDataList.get(i).toString();
                    if (binaryDataName.indexOf("CLOB") == 0 || binaryDataName.indexOf("NCLOB") == 0) {
                        processElement.setAttribute("type", "9");
                    } else {
                        processElement.setAttribute("type", "7");
                    }
                    if (!StringUtils.isEmpty((String)relativepath)) {
                        processElement.setText(relativepath + "/" + binaryDataName.substring(4));
                    } else {
                        processElement.setText(binaryDataName.substring(4));
                    }
                    paraElement.addContent((Content)processElement);
                }
                itemElement.addContent((Content)paraElement);
                rootElement.addContent((Content)itemElement);
                continue;
            }
            datasql.append(insertSql);
            datasql.append(");\n");
        }
        if (index > 0) {
            if (rootElement.getChildren() != null && rootElement.getChildren().size() > 0) {
                Format format = Format.getRawFormat();
                format.setEncoding("UTF-8");
                XMLOutputter outp = new XMLOutputter(format);
                String path = tablePk.getName() + "/" + tablePk.getName() + ".xml";
                path = path.toLowerCase();
                JarEntry jarAdd = new JarEntry(path);
                jarAdd.setTime(new Date().getTime());
                outStream.putNextEntry(jarAdd);
                outStream.write(outp.outputString(doc).getBytes("UTF-8"), 0, outp.outputString(doc).getBytes("UTF-8").length);
                paths.add(path);
            }
            if (datasql.length() > 0) {
                String path = tablePk.getName() + "/" + tablePk.getName() + ".sql";
                path = path.toLowerCase();
                JarEntry jarAdd = new JarEntry(path);
                jarAdd.setTime(new Date().getTime());
                outStream.putNextEntry(jarAdd);
                outStream.write(datasql.toString().getBytes("UTF-8"), 0, datasql.toString().getBytes("UTF-8").length);
                paths.add(path);
            }
        }
    }

    private static String translateID(String id) {
        id = id.replace('\\', '$');
        id = id.replace('/', '$');
        id = id.replace(':', '$');
        id = id.replace('*', '$');
        id = id.replace('?', '$');
        id = id.replace('\'', '$');
        id = id.replace('<', '$');
        id = id.replace('>', '$');
        id = id.replace('|', '$');
        return id;
    }

    private static void exportTableDataToJar(Context ctx, JarOutputStream outStream, IMetaDataPK tablePk, String sql) throws Exception {
        HashMap columnMap = EPUtils.getColumnTypes(ctx, tablePk);
        ISQLExecutor iSQL = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
        IRowSet rows = iSQL.executeSQL();
        ResultSetMetaData meta = rows.getMetaData();
        ArrayList<String> columnNames = new ArrayList<String>(meta.getColumnCount());
        int size = meta.getColumnCount();
        for (int i = 1; i <= size; ++i) {
            columnNames.add(meta.getColumnName(i).toUpperCase());
        }
        Document doc = new Document();
        Element rootElement = new Element("rows");
        doc.setRootElement(rootElement);
        int index = 0;
        String columnName = null;
        while (rows.next()) {
            ++index;
            Element rowElement = new Element("row");
            int size2 = columnNames.size();
            for (int i = 0; i < size2; ++i) {
                JarEntry jarAdd;
                columnName = columnNames.get(i).toString();
                SQLType sqlType = (SQLType)columnMap.get(columnName);
                Object obj = rows.getObject(columnName);
                Element dataElement = null;
                dataElement = obj != null ? (sqlType == SQLType.BLOB || sqlType == SQLType.CLOB || sqlType == SQLType.NCLOB ? new Element(columnName).setText(tablePk.getName() + "/" + columnName + index + ".dat") : (tablePk.getName().equalsIgnoreCase(CUSTOMIZEDSCHEME) && columnName.equalsIgnoreCase("FStart") ? new Element(columnName).setText("0") : new Element(columnName).setText(obj.toString()))) : new Element(columnName).setText(null);
                rowElement.addContent((Content)dataElement);
                if (obj == null) continue;
                if (sqlType == SQLType.BLOB) {
                    InputStream is;
                    jarAdd = new JarEntry(tablePk.getName() + "/" + columnName + index + ".dat");
                    jarAdd.setTime(new Date().getTime());
                    outStream.putNextEntry(jarAdd);
                    try {
                        is = rows.getBlob(columnName).getBinaryStream();
                    }
                    catch (SQLException e) {
                        is = rows.getBinaryStream(columnName);
                    }
                    byte[] buffer = new byte[2048];
                    int length = -1;
                    while ((length = is.read(buffer)) != -1) {
                        outStream.write(buffer, 0, length);
                    }
                    is.close();
                    continue;
                }
                if (sqlType != SQLType.CLOB && sqlType != SQLType.NCLOB) continue;
                jarAdd = new JarEntry(tablePk.getName() + "/" + columnName + index + ".dat");
                jarAdd.setTime(new Date().getTime());
                outStream.putNextEntry(jarAdd);
                String content = rows.getString(columnName);
                outStream.write(content.getBytes("UTF-8"));
            }
            rootElement.addContent((Content)rowElement);
        }
        Format format = Format.getRawFormat();
        format.setEncoding("UTF-8");
        XMLOutputter outp = new XMLOutputter(format);
        JarEntry jarAdd = new JarEntry(tablePk.getName() + "/" + tablePk.getName() + ".xml");
        jarAdd.setTime(new Date().getTime());
        outStream.putNextEntry(jarAdd);
        outStream.write(outp.outputString(doc).getBytes("UTF-8"), 0, outp.outputString(doc).getBytes("UTF-8").length);
    }

    private static void importTableDataToDB2(Context ctx, IMetaDataPK tablePk, HashMap jarContents, ArrayList primaryKeyColumns) throws Exception {
        int i;
        SAXBuilder builder = new SAXBuilder();
        byte[] bb = (byte[])jarContents.get(tablePk.getName() + "/" + tablePk.getName() + ".xml");
        String tableDataXml = new String(bb, "UTF-8");
        Document doc = builder.build((Reader)new StringReader(tableDataXml));
        Element rootElement = doc.getRootElement();
        if (rootElement.getChildren().size() == 0) {
            return;
        }
        Connection conn = EJBFactory.getConnection((Context)ctx);
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer("SELECT ");
        int size = primaryKeyColumns.size();
        for (int i2 = 0; i2 < size; ++i2) {
            sql.append(primaryKeyColumns.get(i2));
            if (i2 >= size - 1) continue;
            sql.append(",");
        }
        sql.append(" FROM ");
        sql.append(tablePk.getName());
        ps = conn.prepareStatement(sql.toString());
        ResultSet rs = ps.executeQuery();
        ArrayList<String> frimaryKeyList = new ArrayList<String>();
        String value = null;
        while (rs.next()) {
            value = "";
            int size2 = primaryKeyColumns.size();
            for (int i3 = 0; i3 < size2; ++i3) {
                value = value + rs.getString(i3 + 1);
            }
            frimaryKeyList.add(value);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        Element rowElement = (Element)rootElement.getChildren().get(0);
        Element columnElement = null;
        ArrayList<String> columnNameList = new ArrayList<String>(rowElement.getChildren().size());
        int length = rowElement.getChildren().size();
        for (int t = 0; t < length; ++t) {
            columnElement = (Element)rowElement.getChildren().get(t);
            columnNameList.add(columnElement.getName());
        }
        PreparedStatement insertPs = null;
        PreparedStatement updatePs = null;
        sql = new StringBuffer("INSERT INTO ");
        sql.append(tablePk.getName());
        sql.append(" (");
        int size3 = columnNameList.size();
        for (i = 0; i < size3; ++i) {
            sql.append(columnNameList.get(i));
            if (i == size3 - 1) {
                sql.append(") ");
                continue;
            }
            sql.append(",");
        }
        sql.append(" VALUES (");
        size3 = columnNameList.size();
        for (i = 0; i < size3; ++i) {
            sql.append("?");
            if (i == size3 - 1) {
                sql.append(") ");
                continue;
            }
            sql.append(",");
        }
        insertPs = conn.prepareStatement(sql.toString());
        sql = new StringBuffer("UPDATE ");
        sql.append(tablePk.getName());
        sql.append(" SET ");
        size3 = columnNameList.size();
        for (i = 0; i < size3; ++i) {
            sql.append(columnNameList.get(i));
            sql.append(" = ? ");
            if (i >= size3 - 1) continue;
            sql.append(",");
        }
        sql.append(" WHERE ");
        size3 = primaryKeyColumns.size();
        for (i = 0; i < size3; ++i) {
            sql.append(primaryKeyColumns.get(i));
            sql.append(" = ? ");
            if (i >= size3 - 1) continue;
            sql.append(" AND ");
        }
        updatePs = conn.prepareStatement(sql.toString());
        HashMap columnTypeMap = EPUtils.getColumnTypes(ctx, tablePk);
        HashMap<String, String> dataMap = null;
        String keyField = null;
        boolean existUpdate = false;
        boolean existInsert = false;
        int size4 = rootElement.getChildren().size();
        for (int i4 = 0; i4 < size4; ++i4) {
            int t;
            rowElement = (Element)rootElement.getChildren().get(i4);
            dataMap = new HashMap<String, String>();
            int length2 = rowElement.getChildren().size();
            for (t = 0; t < length2; ++t) {
                columnElement = (Element)rowElement.getChildren().get(t);
                if (StringUtils.isEmpty((String)columnElement.getText())) {
                    dataMap.put(columnElement.getName(), null);
                    continue;
                }
                dataMap.put(columnElement.getName(), columnElement.getText());
            }
            keyField = "";
            length2 = primaryKeyColumns.size();
            for (int d = 0; d < length2; ++d) {
                keyField = keyField + dataMap.get(primaryKeyColumns.get(d));
            }
            if (frimaryKeyList.contains(keyField)) continue;
            length2 = columnNameList.size();
            for (t = 0; t < length2; ++t) {
                SQLType sqlType = (SQLType)columnTypeMap.get(columnNameList.get(t));
                if (sqlType == SQLType.BLOB) {
                    bb = (byte[])jarContents.get(dataMap.get(columnNameList.get(t)));
                    if (bb != null) {
                        insertPs.setBinaryStream(t + 1, (InputStream)new BufferedInputStream(new ByteArrayInputStream(bb)), bb.length);
                        continue;
                    }
                    insertPs.setNull(t + 1, 2004);
                    continue;
                }
                if (sqlType == SQLType.CLOB || sqlType == SQLType.NCLOB) {
                    bb = (byte[])jarContents.get(dataMap.get(columnNameList.get(t)));
                    if (bb != null) {
                        insertPs.setString(t + 1, new String(bb, "UTF-8"));
                        continue;
                    }
                    insertPs.setNull(t + 1, 12);
                    continue;
                }
                if (dataMap.get(columnNameList.get(t)) == null) {
                    insertPs.setNull(t + 1, 12);
                    continue;
                }
                insertPs.setObject(t + 1, dataMap.get(columnNameList.get(t)));
            }
            insertPs.addBatch();
            existInsert = true;
        }
        if (existInsert) {
            insertPs.executeBatch();
        }
        if (existUpdate) {
            updatePs.executeBatch();
        }
        SQLUtils.cleanup((Statement)updatePs);
        SQLUtils.cleanup((Statement)insertPs);
    }

    public static boolean isJarFile(File file) throws Exception {
        if (!EPUtils.isZipFile(file)) {
            return false;
        }
        ZipFile zip = new ZipFile(file);
        boolean manifest = zip.getEntry("META-INF/MANIFEST.MF") != null;
        zip.close();
        return manifest;
    }

    public static boolean isZipFile(File file) throws Exception {
        if (file.isDirectory()) {
            return false;
        }
        if (!file.canRead()) {
            throw new IOException("\u4e0d\u80fd\u8bfb\u6587\u4ef6  " + file.getAbsolutePath());
        }
        if (file.length() < 4L) {
            return false;
        }
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        int test = in.readInt();
        in.close();
        return test == 1347093252;
    }

    public static boolean checkStringIsChinese(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        String PROPERTY_REGEX = "[a-zA-Z]+[a-zA-Z0-9\\_]*";
        Pattern pattern = Pattern.compile(PROPERTY_REGEX);
        Matcher m = pattern.matcher(str);
        return !m.matches();
    }

    public static boolean isContainChinese(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        String PROPERTY_REGEX = "[\u4e00-\u9fa5]+";
        Pattern pattern = Pattern.compile(PROPERTY_REGEX);
        Matcher m = pattern.matcher(str);
        return m.matches();
    }

    public static void clearCache() throws Exception {
        EPUtils.updateProject();
        ClientCacheManager.clearCache();
    }

    private static void updateProject() throws BOSException {
        ICustomizedScheme ics = CustomizedSchemeFactory.getRemoteInstance();
        CustomizedSchemeCollection col = ics.getCustomizedSchemeCollection();
        IMetadataStore mds = MetadataStoreFactory.getMetadataStore(null);
        ArrayList<Project> ps = new ArrayList<Project>();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            CustomizedSchemeInfo csInfo = col.get(i);
            if (!csInfo.isStart()) continue;
            ps.add(new Project(csInfo.getId().toString()));
        }
        Project[] p = new Project[ps.size()];
        p = ps.toArray(p);
        mds.setProjects(p);
    }

    private static boolean existsInTable(Context ctx, String table, String column) {
        try {
            IUpdateSql instance = UpdateSqlFactory.getLocalInstance(ctx);
            if (instance.exists(table, column)) {
                return true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }
}

