/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.datagrid;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.editor.kdtable.AbstractKDTableDesigner4SimpleConfigUI;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.WebEditorHelper;
import com.kingdee.eas.ep.webclient.model.WebTreeNode;
import com.kingdee.eas.ep.webclient.util.WebUIEditorHelper;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DataGrid4SimpleConfigUI
extends AbstractKDTableDesigner4SimpleConfigUI {
    private static final Logger logger = CoreUIObject.getLogger(DataGrid4SimpleConfigUI.class);
    public static final String DATAGRID_NODE = "datagrid_node";
    protected String EXIT_STATUS = null;
    public static final String CONFIRM_EXIT = "confirm";
    public static final String CANCEL_EXIT = "cancel";
    private WebTreeNode node;
    private ComponentInfo grid;

    public void onLoad() throws Exception {
        super.onLoad();
        this.node = (WebTreeNode)((Object)this.getUIContext().get(DATAGRID_NODE));
        this.grid = (ComponentInfo)this.node.getUserObject();
        this.setBounds(new Rectangle(10, 10, 700, 430));
        this.initTableList();
        this.loadData();
    }

    protected void initTableList() {
        this.tableList.setFormatXml("");
        this.tableList.checkParsed(true);
        this.tableList.removeHeadRows();
        this.tableList.setEditable(false);
        this.tableList.addColumns(3);
        IRow tableHead = this.tableList.addHeadRow();
        ICell tableCell = tableHead.getCell(0);
        tableCell.setValue((Object)"\u540d\u79f0");
        tableCell = tableHead.getCell(1);
        tableCell.setValue((Object)"\u6807\u9898");
        tableCell = tableHead.getCell(2);
        tableCell.setValue((Object)"\u9690\u85cf");
        this.tableList.getColumn(2).getStyleAttributes().setHided(true);
        this.tableList.getColumn(2).getStyleAttributes().setBackground(Color.GRAY);
    }

    public void loadData() {
        this.tableList.removeRows();
        ComponentCollection columns = this.grid.getComponents();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            ComponentInfo columnInfo = columns.get(i);
            String hidden = WebEditorHelper.getPropertyValue(columnInfo, "hidden");
            IRow row = this.tableList.addRow();
            row.setUserObject((Object)columnInfo);
            row.getCell(0).setValue((Object)columnInfo.getName());
            row.getCell(1).setValue((Object)WebEditorHelper.getPropertyValue(columnInfo, "header"));
            row.getCell(2).setValue((Object)("true".equals(hidden) ? Boolean.TRUE : Boolean.FALSE));
        }
    }

    public void refreshOrder() {
        int size = this.tableList.getRowCount();
        ArrayList<String> names = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            ComponentInfo columnInfo = (ComponentInfo)this.tableList.getRow(i).getUserObject();
            names.add(columnInfo.getName());
        }
        WebUIEditorHelper.reOrderDataGrid(this.grid, names);
    }

    @Override
    protected void tableList_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    @Override
    protected void tableList_tableClicked(KDTMouseEvent e) throws Exception {
    }

    @Override
    protected void tableList_editStopped(KDTEditEvent e) throws Exception {
    }

    @Override
    protected void butUP_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.tableList);
        if (rowIndex.length > 0 && rowIndex[0] > 0) {
            this.tableList.moveRow(rowIndex[0], rowIndex[0] - 1);
            KDTableUtil.setSelectedRow((KDTable)this.tableList, (int)(rowIndex[0] - 1));
            this.refreshOrder();
        }
    }

    @Override
    protected void butDown_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.tableList);
        if (rowIndex.length > 0 && rowIndex[0] < this.tableList.getRowCount() - 1) {
            this.tableList.moveRow(rowIndex[0], rowIndex[0] + 1);
            KDTableUtil.setSelectedRow((KDTable)this.tableList, (int)(rowIndex[0] + 1));
            this.refreshOrder();
        }
    }

    @Override
    protected void butTop_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.tableList);
        if (rowIndex.length > 0 && rowIndex[0] > 0) {
            this.tableList.moveRow(rowIndex[0], 0);
            KDTableUtil.setSelectedRow((KDTable)this.tableList, (int)0);
            this.refreshOrder();
        }
    }

    @Override
    protected void butBottom_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.tableList);
        if (rowIndex.length > 0 && rowIndex[0] < this.tableList.getRowCount() - 1) {
            this.tableList.moveRow(rowIndex[0], this.tableList.getRowCount() - 1);
            KDTableUtil.setSelectedRow((KDTable)this.tableList, (int)(this.tableList.getRowCount() - 1));
            this.refreshOrder();
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.EXIT_STATUS = CONFIRM_EXIT;
        this.disposeUIWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.EXIT_STATUS = CANCEL_EXIT;
        this.disposeUIWindow();
    }

    public String getExitStatus() {
        return this.EXIT_STATUS;
    }
}

