/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.datagrid;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.editor.editui.designer.action.ActionRegistry;
import com.kingdee.eas.ep.client.editor.editui.designer.action.BaseAction;
import com.kingdee.eas.ep.client.editor.editui.designer.util.ComponentHelper;
import com.kingdee.eas.ep.client.figure.FigureHelper;
import com.kingdee.eas.ep.webclient.editor.datagrid.AbstractDataGridDesignerUI;
import com.kingdee.eas.ep.webclient.editor.webui.designer.AbstractWebEditPartViewer;
import com.kingdee.eas.ep.webclient.editor.webui.designer.action.WebDeleteColumnAction;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.WebComponentHelper;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.WebEditorHelper;
import com.kingdee.eas.ep.webclient.model.WebTreeNode;
import com.kingdee.eas.ep.webclient.util.WebUIEditorHelper;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class DataGridDesignerUI
extends AbstractDataGridDesignerUI {
    private static final Logger logger = CoreUIObject.getLogger(DataGridDesignerUI.class);
    public static final String DATAGRID_NODE = "datagrid_node";
    public static final String VIEWER = "viewer";
    protected String EXIT_STATUS = null;
    public static final String CONFIRM_EXIT = "confirm";
    public static final String CANCEL_EXIT = "cancel";
    private static final String TREE_COLUMN = "column";
    private static final String GRID_NAME = "grid.name";
    private static final String COLUMN_NAME = "column.name";
    private static final String COLUMN_HEADER = "column.header";
    private static final String COLUMN_WIDTH = "column.width";
    private static final String COLUMN_HIDE = "column.hidden";
    private static final String TABLE_PROPERTY = "proColumn";
    private static final String TABLE_VALUE = "valueColumn";
    private static final String COLUMN_MAXLENGTH = "column_maxlength";
    private DefaultKingdeeTreeNode treeRoot = new DefaultKingdeeTreeNode();
    private WebTreeNode node;
    private ComponentInfo grid;
    private AbstractWebEditPartViewer viewer;
    private ActionRegistry actionRegister;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        Object object = this.getUIContext().get(DATAGRID_NODE);
        this.node = (WebTreeNode)((Object)object);
        this.grid = (ComponentInfo)this.node.getUserObject();
        object = this.getUIContext().get(VIEWER);
        this.viewer = (AbstractWebEditPartViewer)object;
        this.tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.treeRoot));
        this.refreshTreeRoot(null);
        this.initMyToolBar();
    }

    public void initMyToolBar() {
        KDWorkButton createCtrl = new KDWorkButton("\u63a7\u4ef6");
        createCtrl.setIcon((Icon)FigureHelper.getImageIcon("type/function.gif"));
        createCtrl.setToolTipText("\u521b\u5efa\u63a7\u4ef6");
        final KDPopupMenu popMenu = new KDPopupMenu();
        this.actionRegister = WebUIEditorHelper.buildColumnMenu(this.viewer, this, popMenu);
        createCtrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataGridDesignerUI.this.showCreateCtrlMenu(popMenu);
            }
        });
        this.toolBar.add((Component)createCtrl);
        WebDeleteColumnAction deleteAction = new WebDeleteColumnAction(this.viewer, this);
        deleteAction.setToolTips("\u5220\u9664");
        this.actionRegister.registerAction(deleteAction);
        JButton btnDelete = this.toolBar.add((Action)deleteAction);
        btnDelete.setText("\u5220\u9664");
        deleteAction.addRelateComponent(btnDelete);
    }

    public void showCreateCtrlMenu(KDPopupMenu popMenu) {
        popMenu.show((Component)((Object)this), 0, 0);
    }

    protected void refreshTreeRoot(Object locateUserObject) {
        this.treeRoot.removeAllChildren();
        this.treeRoot.setText("root");
        this.treeRoot.setUserObject((Object)"root");
        DefaultKingdeeTreeNode tableNode = new DefaultKingdeeTreeNode();
        tableNode.setUserObject((Object)this.grid);
        tableNode.setText("\u8868");
        tableNode.setCustomIcon((Icon)FigureHelper.getImageIcon("designer/KDTablePanel.gif"));
        this.treeRoot.add((MutableTreeNode)tableNode);
        DefaultKingdeeTreeNode columnNode = new DefaultKingdeeTreeNode();
        columnNode.setUserObject((Object)TREE_COLUMN);
        columnNode.setText("\u8868\u5217");
        columnNode.setCustomIcon((Icon)FigureHelper.getImageIcon("designer/Status.gif"));
        this.treeRoot.add((MutableTreeNode)columnNode);
        ComponentCollection columns = this.grid.getComponents();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            ComponentCollection es;
            ComponentInfo column = columns.get(i);
            DefaultKingdeeTreeNode cNode = new DefaultKingdeeTreeNode();
            cNode.setUserObject((Object)column);
            cNode.setText(column.getName());
            cNode.setCustomIcon(ComponentHelper.getComponentIcon(column.getClassType()));
            columnNode.add((MutableTreeNode)cNode);
            if (!"com.kingdee.bos.ctrl.web.EditableColumn".equals(column.getClassType()) || (es = column.getComponents()) == null || es.size() <= 0) continue;
            ComponentInfo editor = es.get(0);
            DefaultKingdeeTreeNode eNode = new DefaultKingdeeTreeNode();
            eNode.setUserObject((Object)editor);
            eNode.setText(editor.getName());
            eNode.setCustomIcon(ComponentHelper.getComponentIcon(editor.getClassType()));
            cNode.add((MutableTreeNode)eNode);
        }
        ((KingdeeTreeModel)this.tree.getModel()).reload();
        this.tree.expandAllNodes(true, (TreeNode)this.treeRoot);
        this.locateCurrentNode(this.treeRoot, locateUserObject);
    }

    public void refreshTreeAndLocateCurrentSelected() {
        Object locateUserObject = null;
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (treeNode != null) {
            locateUserObject = treeNode.getUserObject();
        }
        this.refreshTreeRoot(locateUserObject);
    }

    @Override
    protected void tree_valueChanged(TreeSelectionEvent e) throws Exception {
        DefaultKingdeeTreeNode treeNode;
        if (e.getOldLeadSelectionPath() != null && e.getOldLeadSelectionPath().getLastPathComponent() != null) {
            DefaultKingdeeTreeNode defaultKingdeeTreeNode = (DefaultKingdeeTreeNode)e.getOldLeadSelectionPath().getLastPathComponent();
        }
        this.tableList.removeRows();
        if (e.getNewLeadSelectionPath() != null && e.getNewLeadSelectionPath().getLastPathComponent() != null && (treeNode = (DefaultKingdeeTreeNode)e.getNewLeadSelectionPath().getLastPathComponent()).getUserObject() instanceof ComponentInfo) {
            ComponentInfo cInfo = (ComponentInfo)treeNode.getUserObject();
            if ("com.kingdee.bos.ctrl.web.EditDataGrid".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.web.DataGrid".equals(cInfo.getClassType())) {
                this.loadGridInfo2TableList(cInfo);
            } else if ("com.kingdee.bos.ctrl.web.EditableColumn".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.web.Column".equals(cInfo.getClassType())) {
                this.loadColumnInfo2TableList(cInfo);
            } else {
                this.loadEditorInfo2TableList(cInfo);
            }
        }
        this.updateAction();
    }

    protected void loadGridInfo2TableList(ComponentInfo grid) {
        if (this.tableList.getColumn(COLUMN_MAXLENGTH) != null) {
            this.tableList.removeColumn(this.tableList.getColumnIndex(COLUMN_MAXLENGTH));
        }
        IRow row = this.tableList.addRow();
        row.setUserObject((Object)GRID_NAME);
        row.getCell(TABLE_PROPERTY).setValue((Object)"name");
        row.getCell(TABLE_VALUE).setValue((Object)grid.getName());
        row.getCell(TABLE_VALUE).getStyleAttributes().setLocked(true);
    }

    protected void loadColumnInfo2TableList(ComponentInfo columnInfo) {
        if (this.tableList.getColumn(COLUMN_MAXLENGTH) != null) {
            this.tableList.removeColumn(this.tableList.getColumnIndex(COLUMN_MAXLENGTH));
        }
        IRow row = this.tableList.addRow();
        row.setUserObject((Object)COLUMN_NAME);
        row.getCell(TABLE_PROPERTY).setValue((Object)"name");
        row.getCell(TABLE_VALUE).setValue((Object)columnInfo.getName());
        row.getCell(TABLE_VALUE).getStyleAttributes().setLocked(true);
        row = this.tableList.addRow();
        row.setUserObject((Object)COLUMN_HEADER);
        row.getCell(TABLE_PROPERTY).setValue((Object)"header");
        row.getCell(TABLE_VALUE).setValue((Object)WebEditorHelper.getPropertyValue(columnInfo, "header"));
        Integer width = new Integer(-1);
        try {
            width = new Integer(WebEditorHelper.getPropertyValue(columnInfo, "width"));
        }
        catch (Exception ex) {
            logger.error((Object)"loadColumnInfo2TableList error", (Throwable)ex);
        }
        row = this.tableList.addRow();
        row.setUserObject((Object)COLUMN_WIDTH);
        row.getCell(TABLE_PROPERTY).setValue((Object)"width");
        row.getCell(TABLE_VALUE).setValue((Object)width);
        String hidden = WebEditorHelper.getPropertyValue(columnInfo, "hidden");
        row = this.tableList.addRow();
        row.setUserObject((Object)COLUMN_HIDE);
        row.getCell(TABLE_PROPERTY).setValue((Object)"hidden");
        row.getCell(TABLE_VALUE).setValue((Object)("true".equals(hidden) ? Boolean.TRUE : Boolean.FALSE));
    }

    protected void loadEditorInfo2TableList(ComponentInfo editor) {
        if ("com.kingdee.bos.ctrl.web.TextField".equalsIgnoreCase(editor.getClassType()) || "com.kingdee.bos.ctrl.web.NumberField".equalsIgnoreCase(editor.getClassType())) {
            if (this.tableList.getColumn(COLUMN_MAXLENGTH) == null) {
                IColumn column = this.tableList.addColumn();
                column.setKey(COLUMN_MAXLENGTH);
                this.tableList.getHeadRow(0).getCell(COLUMN_MAXLENGTH).setValue((Object)"\u8f93\u5165\u6700\u5927\u957f\u5ea6");
            }
        } else if (this.tableList.getColumn(COLUMN_MAXLENGTH) != null) {
            this.tableList.removeColumn(this.tableList.getColumnIndex(COLUMN_MAXLENGTH));
        }
        IRow row = this.tableList.addRow();
        row.setUserObject((Object)COLUMN_NAME);
        row.getCell(TABLE_PROPERTY).setValue((Object)"name");
        row.getCell(TABLE_VALUE).setValue((Object)editor.getName());
        row.getCell(TABLE_VALUE).getStyleAttributes().setLocked(true);
        if (row.getCell(COLUMN_MAXLENGTH) != null) {
            row.getCell(COLUMN_MAXLENGTH).setValue(WebComponentHelper.getPropertyValue(editor, "maxLength"));
            row.getCell(COLUMN_MAXLENGTH).getStyleAttributes().setLocked(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean storeColumnInfo2TableList(ComponentInfo columnInfo, Object userObj, Object newValue) {
        if (COLUMN_NAME.equals(userObj)) {
            columnInfo.setName(this.parseString(newValue));
            this.refreshTreeAndLocateCurrentSelected();
            return true;
        } else if (COLUMN_HEADER.equals(userObj)) {
            WebEditorHelper.setPropertyValue(columnInfo, "header", this.parseString(newValue), "java.lang.String", true);
            this.refreshTreeAndLocateCurrentSelected();
            return true;
        } else if (COLUMN_WIDTH.equals(userObj)) {
            if (!this.checkPositiveNumber(newValue)) return false;
            WebEditorHelper.setPropertyValue(columnInfo, "width", String.valueOf(this.parseInt(newValue)), "java.lang.Integer", false);
            return true;
        } else {
            if (!COLUMN_HIDE.equals(userObj)) return true;
            WebEditorHelper.setPropertyValue(columnInfo, "hidden", String.valueOf(this.parseBoolean(newValue)), "java.lang.Boolean", false);
        }
        return true;
    }

    private boolean checkPositiveNumber(Object obj) {
        int i = this.parseInt(obj);
        if (i < -1) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u8f93\u5165\u7684\u6570\u5b57\u4e0d\u5408\u6cd5\uff01");
            return false;
        }
        return true;
    }

    private int parseInt(Object obj) {
        int i = -2;
        try {
            i = Integer.parseInt(obj.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return i;
    }

    private boolean parseBoolean(Object obj) {
        boolean b = false;
        try {
            String s = obj.toString();
            if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equals("1")) {
                b = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return b;
    }

    private String parseString(Object obj) {
        String s = null;
        try {
            s = obj.toString();
            s = s.trim();
        }
        catch (Throwable t) {
            s = null;
        }
        return s;
    }

    public WebTreeNode getNode() {
        return this.node;
    }

    public ComponentInfo getSelectedComponent() {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (treeNode != null) {
            ComponentInfo cInfo;
            if (TREE_COLUMN.equals(treeNode.getUserObject())) {
                return this.grid;
            }
            if (treeNode.getUserObject() instanceof ComponentInfo && ("com.kingdee.bos.ctrl.web.EditableColumn".equals((cInfo = (ComponentInfo)treeNode.getUserObject()).getClassType()) || "com.kingdee.bos.ctrl.web.Column".equals(cInfo.getClassType()))) {
                return cInfo;
            }
        }
        return null;
    }

    protected void updateAction() {
        Iterator iter = this.actionRegister.getActions();
        while (iter.hasNext()) {
            BaseAction action = (BaseAction)iter.next();
            action.updateAction();
        }
    }

    @Override
    protected void butUP_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() != null) {
            ComponentInfo cInfo;
            Object element = treeNode.getUserObject();
            if (element instanceof ComponentInfo && ("com.kingdee.bos.ctrl.web.EditableColumn".equals((cInfo = (ComponentInfo)element).getClassType()) || "com.kingdee.bos.ctrl.web.Column".equals(cInfo.getClassType()))) {
                ComponentInfo parent = cInfo.getParent();
                ComponentCollection cols = parent.getComponents();
                int currentIndex = cols.indexOf((IObjectValue)cInfo);
                if (currentIndex <= 0) {
                    return;
                }
                for (int i = 0; i < cols.size(); ++i) {
                    cols.get(i).setExtendedProperty("order", String.valueOf(i));
                }
                ComponentInfo preInfo = cols.get(currentIndex - 1);
                if (preInfo != null) {
                    preInfo.setExtendedProperty("order", String.valueOf(currentIndex));
                }
                cInfo.setExtendedProperty("order", String.valueOf(currentIndex - 1));
                ComponentHelper.resetOrderConstraint(parent);
            }
            this.refreshTreeAndLocateCurrentSelected();
        }
    }

    @Override
    protected void butDown_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() != null) {
            ComponentInfo cInfo;
            Object element = treeNode.getUserObject();
            if (element instanceof ComponentInfo && ("com.kingdee.bos.ctrl.web.EditableColumn".equals((cInfo = (ComponentInfo)element).getClassType()) || "com.kingdee.bos.ctrl.web.Column".equals(cInfo.getClassType()))) {
                ComponentInfo parent = cInfo.getParent();
                ComponentCollection cols = parent.getComponents();
                int currentIndex = cols.indexOf((IObjectValue)cInfo);
                if (currentIndex >= cols.size() - 1) {
                    return;
                }
                for (int i = 0; i < cols.size(); ++i) {
                    cols.get(i).setExtendedProperty("order", String.valueOf(i));
                }
                ComponentInfo nextInfo = cols.get(currentIndex + 1);
                if (nextInfo != null) {
                    nextInfo.setExtendedProperty("order", String.valueOf(currentIndex));
                }
                cInfo.setExtendedProperty("order", String.valueOf(currentIndex + 1));
                ComponentHelper.resetOrderConstraint(parent);
            }
            this.refreshTreeAndLocateCurrentSelected();
        }
    }

    @Override
    protected void butTop_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() != null) {
            ComponentInfo cInfo;
            Object element = treeNode.getUserObject();
            if (element instanceof ComponentInfo && ("com.kingdee.bos.ctrl.web.EditableColumn".equals((cInfo = (ComponentInfo)element).getClassType()) || "com.kingdee.bos.ctrl.web.Column".equals(cInfo.getClassType()))) {
                int i;
                ComponentInfo parent = cInfo.getParent();
                ComponentCollection cols = parent.getComponents();
                int currentIndex = cols.indexOf((IObjectValue)cInfo);
                if (currentIndex <= 0) {
                    return;
                }
                for (i = 0; i < cols.size(); ++i) {
                    cols.get(i).setExtendedProperty("order", String.valueOf(i));
                }
                for (i = 0; i < currentIndex; ++i) {
                    ComponentInfo preInfo = cols.get(i);
                    if (preInfo == null) continue;
                    preInfo.setExtendedProperty("order", String.valueOf(i + 1));
                }
                cInfo.setExtendedProperty("order", String.valueOf(0));
                ComponentHelper.resetOrderConstraint(parent);
            }
            this.refreshTreeAndLocateCurrentSelected();
        }
    }

    @Override
    protected void butBottom_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() != null) {
            ComponentInfo cInfo;
            Object element = treeNode.getUserObject();
            if (element instanceof ComponentInfo && ("com.kingdee.bos.ctrl.web.EditableColumn".equals((cInfo = (ComponentInfo)element).getClassType()) || "com.kingdee.bos.ctrl.web.Column".equals(cInfo.getClassType()))) {
                int i;
                ComponentInfo parent = cInfo.getParent();
                ComponentCollection cols = parent.getComponents();
                int currentIndex = cols.indexOf((IObjectValue)cInfo);
                if (currentIndex >= cols.size() - 1) {
                    return;
                }
                for (i = 0; i < cols.size(); ++i) {
                    cols.get(i).setExtendedProperty("order", String.valueOf(i));
                }
                for (i = currentIndex + 1; i < cols.size(); ++i) {
                    ComponentInfo preInfo = cols.get(i);
                    if (preInfo == null) continue;
                    preInfo.setExtendedProperty("order", String.valueOf(i - 1));
                }
                cInfo.setExtendedProperty("order", String.valueOf(cols.size() - 1));
                ComponentHelper.resetOrderConstraint(parent);
            }
            this.refreshTreeAndLocateCurrentSelected();
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.EXIT_STATUS = CONFIRM_EXIT;
        this.disposeUIWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.EXIT_STATUS = CANCEL_EXIT;
        this.disposeUIWindow();
    }

    @Override
    protected void tableList_editStopped(KDTEditEvent e) throws Exception {
        ComponentInfo cInfo;
        IRow row = this.tableList.getRow(e.getRowIndex());
        ICell cell = row.getCell(e.getColIndex());
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof ComponentInfo && ("com.kingdee.bos.ctrl.web.EditableColumn".equals((cInfo = (ComponentInfo)treeNode.getUserObject()).getClassType()) || "com.kingdee.bos.ctrl.web.Column".equals(cInfo.getClassType()))) {
            if (!this.storeColumnInfo2TableList(cInfo, row.getUserObject(), newValue)) {
                cell.setValue(oldValue);
            } else {
                this.refreshTreeAndLocateCurrentSelected();
            }
        }
    }

    @Override
    protected void tableList_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    @Override
    protected void tableList_tableClicked(KDTMouseEvent e) throws Exception {
    }

    private boolean locateCurrentNode(DefaultKingdeeTreeNode root, Object userObj) {
        if (this.tree != null && root != null && userObj != null) {
            if (root.getUserObject() == userObj) {
                this.tree.setSelectionNode(root);
                return true;
            }
            Enumeration children = root.children();
            while (children.hasMoreElements()) {
                DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)children.nextElement();
                boolean ret = this.locateCurrentNode(child, userObj);
                if (!ret) continue;
                return true;
            }
        }
        return false;
    }

    public String getExitStatus() {
        return this.EXIT_STATUS;
    }
}

