/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.tabpane;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.client.editor.tabpane.AbstractKDTabPaneConfigUI;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.AbstractBizConfigureItemCollection;
import com.kingdee.eas.ep.client.model.AbstractBizConfigureItemInfo;
import com.kingdee.eas.ep.webclient.editor.webui.designer.AbstractWebEditPartViewer;
import com.kingdee.eas.ep.webclient.editor.webui.designer.NewWebCtrlDialog;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebItemInfoAdapter;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebTabbedPaneEditPart;
import com.kingdee.eas.ep.webclient.model.WebTreeNode;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;

public class WebTabPaneConfigUI
extends AbstractKDTabPaneConfigUI {
    private static final Logger logger = CoreUIObject.getLogger(WebTabPaneConfigUI.class);
    public static final String VIEWER = "viewer";
    public static final String TABPANE_EDITPART = "tabpane_editpart";
    private WebTabbedPaneEditPart tabEditPart;
    private AbstractWebEditPartViewer viewer;

    public void onLoad() throws Exception {
        super.onLoad();
        Object object = this.getUIContext().get(TABPANE_EDITPART);
        if (!(object instanceof WebTabbedPaneEditPart)) {
            throw new IllegalArgumentException("can not get the WebTabbedPaneEditPart from uicontext!");
        }
        this.tabEditPart = (WebTabbedPaneEditPart)object;
        object = this.getUIContext().get(VIEWER);
        if (!(object instanceof AbstractWebEditPartViewer)) {
            throw new IllegalArgumentException("can not get the AbstractWebEditPartViewer from uicontext!");
        }
        this.viewer = (AbstractWebEditPartViewer)object;
        if (this.viewer.getContext().isBase()) {
            this.butUP.setEnabled(false);
            this.butDown.setEnabled(false);
        } else {
            this.butAddNew.setEnabled(false);
            this.butDelete.setEnabled(false);
        }
        this.tableList.checkParsed(true);
        this.loadData();
    }

    public void loadData() {
        this.tableList.removeRows();
        WebTreeNode node = this.tabEditPart.getTabbedPanelNode();
        List col = node.getNodeChildren();
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            WebTreeNode child = (WebTreeNode)((Object)col.get(i));
            if (!(child.getUserObject() instanceof ComponentInfo)) continue;
            ComponentInfo cInfo = (ComponentInfo)child.getUserObject();
            String title = cInfo.getConstraint() instanceof String ? cInfo.getConstraint().toString() : "\u5206\u7ec4";
            IRow row = this.tableList.addRow();
            row.setUserObject((Object)child);
            row.getCell(0).setValue((Object)child.getName());
            row.getCell(1).setValue((Object)title);
        }
    }

    private void resetTabOrder() {
        WebTreeNode node = this.tabEditPart.getTabbedPanelNode();
        int size = this.tableList.getRowCount();
        ArrayList<WebTreeNode> col = new ArrayList<WebTreeNode>(size);
        for (int i = 0; i < size; ++i) {
            col.add((WebTreeNode)((Object)this.tableList.getRow(i).getUserObject()));
        }
        node.resetChildNode(col);
    }

    @Override
    protected void tableList_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    @Override
    protected void tableList_tableClicked(KDTMouseEvent e) throws Exception {
    }

    @Override
    protected void tableList_editStopped(KDTEditEvent e) throws Exception {
    }

    @Override
    protected void butUP_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.tableList);
        if (rowIndex.length > 0 && rowIndex[0] > 0) {
            this.tableList.moveRow(rowIndex[0], rowIndex[0] - 1);
            this.resetTabOrder();
            this.loadData();
            this.tabEditPart.reload();
            KDTableUtil.setSelectedRow((KDTable)this.tableList, (int)(rowIndex[0] - 1));
        }
    }

    @Override
    protected void butDown_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.tableList);
        if (rowIndex.length > 0 && rowIndex[0] < this.tableList.getRowCount() - 1) {
            this.tableList.moveRow(rowIndex[0], rowIndex[0] + 1);
            this.resetTabOrder();
            this.loadData();
            this.tabEditPart.reload();
            KDTableUtil.setSelectedRow((KDTable)this.tableList, (int)(rowIndex[0] + 1));
        }
    }

    @Override
    protected void butAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(NewWebCtrlDialog.class.getName(), (Map)uiContext);
            NewWebCtrlDialog ncUI = (NewWebCtrlDialog)uiWindow.getUIObject();
            ncUI.setWebUIObjectInfo((WebUIObjectInfo)this.viewer.getContext().getUiModel());
            ncUI.setNode(this.tabEditPart.getTabbedPanelNode());
            ncUI.setClassType("com.kingdee.bos.ctrl.web.FreePanel");
            uiWindow.show();
            if ("confirm".equals(ncUI.getExitStatus())) {
                this.tabEditPart.reload();
                this.loadData();
                this.viewer.getContext().setDirty(true);
                this.viewer.getCommandStack().flush();
            }
        }
        catch (UIException ue) {
            ExceptionHandler.handleError(null, (Exception)((Object)ue), "\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
        }
    }

    @Override
    protected void butDelete_actionPerformed(ActionEvent e) throws Exception {
        WebTreeNode selectNode;
        ComponentInfo cInfo;
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tableList);
        if (row != null && row.getUserObject() != null && row.getUserObject() instanceof WebTreeNode && (cInfo = (ComponentInfo)(selectNode = (WebTreeNode)((Object)row.getUserObject())).getUserObject()) != null) {
            if (cInfo.isConfigured()) {
                WebItemInfoAdapter adapter = (WebItemInfoAdapter)this.tabEditPart.getModel();
                ComponentInfo tabbedPane = adapter.getItem().getComponent();
                WebTreeNode tabbedPaneNode = this.tabEditPart.getTabbedPanelNode();
                tabbedPaneNode.remove((MutableTreeNode)((Object)selectNode));
                AbstractBizConfigureItemCollection items = tabbedPaneNode.getConfigureItems();
                int n = items.size();
                for (int i = 0; i < n; ++i) {
                    AbstractBizConfigureItemInfo itemInfo = items.get(i);
                    if (!cInfo.equals((Object)itemInfo.getComponent())) continue;
                    items.remove(itemInfo);
                    break;
                }
                tabbedPane.removeChild(this.viewer.getContext().getUiModel(), cInfo);
                this.tabEditPart.reload();
                this.loadData();
                this.viewer.getContext().setDirty(true);
                this.viewer.getCommandStack().flush();
            } else {
                MsgBox.showWarning((String)("[" + cInfo.getName() + "]\u662f\u9759\u6001\u5143\u6570\u636e\u63a7\u4ef6\uff0c\u4e0d\u80fd\u5220\u9664\uff01"));
            }
        }
    }
}

