/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.webui.designer;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.editor.editui.designer.AbstractEditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.Request;
import com.kingdee.eas.ep.client.figure.FigureHelper;
import com.kingdee.eas.ep.client.model.dtc.DTControlHelper;
import com.kingdee.eas.ep.webclient.editor.webui.designer.AbstractWebEditPartViewer;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebItemInfoAdapter;
import com.kingdee.eas.ep.webclient.editor.webui.designer.policy.AlignPolicy;
import com.kingdee.eas.ep.webclient.editor.webui.designer.policy.ChangeContainerPolicy;
import com.kingdee.eas.ep.webclient.editor.webui.designer.policy.ResizePolicy;
import com.kingdee.eas.ep.webclient.editor.webui.designer.policy.SameSizePolicy;
import com.kingdee.eas.ep.webclient.editor.webui.designer.policy.SmartLayoutDirectEditPolicy;
import com.kingdee.eas.ep.webclient.editor.webui.designer.policy.WebLayoutDirectEditPolicy;
import com.kingdee.eas.ep.webclient.editor.webui.designer.policy.WebToolbarLayoutDirectEditPolicy;
import com.kingdee.eas.ep.webclient.editor.webui.designer.ui.UnrecognizedTypeCtrl;
import com.kingdee.eas.ep.webclient.editor.webui.designer.ui.WebButton;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.ConstraintUtil;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.WebComponent2SwingMapping;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.WebEditorHelper;
import com.kingdee.eas.ep.webclient.figure.WebComponentParam;
import com.kingdee.eas.ep.webclient.model.WebItemInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JViewport;
import org.apache.log4j.Logger;

public class CommonEditPart
extends AbstractEditPart {
    private static final Logger logger = CoreUIObject.getLogger(CommonEditPart.class);
    protected BufferedImage figure;
    protected Component component;
    protected Component baseComponent;
    protected boolean isMoveIn = false;
    protected boolean isSelected = false;
    protected boolean isMultiSelected = false;
    protected BasicStroke _3fbs = new BasicStroke(3.0f);

    public CommonEditPart() {
    }

    public CommonEditPart(WebItemInfo item, AbstractWebEditPartViewer viewer) {
        super.setViewer(viewer);
        if (item == null) {
            return;
        }
        ComponentInfo cInfo = item.getComponent();
        Object constraint = item.getConstraint();
        WebComponentParam cp = new WebComponentParam(item);
        this.component = this.createComponent(cInfo, cp);
        if (this.component != null) {
            Dimension parentSize = viewer.getSize();
            Dimension size = ConstraintUtil.translateConstraint2Dimension(constraint, parentSize);
            this.component.setSize(size);
            viewer.addComponent2ComponentPanel(this.component, constraint);
        }
    }

    @Override
    public void activate() {
        ((WebItemInfoAdapter)this.getModel()).addPropertyChangeListener(this);
    }

    @Override
    public void deactivate() {
        ((WebItemInfoAdapter)this.getModel()).removePropertyChangeListener(this);
    }

    @Override
    public void performRequest(Request request) {
        if ("move in".equals(request.getType())) {
            if (!this.isMoveIn) {
                this.isMoveIn = true;
                this.refreshVisuals();
            }
        } else if ("move out".equals(request.getType())) {
            if (this.isMoveIn) {
                this.isMoveIn = false;
                this.refreshVisuals();
            }
        } else if ("selected".equals(request.getType())) {
            if (!this.isSelected) {
                this.isSelected = true;
                this.isMultiSelected = false;
                this.refreshVisuals();
            }
        } else if ("multiselected".equals(request.getType())) {
            if (!this.isMultiSelected) {
                this.isSelected = false;
                this.isMultiSelected = true;
                this.refreshVisuals();
            }
        } else if ("unselected".equals(request.getType()) && (this.isSelected || this.isMultiSelected)) {
            this.isSelected = false;
            this.isMultiSelected = false;
            this.refreshVisuals();
        }
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ChangeContainerPolicy", new ChangeContainerPolicy());
        this.installEditPolicy("ResizePolicy", new ResizePolicy());
        this.installEditPolicy("AlignPolicy", new AlignPolicy());
        this.installEditPolicy("SameSizePolicy", new SameSizePolicy());
        String type = ((AbstractWebEditPartViewer)this.viewer).getLayoutInfo().getType();
        if ("SmartLayout".equalsIgnoreCase(type)) {
            this.installEditPolicy("DirectEditPolicy", new SmartLayoutDirectEditPolicy());
        } else if ("WebLayout".equalsIgnoreCase(type)) {
            this.installEditPolicy("DirectEditPolicy", new WebLayoutDirectEditPolicy());
        } else if ("WebToolBarLayout".equalsIgnoreCase(type)) {
            this.installEditPolicy("DirectEditPolicy", new WebToolbarLayoutDirectEditPolicy());
        }
    }

    @Override
    public BufferedImage getFigure() {
        if (this.figure == null) {
            this.figure = this.createFigure();
        }
        return this.figure;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    protected BufferedImage createFigure() {
        Dimension size = null;
        size = this.component != null ? this.component.getSize() : new Dimension(0, 0);
        size.width += 4;
        size.height += 4;
        return FigureHelper.drawAlphaImage(size, 0.0f, Color.white, false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt != null && evt.getPropertyName().equals("constraint")) {
            ((AbstractWebEditPartViewer)this.viewer).getLayoutManager().setConstraint(this.component, evt.getNewValue());
            this.refreshVisuals();
        }
        WebItemInfoAdapter adpter = (WebItemInfoAdapter)this.getModel();
        WebItemInfo item = (WebItemInfo)adpter.getItem();
        this.refreshComponent(new WebComponentParam(item));
        ((AbstractWebEditPartViewer)this.viewer).revalidate();
        ((AbstractWebEditPartViewer)this.viewer).repaint();
    }

    @Override
    public void refreshVisuals() {
        Graphics g;
        this.figure = this.createFigure();
        if (this.isMoveIn) {
            g = this.figure.getGraphics();
            g.setColor(Color.red);
            ((Graphics2D)g).setStroke(this._3fbs);
            g.drawRect(0, 0, this.figure.getWidth() - 1, this.figure.getHeight() - 1);
        }
        if (this.isSelected) {
            g = this.figure.getGraphics();
            g.setColor(Color.orange);
            ((Graphics2D)g).setStroke(this._3fbs);
            g.drawRect(0, 0, this.figure.getWidth() - 1, this.figure.getHeight() - 1);
            FigureHelper.drawPoint(g, new Rectangle(0, 0, this.figure.getWidth(), this.figure.getHeight()), 15, Color.black);
        }
        if (this.isMultiSelected) {
            g = this.figure.getGraphics();
            g.setColor(Color.orange);
            ((Graphics2D)g).setStroke(this._3fbs);
            g.drawRect(0, 0, this.figure.getWidth() - 1, this.figure.getHeight() - 1);
        }
        ((AbstractWebEditPartViewer)this.viewer).repaint();
    }

    @Override
    public Object getConstraint() {
        WebItemInfo item = (WebItemInfo)((WebItemInfoAdapter)this.getModel()).getItem();
        return item.getConstraint();
    }

    protected Component createComponent(ComponentInfo cInfo, WebComponentParam cp) {
        if (cp == null || cInfo == null || !DTControlHelper.isVisual(cInfo.getClassType())) {
            return null;
        }
        Component control = null;
        String classType = WebComponent2SwingMapping.getSwingClass(cInfo.getClassType());
        try {
            control = (Component)Class.forName(classType).newInstance();
            control.setName(cInfo.getName());
            this.baseComponent = control;
            if (control instanceof JComponent) {
                ((JComponent)control).setOpaque(true);
            }
            control.setEnabled(!cp.disabled);
            Method method = null;
            try {
                method = control.getClass().getMethod("setRequired", Boolean.TYPE);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            if (method != null) {
                method.invoke((Object)control, cp.required);
            }
            if ("com.kingdee.bos.ctrl.web.EditDataGrid".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.web.DataGrid".equals(cInfo.getClassType())) {
                WebEditorHelper.initDataGrid((KDTable)control, cInfo);
            } else if ("com.kingdee.bos.ctrl.web.Label".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.web.Button".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.web.RadioButton".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.web.CheckBox".equals(cInfo.getClassType())) {
                method = null;
                try {
                    method = control.getClass().getMethod("setText", String.class);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                if (method != null) {
                    method.invoke((Object)control, cp.text);
                }
                if ("com.kingdee.bos.ctrl.web.Label".equals(cInfo.getClassType())) {
                    KDLabel label = (KDLabel)control;
                    label.setBackground(Color.gray);
                }
            }
            if (cInfo.getParent() != null && "com.kingdee.bos.ctrl.web.LabelContainer".equals(cInfo.getParent().getClassType())) {
                KDLabelContainer lblContainer = new KDLabelContainer();
                lblContainer.setBoundLabelText(cp.boundLabelText);
                lblContainer.setBoundLabelLength(cp.boundLabelLength);
                lblContainer.getBoundLabel().setOpaque(true);
                lblContainer.setBoundEditor((JComponent)control);
                control = lblContainer;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
        if (control instanceof UnrecognizedTypeCtrl) {
            ((UnrecognizedTypeCtrl)((Object)control)).setText(cInfo.getClassType());
        }
        return control;
    }

    protected void refreshComponent(WebComponentParam cp) {
        if (cp == null || this.baseComponent == null) {
            return;
        }
        try {
            if (this.baseComponent instanceof JComponent) {
                ((JComponent)this.baseComponent).setOpaque(true);
            }
            this.baseComponent.setEnabled(!cp.disabled);
            Method method = null;
            try {
                method = this.baseComponent.getClass().getMethod("setRequired", Boolean.TYPE);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            if (method != null) {
                method.invoke((Object)this.baseComponent, cp.required);
            }
            if (this.baseComponent instanceof KDTable) {
                WebEditorHelper.initDataGrid((KDTable)this.baseComponent, cp.cInfo);
            } else if (this.baseComponent instanceof KDLabel || this.baseComponent instanceof WebButton || this.baseComponent instanceof KDRadioButton || this.baseComponent instanceof KDCheckBox) {
                method = null;
                try {
                    method = this.baseComponent.getClass().getMethod("setText", String.class);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                if (method != null) {
                    method.invoke((Object)this.baseComponent, cp.text);
                }
            } else if (this.baseComponent instanceof KDContainer) {
                method = null;
                try {
                    method = this.baseComponent.getClass().getMethod("setTitle", String.class);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                if (method != null) {
                    method.invoke((Object)this.baseComponent, cp.text);
                }
            }
            if (this.baseComponent.getParent() != null) {
                Component tmp = this.baseComponent;
                if (tmp.getParent() instanceof JViewport) {
                    tmp = tmp.getParent();
                }
                if (tmp.getParent() instanceof KDLabelContainer) {
                    KDLabelContainer lblContainer = (KDLabelContainer)tmp.getParent();
                    lblContainer.setBoundLabelText(cp.boundLabelText);
                    lblContainer.setBoundLabelLength(cp.boundLabelLength);
                    lblContainer.getBoundLabel().setOpaque(true);
                }
            }
            if (this.baseComponent instanceof UnrecognizedTypeCtrl) {
                ((UnrecognizedTypeCtrl)((Object)this.baseComponent)).setText(cp.cInfo.getClassType());
            }
        }
        catch (Exception e1) {
            logger.error((Object)"CommonEditPart.refreshComponent", (Throwable)e1);
        }
    }
}

