/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.webui.designer;

import com.kingdee.eas.ep.client.editor.editui.designer.EditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.request.ChangeContainerRequest;
import com.kingdee.eas.ep.client.editor.editui.designer.request.ResizeRequest;
import com.kingdee.eas.ep.webclient.editor.webui.designer.AbstractWebEditPartViewer;
import com.kingdee.eas.ep.webclient.editor.webui.designer.ContainerEditPart;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebContext;
import com.kingdee.eas.ep.webclient.editor.webui.designer.layout.WebLayout;
import com.kingdee.eas.ep.webclient.editor.webui.designer.request.WebLayoutDirectEditRequest;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.WebEditorHelper;
import com.kingdee.eas.ep.webclient.model.WebTreeNode;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class WebLayoutWebEditPartViewer
extends AbstractWebEditPartViewer {
    public WebLayoutWebEditPartViewer(WebTreeNode node, Dimension size, WebContext context) {
        super(node, size, context, new WebLayout());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.launchMouseEvent) {
            EditPart source = this.partManager.getSource();
            EditPart target = this.partManager.getTarget();
            if (source != null) {
                if (!this.isResizing) {
                    if (!this.imageList.isEmpty()) {
                        if (this == ((WebContext)this.context).getMouseInViewer()) {
                            if (source != null && target != null) {
                                source.sendRequest(new WebLayoutDirectEditRequest(source, target, this));
                            }
                        } else {
                            boolean isParent;
                            if (source instanceof ContainerEditPart && (isParent = WebEditorHelper.isParent(((WebContext)this.context).getMouseInViewer(), source.getComponent()))) {
                                return;
                            }
                            source.sendRequest(new ChangeContainerRequest(source, this, ((WebContext)this.context).getMouseInViewer()));
                        }
                    }
                } else {
                    if (this.border == 8 || this.border == 9) {
                        source.sendRequest(new ResizeRequest(source, this, this.border, this.y));
                    } else {
                        source.sendRequest(new ResizeRequest(source, this, this.border, this.x));
                    }
                    this.isResizing = false;
                }
                if (source instanceof ContainerEditPart) {
                    source.getComponent().setVisible(true);
                }
            } else {
                WebEditorHelper.dispatchEvent2ParentViewer(this, e);
            }
            this.releasSelectedParam();
            this.setAllViewerEditPartMoveOut();
            this.repaint();
        }
        this.launchMouseEvent = false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.x = e.getX();
            this.y = e.getY();
            if (this.partManager.getSelection() == null) {
                WebEditorHelper.dispatchEvent2ParentViewer(this, e);
                return;
            }
            if (!this.isResizing) {
                EditPart moveInPart = WebEditorHelper.getEditPartByPoint(this.x, this.y, this.partManager);
                this.setAllEditPartMoveOut();
                if (moveInPart != null) {
                    this.partManager.target(moveInPart);
                    moveInPart.performRequest(this.moveInRequest);
                }
            }
            this.repaint();
        }
    }
}

