/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.webui.designer;

import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.eas.ep.webclient.editor.webui.designer.AbstractWebEditPartViewer;
import com.kingdee.eas.ep.webclient.editor.webui.designer.ContainerEditPart;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebContext;
import com.kingdee.eas.ep.webclient.editor.webui.designer.ui.WebTabbedPane;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.ConstraintUtil;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.WebEditorHelper;
import com.kingdee.eas.ep.webclient.model.WebItemInfo;
import com.kingdee.eas.ep.webclient.model.WebTreeNode;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class WebTabbedPaneEditPart
extends ContainerEditPart {
    WebTreeNode tabbedPanelNode;
    protected List childViewerList = new ArrayList(3);

    public WebTabbedPaneEditPart(WebTreeNode tabbedPanelNode, WebItemInfo item, AbstractWebEditPartViewer viewer) {
        super.setViewer(viewer);
        if (item == null) {
            return;
        }
        this.tabbedPanelNode = tabbedPanelNode;
        Object constraint = item.getConstraint();
        this.component = WebTabbedPaneEditPart.createComponent(WebTabbedPane.class);
        Dimension parentSize = viewer.getSize();
        Dimension size = ConstraintUtil.translateConstraint2Dimension(constraint, parentSize);
        this.component.setSize(size);
        WebTabbedPane tabbedPane = (WebTabbedPane)((Object)this.component);
        this.createTab(tabbedPanelNode, tabbedPane);
        viewer.addComponent2MaskPanel((Component)((Object)tabbedPane), constraint);
        viewer.revalidate();
        for (AbstractWebEditPartViewer childViewer : this.childViewerList) {
            viewer.addChildViewer(childViewer);
            childViewer.setParentViewer(viewer);
        }
        this.baseComponent = tabbedPane;
    }

    private void createTab(WebTreeNode node, WebTabbedPane tabpane) {
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            WebTreeNode child = (WebTreeNode)((Object)node.getChildAt(i));
            if (!(child.getUserObject() instanceof ComponentInfo)) continue;
            ComponentInfo cInfo = (ComponentInfo)child.getUserObject();
            String title = cInfo.getConstraint() instanceof String ? cInfo.getConstraint().toString() : "\u5206\u7ec4";
            AbstractWebEditPartViewer childViewer = WebEditorHelper.getViewerInstance(cInfo.getLayoutInfo(), child, null, (WebContext)this.viewer.getContext());
            if (childViewer == null) continue;
            tabpane.add(childViewer, title);
            this.childViewerList.add(childViewer);
        }
    }

    public void reload() {
        WebTabbedPane tabbedPane = (WebTabbedPane)((Object)this.component);
        tabbedPane.removeAll();
        this.createTab(this.tabbedPanelNode, tabbedPane);
    }

    public WebTreeNode getTabbedPanelNode() {
        return this.tabbedPanelNode;
    }
}

