/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.webui.designer.commands;

import com.kingdee.bos.ui.dtp.smartlayout.SmartLayoutData;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.Command;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebItemInfoAdapter;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.ConstraintUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlignCommand
extends Command {
    private List listBack;
    private Map back;
    private int align;
    private boolean canExecute = true;

    public AlignCommand(List list, int align) {
        this.align = align;
        this.listBack = new ArrayList(list.size());
        this.back = new HashMap(list.size());
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            WebItemInfoAdapter item = (WebItemInfoAdapter)((EditPart)list.get(i)).getModel();
            if (!(item.getConstranit() instanceof SmartLayoutData)) {
                this.canExecute = false;
                return;
            }
            Object constraint = ConstraintUtil.clone(item.getConstranit());
            this.back.put(item, constraint);
            this.listBack.add(item);
        }
    }

    @Override
    public boolean canExecute() {
        return this.canExecute;
    }

    @Override
    public void execute() {
        int size = this.listBack.size();
        if (size < 2) {
            return;
        }
        SmartLayoutData refer = (SmartLayoutData)((WebItemInfoAdapter)this.listBack.get(size - 1)).getConstranit();
        for (int i = 0; i < size - 1; ++i) {
            WebItemInfoAdapter item = (WebItemInfoAdapter)this.listBack.get(i);
            SmartLayoutData change = (SmartLayoutData)ConstraintUtil.clone(item.getConstranit());
            switch (this.align) {
                case 0: {
                    change.x = refer.x;
                    break;
                }
                case 1: {
                    change.x = refer.x + refer.width / 2 - change.width / 2;
                    break;
                }
                case 2: {
                    change.x = refer.x + refer.width - change.width;
                    break;
                }
                case 3: {
                    change.y = refer.y;
                    break;
                }
                case 4: {
                    change.y = refer.y + refer.height / 2 - change.height / 2;
                    break;
                }
                case 5: {
                    change.y = refer.y + refer.height - change.height;
                }
            }
            item.setConstraint(change);
        }
    }

    @Override
    public void undo() {
        if (this.listBack.size() < 2) {
            return;
        }
        int size = this.listBack.size() - 1;
        for (int i = 0; i < size; ++i) {
            WebItemInfoAdapter item = (WebItemInfoAdapter)this.listBack.get(i);
            SmartLayoutData old = (SmartLayoutData)this.back.get(item);
            if (old == null) continue;
            item.setConstraint(ConstraintUtil.clone(old));
        }
    }
}

