/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.webui.designer.layout;

import com.kingdee.eas.ep.client.editor.editui.designer.MaskPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;

public abstract class LayoutManager
implements LayoutManager2,
Serializable {
    protected JPanel viewer;
    protected Map constraints = new HashMap();

    @Override
    public void addLayoutComponent(Component comp, Object constraint) {
        if (comp instanceof MaskPanel) {
            return;
        }
        this.constraints.put(comp, constraint);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.constraints.remove(comp);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return null;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            return new Dimension(parent.getSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            return new Dimension(parent.getSize());
        }
    }

    public void setConstraint(String name, Object constraint) {
        Component comp = this.getComponent(name);
        if (comp != null) {
            this.constraints.put(comp, constraint);
            if (this.viewer != null) {
                this.viewer.doLayout();
            }
        }
    }

    public void setConstraint(Component comp, Object constraint) {
        this.constraints.put(comp, constraint);
        if (this.viewer != null) {
            this.viewer.doLayout();
        }
    }

    public Rectangle getBounds(String name) {
        if (name == null) {
            return null;
        }
        Component[] components = this.viewer.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!name.equals(components[i].getName())) continue;
            return components[i].getBounds();
        }
        return null;
    }

    public Object getConstraint(Component comp) {
        return this.constraints.get(comp);
    }

    public Component getComponent(String name) {
        if (name == null) {
            return null;
        }
        Component[] components = this.viewer.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!name.equals(components[i].getName())) continue;
            return components[i];
        }
        return null;
    }

    public JPanel getViewer() {
        return this.viewer;
    }

    public void setViewer(JPanel viewer) {
        this.viewer = viewer;
    }

    public MaskPanel getMaskPanel() {
        Component[] components = this.viewer.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof MaskPanel)) continue;
            return (MaskPanel)((Object)components[i]);
        }
        return null;
    }
}

