/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.webui.designer.policy;

import com.kingdee.eas.ep.client.editor.editui.designer.EditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPolicy;
import com.kingdee.eas.ep.client.editor.editui.designer.Request;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.Command;
import com.kingdee.eas.ep.client.editor.editui.designer.request.ResizeRequest;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebItemInfoAdapter;
import com.kingdee.eas.ep.webclient.editor.webui.designer.commands.ReConstraintCommand;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.ConstraintUtil;
import java.awt.Rectangle;

public class ResizePolicy
implements EditPolicy {
    private EditPart editpart;

    @Override
    public boolean understandsRequest(Request request) {
        return request != null && "resize".equals(request.getType());
    }

    @Override
    public Command getCommand(Request request) {
        if (request != null && "resize".equals(request.getType())) {
            ResizeRequest resizeRequest = (ResizeRequest)request;
            EditPart source = resizeRequest.getSourceEditPart();
            WebItemInfoAdapter model = (WebItemInfoAdapter)source.getModel();
            Rectangle oldBounds = source.getComponent().getBounds();
            Rectangle newBounds = new Rectangle(oldBounds);
            int coordinate = resizeRequest.getCoordinate();
            switch (resizeRequest.getBorder()) {
                case 8: {
                    int offset = oldBounds.y - coordinate;
                    newBounds.y = coordinate;
                    newBounds.height += offset;
                    break;
                }
                case 9: {
                    newBounds.height = coordinate - oldBounds.y;
                    break;
                }
                case 10: {
                    int offset = oldBounds.x - coordinate;
                    newBounds.x = coordinate;
                    newBounds.width += offset;
                    break;
                }
                case 11: {
                    newBounds.width = coordinate - oldBounds.x;
                }
            }
            Object newConstraint = ConstraintUtil.clone(model.getConstranit());
            ConstraintUtil.resetConstraintByRectangle(newConstraint, newBounds);
            ReConstraintCommand command = new ReConstraintCommand(model, newConstraint);
            return command;
        }
        return null;
    }

    @Override
    public EditPart getHost() {
        return this.editpart;
    }

    @Override
    public EditPart getTargetEditPart(Request request) {
        return null;
    }

    @Override
    public void setHost(EditPart editpart) {
        this.editpart = editpart;
    }
}

