/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.webui.designer.util;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartManager;
import com.kingdee.eas.ep.webclient.editor.webui.designer.AbstractWebEditPartViewer;
import com.kingdee.eas.ep.webclient.editor.webui.designer.SmartLayoutWebEditPartViewer;
import com.kingdee.eas.ep.webclient.editor.webui.designer.ToolbarLayoutWebEditPartViewer;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebContext;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebItemInfoAdapter;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebLayoutWebEditPartViewer;
import com.kingdee.eas.ep.webclient.model.WebItemCollection;
import com.kingdee.eas.ep.webclient.model.WebItemInfo;
import com.kingdee.eas.ep.webclient.model.WebTreeNode;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class WebEditorHelper {
    public static void retainAll(EditPartManager manager, Map map, WebItemCollection c, AbstractWebEditPartViewer viewer) {
        Iterator e = manager.iterator();
        while (e.hasNext()) {
            WebItemInfoAdapter adapter;
            EditPart part = (EditPart)e.next();
            if (!(part.getModel() instanceof WebItemInfoAdapter) || WebEditorHelper.contains(c, (WebItemInfo)(adapter = (WebItemInfoAdapter)part.getModel()).getItem())) continue;
            if (part.getComponent() != null) {
                viewer.removeComponent(part.getComponent());
            }
            e.remove();
            map.remove(adapter.getItem());
        }
    }

    public static boolean contains(WebItemCollection c, WebItemInfo item) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (item != iter.next()) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(EditPartManager manager, WebItemInfo item) {
        Iterator e = manager.iterator();
        while (e.hasNext()) {
            WebItemInfoAdapter adapter;
            EditPart part = (EditPart)e.next();
            if (!(part.getModel() instanceof WebItemInfoAdapter) || item != (adapter = (WebItemInfoAdapter)part.getModel()).getItem()) continue;
            return true;
        }
        return false;
    }

    public static boolean isParent(Component component, Component parent) {
        if (component != null && parent != null) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (container != parent) continue;
                return true;
            }
        }
        return false;
    }

    public static AbstractWebEditPartViewer getParentViewer(JComponent component) {
        if (component != null) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof AbstractWebEditPartViewer)) continue;
                return (AbstractWebEditPartViewer)container;
            }
        }
        return null;
    }

    public static void getAllViewer(List set, Component component) {
        if (component != null) {
            if (component instanceof AbstractWebEditPartViewer) {
                set.add((AbstractWebEditPartViewer)component);
            }
            if (component instanceof Container) {
                Component[] cs = ((Container)component).getComponents();
                for (int i = 0; i < cs.length; ++i) {
                    WebEditorHelper.getAllViewer(set, cs[i]);
                }
            }
        }
    }

    public static void dispatchEvent2ParentViewer(JComponent component, MouseEvent e) {
        AbstractWebEditPartViewer parentViewer = WebEditorHelper.getParentViewer(component);
        if (parentViewer != null) {
            MouseEvent me = SwingUtilities.convertMouseEvent((Component)e.getSource(), e, parentViewer.getMaskPanel());
            parentViewer.getMaskPanel().dispatchEvent(me);
        }
    }

    public static AbstractWebEditPartViewer getViewerInstance(LayoutInfo layout, WebTreeNode node, Dimension size, WebContext context) {
        String layoutType = layout.getType();
        if ("SmartLayout".equalsIgnoreCase(layoutType)) {
            return new SmartLayoutWebEditPartViewer(node, size, context);
        }
        if ("WebLayout".equalsIgnoreCase(layoutType)) {
            return new WebLayoutWebEditPartViewer(node, size, context);
        }
        if ("WebToolBarLayout".equalsIgnoreCase(layoutType)) {
            return new ToolbarLayoutWebEditPartViewer(node, size, context);
        }
        return null;
    }

    public static void initDataGrid(KDTable table, ComponentInfo datagrid) {
        if (table == null || datagrid == null) {
            return;
        }
        table.removeColumns();
        ComponentCollection columns = datagrid.getComponents();
        int size = columns.size();
        table.addColumns(size);
        IRow tableHead = table.addHeadRow();
        for (int i = 0; i < size; ++i) {
            PropertyInfo widthPro;
            ComponentInfo column = columns.get(i);
            String header = column.getName();
            int width = 80;
            PropertyInfo headerPro = column.getPropertyByName("header");
            if (headerPro != null) {
                header = headerPro.getValue();
            }
            if ((widthPro = column.getPropertyByName("width")) != null) {
                try {
                    width = Integer.valueOf(widthPro.getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ICell tableCell = tableHead.getCell(i);
            tableCell.setValue((Object)header);
            IColumn tableColumn = table.getColumn(i);
            tableColumn.setWidth(width);
        }
    }

    public static EditPart getEditPartByComponent(Component comp, EditPartManager manager) {
        Iterator e = manager.iterator();
        while (e.hasNext()) {
            EditPart part = (EditPart)e.next();
            Component component = part.getComponent();
            if (component != comp) continue;
            return part;
        }
        return null;
    }

    public static Component getComponentByEditPart(EditPart part, EditPartManager manager) {
        Iterator e = manager.iterator();
        while (e.hasNext()) {
            EditPart part2 = (EditPart)e.next();
            Component component2 = part2.getComponent();
            Component component = part.getComponent();
            if (component == null || component2 == null || component != component2) continue;
            return component;
        }
        return null;
    }

    public static EditPart getEditPartByPoint(int x, int y, EditPartManager manager) {
        Iterator e = manager.iterator();
        while (e.hasNext()) {
            EditPart part = (EditPart)e.next();
            Component component = part.getComponent();
            if (component == null) continue;
            Rectangle bounds = component.getBounds();
            if (x < bounds.x || x > bounds.x + bounds.width || y < bounds.y || y > bounds.y + bounds.height) continue;
            return part;
        }
        return null;
    }

    public static Component getComponentByPoint(int x, int y, EditPartManager manager) {
        Iterator e = manager.iterator();
        while (e.hasNext()) {
            EditPart part = (EditPart)e.next();
            Component component = part.getComponent();
            if (component == null) continue;
            Rectangle bounds = component.getBounds();
            if (x < bounds.x || x > bounds.x + bounds.width || y < bounds.y || y > bounds.y + bounds.height) continue;
            return component;
        }
        return null;
    }

    public static String getPropertyValue(ComponentInfo cInfo, String propertyName) {
        PropertyInfo property;
        if (cInfo != null && !StringUtils.isEmpty((String)propertyName) && (property = cInfo.getPropertyByName(propertyName)) != null) {
            return property.getValue();
        }
        return null;
    }

    public static void setPropertyValue(ComponentInfo cInfo, String propertyName, String propertyValue, String type, boolean isMultiLanguage) {
        if (cInfo != null && !StringUtils.isEmpty((String)propertyName)) {
            PropertyInfo property = cInfo.getPropertyByName(propertyName);
            if (property != null) {
                property.setValue(propertyValue);
            } else {
                property = new PropertyInfo();
                property.setName(propertyName);
                property.setType(type);
                property.setValue(propertyValue);
                property.setMultiLanguage(isMultiLanguage);
                cInfo.getProperties().add(property);
            }
        }
    }
}

