/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bizrule.ConditionRuleInfo;
import com.kingdee.bos.metadata.bizrule.RuleSetCtrl;
import com.kingdee.bos.metadata.bizrule.RuleSetInfo;
import com.kingdee.bos.metadata.bizrule.common.AbstractRuleInfo;
import com.kingdee.bos.metadata.bizrule.common.ActionCollection;
import com.kingdee.bos.metadata.bizrule.common.RuleCollection;
import com.kingdee.bos.metadata.bizrule.common.SimpleExpressionInfo;
import com.kingdee.bos.metadata.bizunit.BIMException;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizUnitCtrl;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.DataSourceType;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.metadata.webui.WebUIObjectAssembler;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.ui.bizunitproxy.WebEditUIProxyHelper;
import com.kingdee.bos.ui.bizunitproxy.WebUIProxyHelper;
import com.kingdee.bos.ui.dtp.smartlayout.SmartLayoutData;
import com.kingdee.bos.ui.dtp.weblayout.WebLayoutData;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.layout.ConstraintPropertyValue;
import com.kingdee.bos.ui.layout.IntegerPropertyValue;
import com.kingdee.bos.ui.layout.StringPropertyValue;
import com.kingdee.bos.ui.layout.WebDataGridConfigInfo;
import com.kingdee.bos.ui.layout.WebTabbedPaneConfigInfo;
import com.kingdee.bos.ui.layout.WebUIComponentConfigInfo;
import com.kingdee.bos.ui.layout.WebUILayoutConfigInfo;
import com.kingdee.eas.ep.BizDataTypeEnum;
import com.kingdee.eas.ep.DataSourceEnum;
import com.kingdee.eas.ep.EditUIConfigureInfo;
import com.kingdee.eas.ep.client.editor.editui.designer.action.ActionRegistry;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.BizEventDefHelper;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.AbstractBizConfigureItemCollection;
import com.kingdee.eas.ep.client.model.AbstractBizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureEventCollection;
import com.kingdee.eas.ep.client.model.BizConfigureEventInfo;
import com.kingdee.eas.ep.client.model.ComponentTreeNode;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.ep.webclient.editor.datagrid.DataGridDesignerUI;
import com.kingdee.eas.ep.webclient.editor.webui.designer.AbstractWebEditPartViewer;
import com.kingdee.eas.ep.webclient.editor.webui.designer.action.WebCreateAction;
import com.kingdee.eas.ep.webclient.editor.webui.designer.action.WebCreateColumnAction;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.ConstraintUtil;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.WebComponentHelper;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.WebEditorHelper;
import com.kingdee.eas.ep.webclient.model.WebItemCollection;
import com.kingdee.eas.ep.webclient.model.WebItemInfo;
import com.kingdee.eas.ep.webclient.model.WebTreeNode;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.input.SAXBuilder;

public class WebUIEditorHelper {
    private static Logger logger = CoreUIObject.getLogger(WebUIEditorHelper.class);
    public static final String DATA_SOURCE_TYPE = "DataSourceType";
    public static final String DATA_FIELD = "dataField";
    public static final String DATA_FIELD_2 = "DataField";
    public static final String ONCREATENEWDATA = "onCreateNewData";
    public static final String CONTAINER = "container";

    public static WebTreeNode getBizConfigureTree(WebUIObjectInfo uiModel, EntityObjectInfo entity, boolean isBase) {
        WebTreeNode rootNode = null;
        if (uiModel != null) {
            rootNode = WebUIEditorHelper.createConfigureTreeNode(uiModel.getMainPanelComponent(), uiModel, entity, isBase);
        }
        return rootNode;
    }

    public static void loadConfigure(WebUIObjectInfo WebUIObjectInfo2, WebTreeNode root, EditUIConfigureInfo configure) {
        String cfgUIXml;
        if (configure != null && !StringUtils.isEmpty((String)(cfgUIXml = configure.getUIObject()))) {
            RuleSetInfo ruleSet;
            WebUILayoutConfigInfo cfgUI = WebUIEditorHelper.loadConfigureInfo(cfgUIXml);
            WebUIEditorHelper.loadConfigureUI(root, root, cfgUI);
            String ruleSetXml = configure.getBizRuleSet();
            if (!StringUtils.isEmpty((String)ruleSetXml) && (ruleSet = WebUIEditorHelper.loadRuleSet(ruleSetXml)) != null) {
                WebUIEditorHelper.loadConfigureItemRules(root, ruleSet);
            }
        }
    }

    private static void loadConfigureItemRules(WebTreeNode root, RuleSetInfo ruleSet) {
        int i;
        int n;
        RuleCollection rules = ruleSet.getRules();
        HashMap<String, AbstractBizConfigureItemInfo> nameItemMap = new HashMap<String, AbstractBizConfigureItemInfo>();
        HashMap configureItems = new HashMap();
        WebUIEditorHelper.createConfigureItemMap(root, configureItems);
        for (String key : configureItems.keySet()) {
            AbstractBizConfigureItemCollection items = (AbstractBizConfigureItemCollection)((Object)configureItems.get(key));
            if ("this".equals(key)) {
                n = items.size();
                for (i = 0; i < n; ++i) {
                    nameItemMap.put(items.get(i).getName(), items.get(i));
                }
                continue;
            }
            n = items.size();
            for (i = 0; i < n; ++i) {
                nameItemMap.put(key + "." + items.get(i).getName(), items.get(i));
            }
        }
        n = rules.size();
        for (i = 0; i < n; ++i) {
            SimpleExpressionInfo exp;
            if (!(rules.get(i) instanceof ConditionRuleInfo)) continue;
            ConditionRuleInfo rule = (ConditionRuleInfo)rules.get(i);
            ActionCollection actionCol = rule.getActions();
            String eventObjectName = rule.getEventObjectName();
            AbstractBizConfigureItemInfo item = (AbstractBizConfigureItemInfo)nameItemMap.get(eventObjectName);
            if (item == null || StringUtils.isEmpty((String)rule.getRuleType())) continue;
            BizConfigureEventInfo eventInfo = new BizConfigureEventInfo();
            eventInfo.setRuleName(rule.getName());
            eventInfo.setRuleType(rule.getRuleType());
            eventInfo.setEventType(rule.getEventType());
            eventInfo.setEventObjectName(eventObjectName);
            if (rule.getCondition() != null) {
                eventInfo.setUseCondtion(true);
                eventInfo.setCondition(rule.getCondition().getExpression().getSource());
                LinkedList<String> exceptionActions = new LinkedList<String>();
                ActionCollection exceptionActionCol = rule.getExceptionActions();
                int m = exceptionActionCol.size();
                for (int k = 0; k < m; ++k) {
                    if (exceptionActionCol.get(k).getExpression() == null || !(exceptionActionCol.get(k).getExpression() instanceof SimpleExpressionInfo)) continue;
                    exp = (SimpleExpressionInfo)exceptionActionCol.get(k).getExpression();
                    exceptionActions.add(exp.getSource());
                }
                eventInfo.setExceptionActions(exceptionActions);
            } else {
                eventInfo.setUseCondtion(false);
            }
            LinkedList<String> actions = new LinkedList<String>();
            int m = actionCol.size();
            for (int k = 0; k < m; ++k) {
                if (actionCol.get(k).getExpression() == null || !(actionCol.get(k).getExpression() instanceof SimpleExpressionInfo)) continue;
                exp = (SimpleExpressionInfo)actionCol.get(k).getExpression();
                actions.add(exp.getSource());
            }
            eventInfo.setActions(actions);
            eventInfo.setConditionRuleInfo(rule);
            if (item.getConfigureEventCollection() == null) {
                item.setConfigureEventCollection(new BizConfigureEventCollection());
            }
            item.getConfigureEventCollection().add(eventInfo);
        }
    }

    private static void loadConfigureUI(WebTreeNode root, WebTreeNode parent, WebUILayoutConfigInfo cfgUI) {
        int i;
        ComponentInfo pInfo;
        if (parent == null || cfgUI == null) {
            return;
        }
        if (parent.getUserObject() instanceof ComponentInfo && "com.kingdee.bos.ctrl.web.TabbedPane".equals((pInfo = (ComponentInfo)parent.getUserObject()).getClassType())) {
            WebTabbedPaneConfigInfo tabbedpaneCfgInfo = cfgUI.getTabbedPaneConfig(pInfo.getName());
            WebUIEditorHelper.loadTabOrder(parent, pInfo, tabbedpaneCfgInfo);
        }
        for (i = 0; i < parent.getConfigureItems().size(); ++i) {
            WebDataGridConfigInfo tableCfg;
            WebItemInfo item = (WebItemInfo)parent.getConfigureItems().get(i);
            WebUIComponentConfigInfo cInfo = null;
            if (item.getComponent() != null) {
                cInfo = cfgUI.getWebUIComponentConfigInfo(item.getComponent().getName());
            }
            if (cInfo != null) {
                StringPropertyValue container;
                ConstraintPropertyValue rect;
                IntegerPropertyValue labelLength = cInfo.getLabelLength();
                if (!labelLength.isNull()) {
                    item.setLabelLength(labelLength.getValue());
                }
                if (!(rect = cInfo.getConstraint()).isNull()) {
                    item.setConstraint(rect.getValue());
                }
                if (cInfo.isVisable().getValue() != null) {
                    item.setVisible(cInfo.isVisable().getValue());
                }
                if (!(container = cInfo.getContainer()).isNull()) {
                    WebTreeNode changedParent;
                    item.setContainer(cInfo.getContainer().getValue());
                    String parentName = item.getContainer();
                    if (!StringUtils.isEmpty((String)parentName) && !parentName.equals(parent.getName()) && (changedParent = (WebTreeNode)root.findTreeNodeByName(parentName)) != null) {
                        changedParent.getConfigureItems().add(item);
                        parent.getConfigureItems().remove(item);
                        --i;
                    }
                }
            }
            if (item.getComponent() == null || !"com.kingdee.bos.ctrl.web.DataGrid".equals(item.getComponent().getClassType()) && !"com.kingdee.bos.ctrl.web.EditDataGrid".equals(item.getComponent().getClassType()) || (tableCfg = cfgUI.getDataGridConfigInfo(item.getComponent().getName())) == null) continue;
            WebUIEditorHelper.loadDataGridColumnOrder(item.getComponent(), tableCfg);
        }
        int n = parent.getChildCount();
        for (i = 0; i < n; ++i) {
            WebUIEditorHelper.loadConfigureUI(root, (WebTreeNode)((Object)parent.getChildAt(i)), cfgUI);
        }
    }

    public static WebTreeNode createConfigureTreeNode(ComponentInfo cInfo, WebUIObjectInfo uiModel, EntityObjectInfo entity, boolean isBase) {
        if (cInfo == null) {
            return null;
        }
        if ("com.kingdee.bos.ctrl.web.LabelContainer".equalsIgnoreCase(cInfo.getClassType()) || "com.kingdee.bos.ctrl.web.EditableColumn".equalsIgnoreCase(cInfo.getClassType())) {
            return null;
        }
        if (!cInfo.isContainer()) {
            return null;
        }
        if ("com.kingdee.bos.ctrl.web.EditDataGrid".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.web.DataGrid".equals(cInfo.getClassType())) {
            WebTreeNode node = new WebTreeNode(cInfo);
            node.setName(cInfo.getName());
            WebItemCollection col = (WebItemCollection)node.getConfigureItems();
            ComponentCollection cs = cInfo.getComponents();
            int size = cs.size();
            for (int i = 0; i < size; ++i) {
                ComponentInfo column = cs.get(i);
                WebItemInfo item = WebUIEditorHelper.createConfigureItem(cInfo, column, null, uiModel, entity, isBase);
                if (item == null) continue;
                item.setConfigured(false);
                col.add(item);
            }
            return node;
        }
        if (cInfo.getComponents() != null) {
            WebTreeNode node = new WebTreeNode(cInfo);
            node.setName(cInfo.getName());
            WebItemCollection col = (WebItemCollection)node.getConfigureItems();
            col.clear();
            int n = cInfo.getComponents().size();
            for (int i = 0; i < n; ++i) {
                WebItemInfo item;
                ComponentInfo component;
                WebTreeNode subNode;
                ComponentInfo subComponent = cInfo.getComponents().get(i);
                if (WebUIEditorHelper.needCreateNode(subComponent) && (subNode = WebUIEditorHelper.createConfigureTreeNode(subComponent, uiModel, entity, isBase)) != null) {
                    node.add((MutableTreeNode)((Object)subNode));
                }
                if ((component = WebUIEditorHelper.getNeedComponent(subComponent)) == null || (item = WebUIEditorHelper.createConfigureItem(component, null, entity, isBase)) == null) continue;
                item.setConfigured(false);
                col.add(item);
            }
            return node;
        }
        return null;
    }

    public static boolean needCreateNode(ComponentInfo cInfo) {
        if (cInfo != null && ("com.kingdee.bos.ctrl.web.EditDataGrid".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.web.DataGrid".equals(cInfo.getClassType()))) {
            return true;
        }
        return WebUIEditorHelper.isIdentifiableLayout(cInfo);
    }

    public static boolean isIdentifiableLayout(ComponentInfo cInfo) {
        if (cInfo == null || !cInfo.isContainer()) {
            return false;
        }
        LayoutInfo layout = cInfo.getLayoutInfo();
        if (layout == null) {
            return false;
        }
        String layoutType = layout.getType();
        return "SmartLayout".equalsIgnoreCase(layoutType) || "WebLayout".equalsIgnoreCase(layoutType) && ("com.kingdee.bos.ctrl.web.RootPane".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.web.Panel".equals(cInfo.getClassType())) || "TabbedPaneLayout".equalsIgnoreCase(layoutType) || "WebToolBarLayout".equalsIgnoreCase(layoutType);
    }

    public static ComponentInfo getNeedComponent(ComponentInfo component) {
        if (component != null) {
            if ("com.kingdee.bos.ctrl.web.LabelContainer".equalsIgnoreCase(component.getClassType())) {
                if (component.getComponents().size() == 0) {
                    return component;
                }
                return WebUIEditorHelper.getNeedComponent(component.getComponents().get(0));
            }
            return component;
        }
        return null;
    }

    private static WebItemInfo createConfigureItem(ComponentInfo component, WebItemInfo updateItem, EntityObjectInfo entity, boolean isBase) {
        WebItemInfo item = updateItem != null ? updateItem : new WebItemInfo();
        item.setName(component.getName());
        item.setAlias(component.getAlias());
        item.setDisabled(WebUIEditorHelper.isDisabled(component));
        item.setLabel(WebUIEditorHelper.getLabel(component));
        item.setLabelLength(WebUIEditorHelper.getLabelLength(component));
        item.setRequired(WebUIEditorHelper.isRequired(component));
        item.setComponent(component);
        item.setConstraint(WebUIEditorHelper.getConstraint(component));
        item.setControlName(component.getName());
        item.setVisible(true);
        com.kingdee.bos.metadata.entity.PropertyInfo prop = WebUIEditorHelper.getBindingProperty(component, entity);
        if (prop != null) {
            item.setProperty(prop);
            if (prop instanceof OwnPropertyInfo) {
                item.setDataType(WebUIEditorHelper.getDataTypeAlias(prop));
                item.setDefaultValue(prop.getExtendedProperty("defaultValue"));
                item.setLength(((OwnPropertyInfo)prop).getLength());
                item.setScale(((OwnPropertyInfo)prop).getDecimalDigits());
                item.setPrecision(((OwnPropertyInfo)prop).getPrecision());
                if (BizDataTypeEnum.ENUM.equals((Object)item.getDataType())) {
                    item.setEnumPK(((OwnPropertyInfo)prop).getMetaDataRef());
                }
                if (!StringUtils.isEmpty((String)prop.getExtendedProperty(DATA_SOURCE_TYPE))) {
                    item.setDataSourceType(WebUIEditorHelper.getDataSourceType(DataSourceType.getEnum((String)prop.getExtendedProperty(DATA_SOURCE_TYPE))));
                }
                item.setDataField(prop.getExtendedProperty(DATA_FIELD));
                if (StringUtils.isEmpty((String)item.getDataField())) {
                    item.setDataField(prop.getExtendedProperty(DATA_FIELD_2));
                }
                if (item.getDataSourceType() == null) {
                    if (BizDataTypeEnum.ENUM.equals((Object)item.getDataType())) {
                        item.setDataSourceType(DataSourceEnum.LIST);
                    } else {
                        item.setDataSourceType(DataSourceEnum.SELF);
                    }
                }
            } else {
                LinkPropertyInfo lnkProp = (LinkPropertyInfo)prop;
                RelationshipInfo relation = lnkProp.getRelationship();
                if (CardinalityType.ONE.equals((Object)relation.getSupplierCardinality()) || CardinalityType.ZERO_TO_ONE.equals((Object)relation.getSupplierCardinality())) {
                    item.setDataType(WebUIEditorHelper.getDataTypeAlias(prop));
                    item.setDefaultValue(prop.getExtendedProperty("defaultValue"));
                    item.setDataSourceType(DataSourceEnum.BASEDATA);
                    EntityObjectInfo subEntity = relation.getSupplierObject();
                    item.setDataSource(subEntity);
                    item.setDataField(prop.getExtendedProperty(DATA_FIELD));
                    if (StringUtils.isEmpty((String)item.getDataField())) {
                        item.setDataField(prop.getExtendedProperty(DATA_FIELD_2));
                    }
                }
            }
        }
        return item;
    }

    private static WebItemInfo createConfigureItem(ComponentInfo table, ComponentInfo column, WebItemInfo updateItem, WebUIObjectInfo uiModel, EntityObjectInfo entity, boolean isBase) {
        WebItemInfo item = updateItem != null ? updateItem : new WebItemInfo();
        item.setName(column.getName());
        String header = WebEditorHelper.getPropertyValue(column, "header");
        item.setAlias(header == null ? column.getName() : header);
        item.setControlName(column.getName());
        String hidden = WebEditorHelper.getPropertyValue(column, "hidden");
        item.setVisible(!"true".equals(hidden));
        item.setEnabled(true);
        item.setLabel(item.getAlias());
        item.setRequired(false);
        item.setComponent(column);
        String bindField = WebUIEditorHelper.getColumnBindField(column);
        com.kingdee.bos.metadata.entity.PropertyInfo prop = WebEditUIProxyHelper.getPropertyByName((EntityObjectInfo)entity, (String)bindField);
        if (prop != null) {
            item.setProperty(prop);
            item.setDataType(WebUIEditorHelper.getDataTypeAlias(prop));
            item.setDefaultValue(prop.getExtendedProperty("defaultValue"));
            item.setAlias(prop.getAlias());
            if (prop instanceof OwnPropertyInfo) {
                if (BizDataTypeEnum.ENUM.equals((Object)item.getDataType())) {
                    item.setDataSourceType(DataSourceEnum.LIST);
                    item.setEnumPK(((OwnPropertyInfo)prop).getMetaDataRef());
                } else {
                    item.setDataSourceType(DataSourceEnum.SELF);
                    item.setLength(((OwnPropertyInfo)prop).getLength());
                    item.setScale(((OwnPropertyInfo)prop).getDecimalDigits());
                    item.setPrecision(((OwnPropertyInfo)prop).getPrecision());
                }
            } else {
                LinkPropertyInfo lnkProp = (LinkPropertyInfo)prop;
                RelationshipInfo relation = lnkProp.getRelationship();
                if (CardinalityType.ONE.equals((Object)relation.getSupplierCardinality()) || CardinalityType.ZERO_TO_ONE.equals((Object)relation.getSupplierCardinality())) {
                    item.setDataSourceType(DataSourceEnum.BASEDATA);
                    EntityObjectInfo rEntity = relation.getSupplierObject();
                    item.setDataSource(rEntity);
                }
            }
            item.setDataField(prop.getExtendedProperty(DATA_FIELD));
            if (StringUtils.isEmpty((String)item.getDataField())) {
                item.setDataField(prop.getExtendedProperty(DATA_FIELD_2));
            }
        }
        return item;
    }

    public static BizDataTypeEnum getDataTypeAlias(com.kingdee.bos.metadata.entity.PropertyInfo prop) {
        if (prop == null) {
            return null;
        }
        if (prop instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
            if (ownProp.getEnumType() != null) {
                return BizDataTypeEnum.ENUM;
            }
            DataType dataType = ownProp.getDataType();
            if (DataType.BOOLEAN.equals((Object)dataType)) {
                return BizDataTypeEnum.BOOLEAN;
            }
            if (DataType.STRING.equals((Object)dataType)) {
                String bdt = prop.getExtendedProperty("bizDataType");
                if ("NOTE".equalsIgnoreCase(bdt)) {
                    return BizDataTypeEnum.NOTE;
                }
                return BizDataTypeEnum.STRING;
            }
            if (DataType.INTEGER.equals((Object)dataType)) {
                return BizDataTypeEnum.INTEGER;
            }
            if (DataType.FLOAT.equals((Object)dataType)) {
                return BizDataTypeEnum.FLOAT;
            }
            if (DataType.DOUBLE.equals((Object)dataType)) {
                return BizDataTypeEnum.DOUBLE;
            }
            if (DataType.BOSUUID.equals((Object)dataType)) {
                return BizDataTypeEnum.BOSUUID;
            }
            if (DataType.CHAR.equals((Object)dataType)) {
                return BizDataTypeEnum.CHAR;
            }
            if (DataType.DATE.equals((Object)dataType) || DataType.TIMESTAMP.equals((Object)dataType)) {
                return BizDataTypeEnum.DATE;
            }
            if (DataType.DECIMAL.equals((Object)dataType)) {
                return BizDataTypeEnum.DECIMAL;
            }
            if (DataType.LONG.equals((Object)dataType)) {
                return BizDataTypeEnum.LONG;
            }
            if (DataType.TIME.equals((Object)dataType)) {
                return BizDataTypeEnum.TIME;
            }
            return BizDataTypeEnum.OTHER;
        }
        LinkPropertyInfo lnkProp = (LinkPropertyInfo)prop;
        RelationshipInfo relation = lnkProp.getRelationship();
        if (CardinalityType.ONE.equals((Object)relation.getSupplierCardinality()) || CardinalityType.ZERO_TO_ONE.equals((Object)relation.getSupplierCardinality())) {
            return BizDataTypeEnum.OBJECT;
        }
        return BizDataTypeEnum.COLLECTION;
    }

    public static DataSourceEnum getDataSourceType(DataSourceType type) {
        if (type == null) {
            return DataSourceEnum.SELF;
        }
        if (type.equals((Object)DataSourceType.MANAUL)) {
            return DataSourceEnum.SELF;
        }
        if (type.equals((Object)DataSourceType.BASEDATA)) {
            return DataSourceEnum.BASEDATA;
        }
        if (type.equals((Object)DataSourceType.BASEDATAEXT)) {
            return DataSourceEnum.BASEDATAEXT;
        }
        if (type.equals((Object)DataSourceType.ENUMLIST)) {
            return DataSourceEnum.LIST;
        }
        return DataSourceEnum.SELF;
    }

    public static com.kingdee.bos.metadata.entity.PropertyInfo getPropertyByName(EntityObjectInfo entity, String propertyName) {
        if (entity == null || StringUtils.isEmpty((String)propertyName)) {
            return null;
        }
        String[] propertys = StringUtils.split((String)propertyName, (String)".");
        com.kingdee.bos.metadata.entity.PropertyInfo prop = null;
        EntityObjectInfo subEntity = entity;
        int n = propertys.length;
        for (int i = 0; i < n && (prop = subEntity.getPropertyByName(propertys[i], true)) != null; ++i) {
            if (prop instanceof OwnPropertyInfo) {
                if (i == n - 1) break;
                prop = null;
                break;
            }
            RelationshipInfo relation = ((LinkPropertyInfo)prop).getRelationship();
            subEntity = relation.getSupplierObject();
            if (subEntity != null) continue;
            prop = null;
            break;
        }
        return prop;
    }

    public static String getColumnBindField(ComponentInfo column) {
        if (column == null) {
            return null;
        }
        int n = column.getPropertyBindings().size();
        for (int j = 0; j < n; ++j) {
            PropertyBindingInfo pbInfo = column.getPropertyBindings().get(j);
            if (!"value".equals(pbInfo.getPropertyName())) continue;
            return pbInfo.getBingdingField();
        }
        return null;
    }

    public static Object getConstraint(ComponentInfo component) {
        component = WebUIEditorHelper.getRoundedComponent(component);
        return ConstraintUtil.clone(component.getConstraint());
    }

    public static boolean isDisabled(WebItemInfo item) {
        if (item == null) {
            return false;
        }
        if (item.getComponent() != null) {
            return WebUIEditorHelper.isDisabled(item.getComponent());
        }
        return false;
    }

    public static boolean isRequired(WebItemInfo item) {
        if (item == null) {
            return false;
        }
        if (item.getComponent() != null) {
            return WebUIEditorHelper.isRequired(item.getComponent());
        }
        return false;
    }

    public static String getLabel(WebItemInfo item) {
        if (item == null) {
            return "";
        }
        if (item.getComponent() != null) {
            return WebUIEditorHelper.getLabel(item.getComponent());
        }
        return "";
    }

    public static boolean isDisabled(ComponentInfo component) {
        if (component == null) {
            logger.info((Object)"component is null in WebUIEditorHelper -> isEnabled(),return false now...");
            return false;
        }
        PropertyInfo prop = component.getPropertyByName("disabled");
        if (prop != null) {
            String propValue = prop.getValue();
            return "true".equalsIgnoreCase(propValue);
        }
        return false;
    }

    public static boolean isRequired(ComponentInfo component) {
        if (component == null) {
            logger.info((Object)"component is null in WebUIEditorHelper -> isRequired(),return false now...");
            return false;
        }
        PropertyInfo prop = component.getPropertyByName("required");
        if (prop != null) {
            String propValue = prop.getValue();
            return "true".equalsIgnoreCase(propValue);
        }
        return false;
    }

    public static boolean isKDTable(WebItemInfo item) {
        if (item == null) {
            return false;
        }
        if (item.getComponent() != null) {
            return "com.kingdee.bos.ctrl.web.DataGrid".equalsIgnoreCase(item.getComponent().getClassType()) || "com.kingdee.bos.ctrl.web.EditDataGrid".equalsIgnoreCase(item.getComponent().getClassType());
        }
        return false;
    }

    public static boolean isKDTable(ComponentInfo info) {
        if (info == null) {
            return false;
        }
        return "com.kingdee.bos.ctrl.web.DataGrid".equalsIgnoreCase(info.getClassType()) || "com.kingdee.bos.ctrl.web.EditDataGrid".equalsIgnoreCase(info.getClassType());
    }

    public static String getLabel(ComponentInfo component) {
        if ((component = WebUIEditorHelper.getRoundedComponent(component)) != null) {
            String propertyName = WebComponentHelper.getLabelPropertyName(component);
            PropertyInfo prop = component.getProperties().get(propertyName);
            if (prop != null) {
                return prop.getValue();
            }
        }
        return "";
    }

    public static int getLabelLength(ComponentInfo component) {
        PropertyInfo prop;
        if ("com.kingdee.bos.ctrl.web.LabelContainer".equals((component = WebUIEditorHelper.getRoundedComponent(component)).getClassType()) && (prop = component.getPropertyByName("lineWidth")) != null) {
            try {
                return Integer.parseInt(prop.getValue());
            }
            catch (Exception e) {
                logger.error((Object)"error when getLabelLength : ", (Throwable)e);
            }
        }
        return -1;
    }

    public static String getUIModelXml(WebUIObjectInfo uiObj) throws DataAccessException, UnsupportedEncodingException {
        if (uiObj == null) {
            return "";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(16384);
        new UIObjectCtrl(ContextManager.getContext()).store((IObjectValue)uiObj, (OutputStream)out);
        return new String(out.toByteArray(), "UTF-8");
    }

    public static String getRuleSetXml(RuleSetInfo ruleSet) throws DataAccessException, UnsupportedEncodingException {
        if (ruleSet == null) {
            return "";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(16384);
        new RuleSetCtrl(ContextManager.getContext()).store((IObjectValue)ruleSet, (OutputStream)out);
        return new String(out.toByteArray(), "UTF-8");
    }

    public static Document getUIModelDocument(WebUIObjectInfo uiObj) throws DataAccessException, UnsupportedEncodingException {
        String xml = WebUIEditorHelper.getUIModelXml(uiObj);
        if (StringUtils.isEmpty((String)xml)) {
            return null;
        }
        SAXBuilder sb = new SAXBuilder();
        Document doc = null;
        try {
            doc = sb.build((Reader)new StringReader(xml));
        }
        catch (Exception e) {
            logger.error((Object)"getUIModelDocument error:", (Throwable)e);
        }
        return doc;
    }

    public static WebUILayoutConfigInfo loadConfigureInfo(String configJson) {
        try {
            WebUILayoutConfigInfo info = WebUILayoutConfigInfo.toUILayoutConfigInfo((String)configJson);
            return info;
        }
        catch (Exception e) {
            ExceptionHandler.handleError(null, e, "\u52a0\u8f7d\u5e03\u5c40\u914d\u7f6e\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
            return null;
        }
    }

    public static RuleSetInfo loadRuleSet(String ruleSetXml) {
        RuleSetInfo ruleSet = null;
        if (!StringUtils.isEmpty((String)ruleSetXml)) {
            try {
                ruleSet = (RuleSetInfo)new RuleSetCtrl(ContextManager.getContext()).load((InputStream)new ByteArrayInputStream(ruleSetXml.getBytes("UTF-8")));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return ruleSet;
    }

    public static WebUIObjectInfo loadUIObject(MetaDataPK pk, Project depend) {
        WebUIObjectInfo uiObj = null;
        if (pk != null) {
            try {
                uiObj = UictUtils.loadWebUI((IMetaDataPK)pk, depend);
                if (!uiObj.isAssembled()) {
                    uiObj = WebUIObjectAssembler.assembleUI((Context)ContextManager.getContext(), (WebUIObjectInfo)uiObj);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return uiObj;
    }

    public static void storeConfigureModel(WebUIObjectInfo uiModel, EditUIConfigureInfo configure, WebTreeNode root) throws Exception {
        WebUILayoutConfigInfo uiObj = new WebUILayoutConfigInfo(uiModel.getPackage(), uiModel.getName(), uiModel.getAlias());
        WebUIEditorHelper.adjustComponents(uiObj, root);
        configure.setUIObject(uiObj.toJSONObject().toString());
    }

    public static void storeConfigureModel(WebUIObjectInfo uiModel, EditUIConfigureInfo configure, WebTreeNode root, BizUnitInfo bizunit) throws Exception {
        WebUIEditorHelper.storeConfigureModel(uiModel, configure, root);
        RuleSetInfo ruleset = WebUIEditorHelper.createRuleSet(root, bizunit);
        try {
            String xml = WebUIEditorHelper.getRuleSetXml(ruleset);
            configure.setBizRuleSet(xml);
        }
        catch (Exception e1) {
            logger.error((Object)e1, (Throwable)e1);
        }
    }

    public static RuleSetInfo createRuleSet(ComponentTreeNode root, BizUnitInfo bizUnit) {
        if (bizUnit == null || bizUnit.getWebEditUI() == null) {
            return null;
        }
        WebUIObjectInfo uiModel = bizUnit.getWebEditUI();
        RuleSetInfo ruleSet = new RuleSetInfo();
        ruleSet.setPackage(uiModel.getPackage());
        ruleSet.setName(uiModel.getName() + "RuleSetRT");
        HashMap configureItems = new HashMap();
        WebUIEditorHelper.createConfigureItemMap(root, configureItems);
        for (String key : configureItems.keySet()) {
            AbstractBizConfigureItemCollection col = (AbstractBizConfigureItemCollection)((Object)configureItems.get(key));
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                AbstractBizConfigureItemInfo item = col.get(i);
                String eventObjectName = item.getName();
                WebUIEditorHelper.extractRulesFromEventDef(bizUnit, ruleSet, item, eventObjectName);
            }
        }
        return ruleSet;
    }

    private static void extractRulesFromEventDef(BizUnitInfo bizUnit, RuleSetInfo ruleSet, AbstractBizConfigureItemInfo configureItem, String eventObjectName) {
        BizConfigureEventCollection eventConfigureCol = configureItem.getConfigureEventCollection();
        if (eventConfigureCol != null) {
            try {
                ConditionRuleInfo conditionRuleInfo = null;
                int m = eventConfigureCol.size();
                for (int i = 0; i < m; ++i) {
                    conditionRuleInfo = BizEventDefHelper.createRuleFromEventInfo(bizUnit, eventObjectName, eventConfigureCol.get(i));
                    ruleSet.getRules().add((AbstractRuleInfo)conditionRuleInfo);
                }
            }
            catch (BIMException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private static void createConfigureItemMap(ComponentTreeNode root, Map configureItems) {
        AbstractBizConfigureItemCollection detailItems;
        if (configureItems.get("this") != null) {
            detailItems = (AbstractBizConfigureItemCollection)((Object)configureItems.get("this"));
        } else {
            detailItems = new AbstractBizConfigureItemCollection();
            configureItems.put("this", detailItems);
        }
        int m = root.getConfigureItems().size();
        for (int j = 0; j < m; ++j) {
            detailItems.add(root.getConfigureItems().get(j));
        }
        int n = root.getChildCount();
        for (int i = 0; i < n; ++i) {
            ComponentTreeNode treeNode = (ComponentTreeNode)((Object)root.getChildAt(i));
            if (treeNode.getUserObject() == null) continue;
            detailItems = new AbstractBizConfigureItemCollection();
            if (!(treeNode.getUserObject() instanceof ComponentInfo)) continue;
            WebUIEditorHelper.createConfigureItemMap(treeNode, configureItems);
        }
    }

    public static void adjustComponents(WebUILayoutConfigInfo uiObj, WebTreeNode parent) {
        if (parent != null) {
            int i;
            ComponentInfo pInfo;
            if (parent.getUserObject() instanceof ComponentInfo && "com.kingdee.bos.ctrl.web.TabbedPane".equals((pInfo = (ComponentInfo)parent.getUserObject()).getClassType())) {
                WebTabbedPaneConfigInfo tabbedpaneCfgInfo = new WebTabbedPaneConfigInfo();
                tabbedpaneCfgInfo.setName(pInfo.getName());
                WebUIEditorHelper.saveTabOrder(parent, pInfo, tabbedpaneCfgInfo);
                uiObj.addTabbedPaneConfig(tabbedpaneCfgInfo);
            }
            int n = parent.getConfigureItems().size();
            for (i = 0; i < n; ++i) {
                WebItemInfo item = (WebItemInfo)parent.getConfigureItems().get(i);
                ComponentInfo cInfo = item.getComponent();
                if (cInfo == null) continue;
                if ("com.kingdee.bos.ctrl.web.DataGrid".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.web.EditDataGrid".equals(cInfo.getClassType())) {
                    WebDataGridConfigInfo tableCfgInfo = new WebDataGridConfigInfo();
                    tableCfgInfo.setName(cInfo.getName());
                    WebUIEditorHelper.saveDataGridColumnOrder(cInfo, tableCfgInfo);
                    uiObj.addDataGridConfig(tableCfgInfo);
                }
                WebUIComponentConfigInfo cfgComponent = new WebUIComponentConfigInfo();
                cfgComponent.setName(cInfo.getName());
                if (!WebUIEditorHelper.needRecord(item, parent, cfgComponent)) continue;
                uiObj.addMainPanelComponentConfig(cfgComponent);
            }
            n = parent.getChildCount();
            for (i = 0; i < n; ++i) {
                WebUIEditorHelper.adjustComponents(uiObj, (WebTreeNode)((Object)parent.getChildAt(i)));
            }
        }
    }

    public static void adjustComponents4Base(WebUIObjectInfo uiObj, WebTreeNode parent) {
        if (parent != null) {
            int i;
            int n = parent.getConfigureItems().size();
            for (i = 0; i < n; ++i) {
                ComponentInfo newParent;
                WebItemInfo item = (WebItemInfo)parent.getConfigureItems().get(i);
                Object constraint = WebUIEditorHelper.getConstraint(item.getComponent());
                if (WebUIEditorHelper.isChangeContainer(item.getComponent(), parent.getName()) && (newParent = WebUIProxyHelper.findControlByName((WebUIObjectInfo)uiObj, (String)parent.getName())) != null) {
                    ComponentInfo round = WebUIEditorHelper.getRoundedComponent(item.getComponent());
                    WebUIEditorHelper.addChild(uiObj, newParent, round);
                    round.setOverrideConstraint(true);
                    round.setOverrideParent(true);
                }
                if (item.getConstraint() != null && !item.getConstraint().equals(constraint)) {
                    WebUIEditorHelper.setComponentConstraints(item.getComponent(), item.getConstraint());
                }
                WebUIEditorHelper.setComponentLabel(item);
            }
            n = parent.getChildCount();
            for (i = 0; i < n; ++i) {
                WebUIEditorHelper.adjustComponents4Base(uiObj, (WebTreeNode)((Object)parent.getChildAt(i)));
            }
        }
    }

    private static void addChild(WebUIObjectInfo uiModel, ComponentInfo parent, ComponentInfo child) {
        ComponentInfo oldParent = child.getParent();
        if (parent == oldParent) {
            return;
        }
        if (oldParent != null) {
            oldParent.removeChild((AbstractUIObjectInfo)uiModel, child);
        }
        parent.addChild((AbstractUIObjectInfo)uiModel, child);
    }

    private static boolean needRecord(WebItemInfo item, WebTreeNode parent, WebUIComponentConfigInfo cfgInfo) {
        boolean ret = false;
        if (item != null && item.getComponent() != null && parent != null && cfgInfo != null) {
            Object constraint = WebUIEditorHelper.getConstraint(item.getComponent());
            if (constraint != null && item.getConstraint() != null && !constraint.equals(item.getConstraint())) {
                cfgInfo.setConstraint(ConstraintUtil.getStoreConstraint(item.getConstraint()));
                ret = true;
            }
            if (WebUIEditorHelper.isChangeContainer(item.getComponent(), parent.getName())) {
                cfgInfo.setContainer(parent.getName());
                ret = true;
            }
            if (item.getLabelLength() != WebUIEditorHelper.getLabelLength(item.getComponent())) {
                cfgInfo.setLabelLength(item.getLabelLength());
                ret = true;
            }
            if (!item.isVisible()) {
                cfgInfo.setVisable(false);
                ret = true;
            }
            if ("com.kingdee.bos.ctrl.web.Column".equalsIgnoreCase(item.getComponent().getClassType()) || "com.kingdee.bos.ctrl.web.EditableColumn".equalsIgnoreCase(item.getComponent().getClassType())) {
                cfgInfo.setVisable(item.isVisible());
                ret = true;
            }
        }
        return ret;
    }

    private static void saveTabOrder(WebTreeNode tabNode, ComponentInfo tabbedpane, WebTabbedPaneConfigInfo cfgInfo) {
        if (tabNode != null && tabbedpane != null && cfgInfo != null) {
            List nodes = tabNode.getNodeChildren();
            StringBuffer sb = new StringBuffer();
            logger.info((Object)("------------- save " + tabbedpane.getName() + " tab order ---------------"));
            int size = nodes.size();
            for (int i = 0; i < size; ++i) {
                WebTreeNode item = (WebTreeNode)((Object)nodes.get(i));
                if (i == 0) {
                    sb.append(item.getName());
                    continue;
                }
                sb.append("|" + item.getName());
            }
            cfgInfo.setTabOrder(sb.toString());
            logger.info((Object)(tabbedpane.getName() + ":" + sb.toString()));
        }
    }

    private static void loadTabOrder(WebTreeNode tabNode, ComponentInfo tabbedpane, WebTabbedPaneConfigInfo cfgInfo) {
        String order;
        if (tabNode != null && tabbedpane != null && cfgInfo != null && !cfgInfo.getTabOrder().isNull() && !StringUtils.isEmpty((String)(order = cfgInfo.getTabOrder().getValue()))) {
            logger.info((Object)("------------- load " + tabbedpane.getName() + " tab order ---------------"));
            logger.info((Object)(tabbedpane.getName() + ":" + order));
            String[] orders = order.split("\\|");
            ArrayList<String> listColumnNames = new ArrayList<String>(orders.length);
            int size = orders.length;
            for (int j = 0; j < size; ++j) {
                listColumnNames.add(orders[j]);
            }
            int m = 0;
            List nodes = tabNode.getNodeChildren();
            int size2 = listColumnNames.size();
            for (int j = 0; j < size2; ++j) {
                int index = WebUIEditorHelper.getTabIndex(nodes, listColumnNames.get(j).toString());
                if (index == -1) continue;
                WebTreeNode tmp = (WebTreeNode)((Object)nodes.get(index));
                nodes.remove(index);
                nodes.add(m, tmp);
                ++m;
            }
            tabNode.resetChildNode(nodes);
        }
    }

    private static int getTabIndex(List nodes, String name) {
        if (nodes != null && !StringUtils.isEmpty((String)name)) {
            int size = nodes.size();
            for (int i = 0; i < size; ++i) {
                if (!name.equals(((WebTreeNode)((Object)nodes.get(i))).getName())) continue;
                return i;
            }
        }
        return -1;
    }

    private static void saveDataGridColumnOrder(ComponentInfo grid, WebDataGridConfigInfo cfgInfo) {
        if (grid != null && cfgInfo != null) {
            StringBuffer sb = new StringBuffer();
            logger.info((Object)("------------- save " + grid.getName() + " column order ---------------"));
            ComponentCollection columns = grid.getComponents();
            int size = columns.size();
            for (int i = 0; i < size; ++i) {
                ComponentInfo columnInfo = columns.get(i);
                if (i == 0) {
                    sb.append(columnInfo.getName());
                    continue;
                }
                sb.append("|" + columnInfo.getName());
            }
            cfgInfo.setColumnOrder(sb.toString());
            logger.info((Object)(grid.getName() + ":" + sb.toString()));
        }
    }

    private static void loadDataGridColumnOrder(ComponentInfo table, WebDataGridConfigInfo cfgInfo) {
        String order;
        if (table != null && cfgInfo != null && !cfgInfo.getColumnOrder().isNull() && !StringUtils.isEmpty((String)(order = cfgInfo.getColumnOrder().getValue()))) {
            logger.info((Object)("------------- load " + table.getName() + " column order ---------------"));
            logger.info((Object)(table.getName() + ":" + order));
            String[] orders = order.split("\\|");
            ArrayList<String> listColumnNames = new ArrayList<String>(orders.length);
            int size = orders.length;
            for (int j = 0; j < size; ++j) {
                listColumnNames.add(orders[j]);
            }
            WebUIEditorHelper.reOrderDataGrid(table, listColumnNames);
        }
    }

    public static void reOrderDataGrid(ComponentInfo grid, List list) {
        if (grid == null || list == null) {
            return;
        }
        int m = 0;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            int index = WebUIEditorHelper.getColumnIndexByName(grid, list.get(i).toString());
            if (index == -1) continue;
            WebUIEditorHelper.moveDataGridColumn(grid, index, m);
            ++m;
        }
    }

    public static int getColumnIndexByName(ComponentInfo grid, String columnName) {
        if (grid == null || StringUtils.isEmpty((String)columnName)) {
            return -1;
        }
        ComponentCollection col = grid.getComponents();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            ComponentInfo con = col.get(i);
            if (!columnName.equals(con.getName())) continue;
            return i;
        }
        return -1;
    }

    public static void moveDataGridColumn(ComponentInfo grid, int from, int to) {
        if (grid != null && from >= 0 && to >= 0 && from != to) {
            ComponentCollection collection = grid.getComponents();
            collection.move(from, to);
            for (int i = 0; i < collection.size(); ++i) {
                collection.get(i).setExtendedProperty("order", String.valueOf(i));
            }
        }
    }

    private static boolean isChangeContainer(ComponentInfo component, String currentContainer) {
        return component != null && (component = WebUIEditorHelper.getRoundedComponent(component)).getParent() != null && currentContainer != null && !currentContainer.equals(component.getParent().getName());
    }

    public static boolean isVisible(WebItemInfo item) {
        if (item == null) {
            return false;
        }
        if (item.getComponent() != null) {
            return WebUIEditorHelper.isVisible(item.getComponent());
        }
        return false;
    }

    private static boolean isVisible(ComponentInfo component) {
        ComponentInfo parent;
        String propValue;
        PropertyInfo prop = component.getPropertyByName("visible");
        if (prop != null && (propValue = prop.getValue()) != null && propValue.equalsIgnoreCase("true") && (parent = WebUIEditorHelper.getRoundedComponent(component)) != component) {
            return WebUIEditorHelper.isVisible(parent);
        }
        return false;
    }

    public static ComponentInfo getRoundedComponent(ComponentInfo component) {
        if (component != null && component.getParent() != null && "com.kingdee.bos.ctrl.web.LabelContainer".equalsIgnoreCase(component.getParent().getClassType())) {
            component = component.getParent();
        }
        return component;
    }

    public static void setComponentConstraints(ComponentInfo component, Object constraint) {
        if (component == null) {
            return;
        }
        ComponentInfo container = (component = WebUIEditorHelper.getRoundedComponent(component)).getParent();
        LayoutInfo layout = container.getLayoutInfo();
        String layoutType = layout.getType();
        if ("SmartLayout".equalsIgnoreCase(layoutType) && constraint instanceof SmartLayoutData) {
            component.setConstraint(constraint);
            if (component.isHerited()) {
                component.setOverrideConstraint(true);
            }
        } else if ("WebLayout".equalsIgnoreCase(layoutType) && constraint instanceof WebLayoutData) {
            component.setConstraint(constraint);
            if (component.isHerited()) {
                component.setOverrideConstraint(true);
            }
        } else if ("WebToolBarLayout".equalsIgnoreCase(layoutType) && constraint instanceof Integer) {
            component.setConstraint(constraint);
            if (component.isHerited()) {
                component.setOverrideConstraint(true);
            }
        }
    }

    public static void setComponentLabel(WebItemInfo item) {
        if (item == null) {
            return;
        }
        ComponentInfo component = item.getComponent();
        if ((component = WebUIEditorHelper.getRoundedComponent(component)) != null) {
            if ("com.kingdee.bos.ctrl.web.Label".equals(component.getClassType())) {
                WebComponentHelper.setPropertyValue(component, "value", item.getLabel());
            } else if ("com.kingdee.bos.ctrl.web.Button".equals(component.getClassType())) {
                WebComponentHelper.setPropertyValue(component, "label", item.getLabel());
            } else if ("com.kingdee.bos.ctrl.web.RadioButton".equals(component.getClassType())) {
                WebComponentHelper.setPropertyValue(component, "value", item.getLabel());
            } else if ("com.kingdee.bos.ctrl.web.CheckBox".equals(component.getClassType())) {
                WebComponentHelper.setPropertyValue(component, "boxLabel", item.getLabel());
            } else if ("com.kingdee.bos.ctrl.web.LabelContainer".equals(component.getClassType())) {
                WebComponentHelper.setPropertyValue(component, "caption", item.getLabel());
                WebComponentHelper.setPropertyValue(component, "lineWidth", new Integer(item.getLabelLength()));
            } else if ("com.kingdee.bos.ctrl.web.Container".equals(component.getClassType())) {
                WebComponentHelper.setPropertyValue(component, "caption", item.getLabel());
            } else if ("com.kingdee.bos.ctrl.web.Composite".equals(component.getClassType())) {
                WebComponentHelper.setPropertyValue(component, "title", item.getLabel());
            } else if ("com.kingdee.bos.ctrl.web.Column".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.EditableColumn".equals(component.getClassType())) {
                WebComponentHelper.setPropertyValue(component, "header", item.getLabel());
            }
        }
    }

    public static int getMaxHeight(WebTreeNode node) {
        WebItemCollection col;
        int maxHeight = 0;
        if (node != null && (col = (WebItemCollection)node.getConfigureItems()) != null) {
            int conY = 0;
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                WebItemInfo item = (WebItemInfo)col.get(i);
                Object bound = item.getConstraint();
                if (bound instanceof SmartLayoutData) {
                    conY = ((SmartLayoutData)bound).y + ((WebLayoutData)bound).height;
                } else {
                    if (!(bound instanceof WebLayoutData)) continue;
                    conY = ((WebLayoutData)bound).height;
                }
                maxHeight = maxHeight < conY ? conY : maxHeight;
            }
        }
        return maxHeight;
    }

    public static void buildCreateCtrlMenu(AbstractWebEditPartViewer viewer, KDPopupMenu popMenu) {
        WebUIObjectInfo ui = (WebUIObjectInfo)viewer.getContext().getUiModel();
        JMenu bizCtrl = new JMenu("\u5b57\u6bb5\u63a7\u4ef6");
        WebCreateAction textFieldAction = new WebCreateAction(viewer, "TextField", "designer/KDTextField.gif");
        JMenuItem textField = bizCtrl.add(textFieldAction);
        textField.setText("\u6587\u672c\u63a7\u4ef6");
        WebCreateAction textAreaAction = new WebCreateAction(viewer, "TextArea", "designer/KDTextArea.gif");
        JMenuItem textArea = bizCtrl.add(textAreaAction);
        textArea.setText("\u5907\u6ce8\u63a7\u4ef6");
        WebCreateAction numberAction = new WebCreateAction(viewer, "Number", "designer/KDNumberTextField.gif");
        JMenuItem number = bizCtrl.add(numberAction);
        number.setText("\u6570\u5b57\u63a7\u4ef6");
        WebCreateAction dateAction = new WebCreateAction(viewer, "Date", "designer/KDDatePicker.gif");
        JMenuItem date = bizCtrl.add(dateAction);
        date.setText("\u65e5\u671f\u63a7\u4ef6");
        WebCreateAction timeAction = new WebCreateAction(viewer, "Time", "designer/KDTimePicker.gif");
        JMenuItem time = bizCtrl.add(timeAction);
        time.setText("\u65f6\u95f4\u63a7\u4ef6");
        time.setEnabled(false);
        WebCreateAction boolAction = new WebCreateAction(viewer, "Bool", "designer/KDCheckBox.gif");
        JMenuItem bool = bizCtrl.add(boolAction);
        bool.setText("\u5e03\u5c14\u63a7\u4ef6");
        WebCreateAction enumsAction = new WebCreateAction(viewer, "Enum", "designer/KDComboBox.gif");
        JMenuItem enums = bizCtrl.add(enumsAction);
        enums.setText("\u679a\u4e3e\u63a7\u4ef6");
        WebCreateAction f7Action = new WebCreateAction(viewer, "F7", "designer/KDBizPromptBox.gif");
        JMenuItem f7 = bizCtrl.add(f7Action);
        f7.setText("f7\u63a7\u4ef6");
        JMenu baseCtrl = new JMenu("\u57fa\u672c\u63a7\u4ef6");
        WebCreateAction kdBtnAction = new WebCreateAction(viewer, "com.kingdee.bos.ctrl.web.Button", "designer/KDButton.gif");
        JMenuItem kdBtn = baseCtrl.add(kdBtnAction);
        kdBtn.setText("Button\u63a7\u4ef6");
        WebCreateAction kdLabelAction = new WebCreateAction(viewer, "com.kingdee.bos.ctrl.web.Label", "designer/KDLabel.gif");
        JMenuItem kdLabel = baseCtrl.add(kdLabelAction);
        kdLabel.setText("Label\u63a7\u4ef6");
        WebCreateAction kdSeparatorAction = new WebCreateAction(viewer, "com.kingdee.bos.ctrl.web.Separator", "designer/KDSeparator.gif");
        JMenuItem kdSeparator = baseCtrl.add(kdSeparatorAction);
        kdSeparator.setText("\u5206\u9694\u63a7\u4ef6");
        WebCreateAction dataGridAction = new WebCreateAction(viewer, "com.kingdee.bos.ctrl.web.DataGrid", "designer/KDTable.gif");
        JMenuItem dataGrid = baseCtrl.add(dataGridAction);
        dataGrid.setText("\u666e\u901a\u8868\u683c\u63a7\u4ef6");
        WebCreateAction editDataGridAction = new WebCreateAction(viewer, "com.kingdee.bos.ctrl.web.EditDataGrid", "designer/KDTable.gif");
        JMenuItem editDataGrid = baseCtrl.add(editDataGridAction);
        editDataGrid.setText("\u7f16\u8f91\u8868\u683c\u63a7\u4ef6");
        JMenu containerCtrl = new JMenu("\u5bb9\u5668\u63a7\u4ef6");
        WebCreateAction kdPanelAction = new WebCreateAction(viewer, "com.kingdee.bos.ctrl.web.FreePanel", "designer/KDPanel.gif");
        JMenuItem kdPanel = containerCtrl.add(kdPanelAction);
        kdPanel.setText("FreePanel\u63a7\u4ef6");
        WebCreateAction kdContainerAction = new WebCreateAction(viewer, "com.kingdee.bos.ctrl.web.Composite", "designer/KDContainer.gif");
        JMenuItem kdContainer = containerCtrl.add(kdContainerAction);
        kdContainer.setText("Composite\u63a7\u4ef6");
        WebCreateAction kdTabbedPaneAction = new WebCreateAction(viewer, "com.kingdee.bos.ctrl.web.TabbedPane", "designer/KDTabbedPane.gif");
        JMenuItem kdTabbedPane = containerCtrl.add(kdTabbedPaneAction);
        kdTabbedPane.setText("\u9875\u7b7e\u63a7\u4ef6");
        popMenu.add((JMenuItem)bizCtrl);
        popMenu.add((JMenuItem)baseCtrl);
        popMenu.add((JMenuItem)containerCtrl);
        if (ui.getName().endsWith("ListUI")) {
            bizCtrl.setVisible(false);
            editDataGrid.setEnabled(false);
            dataGrid.setEnabled(false);
        }
        editDataGrid.setEnabled(false);
        dataGrid.setEnabled(false);
    }

    public static ActionRegistry buildColumnMenu(AbstractWebEditPartViewer viewer, DataGridDesignerUI designer, KDPopupMenu popMenu) {
        ActionRegistry actionRegistry = new ActionRegistry();
        WebCreateColumnAction columnAction = new WebCreateColumnAction(viewer, designer, "Column", "designer/KDTable.gif");
        actionRegistry.registerAction(columnAction);
        JMenuItem columnField = popMenu.add((Action)columnAction);
        columnAction.addRelateComponent(columnField);
        columnField.setText("\u4e0d\u53ef\u7f16\u8f91\u5217");
        WebCreateColumnAction textFieldAction = new WebCreateColumnAction(viewer, designer, "TextFieldColumn", "designer/KDTextField.gif");
        actionRegistry.registerAction(textFieldAction);
        JMenuItem textField = popMenu.add((Action)textFieldAction);
        textFieldAction.addRelateComponent(textField);
        textField.setText("\u6587\u672c\u5217");
        WebCreateColumnAction numberAction = new WebCreateColumnAction(viewer, designer, "NumberColumn", "designer/KDNumberTextField.gif");
        actionRegistry.registerAction(numberAction);
        JMenuItem number = popMenu.add((Action)numberAction);
        numberAction.addRelateComponent(number);
        number.setText("\u6570\u5b57\u5217");
        WebCreateColumnAction dateAction = new WebCreateColumnAction(viewer, designer, "DateColumn", "designer/KDDatePicker.gif");
        actionRegistry.registerAction(dateAction);
        JMenuItem date = popMenu.add((Action)dateAction);
        dateAction.addRelateComponent(date);
        date.setText("\u65e5\u671f\u5217");
        WebCreateColumnAction boolAction = new WebCreateColumnAction(viewer, designer, "BoolColumn", "designer/KDCheckBox.gif");
        actionRegistry.registerAction(boolAction);
        JMenuItem bool = popMenu.add((Action)boolAction);
        boolAction.addRelateComponent(bool);
        bool.setText("\u5e03\u5c14\u5217");
        WebCreateColumnAction enumsAction = new WebCreateColumnAction(viewer, designer, "EnumColumn", "designer/KDComboBox.gif");
        actionRegistry.registerAction(enumsAction);
        JMenuItem enums = popMenu.add((Action)enumsAction);
        enumsAction.addRelateComponent(enums);
        enums.setText("\u679a\u4e3e\u5217");
        WebCreateColumnAction f7Action = new WebCreateColumnAction(viewer, designer, "F7Column", "designer/KDBizPromptBox.gif");
        actionRegistry.registerAction(f7Action);
        JMenuItem f7 = popMenu.add((Action)f7Action);
        f7Action.addRelateComponent(f7);
        f7.setText("f7\u5217");
        return actionRegistry;
    }

    public static com.kingdee.bos.metadata.entity.PropertyInfo getBindingProperty(ComponentInfo control, EntityObjectInfo entity) {
        if (control == null || control.getClassType() == null || entity == null) {
            return null;
        }
        String propertyName = "value";
        com.kingdee.bos.metadata.entity.PropertyInfo proInfo = null;
        PropertyBindingCollection pbCol = control.getPropertyBindings();
        int size = pbCol.size();
        for (int j = 0; j < size; ++j) {
            PropertyBindingInfo pbInfo = pbCol.get(j);
            if (!propertyName.equalsIgnoreCase(pbInfo.getPropertyName())) continue;
            String bindingField = pbInfo.getBingdingField();
            proInfo = WebEditUIProxyHelper.getPropertyByName((EntityObjectInfo)entity, (String)bindingField);
            break;
        }
        return proInfo;
    }

    public static com.kingdee.bos.metadata.entity.PropertyInfo getColumnBindProperty(EntityObjectInfo entity, ComponentInfo cInfo, String columnName) {
        if (entity == null || cInfo == null || StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        String tableColumnName = "";
        int n = cInfo.getPropertyBindings().size();
        for (int j = 0; j < n; ++j) {
            PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(j);
            if (pbInfo.getPropertyName().indexOf(".text") < 0 || !(tableColumnName = StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"")).equalsIgnoreCase(columnName)) continue;
            String sbindField = pbInfo.getBingdingField();
            return WebEditUIProxyHelper.getPropertyByName((EntityObjectInfo)entity, (String)sbindField);
        }
        return null;
    }

    public static void extraBizUnit(BizUnitInfo biz, WebUIObjectInfo ui) {
        if (biz != null && ui != null) {
            try {
                BizFieldCollection bizFields = new BizFieldCollection();
                BizUnitCtrl bizUnitCtrl = new BizUnitCtrl(ContextManager.getContext());
                bizUnitCtrl.extractEntityFieldsFromBizUnit(biz, bizFields);
                bizUnitCtrl.extractWebEditUIControls(ui, bizFields, biz.getEntity(), null);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    public static void print(WebTreeNode node, int deep) {
        String tab = "";
        for (int i = 0; i <= deep; ++i) {
            tab = tab + "\t";
        }
        logger.info((Object)(tab + node.getName() + ((ComponentInfo)node.getUserObject()).getClassType()));
        WebItemCollection col = (WebItemCollection)node.getConfigureItems();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            WebItemInfo item = (WebItemInfo)col.get(i);
            logger.info((Object)(tab + "[" + item.getName() + "-" + item.getConstraint() + "]"));
        }
        int size2 = node.getChildCount();
        for (int i = 0; i < size2; ++i) {
            WebUIEditorHelper.print((WebTreeNode)((Object)node.getChildAt(i)), deep + 1);
        }
    }

    public static void printUIDom(ComponentInfo cInfo, int deep) {
        if (cInfo == null) {
            return;
        }
        String tab = "";
        for (int i = 0; i <= deep; ++i) {
            tab = tab + "\t";
        }
        logger.info((Object)(tab + "[" + cInfo.getName() + "-" + cInfo.getConstraint() + "-" + cInfo.getClassType() + "]"));
        ComponentCollection col = cInfo.getComponents();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            ComponentInfo item = col.get(i);
            WebUIEditorHelper.printUIDom(item, deep + 1);
        }
    }
}

