/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.analysis;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.ep.analysis.Token;
import org.apache.lucene.ep.analysis.TokenFilter;
import org.apache.lucene.ep.analysis.TokenStream;
import org.apache.lucene.ep.util.AttributeSource;

public class CachingTokenFilter
extends TokenFilter {
    private List cache = null;
    private Iterator iterator = null;
    private AttributeSource.State finalState;

    public CachingTokenFilter(TokenStream input) {
        super(input);
    }

    @Override
    public final Token next(Token reusableToken) throws IOException {
        return super.next(reusableToken);
    }

    @Override
    public final Token next() throws IOException {
        return super.next();
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.cache == null) {
            this.cache = new LinkedList();
            this.fillCache();
            this.iterator = this.cache.iterator();
        }
        if (!this.iterator.hasNext()) {
            return false;
        }
        this.restoreState((AttributeSource.State)this.iterator.next());
        return true;
    }

    @Override
    public final void end() throws IOException {
        if (this.finalState != null) {
            this.restoreState(this.finalState);
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.cache != null) {
            this.iterator = this.cache.iterator();
        }
    }

    private void fillCache() throws IOException {
        while (this.input.incrementToken()) {
            this.cache.add(this.captureState());
        }
        this.input.end();
        this.finalState = this.captureState();
    }
}

