/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import java.io.IOException;
import org.apache.lucene.ep.index.FieldInfo;
import org.apache.lucene.ep.index.FormatPostingsDocsConsumer;
import org.apache.lucene.ep.index.FormatPostingsDocsWriter;
import org.apache.lucene.ep.index.FormatPostingsFieldsWriter;
import org.apache.lucene.ep.index.FormatPostingsTermsConsumer;
import org.apache.lucene.ep.index.SegmentWriteState;
import org.apache.lucene.ep.index.TermInfosWriter;

final class FormatPostingsTermsWriter
extends FormatPostingsTermsConsumer {
    final FormatPostingsFieldsWriter parent;
    final FormatPostingsDocsWriter docsWriter;
    final TermInfosWriter termsOut;
    FieldInfo fieldInfo;
    char[] currentTerm;
    int currentTermStart;
    long freqStart;
    long proxStart;

    FormatPostingsTermsWriter(SegmentWriteState state, FormatPostingsFieldsWriter parent) throws IOException {
        this.parent = parent;
        this.termsOut = parent.termsOut;
        this.docsWriter = new FormatPostingsDocsWriter(state, this);
    }

    void setField(FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        this.docsWriter.setField(fieldInfo);
    }

    @Override
    FormatPostingsDocsConsumer addTerm(char[] text, int start) {
        this.currentTerm = text;
        this.currentTermStart = start;
        this.freqStart = this.docsWriter.out.getFilePointer();
        if (this.docsWriter.posWriter.out != null) {
            this.proxStart = this.docsWriter.posWriter.out.getFilePointer();
        }
        this.parent.skipListWriter.resetSkip();
        return this.docsWriter;
    }

    @Override
    void finish() {
    }

    void close() throws IOException {
        this.docsWriter.close();
    }
}

