/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import java.io.IOException;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.index.Term;
import org.apache.lucene.ep.index.TermEnum;
import org.apache.lucene.ep.index.TermPositions;

final class SegmentMergeInfo {
    Term term;
    int base;
    int ord;
    TermEnum termEnum;
    IndexReader reader;
    int delCount;
    private TermPositions postings;
    private int[] docMap;

    SegmentMergeInfo(int b, TermEnum te, IndexReader r) throws IOException {
        this.base = b;
        this.reader = r;
        this.termEnum = te;
        this.term = te.term();
    }

    int[] getDocMap() {
        if (this.docMap == null) {
            this.delCount = 0;
            if (this.reader.hasDeletions()) {
                int maxDoc = this.reader.maxDoc();
                this.docMap = new int[maxDoc];
                int j = 0;
                for (int i = 0; i < maxDoc; ++i) {
                    if (this.reader.isDeleted(i)) {
                        ++this.delCount;
                        this.docMap[i] = -1;
                        continue;
                    }
                    this.docMap[i] = j++;
                }
            }
        }
        return this.docMap;
    }

    TermPositions getPositions() throws IOException {
        if (this.postings == null) {
            this.postings = this.reader.termPositions();
        }
        return this.postings;
    }

    final boolean next() throws IOException {
        if (this.termEnum.next()) {
            this.term = this.termEnum.term();
            return true;
        }
        this.term = null;
        return false;
    }

    final void close() throws IOException {
        this.termEnum.close();
        if (this.postings != null) {
            this.postings.close();
        }
    }
}

