/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.search.CachingWrapperFilter;
import org.apache.lucene.ep.search.DocIdSet;
import org.apache.lucene.ep.search.SpanFilter;
import org.apache.lucene.ep.search.SpanFilterResult;

public class CachingSpanFilter
extends SpanFilter {
    protected SpanFilter filter;
    private final CachingWrapperFilter.FilterCache cache;
    int hitCount;
    int missCount;

    public CachingSpanFilter(SpanFilter filter) {
        this(filter, CachingWrapperFilter.DeletesMode.RECACHE);
    }

    public CachingSpanFilter(SpanFilter filter, CachingWrapperFilter.DeletesMode deletesMode) {
        this.filter = filter;
        if (deletesMode == CachingWrapperFilter.DeletesMode.DYNAMIC) {
            throw new IllegalArgumentException("DeletesMode.DYNAMIC is not supported");
        }
        this.cache = new CachingWrapperFilter.FilterCache(deletesMode){

            @Override
            protected Object mergeDeletes(IndexReader r, Object value) {
                throw new IllegalStateException("DeletesMode.DYNAMIC is not supported");
            }
        };
    }

    @Override
    public BitSet bits(IndexReader reader) throws IOException {
        SpanFilterResult result = this.getCachedResult(reader);
        return result != null ? result.getBits() : null;
    }

    @Override
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        SpanFilterResult result = this.getCachedResult(reader);
        return result != null ? result.getDocIdSet() : null;
    }

    private SpanFilterResult getCachedResult(IndexReader reader) throws IOException {
        Object delCoreKey;
        Object coreKey = reader.getFieldCacheKey();
        SpanFilterResult result = (SpanFilterResult)this.cache.get(reader, coreKey, delCoreKey = reader.hasDeletions() ? reader.getDeletesCacheKey() : coreKey);
        if (result != null) {
            ++this.hitCount;
            return result;
        }
        ++this.missCount;
        result = this.filter.bitSpans(reader);
        this.cache.put(coreKey, delCoreKey, result);
        return result;
    }

    @Override
    public SpanFilterResult bitSpans(IndexReader reader) throws IOException {
        return this.getCachedResult(reader);
    }

    public String toString() {
        return "CachingSpanFilter(" + this.filter + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof CachingSpanFilter)) {
            return false;
        }
        return this.filter.equals(((CachingSpanFilter)o).filter);
    }

    public int hashCode() {
        return this.filter.hashCode() ^ 0x1117BF25;
    }
}

