/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import org.apache.lucene.ep.search.Collector;
import org.apache.lucene.ep.search.Explanation;
import org.apache.lucene.ep.search.Scorer;
import org.apache.lucene.ep.search.Similarity;

public class ScoreCachingWrappingScorer
extends Scorer {
    private Scorer scorer;
    private int curDoc = -1;
    private float curScore;

    public ScoreCachingWrappingScorer(Scorer scorer) {
        super(scorer.getSimilarity());
        this.scorer = scorer;
    }

    @Override
    protected boolean score(Collector collector, int max, int firstDocID) throws IOException {
        return this.scorer.score(collector, max, firstDocID);
    }

    @Override
    public Similarity getSimilarity() {
        return this.scorer.getSimilarity();
    }

    @Override
    public Explanation explain(int doc) throws IOException {
        return this.scorer.explain(doc);
    }

    @Override
    public float score() throws IOException {
        int doc = this.scorer.docID();
        if (doc != this.curDoc) {
            this.curScore = this.scorer.score();
            this.curDoc = doc;
        }
        return this.curScore;
    }

    @Override
    public int doc() {
        return this.scorer.doc();
    }

    @Override
    public int docID() {
        return this.scorer.docID();
    }

    @Override
    public boolean next() throws IOException {
        return this.scorer.next();
    }

    @Override
    public int nextDoc() throws IOException {
        return this.scorer.nextDoc();
    }

    @Override
    public void score(Collector collector) throws IOException {
        this.scorer.score(collector);
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        return this.scorer.skipTo(target);
    }

    @Override
    public int advance(int target) throws IOException {
        return this.scorer.advance(target);
    }
}

