/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.recorder;

import com.kingdee.bos.ctrl.analysis.bicomponent.ChartComponent;
import com.kingdee.bos.ctrl.analysis.bicomponent.ComponentConfig;
import com.kingdee.bos.ctrl.analysis.bicomponent.WorksheetComponent;
import com.kingdee.bos.ctrl.analysis.olap.ModelFactory;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDChart;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.dbsource.ArrayTable;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.olap.def.SchemaLoader;
import com.kingdee.bos.olap.mem.OLAPDatabase;
import com.kingdee.bos.olap.mem.OLAPEngine;
import com.kingdee.bos.olap.mem.impl.Aggregators;
import com.kingdee.bos.olap.mem.impl.ConnectionImpl;
import com.kingdee.bos.rpc.analysis.AnalysisResult;
import com.kingdee.bos.rpc.impl.DebugInvoke;
import com.kingdee.bos.rpc.impl.RPCRecordStatus;
import com.kingdee.bos.rpc.impl.RPCRequest;
import com.kingdee.bos.rpc.impl.RPCResult;
import com.kingdee.bos.rpc.impl.RPCSessionImpl;
import com.kingdee.bos.rpcrecorder.SerdeTool;
import com.kingdee.bos.rpcrecorder.def.ScriptDef;
import com.kingdee.bos.rpcrecorder.def.StatementDef;
import com.kingdee.eas.client.recorder.FileChooserUtil;
import com.kingdee.eas.client.recorder.RecorderController;
import com.kingdee.eas.client.recorder.SQLDetailDialog;
import com.kingdee.eas.client.recorder.TransactionInfo;
import com.kingdee.eas.client.recorder.Utils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LoggerItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.jdom2.JDOMException;

public class DetailDialog
extends TypicalDialog {
    SQLDetailDialog sqlDetailDialog;
    KDTable table = new KDTable();
    String[] header = new String[]{"\u4e8b\u4ef6ID", "\u4e8b\u4ef6\u7c7b\u578b", "Model", "Method", "\u5f00\u59cb\u65f6\u95f4", "\u8017\u65f6(\u6beb\u79d2)", "rpc\u8bf7\u6c42", "rpc\u7ed3\u679c", "SQL\u5206\u6790"};
    private KDButton deleteRowButton = new KDButton("\u5220\u9664\u884c");
    private KDButton saveButton = new KDButton("\u4fdd\u5b58\u6027\u80fd\u811a\u672c");
    KDButton playFileButton = new KDButton("\u64ad\u653e\u6027\u80fd\u811a\u672c");
    private KDButton saveResultButton = new KDButton("\u4fdd\u5b58\u5206\u6790\u811a\u672c");
    KDButton openResultButton = new KDButton("\u6253\u5f00\u5206\u6790\u811a\u672c");
    private KDPanel analysisPanel = new KDPanel();
    private KDPanel analysisContentPanel = new KDPanel();
    KDRadioButton rbhaoshi = null;
    KDRadioButton rbcishu = null;
    JPopupMenu popupMenu;
    OlapModel olapModel = null;
    private String lastSavePath = null;
    private List rpcRequests;
    private List transactionInfos;

    public DetailDialog(Frame frame) {
        super(frame);
        this.setTitle("\u8be6\u7ec6\u4fe1\u606f--\u5f53\u524d\u5f55\u5236");
    }

    public DetailDialog(Dialog dialog) {
        super(dialog);
        this.setTitle("\u8be6\u7ec6\u4fe1\u606f--\u5f53\u524d\u5f55\u5236");
    }

    public boolean showDialog() {
        try {
            this.hasOwner = false;
            boolean bl = super.showDialog();
            return bl;
        }
        finally {
            this.hasOwner = true;
        }
    }

    private void addRow(IRow row, RPCRequest request) {
        int index = 0;
        row.getCell(index++, true).setValue(request.eventInfo == null ? null : Integer.valueOf(request.eventInfo.id));
        row.getCell(index++, true).setValue(request.eventInfo == null ? null : request.eventInfo.type);
        row.getCell(index++, true).setValue((Object)request.model.getName());
        row.getCell(index++, true).setValue((Object)request.methodName);
        row.getCell(index++, true).setValue((Object)com.kingdee.bos.rpcrecorder.Utils.formatSimpleTime((long)request.startTime));
        row.getCell(index++, true).setValue((Object)("" + (request.endTime - request.startTime)));
        row.getCell(index++).setValue((Object)new HyperLink("\u67e5\u770b\u8bf7\u6c42", "request"));
        row.getCell(index++).setValue((Object)new HyperLink("\u67e5\u770b\u7ed3\u679c", "result"));
        row.getCell(index++).setValue((Object)new HyperLink(this.getAnalysisText(request), "analysis"));
        row.setUserObject((Object)request);
        if (request.next != null) {
            IRow row2 = this.table.addRow();
            row2.getStyleAttributes().setBackground(Color.PINK);
            this.addRow(row2, request.next);
        }
    }

    private void addRow(IRow row, TransactionInfo tInfo) {
        String value = "";
        value = tInfo.status == 0 ? "\u4e8b\u52a1\u5f00\u59cb" : "\u4e8b\u52a1\u7ed3\u675f";
        value = value + "(" + tInfo.transactionName + ")";
        value = value + ",\u65f6\u95f4\uff1a" + com.kingdee.bos.rpcrecorder.Utils.formatSimpleTime((long)tInfo.timestamp);
        row.getCell(0).setValue((Object)value);
        row.getStyleAttributes().setBackground(Color.green);
        row.setUserObject((Object)tInfo);
    }

    protected void todoInit() {
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        int i;
        this.setBounds(new Rectangle(960, 700));
        KDPanel content = new KDPanel();
        content.setLayout((LayoutManager)new BorderLayout());
        KDSplitPane splitPane = new KDSplitPane();
        content.add((Component)splitPane, (Object)"Center");
        splitPane.setOrientation(0);
        splitPane.add((Component)this.table, (Object)"top");
        splitPane.add((Component)this.analysisPanel, (Object)"bottom");
        splitPane.setDividerLocation(400);
        KDPanel rgp = new KDPanel();
        this.rbhaoshi = new KDRadioButton("\u8017\u65f6\u6392\u540d");
        this.rbcishu = new KDRadioButton("\u8c03\u7528\u6b21\u6570\u6392\u540d");
        rgp.add((Component)this.rbhaoshi);
        rgp.add((Component)this.rbcishu);
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this.rbhaoshi);
        bg.add((AbstractButton)this.rbcishu);
        this.rbhaoshi.setSelected(true);
        this.analysisPanel.setLayout((LayoutManager)new BorderLayout());
        this.analysisPanel.add((Component)rgp, (Object)"North");
        this.analysisPanel.add((Component)this.analysisContentPanel, (Object)"Center");
        this.rbhaoshi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailDialog.this.updateAnalysisPanel();
            }
        });
        this.rbcishu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailDialog.this.updateAnalysisPanel();
            }
        });
        parent.add((Component)content, thisCell);
        IRow headRow = this.table.addHeadRow();
        for (i = 0; i < this.header.length; ++i) {
            this.table.addColumn().setKey("F" + i);
        }
        for (i = 0; i < this.header.length; ++i) {
            headRow.getCell(i).setValue((Object)this.header[i]);
        }
        super.getExtPanel().add((Component)this.deleteRowButton);
        super.getExtPanel().add((Component)this.saveButton);
        super.getExtPanel().add((Component)this.playFileButton);
        super.getExtPanel().add((Component)this.saveResultButton);
        super.getExtPanel().add((Component)this.openResultButton);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailDialog.this.save();
            }
        });
        this.saveResultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailDialog.this.saveResultScript();
            }
        });
        this.openResultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailDialog.this.openResultScript();
            }
        });
        this.playFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailDialog.this.playFile();
            }
        });
        this.deleteRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailDialog.this.deleteRow();
            }
        });
        this.updateTable();
        this.table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                int row = e.getRowIndex();
                int column = e.getColIndex();
                if (row >= 0 && column >= 0) {
                    if (SwingUtilities.isLeftMouseButton((MouseEvent)e)) {
                        DetailDialog.this.cellClicked(DetailDialog.this.table, e.getClickCount() == 2, row, column, e.getOriginView(), e.getX(), e.getY(), e.getType() == 0);
                    } else {
                        DetailDialog.this.popup(DetailDialog.this.table, row, column, e.getOriginView(), e.getX(), e.getY(), e.getType() == 0);
                    }
                }
            }
        });
        this.updateAnalysisPanel();
        Utils.makeCenter((Window)((Object)this));
        this.table.getSelectManager().setSelectMode(10);
        this.sqlDetailDialog = new SQLDetailDialog((Dialog)((Object)this));
    }

    private void popup(KDTable table2, int row, int column, Component originView, int x, int y, boolean b) {
        if (b) {
            return;
        }
        IRow trow = this.getRow(this.table, b, row);
        Object userObject = trow.getUserObject();
        if (userObject instanceof RPCRequest) {
            this.getPopupMenu().show(originView, x, y);
        }
    }

    public JPopupMenu getPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(new AbstractAction("\u91cd\u65b0\u6267\u884c\u8be5\u884c"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailDialog.this.debugInvoke();
            }
        });
        this.popupMenu.add(new AbstractAction("\u5220\u9664\u8be5\u884c"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailDialog.this.deleteRow();
            }
        });
        return this.popupMenu;
    }

    private void debugInvoke() {
        int rowIndex = this.getSelectedRow();
        IRow row = this.table.getRow(rowIndex);
        RPCRequest request = (RPCRequest)row.getUserObject();
        RPCRequest parent = request.parent == null ? request : request.parent;
        request = parent.cloneDebugOne();
        RPCSessionImpl session = Utils.getCurrentSession();
        DebugInvoke invoker = new DebugInvoke(request, session, -10, true);
        try {
            invoker.invoke();
            this.updateTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
        }
    }

    private void updateAnalysisPanel() {
        if (this.rbhaoshi.isSelected()) {
            this.updateAnalysisPanelForHaoshi();
        } else if (this.rbcishu.isSelected()) {
            this.updateAnalysisPanelForCishu();
        }
        this.analysisContentPanel.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAnalysisPanelForCishu() {
        this.analysisContentPanel.removeAll();
        this.analysisContentPanel.setLayout((LayoutManager)new BorderLayout());
        KDTable table = new KDTable();
        this.analysisContentPanel.add((Component)table, (Object)"Center");
        ComponentConfig config = ComponentConfig.getConfig();
        WorksheetComponent worksheetComponent = new WorksheetComponent(table);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("cube2.template");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table_Dim", this.createDimTableForCishu());
        params.put("table_Fact", this.createFactTableForCishu());
        String mdx = "with member rpcmethod.[\u6c47\u603b] as 'sum(rpcmethod.members)' select Measures.members on columns,{rpcmethod.[\u6c47\u603b],order(rpcmethod.members,measures.counts,desc)} on rows from cube";
        try {
            Aggregators a = new Aggregators();
            SchemaDef schemaDef = SchemaLoader.load((InputStream)is);
            OLAPDatabase database = OLAPEngine.buildWithoutCheck((SchemaDef)schemaDef, params);
            ConnectionImpl con = new ConnectionImpl(database);
            OlapModel olapModel = ModelFactory.makeKDOlapModel((Connection)con, (String)mdx);
            worksheetComponent.setModel(olapModel);
        }
        catch (OLAPException e) {
            e.printStackTrace();
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.analysisContentPanel.validate();
        table.getColumn(0).setWidth(500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAnalysisPanelForHaoshi() {
        this.analysisContentPanel.removeAll();
        this.analysisContentPanel.setLayout((LayoutManager)new BorderLayout());
        KDChart chart = new KDChart();
        this.analysisContentPanel.add((Component)chart, (Object)"Center");
        ComponentConfig config = ComponentConfig.getConfig();
        ChartComponent chartComponent = new ChartComponent(chart, config);
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("cube1.template");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table_Dim", this.createDimTable());
        params.put("table_Fact", this.createFactTable());
        String mdx = "select Measures.members on rows,topcount(rpcmethod.members,20,measures.cost) on columns from cube";
        try {
            Aggregators a = new Aggregators();
            SchemaDef schemaDef = SchemaLoader.load((InputStream)is);
            OLAPDatabase database = OLAPEngine.buildWithoutCheck((SchemaDef)schemaDef, params);
            ConnectionImpl con = new ConnectionImpl(database);
            OlapModel olapModel = ModelFactory.makeKDOlapModel((Connection)con, (String)mdx);
            chartComponent.setModel(olapModel);
        }
        catch (OLAPException e) {
            e.printStackTrace();
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private Object createFactTable() {
        String[] columnNames = new String[]{"ID", "Cost"};
        int[] types = new int[]{4, 4};
        int rowCount = this.table.getRowCount();
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (int i = 0; i < rowCount; ++i) {
            Object o = this.table.getRow(i).getUserObject();
            if (o == null || !(o instanceof RPCRequest)) continue;
            RPCRequest request = (RPCRequest)o;
            Object[] rowObject = new Object[]{new Integer(i + 1), new Integer((int)(request.endTime - request.startTime))};
            list.add(rowObject);
        }
        Object[][] oa = new Object[list.size()][];
        list.toArray((T[])oa);
        return new ArrayTable(oa, columnNames, types);
    }

    private Object createDimTable() {
        String[] columnNames = new String[]{"ID", "Caption", "Method"};
        int[] types = new int[]{4, 12, 12};
        int rowCount = this.table.getRowCount();
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (int i = 0; i < rowCount; ++i) {
            Object o = this.table.getRow(i).getUserObject();
            if (o == null || !(o instanceof RPCRequest)) continue;
            RPCRequest request = (RPCRequest)o;
            Object[] rowObject = new Object[]{new Integer(i + 1), "\u7b2c" + (i + 1) + "\u884c", request.model.getName() + "." + request.methodName};
            list.add(rowObject);
        }
        Object[][] oa = new Object[list.size()][];
        list.toArray((T[])oa);
        return new ArrayTable(oa, columnNames, types);
    }

    private Object createFactTableForCishu() {
        String[] columnNames = new String[]{"Name", "Counts", "Times"};
        int[] types = new int[]{12, 4, 4};
        int rowCount = this.table.getRowCount();
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (int i = 0; i < rowCount; ++i) {
            Object o = this.table.getRow(i).getUserObject();
            if (o == null || !(o instanceof RPCRequest)) continue;
            RPCRequest request = (RPCRequest)o;
            Object[] rowObject = new Object[]{request.model.getName() + "." + request.methodName, new Integer(1), new Integer((int)(request.endTime - request.startTime))};
            list.add(rowObject);
        }
        Object[][] oa = new Object[list.size()][];
        list.toArray((T[])oa);
        return new ArrayTable(oa, columnNames, types);
    }

    private Object createDimTableForCishu() {
        String[] columnNames = new String[]{"Name"};
        int[] types = new int[]{12};
        int rowCount = this.table.getRowCount();
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < rowCount; ++i) {
            Object o = this.table.getRow(i).getUserObject();
            if (o == null || !(o instanceof RPCRequest)) continue;
            RPCRequest request = (RPCRequest)o;
            Object[] rowObject = new Object[]{request.model.getName() + "." + request.methodName};
            if (set.contains(rowObject[0])) continue;
            set.add(rowObject[0]);
            list.add(rowObject);
        }
        Object[][] oa = new Object[list.size()][];
        list.toArray((T[])oa);
        return new ArrayTable(oa, columnNames, types);
    }

    private IRow getRow(KDTable table, boolean header, int rowIndex) {
        if (header) {
            return table.getHeadRow(rowIndex);
        }
        return table.getRow(rowIndex);
    }

    protected void cellClicked(KDTable table, boolean b, int row, int column, Component originView, int x, int y, boolean header) {
        IRow trow = this.getRow(table, header, row);
        ICell cell = trow.getCell(column);
        Object value = cell.getValue();
        if (value != null && value instanceof HyperLink) {
            RPCRequest request = (RPCRequest)trow.getUserObject();
            RPCResult result = request.rpcResult;
            if (((HyperLink)value).getLinkTo().equals("request")) {
                Utils.showObjectAsXML(request, "request", request.startTime);
            } else if (((HyperLink)value).getLinkTo().equals("result")) {
                Utils.showObjectAsXML(result, "result", request.startTime);
            } else {
                this.showAnalysisResult(request);
            }
        }
    }

    private String getAnalysisText(RPCRequest request) {
        int count = 0;
        int totalTime = 0;
        AnalysisResult result = request.rpcResult.analysisResult;
        if (result == null) {
            return "\u65e0";
        }
        List itemList = result.getSQLExecuteResult();
        if (itemList == null) {
            return "\u65e0";
        }
        Iterator iter = itemList.iterator();
        while (iter.hasNext()) {
            ++count;
            LoggerItem item = (LoggerItem)iter.next();
            totalTime = (int)((long)totalTime + (item.endTime - item.startTime));
        }
        return "\u5171" + count + "\u6761\uff0c\u8017\u65f6" + totalTime;
    }

    private void showAnalysisResult(RPCRequest request) {
        AnalysisResult result = request.rpcResult.analysisResult;
        if (result == null) {
            return;
        }
        List itemList = result.getSQLExecuteResult();
        if (itemList != null) {
            this.sqlDetailDialog.setItemList(itemList);
            this.sqlDetailDialog.showDialog();
        }
    }

    private int getSelectedRow() {
        KDTSelectBlock block = this.table.getSelectManager().get();
        int rowIndex = -1;
        if (block != null) {
            rowIndex = block.getTop();
        }
        return rowIndex;
    }

    private void deleteRow() {
        int ok;
        KDTSelectBlock block = this.table.getSelectManager().get();
        int rowIndex = -1;
        int rowEnd = -1;
        if (block != null) {
            rowIndex = block.getTop();
            rowEnd = block.getBottom();
        }
        if (rowIndex > -1 && (ok = KDOptionPane.showConfirmDialog((Component)((Object)this), (Object)"\u786e\u8ba4\u5220\u9664\u9009\u4e2d\u884c?", (String)"\u5220\u9664\u786e\u8ba4", (int)0)) == 0) {
            this.deleteRow(rowIndex, rowEnd);
        }
        this.updateAnalysisPanel();
    }

    private void deleteRow(int rowBegin, int rowEnd) {
        Object userObject;
        IRow row;
        int rowIndex;
        for (rowIndex = rowBegin; rowIndex <= rowEnd; ++rowIndex) {
            row = this.table.getRow(rowIndex);
            userObject = row.getUserObject();
            if (!(userObject instanceof TransactionInfo)) continue;
            TransactionInfo tInfo = (TransactionInfo)userObject;
            for (int i = this.table.getRowCount() - 1; i > -1; --i) {
                IRow row2 = this.table.getRow(i);
                if (!(row2.getUserObject() instanceof TransactionInfo) || !((TransactionInfo)row2.getUserObject()).transactionName.equals(tInfo.transactionName)) continue;
                this.transactionInfos.remove(row2.getUserObject());
                this.table.removeRow(i);
                if (i <= rowBegin) {
                    --rowBegin;
                    --rowEnd;
                } else if (i <= rowEnd) {
                    --rowEnd;
                }
                if (i > rowIndex) continue;
                --rowIndex;
            }
        }
        for (rowIndex = rowEnd; rowIndex >= rowBegin; --rowIndex) {
            row = this.table.getRow(rowIndex);
            userObject = row.getUserObject();
            RPCRequest request = (RPCRequest)userObject;
            if (request.parent == null) {
                this.table.removeRow(rowIndex);
                this.rpcRequests.remove(userObject);
                RPCRecordStatus.removeRequest((RPCRequest)((RPCRequest)userObject));
                while (request.next != null) {
                    this.table.removeRow(rowIndex);
                    request.next = request.next.next;
                    --rowEnd;
                }
                continue;
            }
            this.table.removeRow(rowIndex);
            request.parent.next = request.next;
        }
    }

    private void deleteRow(int rowIndex) {
        block5: {
            Object userObject;
            block4: {
                IRow row = this.table.getRow(rowIndex);
                userObject = row.getUserObject();
                if (!(userObject instanceof RPCRequest)) break block4;
                RPCRequest request = (RPCRequest)userObject;
                if (request.parent == null) {
                    this.table.removeRow(row.getRowIndex());
                    this.rpcRequests.remove(userObject);
                    RPCRecordStatus.removeRequest((RPCRequest)((RPCRequest)userObject));
                    while (request.next != null) {
                        this.deleteRow(rowIndex);
                    }
                } else {
                    this.table.removeRow(row.getRowIndex());
                    request.parent.next = request.next;
                }
                break block5;
            }
            if (!(userObject instanceof TransactionInfo)) break block5;
            TransactionInfo tInfo = (TransactionInfo)userObject;
            for (int i = this.table.getRowCount() - 1; i > -1; --i) {
                IRow row2 = this.table.getRow(i);
                if (!(row2.getUserObject() instanceof TransactionInfo) || !((TransactionInfo)row2.getUserObject()).transactionName.equals(tInfo.transactionName)) continue;
                this.transactionInfos.remove(row2.getUserObject());
                this.table.removeRow(i);
            }
        }
    }

    private void openResultScript() {
        FileChooserUtil fc = new FileChooserUtil((Component)((Object)this));
        File file = fc.openFile("\u8bf7\u9009\u62e9\u811a\u672c", "script", ".script");
        if (file == null) {
            return;
        }
        try {
            List list = this.loadResultScriptFile(file);
            DetailDialog dialog = new DetailDialog((Dialog)((Object)this));
            dialog.setTitle("\u7ed3\u679c\u5206\u6790\uff1a" + file.getName());
            dialog.setData(list, Collections.EMPTY_LIST);
            dialog.showDialog();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
    }

    private void playFile() {
        FileChooserUtil fc = new FileChooserUtil((Component)((Object)this));
        File file = fc.openFile("\u8bf7\u9009\u62e9\u811a\u672c", "script", ".script");
        if (file == null) {
            return;
        }
        RecorderController.doPlayFile(file.getAbsolutePath());
    }

    private void save() {
        File file;
        FileChooserUtil fc = new FileChooserUtil((Component)((Object)this));
        if (this.lastSavePath != null) {
            fc.setSelectedFile(this.lastSavePath);
        }
        if ((file = fc.saveFile("\u8bf7\u8f93\u5165\u811a\u672c\u540d\u79f0\u548c\u4fdd\u5b58\u8def\u5f84", "script", "*.script")) == null) {
            return;
        }
        if (!file.getName().endsWith(".script")) {
            file = new File(file.getAbsolutePath() + ".script");
        }
        this.lastSavePath = file.getAbsolutePath();
        try {
            this.saveFile(file);
            this.showMessage("\u4fdd\u5b58\u6210\u529f", "\u811a\u672c\u8def\u5f84\uff1a" + file.getAbsolutePath());
        }
        catch (IOException e) {
            this.showMessage("\u4fdd\u5b58\u5931\u8d25", e.getMessage());
        }
    }

    private void saveResultScript() {
        File file;
        FileChooserUtil fc = new FileChooserUtil((Component)((Object)this));
        if (this.lastSavePath != null) {
            fc.setSelectedFile(this.lastSavePath);
        }
        if ((file = fc.saveFile("\u8bf7\u8f93\u5165\u811a\u672c\u540d\u79f0\u548c\u4fdd\u5b58\u8def\u5f84", "script", "*.script")) == null) {
            return;
        }
        if (!file.getName().endsWith(".script")) {
            file = new File(file.getAbsolutePath() + ".script");
        }
        this.lastSavePath = file.getAbsolutePath();
        try {
            this.saveResultScriptFile(file);
            this.showMessage("\u4fdd\u5b58\u6210\u529f", "\u811a\u672c\u8def\u5f84\uff1a" + file.getAbsolutePath());
        }
        catch (IOException e) {
            this.showMessage("\u4fdd\u5b58\u5931\u8d25", e.getMessage());
        }
    }

    private void showMessage(String title, String message) {
        JOptionPane.showMessageDialog((Component)((Object)this), message, title, 1);
    }

    private void saveFile(File file) throws IOException {
        String fileName;
        if (file.exists()) {
            this.deleteRelatedFile(file);
        }
        File rpcPath = Utils.getRPCObjectPath(file);
        rpcPath.mkdir();
        ArrayList<String> rpcObjectFileNames = new ArrayList<String>();
        for (RPCRequest request : this.rpcRequests) {
            fileName = com.kingdee.bos.rpcrecorder.Utils.getRPCObjectFileNameAsXML((RPCRequest)request);
            fileName = rpcPath + "/" + fileName;
            fileName = StringUtils.replace((String)fileName, (String)"\\", (String)"/");
            rpcObjectFileNames.add(fileName);
            SerdeTool.saveObjectAsXML((Object)request, (String)fileName);
        }
        rpcPath = Utils.getRPCInitRequestPath(file);
        rpcPath.mkdir();
        for (RPCRequest request : this.rpcRequests) {
            fileName = com.kingdee.bos.rpcrecorder.Utils.getRPCObjectFileNameAsXML((RPCRequest)request);
            fileName = rpcPath + "/" + fileName;
            fileName = StringUtils.replace((String)fileName, (String)"\\", (String)"/");
            SerdeTool.saveObjectAsXML((Object)request, (String)fileName);
        }
        rpcPath = Utils.getRPCInitResultPath(file);
        rpcPath.mkdir();
        for (RPCRequest request : this.rpcRequests) {
            RPCResult result = request.rpcResult;
            String fileName2 = com.kingdee.bos.rpcrecorder.Utils.getRPCObjectFileNameAsXML((RPCRequest)request);
            fileName2 = rpcPath + "/" + fileName2;
            fileName2 = StringUtils.replace((String)fileName2, (String)"\\", (String)"/");
            SerdeTool.saveObjectAsXML((Object)result, (String)fileName2);
        }
        this.saveScript(file, rpcObjectFileNames);
        this.saveLR(file);
        this.saveBat(file);
    }

    private List loadResultScriptFile(File file) throws IOException, JDOMException {
        FileReader fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        String line = null;
        String script = "";
        while ((line = br.readLine()) != null) {
            script = script + "\r\n" + line;
        }
        try {
            br.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        ScriptDef scriptDef = new ScriptDef();
        scriptDef.fromText(script);
        ArrayList<String> xmlfiles = new ArrayList<String>();
        for (int i = 0; i < scriptDef.defs.length; ++i) {
            if (!(scriptDef.defs[i] instanceof StatementDef)) continue;
            StatementDef sdef = (StatementDef)scriptDef.defs[i];
            if (!sdef.command.equalsIgnoreCase("runrpc")) continue;
            String para = sdef.parameter;
            para = para.substring(para.lastIndexOf(47) + 1);
            para = para.replace("\"", "");
            xmlfiles.add(para);
        }
        ArrayList<RPCRequest> list = new ArrayList<RPCRequest>();
        File rpcPath = Utils.getRPCObjectPath(file);
        File resultPath = Utils.getRPCInitResultPath(file);
        for (String fileName : xmlfiles) {
            RPCResult result;
            String fullName = rpcPath.getAbsoluteFile() + "/" + fileName;
            RPCRequest request = (RPCRequest)SerdeTool.loadObjectFromXML((String)fullName);
            fullName = resultPath.getAbsolutePath() + "/" + fileName;
            request.rpcResult = result = (RPCResult)SerdeTool.loadObjectFromXML((String)fullName);
            if (new File(fullName = fullName.replaceAll("xml", "obj")).exists()) {
                try {
                    AnalysisResult aResult;
                    result.analysisResult = aResult = (AnalysisResult)Utils.loadBinaryObject(fullName);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            list.add(request);
        }
        return list;
    }

    private void saveResultScriptFile(File file) throws IOException {
        if (file.exists()) {
            this.deleteRelatedFile(file);
        }
        File rpcPath = Utils.getRPCObjectPath(file);
        rpcPath.mkdir();
        ArrayList<String> rpcObjectFileNames = new ArrayList<String>();
        for (RPCRequest request : this.rpcRequests) {
            String fileName = com.kingdee.bos.rpcrecorder.Utils.getRPCObjectFileNameAsXML((RPCRequest)request);
            fileName = rpcPath + "/" + fileName;
            fileName = StringUtils.replace((String)fileName, (String)"\\", (String)"/");
            rpcObjectFileNames.add(fileName);
            SerdeTool.saveObjectAsXML((Object)request, (String)fileName);
        }
        rpcPath = Utils.getRPCInitResultPath(file);
        rpcPath.mkdir();
        for (RPCRequest request : this.rpcRequests) {
            RPCResult result = request.rpcResult;
            String fileName = com.kingdee.bos.rpcrecorder.Utils.getRPCObjectFileNameAsXML((RPCRequest)request);
            fileName = rpcPath + "/" + fileName;
            fileName = StringUtils.replace((String)fileName, (String)"\\", (String)"/");
            SerdeTool.saveObjectAsXML((Object)result, (String)fileName);
            if (result.analysisResult == null) continue;
            fileName = fileName.replaceAll("xml", "obj");
            Utils.saveBinaryObject(result.analysisResult, fileName);
        }
        this.saveScript(file, rpcObjectFileNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBat(File file) throws IOException {
        BufferedReader br = null;
        PrintWriter pw = null;
        InputStream is = null;
        InputStreamReader reader = null;
        try {
            String filepath = file.getAbsolutePath();
            String path = StringUtils.replace((String)filepath, (String)".script", (String)".bat");
            is = Utils.class.getResourceAsStream("bat.template");
            reader = new InputStreamReader(is, "UTF-8");
            br = new BufferedReader(reader);
            FileWriter writer = new FileWriter(path);
            pw = new PrintWriter(writer);
            filepath = StringUtils.replace((String)filepath, (String)"\\", (String)"/");
            String scriptFileName = file.getName();
            String line = null;
            while ((line = br.readLine()) != null) {
                pw.println(this.replaceBatTemplate(line, scriptFileName));
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLR(File file) throws IOException {
        String filepath = file.getAbsolutePath();
        String path = StringUtils.replace((String)filepath, (String)".script", (String)".lr");
        BufferedReader br = null;
        PrintWriter pw = null;
        InputStream is = null;
        InputStreamReader reader = null;
        try {
            is = Utils.class.getResourceAsStream("lr.template");
            reader = new InputStreamReader(is, "UTF-8");
            br = new BufferedReader(reader);
            FileWriter writer = new FileWriter(path);
            pw = new PrintWriter(writer);
            filepath = StringUtils.replace((String)filepath, (String)"\\", (String)"/");
            String line = null;
            while ((line = br.readLine()) != null) {
                pw.println(this.replaceLRTemplate(line, filepath));
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private String replaceLRTemplate(String str, String fileName) {
        String date = Utils.formatCurrentTime();
        str = StringUtils.replace((String)str, (String)"@{date}", (String)date);
        str = StringUtils.replace((String)str, (String)"@{filename}", (String)fileName);
        String user = SysContext.getSysContext().getUserName();
        String pwd = SysContext.getSysContext().getCurrentUserInfo().getPassword();
        String datacenter = SysContext.getSysContext().getDcName();
        str = StringUtils.replace((String)str, (String)"@{user}", (String)user);
        str = StringUtils.replace((String)str, (String)"@{password}", (String)(pwd == null ? "" : pwd));
        str = StringUtils.replace((String)str, (String)"@{datacenter}", (String)datacenter);
        return str;
    }

    private String replaceBatTemplate(String str, String fileName) {
        String date = Utils.formatCurrentTime();
        str = StringUtils.replace((String)str, (String)"@{date}", (String)date);
        String user = SysContext.getSysContext().getUserName();
        String pwd = SysContext.getSysContext().getCurrentUserInfo().getPassword();
        String datacenter = SysContext.getSysContext().getDcName();
        Properties prop = System.getProperties();
        String easserver = prop.getProperty("appserver");
        String eashome = prop.getProperty("EAS_HOME");
        String javahome = prop.getProperty("java.home");
        str = StringUtils.replace((String)str, (String)"@{user}", (String)user);
        str = StringUtils.replace((String)str, (String)"@{password}", (String)(pwd == null ? "" : pwd));
        str = StringUtils.replace((String)str, (String)"@{datacenter}", (String)datacenter);
        str = StringUtils.replace((String)str, (String)"@{server}", (String)easserver);
        str = StringUtils.replace((String)str, (String)"@{filename}", (String)fileName);
        str = StringUtils.replace((String)str, (String)"@{EAS_HOME}", (String)eashome);
        str = StringUtils.replace((String)str, (String)"@{JAVA_HOME}", (String)javahome);
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveScript(File file, List rpcObjectFileNames) throws IOException {
        FileWriter fw = null;
        try {
            fw = new FileWriter(file.getAbsoluteFile());
            PrintWriter writer = new PrintWriter(new BufferedWriter(fw));
            writer.println("//Script Name:" + file.getName());
            writer.println("//Generated by EASRecorder.");
            writer.println("\r\n");
            String pathVar = "scriptpath";
            String scriptpath = file.getParent();
            scriptpath = StringUtils.replace((String)scriptpath, (String)"\\", (String)"/");
            writer.println("set $" + pathVar + ",\"" + scriptpath + "\"");
            pathVar = "${" + pathVar + "}";
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                Object userObject = this.table.getRow(i).getUserObject();
                if (userObject instanceof TransactionInfo) {
                    TransactionInfo tInfo = (TransactionInfo)userObject;
                    String command = (tInfo.status == 0 ? "start_transaction" : "end_transaction") + " \"" + ((TransactionInfo)userObject).transactionName + "\"";
                    writer.println();
                    writer.println(command);
                    continue;
                }
                if (((RPCRequest)userObject).parent != null) continue;
                int index = this.rpcRequests.indexOf(userObject);
                String name = (String)rpcObjectFileNames.get(index);
                name = StringUtils.replace((String)name, (String)scriptpath, (String)pathVar);
                writer.println();
                writer.println("runrpc \"" + name + "\"");
            }
            writer.flush();
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void deleteRelatedFile(File file) throws IOException {
        File rpcPath = Utils.getRPCObjectPath(file);
        if (rpcPath.exists()) {
            this.rmDirectory(rpcPath);
        }
        if ((rpcPath = Utils.getRPCInitRequestPath(file)).exists()) {
            this.rmDirectory(rpcPath);
        }
        if ((rpcPath = Utils.getRPCInitResultPath(file)).exists()) {
            this.rmDirectory(rpcPath);
        }
    }

    private boolean rmDirectory(File file) throws IOException {
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.rmDirectory(files[i]);
                continue;
            }
            boolean b = files[i].delete();
            if (b) continue;
            throw new IOException("Can't delete " + files[i].getAbsolutePath());
        }
        boolean b = file.delete();
        if (!b) {
            throw new IOException("Can't delete " + file.getAbsolutePath());
        }
        return true;
    }

    public static void main(String[] args) {
        File file = new File("F:/arch/SOA/20100859.pdf");
        String path = file.getAbsolutePath();
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File file2 = file.getAbsoluteFile();
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        file2.exists();
    }

    public void setData(List rpcRequests, List transactionInfos) {
        ArrayList<RPCRequest> toRemove = new ArrayList<RPCRequest>();
        for (RPCRequest request : rpcRequests) {
            if (request.rpcResult != null) continue;
            toRemove.add(request);
        }
        rpcRequests.removeAll(toRemove);
        this.rpcRequests = rpcRequests;
        this.transactionInfos = transactionInfos;
        if (this.isAddControls) {
            this.updateTable();
            this.updateAnalysisPanel();
        }
    }

    public void updateTable() {
        if (this.rpcRequests == null) {
            return;
        }
        this.table.removeRows();
        int index1 = 0;
        int index2 = 0;
        RPCRequest request = null;
        TransactionInfo tInfo = null;
        int size1 = this.rpcRequests.size();
        int size2 = this.transactionInfos.size();
        while (true) {
            IRow row;
            request = index1 < size1 ? (RPCRequest)this.rpcRequests.get(index1) : null;
            tInfo = index2 < size2 ? (TransactionInfo)this.transactionInfos.get(index2) : null;
            if (tInfo == null && request == null) break;
            if (tInfo == null) {
                row = this.table.addRow();
                this.addRow(row, request);
                ++index1;
                continue;
            }
            if (request == null) {
                row = this.table.addRow();
                this.addRow(row, tInfo);
                ++index2;
                continue;
            }
            if (request.startTime < tInfo.timestamp) {
                row = this.table.addRow();
                this.addRow(row, request);
                ++index1;
                continue;
            }
            row = this.table.addRow();
            this.addRow(row, tInfo);
            ++index2;
        }
    }
}

