/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.recorder;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.rpc.impl.RPCRecordStatus;
import com.kingdee.eas.client.recorder.DetailUI;
import com.kingdee.eas.client.recorder.RecorderController;
import com.kingdee.eas.client.recorder.TransactionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class RecorderUI
extends KDPanel {
    public static RecorderUI instance = new RecorderUI();
    private KDButton recordButton = new KDButton("\u5f55\u5236");
    private KDButton pauseButton = new KDButton("\u6682\u505c");
    private KDButton endButton = new KDButton("\u505c\u6b62");
    private KDButton clearButton = new KDButton("\u6e05\u7a7a");
    private KDButton detailButton = new KDButton("\u67e5\u770b");
    private KDButton playButton = new KDButton("\u64ad\u653e");
    private KDButton startTransactionButton = new KDButton("\u5f00\u59cb\u4e8b\u52a1");
    private KDButton endTransactionButton = new KDButton("\u7ed3\u675f\u4e8b\u52a1");
    private DetailUI detailUI;
    private KDDialog detailDialog;
    private ArrayList transactionInfos = new ArrayList();
    private String currentTransaction;
    KDFrame detailFrame;

    private RecorderUI() {
        this.initUI();
    }

    protected boolean canRecorder() {
        return false;
    }

    private void initUI() {
        this.setLayout(new FlowLayout(1, 0, 0));
        this.add((Component)this.recordButton);
        this.add((Component)this.pauseButton);
        this.add((Component)this.endButton);
        this.add((Component)this.clearButton);
        this.add((Component)this.detailButton);
        this.add((Component)this.startTransactionButton);
        this.add((Component)this.endTransactionButton);
        this.recordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecorderUI.this.doRecord();
            }
        });
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecorderUI.this.doPause();
            }
        });
        this.endButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecorderUI.this.doEnd();
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecorderUI.this.doClear();
            }
        });
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecorderUI.this.doPlay();
            }
        });
        this.detailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecorderUI.this.doDetail();
            }
        });
        this.startTransactionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecorderUI.this.startTransaction();
            }
        });
        this.endTransactionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecorderUI.this.endTransaction();
            }
        });
        this.pauseButton.setEnabled(false);
        this.endButton.setEnabled(false);
    }

    private void startTransaction() {
        this.autoEndTransaction();
        String s = KDOptionPane.showInputDialog((Component)((Object)this), (Object)"\u8bf7\u8f93\u5165\u4e8b\u52a1\u540d\u79f0\uff1a");
        if (s != null) {
            this.currentTransaction = s;
            TransactionInfo tInfo = new TransactionInfo(s, 0);
            this.transactionInfos.add(tInfo);
            this.startTransactionButton.setEnabled(false);
            this.endTransactionButton.setEnabled(true);
            this.endTransactionButton.setText("\u7ed3\u675f\u4e8b\u52a1(" + this.currentTransaction + ")");
        }
    }

    private void endTransaction() {
        TransactionInfo tInfo = new TransactionInfo(this.currentTransaction, 1);
        this.transactionInfos.add(tInfo);
        this.currentTransaction = null;
        this.startTransactionButton.setEnabled(true);
        this.endTransactionButton.setEnabled(false);
        this.endTransactionButton.setText("\u7ed3\u675f\u4e8b\u52a1");
    }

    private void autoEndTransaction() {
        if (this.currentTransaction != null) {
            this.endTransaction();
        }
    }

    private DetailUI getDetailUI() {
        if (this.detailUI == null) {
            this.detailUI = new DetailUI();
        }
        return this.detailUI;
    }

    private KDDialog getDetailDialog() {
        if (this.detailDialog != null) {
            return this.detailDialog;
        }
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        this.detailDialog = parent instanceof Dialog ? new KDDialog((Dialog)parent) : new KDDialog((Frame)parent);
        this.detailDialog.setLayout((LayoutManager)new BorderLayout());
        this.detailDialog.add((Component)((Object)this.getDetailUI()), (Object)"Center");
        this.detailDialog.setTitle("\u8be6\u7ec6\u4fe1\u606f:\u6b63\u5728\u5f55\u5236");
        return this.detailDialog;
    }

    private KDFrame getDetailFrame() {
        if (this.detailFrame != null) {
            return this.detailFrame;
        }
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        this.detailFrame = new KDFrame();
        this.detailFrame.setLayout((LayoutManager)new BorderLayout());
        this.detailFrame.add((Component)((Object)this.getDetailUI()), (Object)"Center");
        this.detailFrame.setTitle("\u8be6\u7ec6\u4fe1\u606f");
        this.detailFrame.setExtendedState(6);
        this.detailFrame.setDefaultCloseOperation(2);
        return this.detailFrame;
    }

    private void doRecord() {
        this.recordButton.setEnabled(false);
        this.pauseButton.setEnabled(true);
        this.endButton.setEnabled(true);
        this.clearButton.setEnabled(false);
        this.playButton.setEnabled(false);
        this.detailButton.setEnabled(false);
        RecorderController.doRecord();
    }

    private void doPause() {
        this.recordButton.setEnabled(true);
        this.pauseButton.setEnabled(false);
        this.clearButton.setEnabled(true);
        this.playButton.setEnabled(true);
        this.detailButton.setEnabled(true);
        RecorderController.doPause();
    }

    private void doEnd() {
        this.recordButton.setEnabled(true);
        this.pauseButton.setEnabled(false);
        this.endButton.setEnabled(false);
        this.clearButton.setEnabled(true);
        this.playButton.setEnabled(true);
        this.detailButton.setEnabled(true);
        this.autoEndTransaction();
        RecorderController.doEnd();
    }

    private void doClear() {
        this.transactionInfos.clear();
        RecorderController.doClear();
    }

    private void doPlay() {
        RecorderController.doPlay();
    }

    private void doDetail() {
        int r;
        if (this.currentTransaction != null && (r = KDOptionPane.showConfirmDialog((Component)((Object)this), (Object)("\u4e8b\u52a1" + this.currentTransaction + "\u672a\u7ed3\u675f\uff0c\u662f\u5426\u7ed3\u675f\uff1f"), (String)"\u53cb\u60c5\u63d0\u793a", (int)0)) == 0) {
            this.autoEndTransaction();
        }
        List requests = RPCRecordStatus.getAllRequests();
        this.getDetailUI().setData(requests, this.transactionInfos);
        this.getDetailFrame().setVisible(true);
    }
}

