/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.recorder.serde;

import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.rpcrecorder.RecorderException;
import com.kingdee.bos.rpcrecorder.serde.AbstractXmlSerde;
import com.kingdee.bos.rpcrecorder.serde.IXmlSerde;
import com.kingdee.bos.rpcrecorder.serde.SerdeContext;
import com.kingdee.bos.rpcrecorder.serde.UnknownConstructorObjectSerde;
import com.kingdee.bos.rpcrecorder.serde.XmlSerdeFactory;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;

public class EASSerdeProvider {
    public static void touch() {
    }

    static {
        XmlSerdeFactory.register(RequestContext.class, (IXmlSerde)new RequestContextSerde(RequestContext.class));
        XmlSerdeFactory.register(ResponseContext.class, (IXmlSerde)new ResponseContextSerde(ResponseContext.class));
        XmlSerdeFactory.register(BatchExecuteParamsEntry.class, (IXmlSerde)new BatchExecuteParamsEntrySerde(BatchExecuteParamsEntry.class));
        XmlSerdeFactory.register(BatchExecuteResult.class, (IXmlSerde)new BatchExecuteResultSerde(BatchExecuteResult.class));
        XmlSerdeFactory.register(BatchSelectionEntries.class, (IXmlSerde)new BatchSelectionEntriesSerde(BatchSelectionEntries.class));
    }

    private static class ResponseContextSerde
    extends AbstractXmlSerde {
        protected ResponseContextSerde(Class clazz) {
            super(clazz);
        }

        public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
            ResponseContext rc = (ResponseContext)object;
            Element element = this.createElement();
            Map map = rc.getResponse();
            if (map != null) {
                int size = map.size();
                element.setAttribute("size", "" + size);
                int index = 0;
                for (Map.Entry entry : map.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    Element childEle = new Element("Child");
                    childEle.setAttribute("index", "" + index++);
                    element.addContent((Content)childEle);
                    Element keyEle = new Element("Key");
                    Element valueEle = new Element("Value");
                    childEle.addContent((Content)keyEle);
                    childEle.addContent((Content)valueEle);
                    keyEle.addContent((Content)ctx.toXML(key));
                    valueEle.addContent((Content)ctx.toXML(value));
                }
            }
            return element;
        }

        public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
            String s = element.getAttributeValue("size");
            int size = Integer.parseInt(s);
            ResponseContext rc = new ResponseContext();
            List children = element.getChildren("Child");
            for (Element child : children) {
                Element keyEle = child.getChild("Key");
                Element valueEle = child.getChild("Value");
                Object key = ctx.fromXML((Element)keyEle.getChildren().get(0));
                Object value = ctx.fromXML((Element)valueEle.getChildren().get(0));
                rc.put((String)key, value);
            }
            return rc;
        }

        public String getTagName() {
            return "ResponseContext";
        }
    }

    private static class RequestContextSerde
    extends AbstractXmlSerde {
        protected RequestContextSerde(Class clazz) {
            super(clazz);
        }

        public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
            RequestContext rc = (RequestContext)object;
            Element element = this.createElement();
            Map map = rc.getParameter();
            if (map != null) {
                int size = map.size();
                element.setAttribute("size", "" + size);
                int index = 0;
                for (Map.Entry entry : map.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    Element childEle = new Element("Child");
                    childEle.setAttribute("index", "" + index++);
                    element.addContent((Content)childEle);
                    Element keyEle = new Element("Key");
                    Element valueEle = new Element("Value");
                    childEle.addContent((Content)keyEle);
                    childEle.addContent((Content)valueEle);
                    keyEle.addContent((Content)ctx.toXML(key));
                    valueEle.addContent((Content)ctx.toXML(value));
                }
            }
            return element;
        }

        public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
            String s = element.getAttributeValue("size");
            int size = Integer.parseInt(s);
            RequestContext rc = new RequestContext();
            List children = element.getChildren("Child");
            for (Element child : children) {
                Element keyEle = child.getChild("Key");
                Element valueEle = child.getChild("Value");
                Object key = ctx.fromXML((Element)keyEle.getChildren().get(0));
                Object value = ctx.fromXML((Element)valueEle.getChildren().get(0));
                rc.put((String)key, value);
            }
            return rc;
        }

        public String getTagName() {
            return "RequestContext";
        }
    }

    private static class BatchExecuteParamsEntrySerde
    extends AbstractXmlSerde {
        protected BatchExecuteParamsEntrySerde(Class clazz) {
            super(clazz);
        }

        public Element toXML(SerdeContext ctx, Class clazz, Object object) {
            BatchExecuteParamsEntry entry = (BatchExecuteParamsEntry)object;
            Element element = this.createElement();
            Class[] types = entry.getParamTypes();
            Object[] values = entry.toArray();
            Element typeEle = new Element("ParamTypes");
            Element valEle = new Element("ParamValues");
            element.addContent((Content)typeEle);
            element.addContent((Content)valEle);
            typeEle.addContent((Content)ctx.toXML((Object)types));
            valEle.addContent((Content)ctx.toXML((Object)values));
            return element;
        }

        public Object fromXML(SerdeContext ctx, Element element) {
            Element typeEle = element.getChild("ParamTypes");
            Element valEle = element.getChild("ParamValues");
            Class[] types = (Class[])ctx.fromXML((Element)typeEle.getChildren().get(0));
            Object[] values = (Object[])ctx.fromXML((Element)valEle.getChildren().get(0));
            return new BatchExecuteParamsEntry(types, values);
        }
    }

    private static class BatchExecuteResultSerde
    extends AbstractXmlSerde {
        protected BatchExecuteResultSerde(Class clazz) {
            super(clazz);
        }

        public Element toXML(SerdeContext ctx, Class clazz, Object object) {
            Element ele;
            BatchExecuteResult result = (BatchExecuteResult)object;
            Element element = this.createElement();
            int size = result.size();
            element.setAttribute("size", "" + size);
            Object[] returnValues = result.getReturnValues();
            Throwable[] exceptions = result.getExceptions();
            Object batchResult = result.getBatchResult();
            if (returnValues != null) {
                ele = new Element("ReturnValues");
                ele.addContent((Content)ctx.toXML((Object)returnValues));
                element.addContent((Content)ele);
            }
            if (exceptions != null) {
                ele = new Element("Exceptions");
                ele.addContent((Content)ctx.toXML((Object)exceptions));
                element.addContent((Content)ele);
            }
            if (batchResult != null) {
                ele = new Element("BatchResult");
                ele.addContent((Content)ctx.toXML(batchResult));
                element.addContent((Content)ele);
            }
            return element;
        }

        public Object fromXML(SerdeContext ctx, Element element) {
            int size = Integer.parseInt(element.getAttributeValue("size"));
            BatchExecuteResult result = new BatchExecuteResult(size);
            if (size > 0) {
                int i;
                if (element.getChild("ReturnValues") != null) {
                    Object[] returnValues = (Object[])ctx.fromXML((Element)element.getChild("ReturnValues").getChildren().get(0));
                    for (i = 0; i < size; ++i) {
                        result.setReturnValue(i, returnValues[i]);
                    }
                }
                if (element.getChild("Exceptions") != null) {
                    Throwable[] exeptions = (Throwable[])ctx.fromXML((Element)element.getChild("Exceptions").getChildren().get(0));
                    for (i = 0; i < size; ++i) {
                        result.setException(i, exeptions[i]);
                    }
                }
            }
            if (element.getChild("BatchResult") != null) {
                Object batchResult = ctx.fromXML((Element)element.getChild("ReturnValues").getChildren().get(0));
                result.setBatchResult(batchResult);
            }
            return result;
        }
    }

    private static class BatchSelectionEntriesSerde
    extends UnknownConstructorObjectSerde {
        protected BatchSelectionEntriesSerde(Class clazz) {
            super(clazz);
        }

        public Class[] getConstructorArgTypes() {
            return new Class[]{ActionLevelEnum.class};
        }

        public String[] getConstructorArgValueFields() {
            return new String[]{"actionLevel"};
        }

        public String[] getConstructorSetFields() {
            return this.getConstructorArgValueFields();
        }

        protected boolean serializeTransient() {
            return false;
        }
    }
}

