/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.access.entity.SimpleProperty;
import com.kingdee.bos.metadata.access.entity.SimplePropertyCollection;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ObjectValueUtil {
    private static Logger logger = Logger.getLogger(ObjectValueUtil.class);

    public static boolean objectValueEquals(AbstractObjectValue source, AbstractObjectValue target) {
        return ObjectValueUtil.objectValueEquals(null, source, target);
    }

    private static SimpleEntity getEntity(Context ctx, BOSObjectType type) {
        EntitySelect select = new EntitySelect(type);
        select.propertySelect().select(new String[]{"*"}, new String[]{"dataType", "linkType"});
        try {
            if (ctx == null) {
                return MetaDataAccessFactory.getRemoteInstance().select(select);
            }
            return MetaDataAccessFactory.getLocalInstance((Context)ctx).select(select);
        }
        catch (BOSException e) {
            logger.error((Object)("Metadata access error. can't load entity:" + type), (Throwable)e);
            return null;
        }
    }

    public static boolean objectValueEquals(Context ctx, AbstractObjectValue source, AbstractObjectValue target) {
        if (source == target) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        if (!source.getBOSType().equals((Object)target.getBOSType())) {
            return false;
        }
        SimpleEntity entity = ObjectValueUtil.getEntity(ctx, source.getBOSType());
        if (entity == null) {
            return false;
        }
        SimplePropertyCollection pc = entity.properties();
        for (SimpleProperty property : pc) {
            if (property.isOwnProperty()) {
                if (ObjectValueUtil.ownPropertyEquals(source, target, property)) continue;
                return false;
            }
            boolean composite = RelationshipType.COMPOSITION.equals((Object)property.getLinkType());
            if (ObjectValueUtil.isAggregation(property.getName(), source)) {
                AbstractObjectCollection sourceChildCollection = (AbstractObjectCollection)source.get(property.getName());
                AbstractObjectCollection targetChildCollection = (AbstractObjectCollection)target.get(property.getName());
                if (sourceChildCollection.size() != targetChildCollection.size()) {
                    return false;
                }
                for (int i = 0; i < sourceChildCollection.size(); ++i) {
                    AbstractObjectValue sourceChildObject = (AbstractObjectValue)sourceChildCollection.getObject(i);
                    AbstractObjectValue targetChildObject = (AbstractObjectValue)targetChildCollection.getObject(i);
                    if (!(composite ? !ObjectValueUtil.objectValueEquals(sourceChildObject, targetChildObject) : !ObjectValueUtil.objectValueEqualsPk(sourceChildObject, targetChildObject))) continue;
                    return false;
                }
                continue;
            }
            AbstractObjectValue sourceChildObject = (AbstractObjectValue)source.get(property.getName());
            AbstractObjectValue targetChildObject = (AbstractObjectValue)target.get(property.getName());
            if (!(composite ? !ObjectValueUtil.objectValueEquals(ctx, sourceChildObject, targetChildObject) : !ObjectValueUtil.objectValueEqualsPk(sourceChildObject, targetChildObject))) continue;
            return false;
        }
        return true;
    }

    private static boolean objectValueEqualsPk(AbstractObjectValue source, AbstractObjectValue target) {
        if (source == null && target == null) {
            return true;
        }
        if (source != null && target != null) {
            Object sourceId = source.get(source.getPKField());
            Object targetId = target.get(target.getPKField());
            if (sourceId == null && targetId == null) {
                return true;
            }
            if (sourceId != null && targetId != null) {
                return sourceId.toString().equals(targetId.toString());
            }
            return false;
        }
        return false;
    }

    private static boolean isAggregation(String propertyName, AbstractObjectValue source) {
        return source.get(propertyName) instanceof AbstractObjectCollection;
    }

    protected static boolean ownPropertyEquals(AbstractObjectValue source, AbstractObjectValue target, SimpleProperty property) {
        if (property.getDataType().equals((Object)DataType.SHORT)) {
            short targetProperty;
            short sourceProperty = source.getShort(property.getName());
            return sourceProperty == (targetProperty = target.getShort(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.INTEGER)) {
            int targetProperty;
            int sourceProperty = source.getInt(property.getName());
            return sourceProperty == (targetProperty = target.getInt(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.LONG)) {
            long targetProperty;
            long sourceProperty = source.getLong(property.getName());
            return sourceProperty == (targetProperty = target.getLong(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.FLOAT)) {
            float targetProperty;
            float sourceProperty = source.getFloat(property.getName());
            return sourceProperty == (targetProperty = target.getFloat(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.DOUBLE)) {
            double targetProperty;
            double sourceProperty = source.getDouble(property.getName());
            return sourceProperty == (targetProperty = target.getDouble(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.ENUM)) {
            Object sourceobj = source.get(property.getName());
            Object targetObj = target.get(property.getName());
            if (sourceobj != null) {
                return sourceobj.equals(targetObj);
            }
            if (targetObj != null) {
                return targetObj.equals(sourceobj);
            }
            return true;
        }
        if (property.getDataType().equals((Object)DataType.BOOLEAN)) {
            boolean targetProperty;
            boolean sourceProperty = source.getBoolean(property.getName());
            return sourceProperty == (targetProperty = target.getBoolean(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.BYTE)) {
            byte targetProperty;
            byte sourceProperty = source.getByte(property.getName());
            return sourceProperty == (targetProperty = target.getByte(property.getName()));
        }
        if (property.getDataType().equals((Object)DataType.DECIMAL)) {
            BigDecimal sourceProperty = source.getBigDecimal(property.getName());
            BigDecimal targetProperty = target.getBigDecimal(property.getName());
            return ObjectValueUtil.bigDecimalEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.STRING)) {
            String sourceProperty = source.getString(property.getName());
            String targetProperty = target.getString(property.getName());
            return ObjectValueUtil.stringEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.BYTEARRAY)) {
            byte[] sourceProperty = source.getBytes(property.getName());
            byte[] targetProperty = target.getBytes(property.getName());
            return ObjectValueUtil.byteArrayEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.DATE)) {
            Date sourceProperty = source.getDate(property.getName());
            Date targetProperty = target.getDate(property.getName());
            return ObjectValueUtil.objectEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.TIME)) {
            Time sourceProperty = source.getTime(property.getName());
            Time targetProperty = target.getTime(property.getName());
            return ObjectValueUtil.objectEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.TIMESTAMP)) {
            Timestamp sourceProperty = source.getTimestamp(property.getName());
            Timestamp targetProperty = target.getTimestamp(property.getName());
            return ObjectValueUtil.objectEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.CHAR)) {
            Character sourceProperty = (Character)source.get(property.getName());
            Character targetProperty = (Character)target.get(property.getName());
            return ObjectValueUtil.objectEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.BOSUUID)) {
            BOSUuid sourceProperty = source.getBOSUuid(property.getName());
            BOSUuid targetProperty = target.getBOSUuid(property.getName());
            return ObjectValueUtil.objectEquals(sourceProperty, targetProperty);
        }
        if (property.getDataType().equals((Object)DataType.UUID)) {
            Uuid sourceProperty = source.getUuid(property.getName());
            Uuid targetProperty = target.getUuid(property.getName());
            return ObjectValueUtil.objectEquals(sourceProperty, targetProperty);
        }
        Object sourceProperty = source.get(property.getName());
        Object targetProperty = target.get(property.getName());
        return ObjectValueUtil.objectEquals(sourceProperty, targetProperty);
    }

    protected static final boolean stringEquals(String source, String target) {
        return StringUtils.equals((String)source, (String)target);
    }

    protected static final boolean bigDecimalEquals(BigDecimal source, BigDecimal target) {
        if (source == null) {
            source = SysConstant.BIGZERO;
        }
        if (target == null) {
            target = SysConstant.BIGZERO;
        }
        return source.compareTo(target) == 0;
    }

    protected static final boolean byteArrayEquals(byte[] source, byte[] target) {
        if (source == target) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        String tempSource = new String(source);
        String tempTarget = new String(target);
        return ObjectValueUtil.objectEquals(tempSource, tempTarget);
    }

    protected static final boolean objectEquals(Object source, Object target) {
        if (source == null && target == null) {
            return true;
        }
        if (source != null && target != null) {
            return source.equals(target);
        }
        return false;
    }

    public static void copy(AbstractObjectValue dataObject) {
        if (dataObject == null) {
            return;
        }
        BOSObjectType bosType = dataObject.getBOSType();
        EntitySelect select = new EntitySelect(bosType);
        select.selectPKFields();
        try {
            SimpleEntity entity = MetaDataAccessFactory.getRemoteInstance().select(select);
            String[] pks = entity.getPKFields();
            ObjectValueUtil.removePKField(dataObject, pks);
        }
        catch (BOSException e) {
            logger.error((Object)("data object copy error." + dataObject), (Throwable)e);
        }
    }

    private static List<AbstractObjectValue> findSubObject(List<AbstractObjectValue> dataObjects, String prop) {
        if (dataObjects == null || dataObjects.size() <= 0 || prop == null) {
            return null;
        }
        ArrayList<AbstractObjectValue> subs = new ArrayList<AbstractObjectValue>();
        int size = dataObjects.size();
        for (int i = 0; i < size; ++i) {
            AbstractObjectValue ov;
            Object sub = dataObjects.get(i).get(prop);
            if (sub == null) continue;
            if (sub instanceof AbstractObjectValue) {
                ov = (AbstractObjectValue)sub;
                subs.add(ov);
                continue;
            }
            if (!(sub instanceof AbstractObjectCollection)) continue;
            AbstractObjectCollection oc = (AbstractObjectCollection)sub;
            int s = oc.size();
            for (int j = 0; j < s; ++j) {
                ov = (AbstractObjectValue)oc.getObject(j);
                subs.add(ov);
            }
        }
        return subs;
    }

    private static void removePKField(AbstractObjectValue dataObject, String[] pks) {
        if (dataObject == null) {
            return;
        }
        dataObject.remove(dataObject.getPKField());
        if (pks != null) {
            for (int i = 0; i < pks.length; ++i) {
                String[] path = StringUtils.split((String)pks[i], (String)".");
                List<AbstractObjectValue> ovs = new ArrayList<AbstractObjectValue>(1);
                ovs.add(dataObject);
                for (int j = 0; j < path.length && (ovs = ObjectValueUtil.findSubObject(ovs, path[j])) != null; ++j) {
                }
                if (ovs == null) continue;
                for (AbstractObjectValue ov : ovs) {
                    ov.remove(ov.getPKField());
                }
            }
        }
    }
}

