/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.framework.client.IDListAssist;
import com.kingdee.eas.framework.client.IIDList;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractIDList
implements IIDList {
    protected final List<String> idList;
    protected final List<String> newIdList;
    protected int currentIndex = -1;
    protected int count = -1;
    protected IDListAssist assist = null;

    public AbstractIDList() {
        this.idList = new ArrayList<String>();
        this.newIdList = new ArrayList<String>();
        Collections.fill(this.idList, null);
    }

    public AbstractIDList(int billCount, int count) {
        this.count = billCount > 0 ? billCount : (count > 0 ? count : 0);
        this.idList = new ArrayList<String>();
        for (int i = 0; i < this.count; ++i) {
            this.idList.add(i, null);
        }
        this.newIdList = new ArrayList<String>();
    }

    @Override
    public void add(int index, String id) {
        if (!this.idList.contains(id)) {
            if (index >= this.count || index < 0) {
                if (!this.newIdList.contains(id)) {
                    this.newIdList.add(id);
                    this.currentIndex = this.count + this.newIdList.size() - 1;
                } else {
                    this.currentIndex = this.count + this.newIdList.indexOf(id);
                }
            } else {
                this.idList.set(index, id);
            }
        }
    }

    @Override
    public void add(String id, boolean isNew) {
        if (!this.idList.contains(id)) {
            if (isNew) {
                this.newIdList.add(id);
                this.currentIndex = this.count + this.newIdList.size() - 1;
            } else {
                this.idList.add(id);
                this.currentIndex = this.count++;
            }
        }
    }

    @Override
    public void add(String id) {
        this.add(id, true);
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public String getID(int index) {
        if (index < 0) {
            return null;
        }
        if (this.size() <= 0) {
            return null;
        }
        if (index < this.count) {
            return this.idList.get(index);
        }
        return this.newIdList.get(index - this.count);
    }

    @Override
    public boolean isExist(int index) {
        if (this.size() <= 0 || this.currentIndex < 0 || index < 0) {
            return false;
        }
        if (index < this.count) {
            return this.idList.get(index) != null;
        }
        if (this.newIdList.size() > 0) {
            return this.newIdList.get(index - this.count) != null;
        }
        return false;
    }

    @Override
    public String getFirstID() {
        if (this.size() <= 0) {
            return null;
        }
        this.currentIndex = 0;
        return this.getID(this.currentIndex);
    }

    @Override
    public String getLastID() {
        if (this.size() <= 0) {
            return null;
        }
        this.currentIndex = this.count + this.newIdList.size() - 1;
        return this.getID(this.currentIndex);
    }

    @Override
    public String getNextID() {
        if (this.size() <= 0) {
            return null;
        }
        if (this.currentIndex < this.count + this.newIdList.size() - 1) {
            ++this.currentIndex;
        }
        return this.getID(this.currentIndex);
    }

    @Override
    public String getPreviousID() {
        if (this.size() <= 0) {
            return null;
        }
        if (this.currentIndex > 0) {
            --this.currentIndex;
        }
        return this.getID(this.currentIndex);
    }

    @Override
    public boolean contains(String id) {
        if (this.size() <= 0) {
            return false;
        }
        return this.idList.contains(id) || this.newIdList.contains(id);
    }

    @Override
    public void remove(String id, boolean moveUp) {
        int index = this.idList.indexOf(id);
        if (index < 0) {
            index = this.newIdList.indexOf(id);
            if (index < 0) {
                return;
            }
            index = this.count + index;
        }
        this.remove(index);
    }

    private void remove(int index) {
        if (index > -1) {
            boolean currentIndexChanged;
            boolean bl = currentIndexChanged = index < this.currentIndex;
            if (index >= this.idList.size()) {
                this.newIdList.remove(index - this.idList.size());
            } else {
                this.idList.remove(index);
                --this.count;
            }
            if (currentIndexChanged) {
                --this.currentIndex;
            } else {
                int size = this.size();
                if (this.currentIndex >= size) {
                    this.currentIndex = size - 1;
                }
            }
        }
    }

    @Override
    public int size() {
        return this.count + this.newIdList.size();
    }

    @Override
    public boolean isBegin() {
        return this.size() == 0 || this.currentIndex <= 0;
    }

    @Override
    public boolean isEnd() {
        return this.size() == 0 || this.currentIndex >= this.count + this.newIdList.size() - 1;
    }

    @Override
    public void setCount(int count) {
    }

    @Override
    public int getCount() {
        return this.count + this.newIdList.size();
    }

    @Override
    public void setCurrentIndex(int index) {
        if (index < 0) {
            this.currentIndex = this.count > 0 ? 0 : -1;
        }
        if (index > -1) {
            this.currentIndex = index > this.count + this.newIdList.size() - 1 ? this.count + this.newIdList.size() - 1 : index;
        }
    }

    @Override
    public void forceIndex(int index) {
        this.currentIndex = index;
    }

    public void reset(int billCount, int count) {
        this.count = billCount > 0 ? billCount : count;
        this.idList.clear();
        for (int i = 0; i < this.count; ++i) {
            this.idList.add(i, null);
        }
    }

    @Override
    public void setCurrentID(String id) {
    }

    @Override
    public void setPkFieldName(String pkFieldName) {
    }

    @Override
    public Context getMainOrgContext() {
        return null;
    }

    @Override
    public int getMaxRowCount() {
        return 0;
    }

    @Override
    public void setMainOrgContext(Context ctx) {
    }

    @Override
    public void setMaxRowCount(int count) {
    }

    @Override
    public void setAssist(IDListAssist assist) {
        this.assist = assist;
    }
}

