/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client;

import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTGetRowEvent;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.framework.cache.UIActionMonitor;
import com.kingdee.bos.invokecounter.RPCInvokeCounter;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.util.StringUtility;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.Uuid;
import java.awt.Color;
import java.awt.Container;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ListUiHelper {
    private PreFetcher preFetcher = null;
    private PreFetcher1 preFetcher1 = null;
    private KDTable tblMain = null;

    public boolean isPreFetcherStarted() {
        return this.preFetcher1 != null;
    }

    public IRowSet getPreFetchRowSet(int start, int length) throws Exception {
        if (this.preFetcher1 == null) {
            return null;
        }
        return this.preFetcher1.getRowSet(start, length);
    }

    public void startPreFetch(CoreUIObject ui, IQueryExecutor exec, Uuid queryUuid, int total, int pageUnit) {
        if (this.preFetcher1 == null) {
            this.preFetcher1 = new PreFetcher1(exec, queryUuid, total, pageUnit);
            this.preFetcher1.setDaemon(true);
            String fullName = ui.getClass().getName();
            int index = fullName.lastIndexOf(".");
            String name = null;
            name = index < 0 ? fullName : fullName.substring(index + 1);
            this.preFetcher1.setName("PreFetcher <" + name + ">");
            this.preFetcher1.start();
        }
    }

    public void stopPreFetch() {
        if (this.preFetcher1 != null) {
            this.preFetcher1.terminate();
            this.preFetcher1 = null;
        }
    }

    public IQueryExecutor getPreFetcherQueryExecutor() {
        if (this.preFetcher1 == null) {
            return null;
        }
        return this.preFetcher1.getExec();
    }

    public void setTblMain(KDTable table) {
        this.tblMain = table;
    }

    public void waitForPreFetcherStop() {
        if (this.preFetcher == null) {
            return;
        }
        while (!this.preFetcher.terminated) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public KDTable getTblMain() {
        return this.tblMain;
    }

    public void getRow(KDTGetRowEvent event, KDTable table) {
        int rowCount;
        int page;
        int rowIndex;
        int newRowIndex;
        this.setTblMain(table);
        KDTDataRequestManager manager = table.getDataRequestManager();
        if (!(manager.getDataRequestMode() != 1 || (newRowIndex = (rowIndex = event.getRowIndex()) / (page = manager.getPageRowCount()) * page + page) >= (rowCount = table.getRowCount()) || table.getBody().getRow2(newRowIndex) != null || this.preFetcher != null && this.preFetcher.isAlive())) {
            this.preFetcher = new PreFetcher(manager, newRowIndex);
            this.preFetcher.start();
        }
    }

    private String getUIClassName(KDTable table) {
        String re = "PreFetcher";
        for (Container parent = table.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof CoreUI)) continue;
            re = parent.getClass().getName();
            break;
        }
        return re;
    }

    public static void setFontColor(KDTable table, List columnList, Color color, double compareValue, List allIdList, int rowCount) {
        ArrayList<String> list = new ArrayList<String>();
        if (columnList != null) {
            for (Object key : columnList) {
                if (key == null) continue;
                int columnIndex = table.getColumn((String)key).getColumnIndex();
                list.add(String.valueOf(columnIndex));
            }
        } else {
            int columnCount = table.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                if (table.getColumn(i).getStyleAttributes().isHided()) continue;
                list.add(String.valueOf(i));
            }
        }
        int rowEndIndex = 0;
        if (table.getDataRequestManager().getDataRequestMode() == 1) {
            if (allIdList != null) {
                rowEndIndex = allIdList.size();
            }
        } else {
            rowEndIndex = rowCount;
        }
        for (int rowIndex = 0; rowIndex < rowEndIndex; ++rowIndex) {
            Iterator lt = list.iterator();
            while (lt.hasNext()) {
                int result;
                int columnIndex = Integer.parseInt((String)lt.next());
                Object cellValue = table.getCell(rowIndex, columnIndex).getValue();
                if (cellValue == null || (result = StringUtility.compareValue(cellValue.toString(), compareValue)) != -1) continue;
                table.getCell(rowIndex, columnIndex).getStyleAttributes().setFontColor(color);
            }
        }
    }

    public static void setFootFontColor(KDTable table, int rowIndex, String[] columnName, Color fontColor) {
        KDTFootManager footRowManager;
        List<Object> listColumn = null;
        if (fontColor == null) {
            return;
        }
        if (rowIndex <= -1) {
            rowIndex = 0;
        }
        if (columnName != null) {
            listColumn = new ArrayList(columnName.length);
            listColumn = Arrays.asList(columnName);
        }
        if ((footRowManager = table.getFootManager()) != null) {
            IRow row = footRowManager.getFootRow(rowIndex);
            int columnCount = table.getColumnCount();
            for (int c = 0; c < columnCount; ++c) {
                String fieldName = table.getColumn(c).getFieldName();
                if (listColumn != null && !listColumn.contains(fieldName)) continue;
                ICell cell = row.getCell(c);
                cell.getStyleAttributes().setFontColor(fontColor);
            }
        }
    }

    public static String getSelectedKeyValue(int[] selectRows, KDTable table, String columnName) {
        if (selectRows.length > 0) {
            Object keyValue;
            int rowIndex = selectRows[0];
            IRow row = table.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(columnName);
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    public static ArrayList getSelectIdForTableSelect(KDTable table, String columnName) {
        ICell cell;
        ArrayList<String> list = new ArrayList<String>();
        if (table.getRowCount() > 0 && (cell = table.getRow(0).getCell(columnName)) == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
            SysUtil.abort();
        }
        for (int i = 0; i <= table.getRowCount(); ++i) {
            String id;
            ICell cell2 = table.getRow(i).getCell(columnName);
            if (cell2.getValue() == null || list.contains(id = cell2.getValue().toString())) continue;
            list.add(id);
        }
        return list;
    }

    public static List getColumnFieldNames(KDTable table) {
        ArrayList<String> keyList = null;
        if (table != null) {
            keyList = new ArrayList<String>();
            for (int i = 0; i < table.getColumnCount(); ++i) {
                IColumn col = table.getColumn(i);
                if (col.getFieldName() == null) continue;
                keyList.add(col.getFieldName());
            }
        }
        return keyList;
    }

    public static List getColumnKeys(KDTable table) {
        ArrayList<String> keyList = null;
        if (table != null) {
            keyList = new ArrayList<String>();
            for (int i = 0; i < table.getColumnCount(); ++i) {
                IColumn col = table.getColumn(i);
                if (col.getKey() == null) continue;
                keyList.add(col.getKey());
            }
        }
        return keyList;
    }

    public static ArrayList getSelectedIdValues(KDTable table, String columnName, ArrayList selectList, List selectIdList) {
        LinkedHashSet<String> idSet;
        block8: {
            int[] selectRows;
            block9: {
                block7: {
                    selectRows = KDTableUtil.getSelectedRows((KDTable)table);
                    int size = table.getSelectManager().size();
                    if (table.getSelectManager().getSelectMode() == 8) {
                        return ListUiHelper.getSelectIdForTableSelect(table, columnName);
                    }
                    if (size == 0 || table.getSelectManager().getActiveRowIndex() < 0) {
                        return new ArrayList();
                    }
                    idSet = new LinkedHashSet<String>();
                    if (size != 1 || selectRows.length != 1) break block7;
                    int rowNum = table.getSelectManager().get().getTop();
                    ICell cell = table.getRow(rowNum).getCell(columnName);
                    if (cell == null) {
                        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                        SysUtil.abort();
                    }
                    if (cell.getValue() == null) break block8;
                    idSet.add(cell.getValue().toString());
                    selectList.add(new Integer(rowNum));
                    break block8;
                }
                int mode = 0;
                ArrayList blockList = table.getSelectManager().getBlocks();
                if (blockList != null && blockList.size() == 1) {
                    mode = ((IBlock)table.getSelectManager().getBlocks().get(0)).getMode();
                }
                if (mode != 8 || selectRows.length < 100) break block9;
                int index = 0;
                if (selectIdList == null) break block8;
                for (Object[] idObj : selectIdList) {
                    if (idObj == null) continue;
                    idSet.add(idObj[0].toString());
                    selectList.add(new Integer(index));
                    ++index;
                }
                break block8;
            }
            for (int i = 0; i < selectRows.length; ++i) {
                ICell cell = table.getRow(selectRows[i]).getCell(columnName);
                if (cell == null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                    SysUtil.abort();
                }
                if (cell.getValue() == null) continue;
                String id = cell.getValue().toString();
                idSet.add(id);
                selectList.add(new Integer(selectRows[i]));
            }
        }
        return new ArrayList(idSet);
    }

    public IIDList getIDList(ListUI listui) {
        this.tblMain = listui.getMainTable();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int size = selectRows.length;
        int mode = 0;
        ArrayList blockList = this.tblMain.getSelectManager().getBlocks();
        if (blockList != null && blockList.size() == 1) {
            mode = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getMode();
        }
        HashSet<String> idSet = new HashSet<String>();
        if (size > 1 && mode != 8) {
            for (int i = 0; idSet.size() < 2 && i < size; ++i) {
                ICell curCell = this.tblMain.getRow(i).getCell(listui.getKeyFieldName());
                if (curCell == null || curCell.getValue() == null) continue;
                idSet.add(curCell.getValue().toString());
            }
        }
        if (size == 0) {
            return null;
        }
        RealModeIDList idList = new RealModeIDList();
        if (idSet.size() == 1 || size == 1 && this.tblMain.getSelectManager().get().getTop() == this.tblMain.getSelectManager().get().getBottom()) {
            int rowNum = this.tblMain.getSelectManager().get().getTop();
            ICell cell = this.tblMain.getRow(rowNum).getCell(listui.getKeyFieldName());
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            String currentId = cell.getValue().toString();
            int curIndex = 0;
            if (currentId == null) {
                return this.getIDListForKeyFieldName(listui.getKeyFieldName());
            }
            if (listui.isReturnSelectedData()) {
                idList.add(currentId);
            } else if (listui.getAllIdList() != null) {
                Object[] ids = null;
                for (int i = 0; i < listui.getAllIdList().size(); ++i) {
                    ids = (Object[])listui.getAllIdList().get(i);
                    if (idList.contains(ids[0].toString())) continue;
                    idList.add(ids[0].toString());
                    if (currentId.equals(ids[0].toString())) {
                        rowNum = curIndex;
                    }
                    ++curIndex;
                }
            }
            if (idList.size() == 0) {
                for (int i = 0; i < selectRows.length; ++i) {
                    curIndex = 0;
                    ICell curCell = this.tblMain.getRow(selectRows[i]).getCell(listui.getKeyFieldName());
                    if (curCell == null || curCell.getValue() == null || idList.contains(curCell.getValue().toString())) continue;
                    idList.add(curCell.getValue().toString());
                    if (currentId.equals(curCell.getValue().toString())) {
                        rowNum = curIndex;
                    }
                    ++curIndex;
                }
            }
            idList.setCurrentIndex(rowNum);
            idList.setQuery(listui.getMainQueryPK(), listui.getMainQuery(), listui.getQueryUuid());
            idList.setMaxRowCount(listui.getMaxReturnRowCount());
            listui.getSelectList().add(new Integer(rowNum));
            return idList;
        }
        if (mode == 8) {
            int index = 0;
            List selectIdList = listui.getQueryPkList();
            if (selectIdList != null) {
                for (Object[] idObj : selectIdList) {
                    if (idObj == null) continue;
                    idList.add(idObj[0].toString());
                    listui.getSelectList().add(new Integer(index));
                    ++index;
                }
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (selectRows[i] < 0) {
                    return idList;
                }
                ICell cell = this.tblMain.getRow(selectRows[i]).getCell(listui.getKeyFieldName());
                if (cell == null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                    SysUtil.abort();
                }
                if (cell.getValue() == null) {
                    return idList;
                }
                String id = cell.getValue().toString();
                if (!idList.contains(id)) {
                    idList.add(id);
                }
                listui.getSelectList().add(new Integer(selectRows[i]));
            }
        }
        idList.setCurrentIndex(0);
        idList.setQuery(listui.getMainQueryPK(), listui.getMainQuery(), listui.getQueryUuid());
        idList.setMaxRowCount(listui.getMaxReturnRowCount());
        return idList;
    }

    private IIDList getIDListForKeyFieldName(String columnName) {
        RealModeIDList idList = new RealModeIDList();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            IRow row = this.tblMain.getRow(selectRows[i]);
            ICell cell = null;
            if (row != null) {
                cell = row.getCell(columnName);
            }
            if (cell == null || cell.getValue() == null) continue;
            idList.add(cell.getValue().toString());
        }
        return idList;
    }

    public String selectPreRow(KDTable table, List allIdList, String selectKeyValue, int selectIndex, String keyFieldName) {
        int index = selectIndex;
        if (table.getRowCount() <= 0) {
            return null;
        }
        if (index >= 0 && selectKeyValue != null) {
            String selectValue;
            if (index >= table.getRowCount()) {
                index = table.getRowCount() - 1;
            }
            if ((selectValue = this.getTableCellValue(table, index, keyFieldName)) != null && selectKeyValue.equals(selectValue)) {
                table.getSelectManager().select(index, 0);
                if (index + 20 < table.getRowCount()) {
                    table.getLayoutManager().scrollRowToShow(index + 20);
                } else {
                    table.getLayoutManager().scrollRowToShow(index);
                }
                return selectValue;
            }
            int size = allIdList == null ? 0 : allIdList.size();
            for (int r = 0; r < size; ++r) {
                selectValue = this.getTableCellValue(table, r, keyFieldName);
                if (selectValue == null || !selectKeyValue.equals(selectValue)) continue;
                table.getSelectManager().select(index, 0);
                if (index + 20 < table.getRowCount()) {
                    table.getLayoutManager().scrollRowToShow(index + 20);
                } else {
                    table.getLayoutManager().scrollRowToShow(index);
                }
                return selectValue;
            }
            if (table.getRowCount() > 0) {
                table.getSelectManager().select(0, 0);
            }
        }
        return null;
    }

    public String getTableCellValue(KDTable table, int rowIndex, String FieldName) {
        ICell cell;
        String selectValue = "";
        if (rowIndex < 0) {
            return selectValue;
        }
        IRow row = table.getRow(rowIndex);
        if (row != null && (cell = row.getCell(FieldName)) != null && cell.getValue() != null) {
            selectValue = cell.getValue().toString();
        }
        return selectValue;
    }

    public int[] removeRows(KDTable table, String id, int selectIndex, String keyFieldName) {
        int[] returnInt = new int[]{-1, -1};
        ArrayList<String> removeList = new ArrayList<String>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
        for (int i = selectRows.length - 1; i > -1; --i) {
            IRow row = table.getRow(selectRows[i]);
            ICell keyCell = null;
            if (row != null) {
                keyCell = row.getCell(keyFieldName);
            }
            if (keyCell == null || keyCell.getValue() == null || !keyCell.getValue().equals(id)) continue;
            removeList.add(String.valueOf(selectRows[i]));
        }
        if (removeList.size() == 0) {
            return returnInt;
        }
        int minIndex = Integer.parseInt(String.valueOf(removeList.get(0)));
        int maxIndex = Integer.parseInt(String.valueOf(removeList.get(removeList.size() - 1)));
        int i = minIndex;
        while (i > -1 && table.getRow(i).getCell(keyFieldName) != null && id.equals(table.getRow(i).getCell(keyFieldName).getValue().toString())) {
            minIndex = i--;
        }
        i = maxIndex;
        while (i < table.getRowCount() && table.getRow(i).getCell(keyFieldName) != null && id.equals(table.getRow(i).getCell(keyFieldName).getValue().toString())) {
            maxIndex = i++;
        }
        for (i = maxIndex; i >= minIndex; --i) {
            try {
                table.removeRow(i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        returnInt[0] = minIndex;
        returnInt[1] = maxIndex;
        return returnInt;
    }

    public IIDList filterDupID(IIDList idList, String selectedId) {
        RealModeIDList noDupIdList = RealModeIDList.getEmptyIDList();
        if (idList == null) {
            return null;
        }
        int size = idList.size();
        String id = null;
        for (int i = 0; i < size; ++i) {
            id = idList.getID(i);
            if (noDupIdList.contains(id)) continue;
            noDupIdList.add(id);
        }
        noDupIdList.setCurrentID(selectedId);
        noDupIdList.setQuery(idList.getMetaDataPK(), idList.getEntityViewInfo(), idList.getQueryUuid());
        noDupIdList.setMainOrgContext(idList.getMainOrgContext());
        noDupIdList.setMaxRowCount(idList.getMaxRowCount());
        return noDupIdList;
    }

    public Map getHideColumnCount(KDTable table) {
        HashMap<String, String> columnMap = new HashMap<String, String>();
        for (int i = 0; i < table.getColumnCount(); ++i) {
            IColumn col = table.getColumn(i);
            if (col.getWidth() <= 0) continue;
            columnMap.put(col.getKey(), String.valueOf(i));
        }
        return columnMap;
    }

    public Map getSelectColumnValue(KDTable table, String keyColumnName, String valueColumnName) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (valueColumnName == null || valueColumnName.equals("")) {
            return map;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
        for (int i = 0; i < selectRows.length; ++i) {
            IRow row = table.getRow(selectRows[i]);
            ICell keyCell = null;
            ICell valueCell = null;
            if (row != null) {
                keyCell = row.getCell(keyColumnName);
                valueCell = row.getCell(valueColumnName);
            }
            if (keyCell == null || keyCell.getValue() == null || valueCell == null || valueCell.getValue() == null || map.containsKey(keyCell.getValue().toString())) continue;
            map.put(keyCell.getValue().toString(), valueCell.getValue().toString());
        }
        return map;
    }

    public Map getSelectRowNumberMap(KDTable table, String fieldName) {
        HashMap<String, Integer> rowNumberMap = new HashMap<String, Integer>();
        if (table != null) {
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
            IRow row = null;
            ICell keyCell = null;
            if (selectRows != null) {
                for (int i = 0; i < selectRows.length; ++i) {
                    row = table.getRow(selectRows[i]);
                    if (row != null) {
                        keyCell = row.getCell(fieldName);
                    }
                    if (keyCell == null) continue;
                    rowNumberMap.put(keyCell.getValue().toString(), new Integer(selectRows[i] + 1));
                }
            }
        }
        return rowNumberMap;
    }

    public static void regroupTable(KDTable table) {
        KDTableHelper.regroupTable((KDTable)table);
    }

    private class PreFetcher
    extends Thread {
        int rowIndex;
        KDTDataRequestManager manager;
        boolean terminated = false;

        public PreFetcher(KDTDataRequestManager manager, int rowIndex) {
            this.manager = manager;
            this.rowIndex = rowIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            String uiClassName = ListUiHelper.this.getUIClassName(ListUiHelper.this.getTblMain());
            String methodName = "preFetch(" + this.rowIndex + ")";
            try {
                RPCInvokeCounter.startActionCount((String)uiClassName, (String)methodName);
                this.manager.doDataRequest(this.rowIndex);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            finally {
                RPCInvokeCounter.endActionCount((String)uiClassName, (String)methodName, (long)(System.currentTimeMillis() - startTime));
            }
            this.terminated = true;
        }

        public synchronized void terminate() {
            this.terminated = true;
            this.notifyAll();
        }

        public synchronized void fetch(KDTDataRequestManager manager, int rowIndex) {
            this.manager = manager;
            this.rowIndex = rowIndex;
            this.notifyAll();
        }
    }

    private class PreFetcher1
    extends Thread {
        private IQueryExecutor exec;
        private boolean terminated = false;
        private Uuid queryUuid;
        private int pageUnit;
        private int pageCount;
        private Set fetched = new TreeSet();
        private Map buffer = new HashMap();
        private int currentPage = 0;

        public IQueryExecutor getExec() {
            return this.exec;
        }

        public PreFetcher1(IQueryExecutor exec, Uuid queryUuid, int total, int pageUnit) {
            this.exec = exec;
            this.queryUuid = queryUuid;
            this.pageUnit = pageUnit;
            this.pageCount = total / pageUnit + (total % pageUnit > 0 ? 1 : 0);
            this.fetched.add(new Integer(0));
        }

        private IRowSet fetchPage(int pageStart, int pageCount) throws Exception {
            if (this.queryUuid == null) {
                this.queryUuid = this.exec.openQuery();
            }
            IRowSet rowSet = this.exec.executeQuery(this.queryUuid, this.pageUnit * pageStart, this.pageUnit * pageCount);
            return rowSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PreFetcher1 preFetcher1 = this;
            synchronized (preFetcher1) {
                while (!this.terminated) {
                    long t1;
                    long t;
                    int fetchPage;
                    if (this.fetched.size() == this.pageCount) {
                        return;
                    }
                    if (this.currentPage - 1 >= 0 && !this.fetched.contains(new Integer(fetchPage = this.currentPage - 1)) && this.buffer.get(new Integer(fetchPage)) == null) {
                        System.out.println("\u9884\u53d6\u7b2c" + fetchPage + "\u9875");
                        try {
                            UIActionMonitor.startAction((String)this.getName(), (String)("PreFetch(" + fetchPage + ")"));
                            t = System.currentTimeMillis();
                            this.buffer.put(new Integer(fetchPage), this.fetchPage(fetchPage, 1));
                            t1 = System.currentTimeMillis() - t;
                            UIActionMonitor.endAction((String)this.getName(), (String)("PreFetch(" + fetchPage + ")"), (long)t1);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (this.currentPage + 1 < this.pageCount && !this.fetched.contains(new Integer(fetchPage = this.currentPage + 1)) && this.buffer.get(new Integer(fetchPage)) == null) {
                        System.out.println("\u9884\u53d6\u7b2c" + fetchPage + "\u9875");
                        try {
                            UIActionMonitor.startAction((String)this.getName(), (String)("PreFetch(" + fetchPage + ")"));
                            t = System.currentTimeMillis();
                            this.buffer.put(new Integer(fetchPage), this.fetchPage(fetchPage, 1));
                            t1 = System.currentTimeMillis() - t;
                            UIActionMonitor.endAction((String)this.getName(), (String)("PreFetch(" + fetchPage + ")"), (long)t1);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public synchronized IRowSet getRowSet(int start, int length) throws Exception {
            int subStart;
            int startPage = start / this.pageUnit;
            int endPage = (start + length - 1) / this.pageUnit;
            IRowSet rowSet = null;
            int currentStart = startPage;
            int currentPageCount = 0;
            for (int i = startPage; i <= endPage; ++i) {
                Integer key = new Integer(i);
                IRowSet rs = (IRowSet)this.buffer.get(key);
                if (rs != null) {
                    if (currentPageCount > 0) {
                        IRowSet rsFetch = this.fetchPage(currentStart, currentPageCount);
                        rowSet = rowSet == null ? rsFetch : this.mergeRowSet(rowSet, rsFetch);
                    }
                    rowSet = rowSet == null ? rs : this.mergeRowSet(rowSet, rs);
                    currentStart = i + 1;
                    currentPageCount = 0;
                    continue;
                }
                ++currentPageCount;
            }
            if (currentPageCount > 0) {
                IRowSet rsFetch = this.fetchPage(currentStart, currentPageCount);
                rowSet = rowSet == null ? rsFetch : this.mergeRowSet(rowSet, rsFetch);
            }
            if ((subStart = start - startPage * this.pageUnit) > 0 || length < rowSet.size()) {
                DynamicRowSet dynamicRowSet = (DynamicRowSet)rowSet;
                dynamicRowSet.subRowSet(subStart, length);
                rowSet = dynamicRowSet;
            }
            for (int i = startPage; i <= endPage; ++i) {
                Integer key = new Integer(i);
                this.buffer.remove(key);
                this.fetched.add(key);
            }
            this.currentPage = startPage;
            this.notifyAll();
            return rowSet;
        }

        private IRowSet mergeRowSet(IRowSet rs1, IRowSet rs2) throws SQLException {
            DynamicRowSet dRs1 = (DynamicRowSet)rs1;
            DynamicRowSet dRs2 = (DynamicRowSet)rs2;
            DynamicRowSet ret = dRs1.subRowSet(0, dRs1.size());
            ret.merge(dRs2);
            return ret;
        }

        public synchronized void terminate() {
            this.terminated = true;
            this.notifyAll();
        }
    }
}

