/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.client.AbstractIDList;
import com.kingdee.eas.framework.client.EmptyRealModeIDList;
import com.kingdee.eas.framework.client.IDListAssist;
import com.kingdee.util.Uuid;
import java.util.List;
import org.apache.log4j.Logger;

public class RealModeIDList
extends AbstractIDList {
    private static final Logger logger = Logger.getLogger(RealModeIDList.class);
    private final int pageLen = 1;
    private String fieldName = null;

    public RealModeIDList() {
        super(0, 0);
    }

    public RealModeIDList(int billCount, int count) {
        super(billCount, count);
    }

    public static RealModeIDList getEmptyIDList() {
        return new EmptyRealModeIDList();
    }

    @Override
    public String getCurrentID() {
        return this.getID(this.currentIndex);
    }

    @Override
    public void setCurrentID(String id) {
        if (id == null) {
            return;
        }
        if (this.idList.contains(id)) {
            this.currentIndex = this.idList.indexOf(id);
        } else {
            IQueryExecutor executor = this.getExecutor();
            try {
                if (executor != null && this.getQueryUuid() != null) {
                    this.currentIndex = executor.indexOfBillID(this.getQueryUuid(), this.fieldName, BOSUuid.read((String)id));
                    this.add(this.currentIndex, id);
                }
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
    }

    @Override
    public String getID(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        if (!this.isExist(index)) {
            List list = this.getQueryList(index, this.pageLen);
            if (list == null || list.size() == 0) {
                return null;
            }
            this.add(index, list.get(0).toString());
        }
        return super.getID(index);
    }

    private List getQueryList(int start, int length) {
        try {
            IQueryExecutor executor = this.getExecutor();
            if (executor != null && this.getQueryUuid() != null) {
                return executor.getBillIDList(this.getQueryUuid(), this.fieldName, start, length);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    @Override
    public void setQuery(IMetaDataPK queryPK, EntityViewInfo viewInfo, Uuid queryUuid) {
        this.setAssist(new DefaultAssist(queryPK, viewInfo, queryUuid));
    }

    @Override
    public void setPkFieldName(String pkFieldName) {
        this.fieldName = pkFieldName;
    }

    private IQueryExecutor getExecutor() {
        if (this.assist != null) {
            return this.assist.getQueryExecutor();
        }
        return null;
    }

    @Override
    public IMetaDataPK getMetaDataPK() {
        if (this.assist != null) {
            return this.assist.getMetaDataPK();
        }
        return null;
    }

    @Override
    public Uuid getQueryUuid() {
        if (this.assist != null) {
            return this.assist.getQueryUuid();
        }
        return null;
    }

    @Override
    public EntityViewInfo getEntityViewInfo() {
        if (this.assist != null) {
            return this.assist.getEntityViewInfo();
        }
        return null;
    }

    @Override
    public String getPkFieldName() {
        return this.fieldName;
    }

    @Override
    public void remove(String id, boolean moveUp) {
        if (this.newIdList.indexOf(id) < 0) {
            int index = this.idList.indexOf(id);
            IQueryExecutor executor = this.getExecutor();
            if (executor == null) {
                super.remove(id, moveUp);
                return;
            }
            if (id != null) {
                if (index < 0) {
                    try {
                        index = executor.indexOfBillID(this.getQueryUuid(), this.fieldName, BOSUuid.read((String)id));
                        if (index < 0) {
                            return;
                        }
                        this.idList.set(index, id);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                }
                try {
                    executor.removeBillID(this.getQueryUuid(), this.fieldName, BOSUuid.read((String)id));
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            super.remove(id, moveUp);
        } else {
            super.remove(id, moveUp);
        }
    }

    static class DefaultAssist
    implements IDListAssist {
        private final IMetaDataPK queryPK;
        private final EntityViewInfo viewInfo;
        private final Uuid queryUuid;
        private IQueryExecutor executor = null;

        DefaultAssist(IMetaDataPK queryPK, EntityViewInfo viewInfo, Uuid queryUuid) {
            this.queryPK = queryPK;
            this.viewInfo = viewInfo;
            this.queryUuid = queryUuid;
        }

        @Override
        public IQueryExecutor getQueryExecutor() {
            if (this.executor == null && this.queryPK != null && this.queryUuid != null) {
                this.executor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.queryPK);
                this.executor.setObjectView(this.viewInfo);
            }
            return this.executor;
        }

        @Override
        public IMetaDataPK getMetaDataPK() {
            return this.queryPK;
        }

        @Override
        public Uuid getQueryUuid() {
            return this.queryUuid;
        }

        @Override
        public EntityViewInfo getEntityViewInfo() {
            return this.viewInfo;
        }
    }
}

